/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.article.latest;

import ch.icit.pegasus.client.converter.ChargeTransactionConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.StockTransactionAmountConverter;
import ch.icit.pegasus.client.converter.StockTransactionRemarkConverter;
import ch.icit.pegasus.client.converter.StockTransactionStoreConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.submodules.print.article.latest.TransactionClassResolver;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TableSearchStateListener;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.StockTransactionSearchAlgorithm2;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.calculator.IBasicArticle;
import ch.icit.pegasus.server.core.calculator.IQuantity;
import ch.icit.pegasus.server.core.calculator.IStoreQuantity;
import ch.icit.pegasus.server.core.calculator.IUnit;
import ch.icit.pegasus.server.core.calculator.UnitCalculator;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.report.BasicArticleTransactionReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionTypeE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class PrintArticleLatestTransactionsComponent
extends DefaultScrollablePrintPopup2<BasicArticleLight>
implements TableSearchStateListener {
    private static final long serialVersionUID = 1L;
    private Node<BasicArticleLight> currentArticle;
    private PageableTable2 table;
    private boolean isLoadingLatest = false;
    private static final String STORE_ID = "Store_ID";
    private static final String TRANSACTION_TYPE = "TRANSACTION_TYPE";
    private static final String TRANSACTION_DATE = "TRANSACTION_DATE";
    private StoreReference searchCriteria1 = null;
    private StockTransactionTypeE searchCriteria2 = null;
    private RowModel<BasicArticleLight> rowModel;
    private PeriodComplete searchCriteria3 = null;
    private boolean blockingForArticleLoad = true;

    public PrintArticleLatestTransactionsComponent(Node<BasicArticleLight> currentNode, RowModel<BasicArticleLight> rowModel) {
        super(true, true, false, true, false, ReportTypeE.ARTICLE_TRANSACTION);
        this.currentArticle = currentNode;
        this.rowModel = rowModel;
        this.loadBeforeShowing(() -> {
            try {
                if (this.currentArticle.getValue(BasicArticleComplete.class) == null) {
                    BasicArticleComplete articleComplete = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(((BasicArticleLight)this.currentArticle.getValue()).getId())).getValue();
                    this.currentArticle.setValue((Object)articleComplete, 0L);
                }
                this.blockingForArticleLoad = false;
                this.table.invokeDefaultSearch();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to show Transaction for Article: " + e.getMessage());
            }
        });
        this.getViewContainer().setLayout(new Layout());
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
        this.isLoadingLatest = true;
        this.remoteObjectLoaded((Node)this.currentArticle);
    }

    @Override
    public void remoteObjectLoaded(Node node) {
        if (this.isLoadingLatest) {
            this.removeAnimation(false);
            this.createComponents();
            this.createInners();
            this.table.setSortedColumn(0);
            this.table.setSortDirection(true);
            this.table.getModel().setNode((Node)new ViewNode("transactions"));
            this.popup.enableCancelButton(true);
            this.table.invokeDefaultSearch();
            this.isLoadingLatest = false;
        } else {
            super.remoteObjectLoaded(node);
        }
        this.rowModel.getView().refreshCells();
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.table != null) {
            this.table.setVisible(false);
        }
    }

    private void createInners() {
        this.table = new PageableTable2("", true, true, false){
            private static final long serialVersionUID = 1L;

            @Override
            public void invokeDefaultSearch() {
                if (PrintArticleLatestTransactionsComponent.this.blockingForArticleLoad) {
                    return;
                }
                super.invokeDefaultSearch();
            }

            @Override
            public SearchAlgorithm getSearchAlgorithm() {
                return SearchAlgorithmRegistry.getSearchAlgorithm(StockTransactionSearchAlgorithm2.class);
            }

            @Override
            public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
                if (id != null && id.equals(PrintArticleLatestTransactionsComponent.STORE_ID)) {
                    if (value instanceof StoreLight) {
                        PrintArticleLatestTransactionsComponent.this.searchCriteria1 = new StoreReference(((StoreLight)value).getId());
                    } else if (value instanceof Node) {
                        PrintArticleLatestTransactionsComponent.this.searchCriteria1 = new StoreReference(((StoreLight)((Node)value).getValue()).getId());
                    } else {
                        PrintArticleLatestTransactionsComponent.this.searchCriteria1 = null;
                    }
                } else if (id != null && id.equals(PrintArticleLatestTransactionsComponent.TRANSACTION_TYPE)) {
                    if (value instanceof String) {
                        String t = (String)value;
                        StockTransactionTypeE nc = TransactionClassResolver.getClassForSelect(t);
                        PrintArticleLatestTransactionsComponent.this.searchCriteria2 = nc;
                    } else {
                        PrintArticleLatestTransactionsComponent.this.searchCriteria2 = null;
                    }
                } else if (id != null && id.equals(PrintArticleLatestTransactionsComponent.TRANSACTION_DATE)) {
                    if (value instanceof TitledPeriodEditor) {
                        PrintArticleLatestTransactionsComponent.this.searchCriteria3 = new PeriodComplete(((TitledPeriodEditor)value).getStartDate(), ((TitledPeriodEditor)value).getEndDate());
                    } else {
                        PrintArticleLatestTransactionsComponent.this.searchCriteria3 = null;
                    }
                }
                StockTransactionSearchConfiguration c = new StockTransactionSearchConfiguration();
                c.setNumResults(this.numberOfShownResults);
                c.setPeriod(PrintArticleLatestTransactionsComponent.this.searchCriteria3);
                c.setStore(PrintArticleLatestTransactionsComponent.this.searchCriteria1);
                c.setType(PrintArticleLatestTransactionsComponent.this.searchCriteria2);
                BasicArticleReference r = (BasicArticleReference)PrintArticleLatestTransactionsComponent.this.currentArticle.getValue();
                c.setArticle(new BasicArticleReference(r.getId()));
                c.setSortDirection(SortDirection.DESCENDING);
                c.setPageNumber(this.pagination.getCurrentPage() - 1);
                if (c.getPageNumber() < 0) {
                    c.setPageNumber(0);
                }
                System.out.println("Generated Search config");
                return c;
            }

            @Override
            public void fillFilterChain() {
                this.filterChain.addStoreSearch(PrintArticleLatestTransactionsComponent.STORE_ID, Words.STORE);
                ComboBox box = new ComboBox();
                box.addItem(Words.ALL);
                for (StockTransactionTypeE type : StockTransactionTypeE.values()) {
                    box.addItem(TransactionClassResolver.getNameFor(type));
                }
                box.setSelectedItem(Words.ALL);
                this.filterChain.addSelectionCombo(PrintArticleLatestTransactionsComponent.TRANSACTION_TYPE, Words.TRANSACTION_TYPE, box);
                this.filterChain.setDefault_comboBoxWidth(220);
                PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
                TitledPeriodEditor i = this.filterChain.addPeriodSelection(PrintArticleLatestTransactionsComponent.TRANSACTION_DATE, p.getStartDate(), p.getEndDate(), Words.DATE, false);
                i.setCheckBoxEnabled();
                i.setCheckBoxChecked(false);
            }
        };
        this.table.addTableSearchStateListener(this);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", 140, 140, 140));
        columns.add(new TableColumnInfo(Words.TRANSACTION, null, null, null, "", 40, 40, 40));
        int tw = QuantityRenderer.getPreferredSize(this);
        columns.add(new TableColumnInfo(Words.QUANTITY, null, null, null, "", tw *= 2, tw, tw));
        columns.add(new TableColumnInfo(Words.STORE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.USER, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.REMARK, null, null, null, "", 40, 40, 40));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.1);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.1);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.getViewContainer().add(this.table);
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE_NAME;
    }

    @Override
    public void popupClosed() {
        super.popupClosed();
    }

    @Override
    protected String getProgressText() {
        if (this.isLoadingLatest) {
            return Words.LOADING_ARTICLE_DATA;
        }
        return Words.getFirstCapitalLetter((String)Words.PRINT);
    }

    @Override
    public String getTitleValue() {
        return (String)this.currentArticle.getChildNamed(new String[]{"name"}).getValue();
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StockTransactionComplete t2;
                ReportingOutputFormatE out = ReportingOutputFormatE.XLS;
                StockTransactionSearchConfiguration c = new StockTransactionSearchConfiguration();
                c.setStore(PrintArticleLatestTransactionsComponent.this.searchCriteria1);
                c.setType(PrintArticleLatestTransactionsComponent.this.searchCriteria2);
                BasicArticleReference r = (BasicArticleReference)PrintArticleLatestTransactionsComponent.this.currentArticle.getValue();
                c.setArticle(new BasicArticleReference(r.getId()));
                c.setSortDirection(SortDirection.DESCENDING);
                c.setPeriod(PrintArticleLatestTransactionsComponent.this.searchCriteria3);
                SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)c);
                ArrayList<StockTransactionComplete> results = new ArrayList<StockTransactionComplete>();
                try {
                    for (StockTransactionComplete t2 : sri) {
                        results.add(t2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                BasicArticleTransactionReportConfiguration config = new BasicArticleTransactionReportConfiguration(out, PrintArticleLatestTransactionsComponent.this.getSelectedReport());
                config.setArticle(new BasicArticleReference(r.getId()));
                config.setStore(PrintArticleLatestTransactionsComponent.this.searchCriteria1);
                config.setTransactions(results);
                config.setSamplingPeriod(PrintArticleLatestTransactionsComponent.this.searchCriteria3);
                config.setIncludeCustomerData(Boolean.valueOf(true));
                t2 = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createArticleTransactionReport(config).getValue();
                PrintArticleLatestTransactionsComponent.this.processFile((PegasusFileComplete)t2);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticleLatestTransactionsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (super.isInnerComponent(c)) {
            return true;
        }
        return this.table.isInnerComponent(c);
    }

    @Override
    public Node getCurrentNode() {
        return this.currentArticle;
    }

    @Override
    public void insertElements() {
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public BatchJob createBatchJob(Node value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    protected void setEnabledFromRemoteLoad(boolean isEnabled) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.table != null) {
            this.table.setEnabled(isEnabled);
        }
        super.setEnabled(isEnabled);
    }

    @Override
    public void searchStarted() {
    }

    @Override
    public void searchFinished() {
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel when;
        private TextLabel charge;
        private QuantityRenderer quantity;
        private TextLabel affectedStore;
        private TextLabel remark;
        private TextLabel who;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            StockTransactionComplete transactionComplete = (StockTransactionComplete)m.getNode().getValue();
            StoreQuantityComplete qty = (StoreQuantityComplete)m.getNode().getChildNamed(StockTransactionComplete_.amount).getValue();
            BasicArticleComplete articleComplete = (BasicArticleComplete)PrintArticleLatestTransactionsComponent.this.currentArticle.getValue(BasicArticleComplete.class);
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            List articleConversion = UnitCalculator.getArticlePackagingQuantities((IBasicArticle)articleComplete, (Timestamp)transactionComplete.getDate());
            if (UnitCalculator.isConvertible((IBasicArticle)articleComplete, (IUnit)qty.getUnit(), (List)articleConversion, (IUnit)settings.getPieceUnit(), (List)articleConversion)) {
                StoreQuantityComplete delta;
                double amountInPieceUnit = UnitCalculator.convert((IBasicArticle)articleComplete, (IStoreQuantity)qty, (List)articleConversion, (IUnit)settings.getPieceUnit(), (List)articleConversion);
                QuantityComplete newQuantity = new QuantityComplete(Double.valueOf(amountInPieceUnit), settings.getPieceUnit());
                StoreQuantityComplete convert = (StoreQuantityComplete)UnitCalculator.convert((IBasicArticle)articleComplete, (List)articleConversion, (IQuantity)newQuantity);
                transactionComplete.setAmount(convert);
                m.getNode().getChildNamed(StockTransactionComplete_.amount).setValue((Object)convert, 0L);
                if (transactionComplete instanceof StockInventoryComplete && (delta = ((StockInventoryComplete)transactionComplete).getDelta()) != null && delta.getUnit() != null && UnitCalculator.isConvertible((IBasicArticle)articleComplete, (IUnit)delta.getUnit(), (List)articleConversion, (IUnit)settings.getPieceUnit(), (List)articleConversion)) {
                    amountInPieceUnit = UnitCalculator.convert((IBasicArticle)articleComplete, (IStoreQuantity)delta, (List)articleConversion, (IUnit)settings.getPieceUnit(), (List)articleConversion);
                    newQuantity = new QuantityComplete(Double.valueOf(amountInPieceUnit), settings.getPieceUnit());
                    convert = (StoreQuantityComplete)UnitCalculator.convert((IBasicArticle)articleComplete, (List)articleConversion, (IQuantity)newQuantity);
                    ((StockInventoryComplete)transactionComplete).setDelta(convert);
                }
            }
            this.when = new TextLabel(m.getNode().getChildNamed(new String[]{"date"}), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.charge = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ChargeTransactionConverter.class));
            this.quantity = new QuantityRenderer((Node<?>)m.getNode(), (Converter<?, ?>)ConverterRegistry.getConverter(StockTransactionAmountConverter.class));
            this.affectedStore = new TextLabel(m.getNode(), ConverterRegistry.getConverter(StockTransactionStoreConverter.class));
            this.who = new TextLabel(m.getNode().getChildNamed(new String[]{"user"}), ConverterRegistry.getConverter(UserConverter.class));
            this.remark = new TextLabel(m.getNode(), ConverterRegistry.getConverter(StockTransactionRemarkConverter.class));
            this.setLayout(new InnerLayout());
            this.add(this.when);
            this.add(this.charge);
            this.add(this.quantity);
            this.add(this.affectedStore);
            this.add(this.who);
            this.add(this.remark);
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new String[]{"date"}).getValue();
                }
                case 1: {
                    return this.charge.getText();
                }
                case 2: {
                    return this.quantity.getText();
                }
                case 3: {
                    return this.affectedStore.getText();
                }
                case 4: {
                    return this.who.getText();
                }
                case 5: {
                    return this.remark.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.when.setEnabled(isEnabled);
            this.charge.setEnabled(isEnabled);
            this.quantity.setEnabled(isEnabled);
            this.affectedStore.setEnabled(isEnabled);
            this.who.setEnabled(isEnabled);
            this.remark.setEnabled(isEnabled);
            super.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.when.kill();
            this.charge.kill();
            this.quantity.kill();
            this.affectedStore.kill();
            this.who.kill();
            this.remark.kill();
            this.when = null;
            this.charge = null;
            this.quantity = null;
            this.affectedStore = null;
            this.who = null;
            this.remark = null;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.when.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.when.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.when.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.when.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.charge.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.charge.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.charge.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.charge.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(3);
                TableRowImpl.this.affectedStore.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.affectedStore.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.affectedStore.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.affectedStore.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(4);
                TableRowImpl.this.who.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.who.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.who.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.who.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(5);
                TableRowImpl.this.remark.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.remark.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.remark.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.remark.getPreferredSize().getHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int cy = PrintArticleLatestTransactionsComponent.this.layoutInheritedComponents(parent);
            cy += PrintArticleLatestTransactionsComponent.this.border;
            if (PrintArticleLatestTransactionsComponent.this.table != null) {
                PrintArticleLatestTransactionsComponent.this.table.setLocation(PrintArticleLatestTransactionsComponent.this.border, cy);
                PrintArticleLatestTransactionsComponent.this.table.setSize(parent.getWidth() - 2 * PrintArticleLatestTransactionsComponent.this.border, parent.getHeight() - (cy + PrintArticleLatestTransactionsComponent.this.border));
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintArticleLatestTransactionsComponent.this.getInheritedComponentsHeight() + PrintArticleLatestTransactionsComponent.this.border;
            return new Dimension(0, h);
        }
    }
}

