/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.allergeninfosheet;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public class PrintAllergenInfoSheetComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<FlightLight> currentFlight;
    protected TitledItem<CheckBox> includeSPML;
    protected TitledItem<CheckBox> includeAlaCarte;
    protected TitledItem<CheckBox> includeAdditional;
    protected TitledItem<CheckBox> includeStandard;
    protected TitledItem<ComboBox> sortBy;
    private final RDProvider provider;

    public PrintAllergenInfoSheetComponent(RDProvider provider, Node<FlightLight> node) {
        super(false, true, PrintAllergenInfoSheetComponent.showImage((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()) ? ReportTypeE.FLIGHT_ALLERGEN_DETAILS_SHEET_WITHIMAGE : ReportTypeE.FLIGHT_ALLERGEN_DETAILS_SHEET_WITHOUTIMAGE);
        this.provider = provider;
        this.currentFlight = node;
    }

    @Override
    public String getPreferredSelection() {
        return "Allergen Info Sheet - grouped";
    }

    @Override
    public boolean isReportAllowed(ReportFileComplete reportFile) {
        if (reportFile.getDescription().contains("detailed")) {
            if (this.provider != null) {
                return this.provider.isWritable("printedDetailedAIS");
            }
            return false;
        }
        return super.isReportAllowed(reportFile);
    }

    public static boolean showImage(SystemSettingsComplete settings) {
        return settings.getFlightCatalogSettings() != null ? settings.getFlightCatalogSettings().getShowImages() : false;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.includeAdditional = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ADDITIONALS, TitledItem.TitledItemOrientation.EAST);
        this.includeSPML = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_SPML, TitledItem.TitledItemOrientation.EAST);
        this.includeAlaCarte = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ALACARTE, TitledItem.TitledItemOrientation.EAST);
        this.includeStandard = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_STANDARD, TitledItem.TitledItemOrientation.EAST);
        this.sortBy = new TitledItem<ComboBox>(new ComboBox(), Words.SORT_BY, TitledItem.TitledItemOrientation.NORTH);
        this.sortBy.getElement().addItem(Words.MEALPLAN);
        this.sortBy.getElement().addItem(Words.NUMBER);
        this.includeAdditional.getElement().setChecked(true);
        this.includeSPML.getElement().setChecked(true);
        this.includeAlaCarte.getElement().setChecked(true);
        this.includeStandard.getElement().setChecked(true);
        this.getViewContainer().add(this.includeAdditional);
        this.getViewContainer().add(this.includeSPML);
        this.getViewContainer().add(this.includeAlaCarte);
        this.getViewContainer().add(this.includeStandard);
        this.getViewContainer().add(this.sortBy);
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        if (this.currentFlight.getValue() != null) {
            return ((FlightLight)this.currentFlight.getValue()).getOutboundCode();
        }
        return "-";
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.includeSPML.setVisible(true);
        this.includeAlaCarte.setVisible(true);
        this.includeAdditional.setVisible(true);
        this.includeStandard.setVisible(true);
        this.sortBy.setVisible(true);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.includeSPML.setVisible(false);
        this.includeAlaCarte.setVisible(false);
        this.includeAdditional.setVisible(false);
        this.includeStandard.setVisible(false);
        this.sortBy.setVisible(false);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintAllergenInfoSheetComponent.this.getSelectedReport();
                FlightLight flight = (FlightLight)PrintAllergenInfoSheetComponent.this.currentFlight.getValue();
                boolean sortByMealPlan = false;
                if (PrintAllergenInfoSheetComponent.this.sortBy != null && PrintAllergenInfoSheetComponent.this.sortBy.getElement().getSelectedItem().equals(Words.MEALPLAN)) {
                    sortByMealPlan = true;
                }
                ReportingOutputFormatE format = ReportingOutputFormatE.PDF;
                if (PrintAllergenInfoSheetComponent.this.asXLS != null && ((RadioButton)PrintAllergenInfoSheetComponent.this.asXLS.getElement()).isChecked()) {
                    format = ReportingOutputFormatE.XLSX;
                }
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).generateAllergenInfoSheetReport(new FlightReference(flight.getId()), format, file, PrintAllergenInfoSheetComponent.this.includeSPML.getElement().isChecked(), PrintAllergenInfoSheetComponent.this.includeAlaCarte.getElement().isChecked(), PrintAllergenInfoSheetComponent.this.includeAdditional.getElement().isChecked(), PrintAllergenInfoSheetComponent.this.includeStandard.getElement().isChecked(), sortByMealPlan, true).getValue();
                PrintAllergenInfoSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintAllergenInfoSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.currentFlight;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            switch (n) {
                case "spml": {
                    this.includeSPML.getElement().setChecked(b);
                    break;
                }
                case "alacarte": {
                    this.includeAlaCarte.getElement().setChecked(b);
                    break;
                }
                case "additionals": {
                    this.includeAdditional.getElement().setChecked(b);
                    break;
                }
                case "standards": {
                    this.includeStandard.getElement().setChecked(b);
                }
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("spml", "" + this.includeSPML.getElement().isChecked());
        conf.addProperty("alacarte", "" + this.includeAlaCarte.getElement().isChecked());
        conf.addProperty("additionals", "" + this.includeAdditional.getElement().isChecked());
        conf.addProperty("standards", "" + this.includeStandard.getElement().isChecked());
        return conf;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintAllergenInfoSheetComponent.this.layoutInheritedComponents(parent);
            if (PrintAllergenInfoSheetComponent.this.includeSPML != null) {
                PrintAllergenInfoSheetComponent.this.includeSPML.setLocation(PrintAllergenInfoSheetComponent.this.border, y + PrintAllergenInfoSheetComponent.this.border);
                PrintAllergenInfoSheetComponent.this.includeSPML.setSize(PrintAllergenInfoSheetComponent.this.includeSPML.getPreferredSize());
                y = PrintAllergenInfoSheetComponent.this.includeSPML.getY() + PrintAllergenInfoSheetComponent.this.includeSPML.getHeight();
                PrintAllergenInfoSheetComponent.this.includeAlaCarte.setLocation(PrintAllergenInfoSheetComponent.this.border, y + PrintAllergenInfoSheetComponent.this.border / 2);
                PrintAllergenInfoSheetComponent.this.includeAlaCarte.setSize(PrintAllergenInfoSheetComponent.this.includeAlaCarte.getPreferredSize());
                y = PrintAllergenInfoSheetComponent.this.includeAlaCarte.getY() + PrintAllergenInfoSheetComponent.this.includeAlaCarte.getHeight();
                PrintAllergenInfoSheetComponent.this.includeAdditional.setLocation(PrintAllergenInfoSheetComponent.this.border, y + PrintAllergenInfoSheetComponent.this.border / 2);
                PrintAllergenInfoSheetComponent.this.includeAdditional.setSize(PrintAllergenInfoSheetComponent.this.includeAdditional.getPreferredSize());
                y = PrintAllergenInfoSheetComponent.this.includeAdditional.getY() + PrintAllergenInfoSheetComponent.this.includeAdditional.getHeight();
                PrintAllergenInfoSheetComponent.this.includeStandard.setLocation(PrintAllergenInfoSheetComponent.this.border, y + PrintAllergenInfoSheetComponent.this.border / 2);
                PrintAllergenInfoSheetComponent.this.includeStandard.setSize(PrintAllergenInfoSheetComponent.this.includeStandard.getPreferredSize());
                y = PrintAllergenInfoSheetComponent.this.includeStandard.getY() + PrintAllergenInfoSheetComponent.this.includeStandard.getHeight();
                PrintAllergenInfoSheetComponent.this.sortBy.setLocation(PrintAllergenInfoSheetComponent.this.border, y + PrintAllergenInfoSheetComponent.this.border);
                PrintAllergenInfoSheetComponent.this.sortBy.setSize(200, (int)PrintAllergenInfoSheetComponent.this.sortBy.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintAllergenInfoSheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintAllergenInfoSheetComponent.this.border;
            if (PrintAllergenInfoSheetComponent.this.includeSPML != null) {
                h = (int)((double)h + PrintAllergenInfoSheetComponent.this.includeSPML.getPreferredSize().getHeight());
                h += PrintAllergenInfoSheetComponent.this.border / 2;
                h = (int)((double)h + PrintAllergenInfoSheetComponent.this.includeAlaCarte.getPreferredSize().getHeight());
                h += PrintAllergenInfoSheetComponent.this.border / 2;
                h = (int)((double)h + PrintAllergenInfoSheetComponent.this.includeAdditional.getPreferredSize().getHeight());
                h += PrintAllergenInfoSheetComponent.this.border / 2;
                h = (int)((double)h + PrintAllergenInfoSheetComponent.this.includeStandard.getPreferredSize().getHeight());
                h += PrintAllergenInfoSheetComponent.this.border;
                h = (int)((double)h + PrintAllergenInfoSheetComponent.this.sortBy.getPreferredSize().getHeight());
                h += PrintAllergenInfoSheetComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

