/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.requisition.order;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.StoreViewConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderReference;
import ch.icit.pegasus.server.core.dtos.report.RequisitionOrderReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.RequisitionOrderReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionTypeE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PrintOrderSheetComponent
extends DefaultScrollablePrintPopup2<RequisitionOrderLight> {
    private static final long serialVersionUID = 1L;
    private final SystemSettingsComplete settings;
    private Node<RequisitionOrderLight> requisitionOrder;
    private RequisitionOrderComplete orderComplete;
    private List<BasicArticleComplete> articles = new ArrayList<BasicArticleComplete>();
    private Node<RequisitionOrderReportConfiguration> configNode;
    Set<CostCenterComplete> usedCostCenters = new HashSet<CostCenterComplete>();
    ViewNode<CostCenterComplete> retNode = new ViewNode("");
    private TitledItem<ComboBox> department;
    private TitledItem<ComboBox> store;
    private TitledItem<CheckBox> showNotAssigned;

    public PrintOrderSheetComponent(Node<RequisitionOrderLight> node) {
        super(false, false, ReportTypeE.REQUISITION_ORDER);
        this.requisitionOrder = node;
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        RequisitionOrderReportConfiguration config = new RequisitionOrderReportConfiguration();
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
        this.loadBeforeShowing(() -> this.loadRequisitionData());
    }

    @Override
    public boolean isReportAllowed(ReportFileComplete reportFile) {
        if (CompanyUtil.isLSGFC((SystemSettingsComplete)this.settings)) {
            return true;
        }
        if (((RequisitionOrderLight)this.requisitionOrder.getValue()).getState() == OrderStateE.CLOSED) {
            return reportFile.getFileName().contains("closed");
        }
        return !reportFile.getFileName().contains("closed");
    }

    private void loadRequisitionData() {
        try {
            RequisitionOrderComplete requisitionComplete;
            this.orderComplete = requisitionComplete = (RequisitionOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getRequisitionOrderByReference(new RequisitionOrderReference(((RequisitionOrderLight)this.requisitionOrder.getValue()).getId())).getValue();
            for (RequisitionOrderPositionComplete pos : requisitionComplete.getOrderPositions()) {
                BasicArticleComplete bac = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(pos.getArticle().getId())).getValue();
                this.articles.add(bac);
                if (bac.getDefaultRequisitionDeliverDepartment() == null) continue;
                this.usedCostCenters.add(bac.getDefaultRequisitionDeliverDepartment());
            }
            for (CostCenterComplete cc : this.usedCostCenters) {
                Node nc = INodeCreator.getDefaultImpl().getNode4DTO((Object)cc, false, true);
                this.retNode.addChild(nc, 0L);
            }
        }
        catch (ClientServerCallException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.department = new TitledItem<ComboBox>(new ComboBox(this.configNode.getChildNamed(RequisitionOrderReportConfiguration_.deliverDepartment), null, ConverterRegistry.getConverter(CostCenterConverter.class), false, true), Words.DELIVERED_BY_DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.store = new TitledItem<ComboBox>(new ComboBox(this.configNode.getChildNamed(RequisitionOrderReportConfiguration_.deliverStore), null, ConverterRegistry.getConverter(StoreViewConverter.class), false, true), Words.DELIVER_STORE, TitledItem.TitledItemOrientation.NORTH);
        this.showNotAssigned = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(RequisitionOrderReportConfiguration_.showNotAssigned)), Words.INCLUDE_NOT_ASSIGNED, TitledItem.TitledItemOrientation.EAST);
        this.department.getElement().addItemListener(this);
        ViewNode<CostCenterComplete> allDepartments = this.retNode;
        this.department.getElement().refreshPossibleValues((Node)allDepartments);
        this.department.getElement().addItem(Words.ALL);
        this.department.getElement().setSelectedItem(Words.ALL);
        this.getViewContainer().add(this.department);
        this.getViewContainer().add(this.store);
        this.getViewContainer().add(this.showNotAssigned);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (this.department != null && e.getSource() == this.department.getElement() && e.getStateChange() == 1) {
            Node stores;
            if (e.getItem() instanceof Node) {
                Node dep = (Node)e.getItem();
                stores = this.createStoreList((CostCenterComplete)dep.getValue());
            } else {
                stores = this.createStoreList(null);
            }
            this.store.getElement().refreshPossibleValues(stores);
            this.store.getElement().addItem(Words.ALL);
            this.store.getElement().setSelectedItem(Words.ALL);
        }
    }

    public Node createStoreList(CostCenterComplete selectedCostCenter) {
        HashSet<StoreLight> usedStores = new HashSet<StoreLight>();
        ViewNode retNode = new ViewNode("");
        for (BasicArticleComplete bac : this.articles) {
            if (selectedCostCenter != null && !selectedCostCenter.equals((Object)bac.getDefaultRequisitionDeliverDepartment())) continue;
            for (StoreConditionComplete sc : bac.getStoreConditions()) {
                if (sc.getType() != StoreConditionTypeE.REQUISITION_DELIVER || sc.getPosition() == null) continue;
                usedStores.add(sc.getPosition().getStore());
            }
        }
        for (StoreLight cc : usedStores) {
            Node nc = INodeCreator.getDefaultImpl().getNode4DTO((Object)cc, false, true);
            retNode.addChild(nc, 0L);
        }
        return retNode;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.ORDER_NO;
    }

    @Override
    public String getTitleValue() {
        return "" + this.requisitionOrder.getChildNamed(RequisitionOrderLight_.number).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintOrderSheetComponent.this.getSelectedReport();
                PrintOrderSheetComponent.this.configNode.commit();
                RequisitionOrderReportConfiguration config = (RequisitionOrderReportConfiguration)PrintOrderSheetComponent.this.configNode.getValue();
                config.setStylesheet(file);
                config.setDto((IDTO)PrintOrderSheetComponent.this.requisitionOrder.getValue());
                config.setUseUnitFromOrder(Boolean.valueOf(true));
                PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).getRequisitionOrder(config).getValue();
                PrintOrderSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintOrderSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<RequisitionOrderLight> getCurrentNode() {
        return this.requisitionOrder;
    }

    @Override
    public BatchJob<RequisitionOrderLight> createBatchJob(Node<RequisitionOrderLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintOrderSheetComponent.this.layoutInheritedComponents(parent);
            if (PrintOrderSheetComponent.this.department != null) {
                PrintOrderSheetComponent.this.department.setLocation(PrintOrderSheetComponent.this.border, y + PrintOrderSheetComponent.this.border);
                PrintOrderSheetComponent.this.department.setSize(parent.getWidth() - 2 * PrintOrderSheetComponent.this.border, (int)PrintOrderSheetComponent.this.department.getPreferredSize().getHeight());
                y = PrintOrderSheetComponent.this.department.getY() + PrintOrderSheetComponent.this.department.getHeight();
                PrintOrderSheetComponent.this.store.setLocation(PrintOrderSheetComponent.this.border, y + PrintOrderSheetComponent.this.border);
                PrintOrderSheetComponent.this.store.setSize(parent.getWidth() - 2 * PrintOrderSheetComponent.this.border, (int)PrintOrderSheetComponent.this.store.getPreferredSize().getHeight());
                y = PrintOrderSheetComponent.this.store.getY() + PrintOrderSheetComponent.this.store.getHeight();
                PrintOrderSheetComponent.this.showNotAssigned.setLocation(PrintOrderSheetComponent.this.border, y + PrintOrderSheetComponent.this.border);
                PrintOrderSheetComponent.this.showNotAssigned.setSize(parent.getWidth() - 2 * PrintOrderSheetComponent.this.border, (int)PrintOrderSheetComponent.this.showNotAssigned.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintOrderSheetComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintOrderSheetComponent.this.border;
            if (PrintOrderSheetComponent.this.department != null) {
                h = (int)((double)h + PrintOrderSheetComponent.this.department.getPreferredSize().getHeight());
                h += PrintOrderSheetComponent.this.border;
                h = (int)((double)h + PrintOrderSheetComponent.this.store.getPreferredSize().getHeight());
                h += PrintOrderSheetComponent.this.border;
                h = (int)((double)h + PrintOrderSheetComponent.this.showNotAssigned.getPreferredSize().getHeight());
                h += PrintOrderSheetComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

