/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.shared.loadingsheet;

import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.impl.FlightPrintBatch;
import ch.icit.pegasus.client.gui.submodules.print.flight.TitleConverter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.TransferObject;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserPopup;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.panels.PaxLegTable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.IFlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.LoadingSheetReportConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public abstract class PrintLoadingSheetReportComponent<T extends IFlightReference>
extends DefaultScrollablePrintPopup2<T> {
    private static final long serialVersionUID = 1L;
    private TextLabel options;
    private TitledItem<CheckBox> includeArticles;
    private TitledItem<CheckBox> includeEmptyEquipments;
    private MultiLineTextLabel infoLabel;
    protected TitledItem<DateChooserPopup> dateChooser;
    protected TitledItem<PaxLegTable> paxCount;
    private TitledItem<ComboBox> labelColor;
    private TitledItem<ComboBox> department;
    protected T dto;
    protected PeriodComplete period;

    public PrintLoadingSheetReportComponent(TransferObject<T> trans, boolean includeDatePicker, PeriodComplete period) {
        super(true, false, false, false, ReportTypeE.LOADINGSHEET);
        this.period = period;
        this.dto = (IFlightReference)trans.getDto();
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.includeArticles);
        CheckedListAdder.addToList(focusList, this.includeEmptyEquipments);
        CheckedListAdder.addToList(focusList, this.department);
        CheckedListAdder.addToList(focusList, this.labelColor);
        if (this.dateChooser != null) {
            CheckedListAdder.addToList(focusList, this.dateChooser);
        }
        if (this.paxCount != null) {
            CheckedListAdder.addToList(focusList, this.paxCount);
        }
        return focusList;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.options.setVisible(true);
        this.includeArticles.setVisible(true);
        this.department.setVisible(true);
        this.labelColor.setVisible(true);
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(true);
        }
        if (this.paxCount != null) {
            this.paxCount.setVisible(true);
        }
        this.includeEmptyEquipments.setVisible(true);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.options = new TextLabel(Words.OPTIONS);
        this.options.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.options.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.infoLabel = new MultiLineTextLabel("<html>* Be aware of<ul><li>Articles show their Label Name, if none is defined, Article's Name is shown</li></ul></html>");
        this.includeArticles = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ARTICLES, TitledItem.TitledItemOrientation.EAST);
        this.includeEmptyEquipments = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_EMPTY_EQUIPMENTS, TitledItem.TitledItemOrientation.EAST);
        this.infoLabel.setForeground(fb);
        this.infoLabel.setFont(f);
        this.includeArticles.getTitle().setForeground(fb);
        this.includeArticles.getTitle().setFont(f);
        this.includeEmptyEquipments.getTitle().setForeground(fb);
        this.includeEmptyEquipments.getTitle().setFont(f);
        this.department = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(CostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class), true), "Department", TitledItem.TitledItemOrientation.NORTH);
        this.labelColor = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(ColorComplete.class), ConverterRegistry.getConverter(ColorConverter.class), true), "Label Color", TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add(this.options);
        this.getViewContainer().add(this.infoLabel);
        this.getViewContainer().add(this.includeArticles);
        this.getViewContainer().add(this.includeEmptyEquipments);
        this.getViewContainer().add(this.department);
        this.getViewContainer().add(this.labelColor);
        this.createComponents();
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            if (n.equals("overview")) {
                this.includeArticles.getElement().setChecked(b);
                continue;
            }
            if (!n.equals("empty")) continue;
            this.includeEmptyEquipments.getElement().setChecked(b);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("overview", "" + this.includeArticles.getElement().isChecked());
        conf.addProperty("empty", "" + this.includeEmptyEquipments.getElement().isChecked());
        return conf;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.options.setVisible(false);
        this.infoLabel.setVisible(false);
        this.includeArticles.setVisible(false);
        this.includeEmptyEquipments.setVisible(false);
        this.department.setVisible(false);
        this.labelColor.setVisible(false);
        if (this.dateChooser != null) {
            this.dateChooser.setVisible(false);
        }
        if (this.paxCount != null) {
            this.paxCount.setVisible(false);
        }
        super.removeInheritedComponents();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.options.kill();
        this.options = null;
        this.infoLabel.kill();
        this.infoLabel = null;
        this.includeArticles.kill();
        this.includeArticles = null;
        this.includeEmptyEquipments.kill();
        this.includeEmptyEquipments = null;
        this.department.kill();
        this.department = null;
        this.labelColor.kill();
        this.labelColor = null;
        if (this.dateChooser != null) {
            this.dateChooser.kill();
        }
        this.dateChooser = null;
        if (this.paxCount != null) {
            this.paxCount.kill();
        }
        this.paxCount = null;
    }

    @Override
    public String getTitleString() {
        return Words.LOADING_SHEET;
    }

    @Override
    public String getTitleValue() {
        return ((TitleConverter)ConverterRegistry.getConverter(TitleConverter.class)).convert((Object)this.dto, (Node)null, new Object[0]);
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        Component currentC;
        if (super.isInnerComponent(c)) {
            return true;
        }
        if (this.department != null && this.department.getElement().getCurrentPopUp() != null) {
            for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.department.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        if (this.labelColor != null && this.labelColor.getElement().getCurrentPopUp() != null) {
            for (currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.labelColor.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> a;
        List<ScreenValidationObject> b;
        ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
        if (this.paxCount != null && (b = this.paxCount.getElement().validatePaxTable()) != null) {
            l.addAll(b);
        }
        if ((a = super.validateBeforePrint()) != null) {
            l.addAll(a);
        }
        return l;
    }

    public void getConfig(LoadingSheetReportConfiguration<?, ?> config) {
        config.setIncludeArticles(Boolean.valueOf(this.includeArticles.getElement().isChecked()));
        config.setIncludeEmptyEquipments(Boolean.valueOf(this.includeEmptyEquipments.getElement().isChecked()));
        config.setDepartment((CostCenterComplete)this.department.getElement().getNode().getValue());
        config.setLabelColor((ColorComplete)this.labelColor.getElement().getNode().getValue());
    }

    @Override
    public BatchJob<T> createBatchJob(Node<T> value, ThreadSafeExecutable job) {
        return new FlightPrintBatch<T>(job, value, this.getPrintProcessor(), false);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintLoadingSheetReportComponent.this.layoutInheritedComponents(parent);
            PrintLoadingSheetReportComponent.this.options.setLocation(PrintLoadingSheetReportComponent.this.border, y += PrintLoadingSheetReportComponent.this.border);
            PrintLoadingSheetReportComponent.this.options.setSize(PrintLoadingSheetReportComponent.this.options.getPreferredSize());
            PrintLoadingSheetReportComponent.this.includeArticles.setLocation(PrintLoadingSheetReportComponent.this.border, PrintLoadingSheetReportComponent.this.options.getY() + PrintLoadingSheetReportComponent.this.options.getHeight() + PrintLoadingSheetReportComponent.this.border / 2);
            PrintLoadingSheetReportComponent.this.includeArticles.setSize(parent.getWidth() - 2 * PrintLoadingSheetReportComponent.this.border, (int)PrintLoadingSheetReportComponent.this.includeArticles.getPreferredSize().getHeight());
            PrintLoadingSheetReportComponent.this.includeEmptyEquipments.setLocation(PrintLoadingSheetReportComponent.this.border, PrintLoadingSheetReportComponent.this.includeArticles.getY() + PrintLoadingSheetReportComponent.this.includeArticles.getHeight() + PrintLoadingSheetReportComponent.this.border / 2);
            PrintLoadingSheetReportComponent.this.includeEmptyEquipments.setSize(parent.getWidth() - 2 * PrintLoadingSheetReportComponent.this.border, (int)PrintLoadingSheetReportComponent.this.includeEmptyEquipments.getPreferredSize().getHeight());
            PrintLoadingSheetReportComponent.this.department.setLocation(PrintLoadingSheetReportComponent.this.border, PrintLoadingSheetReportComponent.this.includeEmptyEquipments.getY() + PrintLoadingSheetReportComponent.this.includeEmptyEquipments.getHeight() + PrintLoadingSheetReportComponent.this.border);
            PrintLoadingSheetReportComponent.this.department.setSize(parent.getWidth() - 2 * PrintLoadingSheetReportComponent.this.border, (int)PrintLoadingSheetReportComponent.this.department.getPreferredSize().getHeight());
            PrintLoadingSheetReportComponent.this.labelColor.setLocation(PrintLoadingSheetReportComponent.this.border, PrintLoadingSheetReportComponent.this.department.getY() + PrintLoadingSheetReportComponent.this.department.getHeight() + PrintLoadingSheetReportComponent.this.border / 2);
            PrintLoadingSheetReportComponent.this.labelColor.setSize(parent.getWidth() - 2 * PrintLoadingSheetReportComponent.this.border, (int)PrintLoadingSheetReportComponent.this.labelColor.getPreferredSize().getHeight());
            PrintLoadingSheetReportComponent.this.infoLabel.setLocation(PrintLoadingSheetReportComponent.this.border, PrintLoadingSheetReportComponent.this.labelColor.getY() + PrintLoadingSheetReportComponent.this.labelColor.getHeight() + PrintLoadingSheetReportComponent.this.border);
            PrintLoadingSheetReportComponent.this.infoLabel.setSize(parent.getWidth() - 2 * PrintLoadingSheetReportComponent.this.infoLabel.getX(), (int)PrintLoadingSheetReportComponent.this.infoLabel.getPreferredSize().getHeight());
            if (PrintLoadingSheetReportComponent.this.dateChooser != null) {
                PrintLoadingSheetReportComponent.this.dateChooser.setLocation(PrintLoadingSheetReportComponent.this.border, PrintLoadingSheetReportComponent.this.infoLabel.getY() + PrintLoadingSheetReportComponent.this.infoLabel.getHeight() + PrintLoadingSheetReportComponent.this.border);
                PrintLoadingSheetReportComponent.this.dateChooser.setSize(PrintLoadingSheetReportComponent.this.dateChooser.getPreferredSize());
                y = PrintLoadingSheetReportComponent.this.dateChooser.getY() + PrintLoadingSheetReportComponent.this.dateChooser.getHeight();
            }
            if (PrintLoadingSheetReportComponent.this.paxCount != null) {
                PrintLoadingSheetReportComponent.this.paxCount.setLocation(PrintLoadingSheetReportComponent.this.border, y);
                PrintLoadingSheetReportComponent.this.paxCount.setSize(parent.getWidth() - 2 * PrintLoadingSheetReportComponent.this.border, (int)PrintLoadingSheetReportComponent.this.paxCount.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintLoadingSheetReportComponent.this.getInheritedComponentsHeight() + PrintLoadingSheetReportComponent.this.border;
            h = (int)((double)h + PrintLoadingSheetReportComponent.this.options.getPreferredSize().getHeight());
            h += PrintLoadingSheetReportComponent.this.border / 2;
            h = (int)((double)h + PrintLoadingSheetReportComponent.this.includeArticles.getPreferredSize().getHeight());
            h += PrintLoadingSheetReportComponent.this.border / 2;
            h = (int)((double)h + PrintLoadingSheetReportComponent.this.includeEmptyEquipments.getPreferredSize().getHeight());
            h += PrintLoadingSheetReportComponent.this.border;
            h = (int)((double)h + PrintLoadingSheetReportComponent.this.department.getPreferredSize().getHeight());
            h += PrintLoadingSheetReportComponent.this.border / 2;
            h = (int)((double)h + PrintLoadingSheetReportComponent.this.labelColor.getPreferredSize().getHeight());
            h += PrintLoadingSheetReportComponent.this.border / 2;
            h = (int)((double)h + PrintLoadingSheetReportComponent.this.infoLabel.getPreferredSize().getHeight());
            h += PrintLoadingSheetReportComponent.this.border;
            if (PrintLoadingSheetReportComponent.this.dateChooser != null) {
                h = (int)((double)h + PrintLoadingSheetReportComponent.this.dateChooser.getPreferredSize().getHeight());
                h += PrintLoadingSheetReportComponent.this.border;
            }
            if (PrintLoadingSheetReportComponent.this.paxCount != null) {
                h = (int)((double)h + PrintLoadingSheetReportComponent.this.paxCount.getPreferredSize().getHeight());
                h += PrintLoadingSheetReportComponent.this.border;
            }
            return new Dimension(0, h);
        }
    }
}

