/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.customer.crew;

import ch.icit.pegasus.client.gui.screentemplates.SubModuleScreenInsert;
import ch.icit.pegasus.client.gui.submodules.tool.customer.crew.utils.CrewTable;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.RowTransferObject;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.masterdata.CreditCardTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SoBAccessLevelComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.CustomerAccess;
import ch.icit.pegasus.server.core.dtos.sob.CrewMemberComplete;
import ch.icit.pegasus.server.core.dtos.sob.CrewMemberLight_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CrewSubModule
extends SubModuleScreenInsert<CustomerLight> {
    private static final long serialVersionUID = 1L;
    private CrewTable crewMembers;
    private Node<CustomerComplete> customer;
    private CustomerLight customerDTO;

    public CrewSubModule() {
        this.setOpaque(false);
    }

    public boolean isChargeBased() {
        return true;
    }

    protected void createFocusCycle() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.crewMembers);
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    @Override
    public String getScreenTitle() {
        return CustomerAccess.TOOL_CUSTOMER_CREW.getDisplayName();
    }

    public void init() {
        this.crewMembers = new CrewTable(this.customerDTO);
        this.crewMembers.getModel().addFocusCycleChangeListener(container -> this.createFocusCycle());
        this.setLayout(new Layout());
        this.add(this.crewMembers);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        boolean b = false;
        if (this.currentState == 5) {
            CustomerComplete c = (CustomerComplete)node.getValue(CustomerComplete.class);
            Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, false, false);
            this.crewMembers.getModel().setNode(n.getChildNamed(CustomerComplete_.crewMembers));
            b = false;
            this.crewMembers.hideLoadingAnimation();
        } else if (this.currentState == 11) {
            this.cancelDocument();
        } else if (this.currentState == 7) {
            b = false;
            CustomerComplete c = (CustomerComplete)node.getValue(CustomerComplete.class);
            Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, false, false);
            n.updateNode();
        } else {
            b = false;
        }
        if (!b) {
            this.crewMembers.hideLoadingAnimation();
            this.setEnabled(true);
        }
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.crewMembers.hideLoadingAnimation();
        super.errorOccurred(exception);
    }

    public void redo() {
    }

    public void undo() {
    }

    @Override
    public void saveAndBackDocument() {
        this.currentState = 11;
        this.crewMembers.showLoadingAnimation(Words.SAVE_DATA);
        List<ScreenValidationObject> o = this.validateSubModule();
        if (o.isEmpty()) {
            this.doSaveDocument();
        } else {
            InnerPopupFactory.showErrorDialog(o, "Unable to save Crew Members", (Component)this);
            this.crewMembers.hideLoadingAnimation();
        }
    }

    @Override
    public void saveDocument() {
        this.currentState = 7;
        this.crewMembers.showLoadingAnimation(Words.SAVE_DATA);
        List<ScreenValidationObject> o = this.validateSubModule();
        if (o.isEmpty()) {
            this.doSaveDocument();
        } else {
            InnerPopupFactory.showErrorDialog(o, "Unable to save Crew Members", (Component)this);
            this.crewMembers.hideLoadingAnimation();
        }
    }

    private List<ScreenValidationObject> validateSubModule() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        boolean foundError = false;
        HashSet<String> crewCodes = new HashSet<String>();
        for (Table2RowPanel p : this.crewMembers.getRows()) {
            String t = (String)p.getModel().getNode().getChildNamed(CrewMemberLight_.crewID).getValue();
            if (!crewCodes.add(t)) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Crew Code " + t + " must be unique"));
            }
            if (p.isRowValid()) continue;
            foundError = true;
        }
        if (foundError) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all fields are set"));
        }
        return o;
    }

    private void doSaveDocument() {
        List<ScreenValidationObject> a = this.crewMembers.validateTable();
        if (a != null && !a.isEmpty()) {
            InnerPopupFactory.showErrorDialog(a, "Unable to save Crew Members", (Component)this.crewMembers);
            this.crewMembers.hideLoadingAnimation();
        } else {
            this.setEnabled(false);
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    CrewSubModule.this.customer.commit(CustomerComplete.class);
                    CustomerComplete c = (CustomerComplete)CrewSubModule.this.customer.getValue(CustomerComplete.class);
                    for (CrewMemberComplete cm : c.getCrewMembers()) {
                        if (cm.getPin() != null) continue;
                        cm.setPin("");
                    }
                    c = (CustomerComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateCustomer((CustomerReference)c).getValue();
                    ViewNode n = new ViewNode("");
                    n.setValue((Object)c, 0L);
                    n.updateNode();
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return CrewSubModule.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    private void doLoadDocument() {
        this.setEnabled(false);
        this.currentState = 5;
        this.crewMembers.showLoadingAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                CustomerComplete c = null;
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CreditCardTypeComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SoBAccessLevelComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                StaticEnumServiceManager.getAllCreditCardValidity();
                c = (CustomerComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getCustomer((CustomerReference)CrewSubModule.this.customerDTO).getValue();
                if (c != null) {
                    CrewSubModule.this.customer = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, false, false);
                }
                ViewNode n = new ViewNode("");
                n.setValue((Object)c, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return CrewSubModule.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void screenSet() {
    }

    @Override
    public void startDataDownload() {
        this.doLoadDocument();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.crewMembers != null) {
            this.crewMembers.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.crewMembers != null) {
            this.crewMembers.kill();
        }
        this.crewMembers = null;
    }

    @Override
    public void setRowAttributes(RowTransferObject<CustomerLight> o) {
        if (o != null) {
            this.setRow(o.getFakeRow());
            this.customerDTO = (CustomerLight)o.getDto();
            this.init();
        }
    }

    @Override
    public SubModuleDefinitionComplete getSubModuleDefinition() {
        return CustomerAccess.getSubModuleDefinition((SubModuleAccessDefinition)CustomerAccess.TOOL_CUSTOMER_CREW);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = CrewSubModule.this.layoutTitle(parent);
            int border = 10;
            y = CrewSubModule.this.layoutTitleBar(y, parent.getWidth());
            CrewSubModule.this.crewMembers.setLocation(0, y + border);
            CrewSubModule.this.crewMembers.setSize(parent.getWidth(), parent.getHeight() - CrewSubModule.this.crewMembers.getY());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

