/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.flight.rim;

import ch.icit.pegasus.client.gui.screentemplates.SubModuleScreenInsert;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rim.utils.RiMTable;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.RowTransferObject;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionTransactionDataComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.AFlightAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class RiMSubModule
extends SubModuleScreenInsert<FlightLight> {
    private static final long serialVersionUID = 1L;
    private RiMTable transactionTable;
    private Node<List<RetailInMotionTransactionDataComplete>> data;
    private FlightLight flight;

    public RiMSubModule() {
        this.setOpaque(false);
    }

    public boolean isChargeBased() {
        return true;
    }

    protected void createFocusCycle() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.transactionTable);
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    @Override
    public String getScreenTitle() {
        return FlightAccess.TOOL_EDIT_RIM_TRANSACTIONS.getDisplayName();
    }

    public void init() {
        this.transactionTable = new RiMTable(this.flight);
        this.transactionTable.getModel().addFocusCycleChangeListener(new MutableFocusContainerListener(){

            @Override
            public void focusCycleChanged(MutableFocusContainer container) {
                RiMSubModule.this.createFocusCycle();
            }
        });
        this.setLayout(new Layout());
        this.add(this.transactionTable);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        boolean b = false;
        if (this.currentState == 5) {
            List c = (List)node.getValue(List.class);
            Node n = INodeCreator.getDefaultImpl().createNodes(c, false);
            this.transactionTable.getModel().setNode(n);
            b = false;
            this.transactionTable.hideLoadingAnimation();
        } else if (this.currentState == 11) {
            this.cancelDocument();
        } else {
            b = this.currentState == 7 ? false : false;
        }
        if (!b) {
            this.transactionTable.hideLoadingAnimation();
            this.setEnabled(true);
        }
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.transactionTable.hideLoadingAnimation();
        super.errorOccurred(exception);
    }

    public void redo() {
    }

    public void undo() {
    }

    @Override
    public void saveAndBackDocument() {
        this.currentState = 11;
        this.transactionTable.showLoadingAnimation(Words.SAVE_DATA);
        this.doSaveDocument();
    }

    @Override
    public void saveDocument() {
        this.currentState = 7;
        this.transactionTable.showLoadingAnimation(Words.SAVE_DATA);
        this.doSaveDocument();
    }

    private void doSaveDocument() {
        Object a = null;
        this.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RiMSubModule.this.transactionTable.commit();
                Node transactionData = RiMSubModule.this.transactionTable.getModel().getNode();
                transactionData.commit(List.class);
                ListWrapper c = new ListWrapper((List)transactionData.getValue(List.class));
                ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).updateRiMTransactionsForFlight(c);
                ViewNode n = new ViewNode("");
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return RiMSubModule.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void doLoadDocument() {
        this.setEnabled(false);
        this.currentState = 5;
        this.transactionTable.showLoadingAnimation(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                List c = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getRiMTransactionsForFlight((FlightReference)RiMSubModule.this.flight).getList();
                if (c != null) {
                    RiMSubModule.this.data = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, false, false);
                }
                ViewNode n = new ViewNode("");
                n.setValue((Object)c, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return RiMSubModule.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void screenSet() {
    }

    @Override
    public void startDataDownload() {
        this.doLoadDocument();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.transactionTable.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.transactionTable != null) {
            this.transactionTable.kill();
        }
        this.transactionTable = null;
    }

    @Override
    public void setRowAttributes(RowTransferObject<FlightLight> o) {
        if (o != null) {
            this.setRow(o.getFakeRow());
            this.flight = (FlightLight)o.getDto();
            this.init();
        }
    }

    @Override
    public SubModuleDefinitionComplete getSubModuleDefinition() {
        return AFlightAccess.getSubModuleDefinition((SubModuleAccessDefinition)AFlightAccess.TOOL_EDIT_RIM_TRANSACTIONS);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = RiMSubModule.this.layoutTitle(parent);
            int border = 10;
            y = RiMSubModule.this.layoutTitleBar(y, parent.getWidth());
            RiMSubModule.this.transactionTable.setLocation(0, y + border);
            RiMSubModule.this.transactionTable.setSize(parent.getWidth(), parent.getHeight() - RiMSubModule.this.transactionTable.getY());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

