/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBox;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyGrid;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyGridPanel;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Iterator;

public class GalleySpecialGrid
extends GalleyGrid {
    private static final long serialVersionUID = 1L;
    private Area theInverseArea;
    private ArrayList<GalleyBox> theSpecialBoxes = new ArrayList();

    public GalleySpecialGrid(GalleyGridPanel g) {
        super(g);
    }

    public GalleyBox getIntersectionBox(int x, int y, boolean special) {
        if (!special) {
            for (GalleyBox box : this.theSpecialBoxes) {
                if (x <= box.getX() || x >= box.getX() + box.getWidth() || y <= box.getY() || y >= box.getY() + box.getHeight()) continue;
                return box;
            }
        }
        for (GalleyBox box : this.theBoxes) {
            if (x <= box.getX() || x >= box.getX() + box.getWidth() || y <= box.getY() || y >= box.getY() + box.getHeight()) continue;
            return box;
        }
        return null;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.theInverseArea = null;
        for (GalleyBox g : this.theSpecialBoxes) {
            g.kill();
        }
        this.theSpecialBoxes.clear();
        this.theSpecialBoxes = null;
    }

    @Override
    public int isEmptyField(int x, int y, double xdSize, double ydSize, double zdSize) {
        double aXg = this.getDiscretIndexX(x, xdSize);
        double aYg = this.getDiscretIndexY(y, ydSize);
        aXg = aXg * (double)this.getGridSizeX() + (double)this.getGridOffsetX();
        aYg = aYg * (double)this.getGridSizeY() + (double)this.getGridOffsetY();
        double aWg = xdSize * (double)this.getGridSizeX();
        double aHg = ydSize * (double)this.getGridSizeY();
        if (x < this.getGridOffsetX() || y < this.getGridOffsetY()) {
            return 0;
        }
        if (this.theBoxArea.intersects(aXg, aYg, aWg, aHg)) {
            GalleyBox aBox;
            if (zdSize == 0.5 && (aBox = this.getSpecialBox4Coordinate(x, y, false)) != null) {
                int count;
                GalleyBox hsBox;
                double dx = this.getDiscretIndexX(x, xdSize);
                double dy = this.getDiscretIndexY(y, ydSize);
                if (aBox.getDDepth() == 1.0 && dx == aBox.getDX() && dy == aBox.getDY() && (hsBox = this.getSpecialBox4Coordinate(x, y, true)) != null && hsBox.getDDepth() == zdSize && (count = this.getSpezialBoxCount4Coordinate(x, y)) == 1) {
                    return 2;
                }
            }
            return 0;
        }
        GalleyBox aBox = this.getSpecialBox4Coordinate(x, y, false);
        if (aBox != null) {
            if (aBox.getDWidth() == xdSize && aBox.getDHeight() == ydSize) {
                if (aBox.getDDepth() >= zdSize) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    public GalleyBox getSpecialBox4DiscretCoordinate(double x, double y, boolean special) {
        if (special) {
            for (GalleyBox box : this.theSpecialBoxes) {
                if (box.getDX() != x || box.getDY() != y) continue;
                return box;
            }
        } else {
            for (GalleyBox box : this.theBoxes) {
                if (box.getDX() != x || box.getDY() != y) continue;
                return box;
            }
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.red);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public GalleyBox getSpecialBox4Coordinate(double x, double y, boolean isSpezial) {
        if (isSpezial) {
            for (GalleyBox box : this.theSpecialBoxes) {
                if (!((double)box.getX() < x) || !((double)(box.getX() + box.getWidth()) > x) || !((double)box.getY() < y) || !((double)(box.getY() + box.getHeight()) > y)) continue;
                return box;
            }
        } else {
            for (GalleyBox box : this.theBoxes) {
                if (!((double)box.getX() < x) || !((double)(box.getX() + box.getWidth()) > x) || !((double)box.getY() < y) || !((double)(box.getY() + box.getHeight()) > y)) continue;
                return box;
            }
        }
        return null;
    }

    public int getSpezialBoxCount4Coordinate(double x, double y) {
        int count = 0;
        for (GalleyBox box : this.theSpecialBoxes) {
            if (!((double)box.getX() < x) || !((double)(box.getX() + box.getWidth()) > x) || !((double)box.getY() < y) || !((double)(box.getY() + box.getHeight()) > y)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void layoutBoxes() {
        double ny;
        double nx;
        this.theInverseArea = new Area();
        this.theBoxArea = new Area();
        this.theBoxArea.add(new Area(new Rectangle(0, 0, this.getWidth(), this.getHeight())));
        int gridOffsetX = this.getGridOffsetX();
        int gridOffsetY = this.getGridOffsetY();
        this.theBoxArea.add(new Area(new Rectangle(0, 0, gridOffsetX, this.getHeight())));
        this.theBoxArea.add(new Area(new Rectangle(0, 0, this.getWidth(), gridOffsetY)));
        this.theBoxArea.add(new Area(new Rectangle(0, this.getHeight() - gridOffsetY, this.getWidth(), gridOffsetY)));
        this.theBoxArea.add(new Area(new Rectangle(this.getWidth() - gridOffsetX, 0, gridOffsetX, this.getHeight())));
        for (GalleyBox aBox : this.theBoxes) {
            nx = 0.0;
            nx = this.isSubGalley ? (double)this.getGridOffsetX() + aBox.getDZ() * (double)this.getGridSizeX() : (double)this.getGridOffsetX() + aBox.getDX() * (double)this.getGridSizeX();
            ny = (double)this.getGridOffsetY() + aBox.getDY() * (double)this.getGridSizeY();
            aBox.setLocation((int)nx, (int)ny);
            aBox.layoutPanel(this.getGridSizeX(), this.getGridSizeY(), this.isSubGalley);
            this.theInverseArea.add(new Area(new Rectangle(aBox.getX(), aBox.getY(), aBox.getWidth(), aBox.getHeight())));
            this.theBoxArea.subtract(new Area(new Rectangle(aBox.getX(), aBox.getY(), aBox.getWidth(), aBox.getHeight())));
        }
        for (GalleyBox aBox : this.theSpecialBoxes) {
            nx = 0.0;
            nx = this.isSubGalley ? (double)this.getGridOffsetX() + aBox.getDZ() * (double)this.getGridSizeX() : (double)this.getGridOffsetX() + aBox.getDX() * (double)this.getGridSizeX();
            ny = (double)this.getGridOffsetY() + aBox.getDY() * (double)this.getGridSizeY();
            aBox.setLocation((int)nx, (int)ny);
            aBox.layoutPanel(this.getGridSizeX(), this.getGridSizeY(), this.isSubGalley);
            this.theBoxArea.add(new Area(new Rectangle(aBox.getX(), aBox.getY(), aBox.getWidth(), aBox.getHeight())));
        }
    }

    @Override
    public void addSpecialBox(GalleyBox g) {
        if (!this.theSpecialBoxes.contains(g)) {
            this.theSpecialBoxes.add(g);
        }
        this.add((Component)g, 0);
        this.layoutBoxes();
        g.setVisible(true);
    }

    @Override
    public void removeAll() {
        GalleyBox box;
        Iterator<GalleyBox> it = this.theSpecialBoxes.iterator();
        while (it.hasNext()) {
            box = it.next();
            box.fadeOut(true);
            it.remove();
        }
        it = this.theBoxes.iterator();
        while (it.hasNext()) {
            box = it.next();
            box.fadeOut(true);
            it.remove();
        }
        this.layoutBoxes();
        this.repaint(32L);
    }

    @Override
    public boolean intersectsBox(int x, int y) {
        return this.theInverseArea.contains(x, y);
    }

    @Override
    public GalleyBox getIntersectingBox(int x, int y) {
        return this.getIntersectingBox(x, y, false);
    }

    @Override
    public void removeBox(GalleyBox galleyBox) {
        if (!this.theSpecialBoxes.remove(galleyBox)) {
            this.theBoxes.remove(galleyBox);
        }
        this.layoutBoxes();
    }

    @Override
    public boolean containsBox(GalleyBox box) {
        return this.theSpecialBoxes.contains(box);
    }

    @Override
    public void selectNode(Node parent, int level) {
        for (GalleyBox box : this.theSpecialBoxes) {
            if (box.getNode() != parent) continue;
            this.theGalley.setSelectedBox(box, level);
            return;
        }
    }

    @Override
    public GalleyBox getBox4Node(Node node) {
        for (GalleyBox box : this.theSpecialBoxes) {
            if (box.getNode() != node) continue;
            return box;
        }
        for (GalleyBox box : this.theBoxes) {
            if (box.getNode() != node) continue;
            return box;
        }
        return null;
    }
}

