/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.search;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.search.SearchAlgorithmus;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class ProductSearchAlgorithm
implements SearchAlgorithmus,
RemoteLoader {
    private Node productRoot;
    private ch.icit.pegasus.client.search.impls.remote.ProductSearchAlgorithm algo;
    private String nextPattern;
    private boolean isSearching;
    private CustomerLight currentCustomer;
    private Component c;

    public ProductSearchAlgorithm(Node m, Component comp) {
        this.productRoot = m;
        this.c = comp;
    }

    public void setCurrentCustomer(CustomerLight ref) {
        this.currentCustomer = ref;
    }

    public void setNode(Node m) {
        this.productRoot = m;
    }

    @Override
    public ArrayList search(ArrayList theList, String pattern) {
        if (!this.isSearching) {
            this.isSearching = true;
            this.doSearch(pattern);
        } else {
            this.nextPattern = pattern;
        }
        return theList;
    }

    private void doSearch(final String pattern) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductSearchConfiguration b = new ProductSearchConfiguration();
                ArrayList<ADTO> locations = new ArrayList<ADTO>();
                locations.add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                b.setLocations(locations);
                try {
                    int no = Integer.valueOf(pattern);
                    b.setNumber(Integer.valueOf(no));
                    b.setName(null);
                }
                catch (NumberFormatException e) {
                    b.setName(pattern);
                }
                b.setCustomer(ProductSearchAlgorithm.this.currentCustomer);
                b.setNumResults(30);
                b.setIsDeleted(Boolean.valueOf(false));
                if (ProductSearchAlgorithm.this.algo == null) {
                    SearchAlgorithm r = SearchAlgorithmRegistry.getSearchAlgorithm(ch.icit.pegasus.client.search.impls.remote.ProductSearchAlgorithm.class);
                    ProductSearchAlgorithm.this.algo = (ch.icit.pegasus.client.search.impls.remote.ProductSearchAlgorithm)r;
                }
                ViewNode n = null;
                n = ProductSearchAlgorithm.this.algo.search((ASearchConfiguration)b);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ProductSearchAlgorithm.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void remoteObjectLoaded(Node<?> node) {
        if (ScreenValidationObject.isErrorList(node)) {
            InnerPopupFactory.showErrorDialog((List)node.getValue(), "Unable to search", this.c);
            return;
        }
        this.algo.mergeValues(this.productRoot, ((SearchResult)node.getValue()).getResults());
        if (this.nextPattern == null) {
            this.isSearching = false;
        } else {
            this.doSearch(this.nextPattern);
            this.nextPattern = null;
        }
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), this.c);
    }
}

