/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class GraphicsUtils {
    public static int drawWrapedString(Graphics2D g, int startx, int starty, int maxWidth, String t) {
        String[] texts = t.split(" ");
        int currentX = startx;
        int currentY = starty;
        for (int i = 0; i < texts.length; ++i) {
            int length = g.getFontMetrics().stringWidth(texts[i] + " ");
            g.drawString(texts[i], currentX, currentY);
            if (currentX + length > maxWidth) {
                if (i + 1 >= texts.length) continue;
                currentX = startx;
                currentY += g.getFont().getSize();
                continue;
            }
            currentX += length;
        }
        return currentY;
    }

    public static int getWrapedStringHeight(FontMetrics fm, Font f, int startx, int starty, int maxWidth, String t) {
        String[] texts = t.split(" ");
        int currentX = startx;
        int currentY = starty;
        for (int i = 0; i < texts.length; ++i) {
            int length = fm.stringWidth(texts[i] + " ");
            if (currentX + length > maxWidth) {
                currentX = startx;
                currentY += f.getSize();
            }
            currentX += length;
        }
        return currentY;
    }

    public static void printMaxofString(Graphics2D g2, int x, int y, FontMetrics fm, String text, int maxWidth) {
        int textWidth = fm.stringWidth(text);
        String displayedString = "";
        if (textWidth > maxWidth) {
            int currentIndex = text.length() - 1;
            String sub = text.substring(0, currentIndex);
            sub = sub + "...";
            textWidth = fm.stringWidth(sub);
            boolean out = false;
            while (textWidth > maxWidth && !out) {
                if (--currentIndex < 0) {
                    out = true;
                    sub = ".";
                    textWidth = fm.stringWidth(sub);
                    continue;
                }
                sub = text.substring(0, currentIndex);
                sub = sub + "...";
                textWidth = fm.stringWidth(sub);
            }
            displayedString = sub;
        } else {
            displayedString = text;
        }
        g2.drawString(displayedString, x, y);
    }
}

