/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.utils.CateringServiceScheduleVariantSorter;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.AlaCarteMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentInsertTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupReference;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServicePartComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationLight;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleReference;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantLight;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantReference;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ICateringServiceScheduleVariantReference;
import ch.icit.pegasus.server.core.dtos.mealplan.LoadingGroupTemplateComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanReference;
import ch.icit.pegasus.server.core.dtos.mealplan.MealTypeComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class MealPlanSpecificationDataHandler
extends DefaultDataHandler<CateringServiceScheduleComplete, CateringServiceScheduleComplete> {
    private Node currentNode;

    public MealPlanSpecificationDataHandler(long id) {
        super(id, null);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    public void setCurrentNode(Node n) {
        this.currentNode = n;
    }

    public boolean reloadVariant(final Node<CateringServiceScheduleVariantComplete> aNode, final RemoteLoader listener, final ProgressListener pListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                MealPlanSpecificationDataHandler.this.showMessage(pListener, Words.LOAD_DATA);
                Long id = 0L;
                if (aNode.getValue(CateringServiceScheduleVariantReference.class) != null) {
                    id = ((CateringServiceScheduleVariantReference)aNode.getValue(CateringServiceScheduleVariantReference.class)).getId();
                } else if (aNode.getValue(CateringServiceScheduleVariantLight.class) != null) {
                    id = ((CateringServiceScheduleVariantLight)aNode.getValue(CateringServiceScheduleVariantLight.class)).getId();
                }
                if (id != null) {
                    CateringServiceScheduleVariantComplete pc = (CateringServiceScheduleVariantComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getVariant(new CateringServiceScheduleVariantReference(id)).getValue();
                    aNode.removeExistingValues();
                    aNode.setValue((Object)pc, 0L);
                    aNode.updateNode();
                }
                return aNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public boolean reloadDataAfterClosing(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                CateringServiceScheduleComplete oldService = (CateringServiceScheduleComplete)node.getValue(CateringServiceScheduleComplete.class);
                CateringServiceScheduleComplete newService = (CateringServiceScheduleComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getServiceSchedule(oldService).getValue();
                node.removeExistingValues();
                node.setValue((Object)newService, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node dpNode;
                CateringServiceScheduleComplete oldService = (CateringServiceScheduleComplete)node.getValue(CateringServiceScheduleComplete.class);
                CateringServiceScheduleComplete newService = (CateringServiceScheduleComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getServiceSchedule(oldService).getValue();
                node.removeExistingValues();
                node.setValue((Object)newService, 0L);
                node.updateNode();
                List variants = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getMealPlanLightVariants(new CateringServiceScheduleReference(newService.getId())).getList();
                Object pvc = null;
                node.disableEvents();
                node.getChildNamed(new String[]{"variants"}).disableEvents();
                node.getChildNamed(new String[]{"variants"}).removeExistingValues();
                node.getChildNamed(new String[]{"variants"}).setValue((Object)variants, 0L);
                node.getChildNamed(new String[]{"variants"}).updateNode();
                node.getChildNamed(new String[]{"variants"}).enableEvents();
                node.enableEvents();
                Node n = node;
                CateringServiceScheduleComplete r = (CateringServiceScheduleComplete)node.getValue(CateringServiceScheduleComplete.class);
                MealPlanLight mp = (MealPlanLight)MealPlanSpecificationDataHandler.this.currentNode.getValue();
                List referencedParts = null;
                if (r.getId() != null) {
                    referencedParts = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getUsedLoadingGroups(null, r);
                }
                if (referencedParts == null) {
                    referencedParts = new ArrayList();
                }
                if ((dpNode = node.getChildNamed(new String[]{"referencedLoadingGroups"})) == null) {
                    dpNode = INodeCreator.getDefaultImpl().createNodes(referencedParts, true);
                    if (dpNode == null) {
                        dpNode = new ListNode();
                    }
                    dpNode.setName("referencedLoadingGroups");
                    node.addChild(dpNode, 0L);
                }
                dpNode.removeExistingValues();
                dpNode.setValue(referencedParts, 0L);
                dpNode.updateNode();
                node.getChildNamed(new DtoField[]{CateringServiceScheduleComplete_.mealplan, MealPlanLight_.state}).setValue((Object)newService.getMealplan().getState(), 0L);
                Node mealPlan = node.getChildNamed(CateringServiceScheduleComplete_.mealplan);
                if (mealPlan instanceof ProxyNode) {
                    ProxyNode mpNode = (ProxyNode)mealPlan;
                    mpNode.setSource((Object)newService.getMealplan());
                    if (mpNode.getRefNode() != null) {
                        mpNode.getRefNode().removeExistingValues();
                        mpNode.getRefNode().setValue((Object)newService.getMealplan(), 0L);
                    }
                } else {
                    mealPlan.removeExistingValues();
                    mealPlan.setValue((Object)newService.getMealplan(), 0L);
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<CateringServiceScheduleComplete> node, final RemoteLoader model, final ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                MealPlanSpecificationDataHandler.this.showMessage(l, Words.SAVE_DATA);
                HashMap<Class<ALoadingGroupReference>, Class<LoadingGroupTemplateComplete>> classMapping = new HashMap<Class<ALoadingGroupReference>, Class<LoadingGroupTemplateComplete>>();
                classMapping.put(CateringServiceRotationLight.class, CateringServiceRotationComplete.class);
                classMapping.put(CateringServiceScheduleReference.class, CateringServiceScheduleComplete.class);
                classMapping.put(ALoadingGroupReference.class, LoadingGroupTemplateComplete.class);
                node.commit(CateringServiceScheduleComplete.class, classMapping);
                CateringServiceScheduleComplete dto = (CateringServiceScheduleComplete)node.getValue(CateringServiceScheduleComplete.class);
                Iterator it = node.getChildNamed(CateringServiceScheduleComplete_.loadingGroups).getFailSafeChildIterator();
                ArrayList<LoadingGroupTemplateComplete> loadingGroups = new ArrayList<LoadingGroupTemplateComplete>();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    n.commitThis(LoadingGroupTemplateComplete.class);
                    LoadingGroupTemplateComplete value = (LoadingGroupTemplateComplete)n.getValue(LoadingGroupTemplateComplete.class);
                    loadingGroups.add(value);
                }
                dto.setLoadingGroups(loadingGroups);
                ArrayList<CateringServiceScheduleVariantComplete> cl = new ArrayList<CateringServiceScheduleVariantComplete>();
                ArrayList<CateringServiceScheduleVariantComplete> ll = new ArrayList<CateringServiceScheduleVariantComplete>();
                ArrayList<Object> allVariants = new ArrayList<Object>();
                SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                it = node.getChildNamed(new String[]{"variants"}).getFailSafeChildIterator();
                while (it.hasNext()) {
                    CateringServiceScheduleVariantComplete c;
                    CateringServiceScheduleVariantComplete vc;
                    Node n = (Node)it.next();
                    n.getChildNamed(new String[]{"base"}).setValue((Object)dto, 0L);
                    if (n.getValue(CateringServiceScheduleVariantComplete.class) != null) {
                        vc = (CateringServiceScheduleVariantComplete)n.getValue(CateringServiceScheduleVariantComplete.class);
                        n.removeExistingValues();
                        n.setValue((Object)vc, 0L);
                        n.commitThis(CateringServiceScheduleVariantComplete.class, classMapping);
                        c = (CateringServiceScheduleVariantComplete)n.getValue(CateringServiceScheduleVariantComplete.class);
                        HashMap<ALoadingGroupComplete, Integer> partSortIndex = new HashMap<ALoadingGroupComplete, Integer>();
                        Collections.sort(c.getRotations());
                        for (CateringServiceRotationComplete rot : c.getRotations()) {
                            if (rot.getNumber() == 1) {
                                for (CateringServicePartComplete part : rot.getParts()) {
                                    partSortIndex.put(part.getLoadingGroup(), part.getNumber());
                                }
                            } else {
                                for (CateringServicePartComplete part : rot.getParts()) {
                                    int newIndex = (Integer)partSortIndex.get(part.getLoadingGroup());
                                    part.setNumber(Integer.valueOf(newIndex));
                                }
                            }
                            Collections.sort(rot.getParts());
                        }
                        c.setBase(dto);
                        cl.add(c);
                        allVariants.add(c);
                        continue;
                    }
                    if (n.getValue(CateringServiceScheduleVariantLight.class) != null) {
                        vc = (CateringServiceScheduleVariantLight)n.getValue(CateringServiceScheduleVariantLight.class);
                        n.removeExistingValues();
                        n.setValue((Object)vc, 0L);
                        n.commitThis(CateringServiceScheduleVariantLight.class, classMapping);
                        c = (CateringServiceScheduleVariantLight)n.getValue(CateringServiceScheduleVariantLight.class);
                        c.setBase(dto);
                        ll.add(c);
                        allVariants.add(c);
                        continue;
                    }
                    allVariants.add((ICateringServiceScheduleVariantReference)n.getValue());
                }
                Hashtable<Class<ALoadingGroupReference>, Class<LoadingGroupTemplateComplete>> t = new Hashtable<Class<ALoadingGroupReference>, Class<LoadingGroupTemplateComplete>>();
                t.put(CateringServiceScheduleVariantReference.class, CateringServiceScheduleVariantLight.class);
                t.put(CateringServiceScheduleVariantLight.class, CateringServiceScheduleVariantComplete.class);
                t.put(ALoadingGroupReference.class, LoadingGroupTemplateComplete.class);
                node.commit(CateringServiceScheduleComplete.class, t);
                dto = (CateringServiceScheduleComplete)node.getValue(CateringServiceScheduleComplete.class);
                it = node.getChildNamed(CateringServiceScheduleComplete_.loadingGroups).getFailSafeChildIterator();
                loadingGroups = new ArrayList();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    n.commitThis(LoadingGroupTemplateComplete.class);
                    LoadingGroupTemplateComplete value = (LoadingGroupTemplateComplete)n.getValue(LoadingGroupTemplateComplete.class);
                    loadingGroups.add(value);
                }
                dto.setLoadingGroups(loadingGroups);
                CateringServiceScheduleComplete l2 = dto;
                l2.setVariants(allVariants);
                if (!cl.isEmpty()) {
                    dto.setCurrentVariant((CateringServiceScheduleVariantComplete)cl.get(0));
                } else {
                    dto.setCurrentVariant(null);
                }
                CateringServiceScheduleComplete h = (CateringServiceScheduleComplete)node.getValue(MealPlanSpecificationDataHandler.this.getCommittingClass());
                ArrayList<CateringServiceScheduleVariantReference> refs = new ArrayList<CateringServiceScheduleVariantReference>();
                for (ICateringServiceScheduleVariantReference variant : h.getVariants()) {
                    refs.add((CateringServiceScheduleVariantReference)variant);
                }
                CateringServiceScheduleComplete nh = (CateringServiceScheduleComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).updateServiceSchedule(h, new ListWrapper(refs)).getValue();
                node.getChildNamed(new String[]{"variants"}).removeAllChilds();
                node.removeExistingValues();
                node.setValue((Object)nh, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<CateringServiceScheduleComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                HashMap<Class<ALoadingGroupReference>, Class<LoadingGroupTemplateComplete>> classMapping = new HashMap<Class<ALoadingGroupReference>, Class<LoadingGroupTemplateComplete>>();
                classMapping.put(CateringServiceRotationLight.class, CateringServiceRotationComplete.class);
                classMapping.put(CateringServiceScheduleReference.class, CateringServiceScheduleComplete.class);
                classMapping.put(ALoadingGroupReference.class, LoadingGroupTemplateComplete.class);
                CateringServiceScheduleComplete before = (CateringServiceScheduleComplete)node.getValue(CateringServiceScheduleComplete.class);
                node.commit(CateringServiceScheduleComplete.class, classMapping);
                CateringServiceScheduleComplete h = (CateringServiceScheduleComplete)node.getValue(CateringServiceScheduleComplete.class);
                Node nn = node;
                ArrayList<CateringServiceScheduleVariantComplete> cl = new ArrayList<CateringServiceScheduleVariantComplete>();
                Iterator it = node.getChildNamed(new String[]{"variants"}).getChilds();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    if (n.getValue(CateringServiceScheduleVariantComplete.class) == null) continue;
                    CateringServiceScheduleVariantComplete c = (CateringServiceScheduleVariantComplete)n.getValue(CateringServiceScheduleVariantComplete.class);
                    c.setBase(h);
                    cl.add(c);
                }
                node.commit(CateringServiceScheduleComplete.class);
                PeriodComplete pTime = h.getPeriod();
                MealPlanSpecificationDataHandler.this.ensurePeriodMatching(pTime, cl, true);
                if (!cl.isEmpty()) {
                    h.setCurrentVariant((CateringServiceScheduleVariantComplete)cl.get(0));
                } else {
                    h.setCurrentVariant(null);
                }
                h.getVariants().clear();
                h.getVariants().addAll(cl);
                MealPlanReference ref = (MealPlanReference)MealPlanSpecificationDataHandler.this.currentNode.getValue();
                ListWrapper objectListWrapper = new ListWrapper();
                for (ICateringServiceScheduleVariantReference variant : h.getVariants()) {
                    CateringServiceScheduleVariantReference varRef = (CateringServiceScheduleVariantReference)variant;
                    objectListWrapper.getList().add(varRef);
                }
                CateringServiceScheduleComplete nh = (CateringServiceScheduleComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).createServiceSchedule(new MealPlanReference(ref.getId()), h, objectListWrapper).getValue();
                if (nh != null) {
                    node.getChildNamed(new String[]{"variants"}).removeAllChilds();
                    node.removeExistingValues();
                    node.setValue((Object)nh, 0L);
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void ensurePeriodMatching(PeriodComplete pTime, List<CateringServiceScheduleVariantComplete> cl, boolean b) {
        ArrayList<CateringServiceScheduleVariantComplete> l = new ArrayList<CateringServiceScheduleVariantComplete>();
        l.addAll(cl);
        Collections.sort(l, ComparatorRegistry.getComparator(CateringServiceScheduleVariantSorter.class));
        long d = pTime.getEndDate().getTime() - pTime.getStartDate().getTime();
        if (l.size() > 0) {
            d /= (long)l.size();
        }
        long latestTS = -1L;
        for (int i = 0; i < l.size(); ++i) {
            CateringServiceScheduleVariantComplete f = (CateringServiceScheduleVariantComplete)l.get(i);
            long dd = pTime.getStartDate().getTime() + (long)i * d;
            if (latestTS != -1L) {
                f.getValidityPeriod().setStartDate(new Date(latestTS));
            } else {
                f.getValidityPeriod().setStartDate(new Date(dd));
            }
            if (i == l.size() - 1) {
                f.getValidityPeriod().setEndDate(pTime.getEndDate());
            } else {
                dd = pTime.getStartDate().getTime() + (long)(i + 1) * d;
                f.getValidityPeriod().setEndDate(new Date(--dd));
            }
            latestTS = f.getValidityPeriod().getEndDate().getTime() + 1L;
        }
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener listener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                MealPlanSpecificationDataHandler.this.showMessage(listener, "Load 1/13 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SpecialMenuTypeComplete.class);
                MealPlanSpecificationDataHandler.this.showMessage(listener, "Load 2/13 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CateringServiceTypeComplete.class);
                MealPlanSpecificationDataHandler.this.showMessage(listener, "Load 3/13 Modules");
                StaticEnumServiceManager.getAllRotationStrategies();
                MealPlanSpecificationDataHandler.this.showMessage(listener, "Load 5/13 Modules");
                StaticEnumServiceManager.getAllDateDurations();
                MealPlanSpecificationDataHandler.this.showMessage(listener, "Load 5/13 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                MealPlanSpecificationDataHandler.this.showMessage(listener, "Load 6/13 Modules");
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                MealPlanSpecificationDataHandler.this.showMessage(listener, "Load 7/13 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                MealPlanSpecificationDataHandler.this.showMessage(listener, "Load 8/13 Modules");
                StaticEnumServiceManager.getAllRotationQuantityTypes();
                MealPlanSpecificationDataHandler.this.showMessage(listener, "Load 9/13 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(GalleyEquipmentInsertTypeComplete.class);
                MealPlanSpecificationDataHandler.this.showMessage(listener, "Load 10/13 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(MealTypeComplete.class);
                MealPlanSpecificationDataHandler.this.showMessage(listener, "Load 11/13 Modules");
                StaticEnumServiceManager.getRoundingStrategies((boolean)true);
                MealPlanSpecificationDataHandler.this.showMessage(listener, "Load 12/13 Modules");
                StaticEnumServiceManager.getListInterpretationModes();
                MealPlanSpecificationDataHandler.this.showMessage(listener, "Load 13/13 Modules");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AlaCarteMenuTypeComplete.class);
                if (MealPlanSpecificationDataHandler.this.currentNode != null) {
                    Node dsNode;
                    MealPlanLight mpl = (MealPlanLight)MealPlanSpecificationDataHandler.this.currentNode.getValue();
                    ArrayList referencedServices = null;
                    referencedServices = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getUsedServices((MealPlanReference)mpl).getList();
                    if (referencedServices == null) {
                        referencedServices = new ArrayList();
                    }
                    if ((dsNode = NodeToolkit.getAffixNamed((String)"referencedServices")) == null) {
                        dsNode = INodeCreator.getDefaultImpl().createNodes(referencedServices, true);
                        if (dsNode == null) {
                            dsNode = new ListNode();
                        }
                        dsNode.setName("referencedServices");
                        NodeToolkit.addAffix((Node)dsNode);
                    }
                    dsNode.removeExistingValues();
                    dsNode.setValue(referencedServices, 0L);
                    MealPlanLight l = (MealPlanLight)MealPlanSpecificationDataHandler.this.currentNode.getValue();
                    if (MealPlanSpecificationDataHandler.this.currentNode.getValue(MealPlanComplete.class) == null) {
                        MealPlanComplete c = (MealPlanComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getMealPlan(new MealPlanReference(l.getId())).getValue();
                        MealPlanSpecificationDataHandler.this.currentNode.removeExistingValues();
                        MealPlanSpecificationDataHandler.this.currentNode.setValue((Object)c, 0L);
                    }
                    List services = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getServiceSchedules(new MealPlanReference(l.getId())).getList();
                    return INodeCreator.getDefaultImpl().createNodes(services, false);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return MealPlanSpecificationDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public boolean removeLoadingGroup(final Node node, final RemoteLoader listener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                CateringServiceScheduleComplete ret = (CateringServiceScheduleComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).removeLoadingGroup((LoadingGroupTemplateComplete)node.getValue(LoadingGroupTemplateComplete.class)).getValue();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    public boolean reloadData(final Node node, final RemoteLoader listener, ProgressListener progressListener, final boolean isAdd) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (!isAdd) {
                    MealPlanComplete c = (MealPlanComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getMealPlan(new MealPlanReference(((MealPlanReference)node.getValue(MealPlanReference.class)).getId())).getValue();
                    node.removeExistingValues();
                    node.setValue((Object)c, 0L);
                    node.updateNode();
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<CateringServiceScheduleComplete> resetData(Node<CateringServiceScheduleComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Node<CateringServiceScheduleComplete> createEmptyNode() {
        CateringServiceScheduleComplete ser = new CateringServiceScheduleComplete();
        ser.setClientOId(Long.valueOf(ADTO.getNextId()));
        CateringServiceScheduleVariantComplete v = new CateringServiceScheduleVariantComplete();
        v.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)ser, true, false);
        ser.setCurrentVariant(v);
        ser.getVariants().add(v);
        MealPlanLight mp = (MealPlanLight)this.currentNode.getValue();
        ser.setEligibleLocations(mp.getEligibleLocations());
        PeriodComplete period = new PeriodComplete(CalendarUtil.getDefaultStartDate((boolean)true), CalendarUtil.getInfinityDate());
        v.setValidityPeriod(period);
        ser.setPeriod(new PeriodComplete(period));
        return n;
    }

    @Override
    public Class<CateringServiceScheduleComplete> getCommittingClass() {
        return CateringServiceScheduleComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<CateringServiceScheduleComplete> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

