/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details;

import ch.icit.pegasus.client.enums.MealplanRotationStrategyE;
import ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details.StrategyTableDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceRotationComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.DayOfMonthRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.DayOfMonthRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixDurationRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixPeriodRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.FixRotationStrategyComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MonthRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MonthRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.PeriodRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.RotationDurationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.RotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.WeekdayRotationComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.WeekdayRotationStrategyComplete;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;

public class RotationConfigurationDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T>
implements NodeListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> strategy;
    private TitledItem<DateChooser> date;
    private boolean isInit = true;
    private StrategyTableDetailsPanel stratPanel;
    private Node<CateringServiceScheduleVariantComplete> currentNode;

    public RotationConfigurationDetailsPanel(RowEditor<T> editor, StrategyTableDetailsPanel stratPanel) {
        super(editor, null);
        this.stratPanel = stratPanel;
        this.setTitleText(Words.CYCLE_CONFIGURATION);
        this.setCustomLayouter(new Layout());
        this.strategy = new TitledItem<ComboBox>(new ComboBox(), Words.STRATEGY, TitledItem.TitledItemOrientation.NORTH);
        this.strategy.getElement().addItem("");
        this.strategy.getElement().addItem(MealplanRotationStrategyE.DAYOFMONTH);
        this.strategy.getElement().addItem(MealplanRotationStrategyE.FIX);
        this.strategy.getElement().addItem(MealplanRotationStrategyE.MONTH);
        this.strategy.getElement().addItem(MealplanRotationStrategyE.WEEKDAY);
        this.strategy.getElement().addItem(MealplanRotationStrategyE.PERIOD);
        this.strategy.setProgress(1.0f);
        this.addToView(this.strategy);
        this.date = new TitledItem<DateChooser>(new DateChooser(), Words.START_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.date.setProgress(0.0f);
        this.date.getFader().setPermanent(true);
        this.strategy.getElement().addItemListener(this);
        this.addToView(this.date);
        this.isInit = false;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.strategy);
        if (this.strategy != null && this.strategy.getElement() != null && this.strategy.getElement().getSelectedItem() != null && this.strategy.getElement().getSelectedItem().equals(MealplanRotationStrategyE.FIX)) {
            CheckedListAdder.addToList(a, this.date);
            a.addAll(this.date.getFocusComponents());
        }
        return a;
    }

    public ComboBox getStratChooser() {
        if (this.strategy == null) {
            return null;
        }
        return this.strategy.getElement();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.strategy != null) {
            this.strategy.getElement().removeItemListener(this);
            this.strategy.kill();
        }
        this.date.kill();
        if (this.currentNode != null && this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy) != null) {
            this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).removeNodeListener((NodeListener)this);
        }
        this.strategy = null;
        this.date = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean shouldEnable = isEnabled;
        MealPlanLight mp = (MealPlanLight)this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.mealplan).getValue();
        if (mp != null) {
            shouldEnable = mp.getState() == ModificationStateE.DRAFT && shouldEnable;
        }
        super.setEnabled(shouldEnable);
        if (this.strategy != null) {
            this.strategy.setEnabled(shouldEnable);
        }
        this.date.setEnabled(shouldEnable);
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        if (this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).getValue() instanceof FixRotationStrategyComplete) {
            Node n = this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy);
            if (n.getChildNamed(FixRotationStrategyComplete_.startDate).getValue() == null) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Please choose Meal Plan start date."));
                this.date.getElement().setInvalid();
            }
        } else if (this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).getValue() == null) {
            this.strategy.getElement().setInvalid();
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Cycle Strategy choosen."));
        }
        return a;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.isInit = true;
        this.currentNode = node;
        this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).removeNodeListener((NodeListener)this);
        this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).addNodeListener((NodeListener)this);
        this.valueChanged(this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy));
        this.isInit = false;
    }

    public void valueChanged(Node<?> node) {
        if (node.getName().equals(CateringServiceScheduleVariantComplete_.rotationStrategy.getFieldName())) {
            RotationStrategyComplete rotStrat = (RotationStrategyComplete)node.getValue();
            if (this.date != null && !this.date.isKilled()) {
                if (rotStrat instanceof FixRotationStrategyComplete) {
                    this.date.getElement().setNode(node.getChildNamed(FixRotationStrategyComplete_.startDate));
                    this.date.fadeIn();
                } else if (this.date.getProgress() != 0.0f) {
                    this.date.fadeOut(false);
                }
                if (!this.isInit) {
                    Iterator it = this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotations).getChilds();
                    while (it.hasNext()) {
                        Node rot = (Node)it.next();
                        Node dur = rot.getChildNamed(CateringServiceRotationComplete_.rotationStrategy);
                        Calendar c = TimeUtil.createCalendar();
                        c.setTimeInMillis(System.currentTimeMillis());
                        c.set(11, 0);
                        c.set(12, 0);
                        c.set(13, 0);
                        c.set(14, 0);
                        if (rotStrat instanceof FixPeriodRotationStrategyComplete) {
                            dur.setValue(null, c.getTimeInMillis());
                            continue;
                        }
                        RotationDurationComplete nDur = this.getDuration((RotationStrategyComplete)node.getValue());
                        if (dur.getValue() != null && ((RotationDurationComplete)dur.getValue()).getClass().equals(nDur.getClass())) continue;
                        dur.removeExistingValues();
                        dur.setValue((Object)nDur, c.getTimeInMillis());
                        dur.updateNode();
                    }
                }
                if (rotStrat instanceof FixPeriodRotationStrategyComplete) {
                    this.stratPanel.setUsed(true);
                } else {
                    this.stratPanel.setUsed(false);
                }
                this.strategy.getElement().removeItemListener(this);
                if (rotStrat instanceof FixRotationStrategyComplete) {
                    this.strategy.getElement().setSelectedItem(MealplanRotationStrategyE.FIX);
                } else if (rotStrat instanceof WeekdayRotationStrategyComplete) {
                    this.strategy.getElement().setSelectedItem(MealplanRotationStrategyE.WEEKDAY);
                } else if (rotStrat instanceof DayOfMonthRotationStrategyComplete) {
                    this.strategy.getElement().setSelectedItem(MealplanRotationStrategyE.DAYOFMONTH);
                } else if (rotStrat instanceof MonthRotationStrategyComplete) {
                    this.strategy.getElement().setSelectedItem(MealplanRotationStrategyE.MONTH);
                } else if (rotStrat instanceof FixPeriodRotationStrategyComplete) {
                    this.strategy.getElement().setSelectedItem(MealplanRotationStrategyE.PERIOD);
                }
                this.strategy.getElement().addItemListener(this);
            }
        }
    }

    private RotationDurationComplete getDuration(RotationStrategyComplete strat) {
        FixDurationRotationComplete dur = null;
        if (strat instanceof FixRotationStrategyComplete) {
            dur = new FixDurationRotationComplete();
            dur.setDuration(new DateDurationComplete());
            dur.setClientOId(Long.valueOf(ADTO.getNextId()));
            dur.getDuration().setClientOId(Long.valueOf(ADTO.getNextId()));
        } else if (strat instanceof WeekdayRotationStrategyComplete) {
            dur = new WeekdayRotationComplete();
            dur.setClientOId(Long.valueOf(ADTO.getNextId()));
        } else if (strat instanceof DayOfMonthRotationStrategyComplete) {
            dur = new DayOfMonthRotationComplete();
            dur.setClientOId(Long.valueOf(ADTO.getNextId()));
        } else if (strat instanceof MonthRotationStrategyComplete) {
            dur = new MonthRotationComplete();
            dur.setClientOId(Long.valueOf(ADTO.getNextId()));
        } else {
            throw new IllegalStateException("Unknown Rotation Type");
        }
        return dur;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            FixRotationStrategyComplete strat = null;
            if (this.strategy.getElement().getSelectedItem() == null || this.strategy.getElement().getSelectedItem().equals("")) {
                this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).removeExistingValues();
                return;
            }
            if (this.strategy.getElement().getSelectedItem().equals(MealplanRotationStrategyE.FIX)) {
                strat = new FixRotationStrategyComplete();
                strat.setClientOId(Long.valueOf(ADTO.getNextId()));
                strat.setStartDate(new Date(System.currentTimeMillis()));
            } else if (this.strategy.getElement().getSelectedItem().equals(MealplanRotationStrategyE.WEEKDAY)) {
                strat = new WeekdayRotationStrategyComplete();
                strat.setClientOId(Long.valueOf(ADTO.getNextId()));
            } else if (this.strategy.getElement().getSelectedItem().equals(MealplanRotationStrategyE.DAYOFMONTH)) {
                strat = new DayOfMonthRotationStrategyComplete();
                strat.setClientOId(Long.valueOf(ADTO.getNextId()));
            } else if (this.strategy.getElement().getSelectedItem().equals(MealplanRotationStrategyE.MONTH)) {
                strat = new MonthRotationStrategyComplete();
                strat.setClientOId(Long.valueOf(ADTO.getNextId()));
            } else if (this.strategy.getElement().getSelectedItem().equals(MealplanRotationStrategyE.PERIOD)) {
                strat = new FixPeriodRotationStrategyComplete();
                strat.setClientOId(Long.valueOf(ADTO.getNextId()));
                PeriodRotationComplete pr = new PeriodRotationComplete();
                pr.setPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
                ((FixPeriodRotationStrategyComplete)strat).getPeriods().add(pr);
            }
            if (strat != null) {
                this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).removeExistingValues();
                this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).removeAllChilds();
                this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).setValue((Object)strat, 0L);
                this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).updateNode();
            }
            this.strategy.getElement().setValid();
            this.editor.createFocusCycle();
            this.editor.revalidate();
        }
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentY = 0;
            if (RotationConfigurationDetailsPanel.this.strategy != null) {
                RotationConfigurationDetailsPanel.this.strategy.setLocation(RotationConfigurationDetailsPanel.this.horizontalBorder, RotationConfigurationDetailsPanel.this.verticalBorder);
                RotationConfigurationDetailsPanel.this.strategy.setSize(200, (int)RotationConfigurationDetailsPanel.this.strategy.getPreferredSize().getHeight());
                currentY = RotationConfigurationDetailsPanel.this.strategy.getY() + RotationConfigurationDetailsPanel.this.strategy.getHeight();
            }
            RotationConfigurationDetailsPanel.this.date.setLocation(RotationConfigurationDetailsPanel.this.horizontalBorder, currentY + RotationConfigurationDetailsPanel.this.inner_verticalBorder);
            RotationConfigurationDetailsPanel.this.date.setSize(RotationConfigurationDetailsPanel.this.date.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = RotationConfigurationDetailsPanel.this.verticalBorder;
            if (RotationConfigurationDetailsPanel.this.strategy != null) {
                h = (int)((double)h + RotationConfigurationDetailsPanel.this.strategy.getPreferredSize().getHeight());
            }
            h += RotationConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + RotationConfigurationDetailsPanel.this.date.getPreferredSize().getHeight());
            return new Dimension(0, h += RotationConfigurationDetailsPanel.this.verticalBorder);
        }
    }
}

