/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.mealplan.spec.details;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.SortableTable2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.tables.comparators.NumberComparator;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceSubstitutionComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceSubstitutionComplete_;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class SubstitutionsDetailsPanel
extends DefaultDetailsPanel {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private Node<CateringServiceScheduleVariantComplete> currentNode;

    public SubstitutionsDetailsPanel(RowEditor editor) {
        super(editor, null);
        this.setTitleText(Words.SUBSTITUTIONS_EXCEPTIONS);
        this.table = new Table2(true, Words.ADD_EXCEPTION);
        this.table.setDontUseScrollBar(15);
        this.table.setComparator(ComparatorRegistry.getComparator(NumberComparator.class));
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                SubstitutionsDetailsPanel.this.table.writeNumber("number", 1);
                SubstitutionsDetailsPanel.this.editor.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                if (SubstitutionsDetailsPanel.this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.rotationStrategy).getValue() == null) {
                    InnerPopupFactory.showErrorDialog("Cycle Strategy must be defined before adding Substitutions", (Component)source);
                } else {
                    CateringServiceSubstitutionComplete c = new CateringServiceSubstitutionComplete();
                    c.setClientOId(Long.valueOf(ADTO.getNextId()));
                    c.setNumber(Integer.valueOf(SubstitutionsDetailsPanel.this.table.getRowCount() + 1));
                    c.setPeriod(new PeriodComplete());
                    c.getPeriod().setStartDate(new Date(System.currentTimeMillis()));
                    c.getPeriod().setEndDate(new Date(System.currentTimeMillis()));
                    Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)c, true, false);
                    SubstitutionsDetailsPanel.this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
                    SubstitutionsDetailsPanel.this.editor.revalidate();
                    SubstitutionsDetailsPanel.this.editor.createFocusCycle();
                }
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", 30, 30, 30));
        int tw = ArrowConnectorIcon.getPreferredWidth() + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.TO, null, null, null, "", 30, 30, 30));
        tw = this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) * 3 + 2 * this.table.getInnerCellPadding() + this.table.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.45);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.45);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
    }

    public void setNode(Node node) {
        super.setNode(node);
        this.currentNode = node;
        this.table.getModel().setNode(this.currentNode.getChildNamed(CateringServiceScheduleVariantComplete_.substitutions));
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.table);
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean shouldEnable = isEnabled;
        MealPlanLight mp = (MealPlanLight)this.editor.getModel().getNode().getChildNamed(CateringServiceScheduleComplete_.mealplan).getValue();
        if (mp != null) {
            shouldEnable = mp.getState() == ModificationStateE.DRAFT && shouldEnable;
        }
        super.setEnabled(shouldEnable);
        this.table.setEnabled(shouldEnable);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class TableRowImpl
    extends SortableTable2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel no;
        private DateChooser fromW;
        private ArrowConnectorIcon connector;
        private DateChooser toW;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.THREE);
            this.setSortAttributeName(CateringServiceSubstitutionComplete_.number);
            this.setStartEndOffset(1, 0);
            this.no = new TextLabel(m.getNode().getChildNamed(CateringServiceSubstitutionComplete_.number), ConverterRegistry.getConverter(IntegerConverter.class));
            this.fromW = new DateChooser(m.getNode().getChildNamed(new DtoField[]{CateringServiceSubstitutionComplete_.period, PeriodComplete_.startDate}));
            this.connector = new ArrowConnectorIcon();
            this.toW = new DateChooser(m.getNode().getChildNamed(new DtoField[]{CateringServiceSubstitutionComplete_.period, PeriodComplete_.endDate}));
            this.fromW.setProgress(1.0f);
            this.toW.setProgress(1.0f);
            this.setLayout(new Layout());
            this.add(this.no);
            this.add(this.fromW);
            this.add(this.connector);
            this.add(this.toW);
        }

        @Override
        public void requestFocusInWindowNow() {
            this.fromW.requestFocusInWindowNow();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.no.setEnabled(isEnabled);
            this.fromW.setEnabled(isEnabled);
            this.connector.setEnabled(isEnabled);
            this.toW.setEnabled(isEnabled);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.fromW.getFocusComponents());
            a.addAll(this.toW.getFocusComponents());
            a.addAll(super.getFocusComponents());
            return a;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.no.kill();
            this.no = null;
            this.fromW.kill();
            this.fromW = null;
            this.connector.kill();
            this.connector = null;
            this.toW.kill();
            this.toW = null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.no.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.no.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.no.setSize(TableRowImpl.this.no.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.fromW.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fromW.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fromW.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.fromW.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.connector.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.connector.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.connector.setSize(TableRowImpl.this.connector.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.toW.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.toW.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.toW.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.toW.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.layoutSortButtons(currentX, parent.getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SubstitutionsDetailsPanel.this.table.setLocation(0, 0);
            SubstitutionsDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)SubstitutionsDetailsPanel.this.table.getPreferredSize().getHeight());
        }
    }
}

