/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.TaxZoneConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.utils.InternalExternalCateringCostTable;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.ScrollableTextArea;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.client.util.variantaccessor.RecipeVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.CateringPointCostComplete;
import ch.icit.pegasus.server.core.dtos.product.CompoundComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComponentComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.product.SimpleComponentComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleComponentComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

public class ComponentOptionsPopupInsert
extends PopUpInsert
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> department;
    private TitledItem<CheckBox> showInCatalog;
    private TitledItem<CheckBox> showAllergens;
    private TextLabel cateringTitle;
    private HorizontalSeparator sep1;
    private InternalExternalCateringCostTable cateringTable;
    private TitledItem<ScrollableTextArea> instructionField;
    private boolean isClosed;
    private boolean changeShowAllergenInfoSheet;
    private TitledItem<ComboBox> taxZone;
    private TitledItem<SearchTextField2<SupplierLight>> supplier;
    private ViewNode<List<CateringPointCostComplete>> cateringPointView;
    private RecipeVariantAccessor recipeAccessor;
    private Node<ProductComponentComplete> recipeNode;

    public ComponentOptionsPopupInsert(final RDProvider provider, Node<ProductComponentComplete> node, Node<QuantityComplete> targetQuantity, Date validityDate, boolean acceptedItem) {
        this.recipeNode = node;
        this.cateringPointView = new ViewNode("mergedCateringPoints");
        try {
            this.readRecipeVariantComplete(node, validityDate, targetQuantity);
        }
        catch (Exception e) {
            InnerPopupFactory.showErrorDialog(e, (Component)this);
        }
        this.isClosed = acceptedItem;
        this.changeShowAllergenInfoSheet = provider.isWritable("changeShowAllergenInfoSheet");
        ComboBoxFactory.DepartmentType usedType = node.getValue() instanceof SimpleComponentComplete ? ComboBoxFactory.DepartmentType.ARTICLE_IN_PRODUCT_UNIT : ComboBoxFactory.DepartmentType.RECIPE_IN_PRODUCT_UNIT;
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        SystemViewSettingsComplete viewSettings = (SystemViewSettingsComplete)NodeToolkit.getAffixClass(SystemViewSettingsComplete.class).getValue();
        this.department = new TitledItem<ComboBox>(new ComboBox(node.getChildNamed(ProductComponentComplete_.costCenter), ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)NodeToolkit.getAffixList(InternalCostCenterComplete.class), (Node<InternalCostCenterComplete>)node.getChildNamed(ProductComponentComplete_.costCenter), usedType), ConverterRegistry.getConverter(CostCenterConverter.class), true, true), "Production Department", TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(viewSettings.getShowProductComponentComment())) {
            this.instructionField = new TitledItem<ScrollableTextArea>(new ScrollableTextArea(), Words.COMMENT, TitledItem.TitledItemOrientation.NORTH);
            this.instructionField.getElement().setNode(node.getChildNamed(ProductComponentComplete_.comment));
            this.instructionField.setIgnorePrefHeight(true);
        }
        if (node.getValue() instanceof SimpleComponentComplete) {
            this.taxZone = new TitledItem<ComboBox>(new ComboBox(node.getChildNamed(SimpleComponentComplete_.preferredTaxZone), NodeToolkit.getAffixList(TaxZoneComplete.class), ConverterRegistry.getConverter(TaxZoneConverter.class), true), Words.PREFERRED_TAX_ZONE, TitledItem.TitledItemOrientation.NORTH);
            this.supplier = new TitledItem<SearchTextField2<SupplierLight>>(SearchTextField2Factory.getSupplierSearchField(true, node.getChildNamed(SimpleComponentComplete_.preferredSupplier)), Words.SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
        }
        this.showInCatalog = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)node.getChildNamed(ProductComponentComplete_.showInCatalog)), Words.SHOW_IN_PRODUCT_CATALOG, TitledItem.TitledItemOrientation.EAST);
        this.showAllergens = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)node.getChildNamed(ProductComponentComplete_.showAllergens)), Words.SHOW_ALLERGENS, TitledItem.TitledItemOrientation.EAST);
        this.sep1 = new HorizontalSeparator();
        if (Boolean.TRUE.equals(viewSettings.getShowProductComponentManMinutes())) {
            this.cateringTitle = new TextLabel("Man Minutes");
            this.cateringTable = new InternalExternalCateringCostTable(this, null, true, null, usedType, true){
                private static final long serialVersionUID = 1L;

                @Override
                public void removeProcessCost(ReloadablePriceView costs) {
                }

                @Override
                public void load(boolean b) {
                }

                @Override
                public void addProcessCost(ReloadablePriceView costs) {
                }

                @Override
                protected Node getAddNode() {
                    return ComponentOptionsPopupInsert.this.recipeNode.getChildNamed(ProductComponentComplete_.cateringPointCosts);
                }

                @Override
                public void setNode(Node<?> node) {
                    this.currentNode = node;
                    boolean tender = false;
                    this.installTable(this.parent2, provider, this.isDeletable, this.loader, this.withBackground, tender);
                    this.internalCost.setNode(node);
                }
            };
        }
        this.recipeNode.getChildNamed(ProductComponentComplete_.cateringPointCosts).addNodeListener((NodeListener)this);
        this.recipeNode.getChildNamed(ProductComponentComplete_.cateringPointCosts).getAllChildAddEvents((NodeListener)this);
        if (this.cateringTable != null) {
            this.cateringTable.setCustomerNode((Node<CustomerLight>)this.recipeNode.getParent().getParent().getParent().getParent().getChildNamed(new DtoField[]{ProductVariantLight_.product, ProductComplete_.customer}));
            this.cateringTable.setNode((Node<?>)this.cateringPointView);
        }
        this.setLayout(new Layout());
        this.setEnabled(true);
        this.add(this.department);
        if (this.instructionField != null) {
            this.add(this.instructionField);
        }
        this.add(this.showInCatalog);
        this.add(this.showAllergens);
        this.add(this.sep1);
        if (this.cateringTable != null) {
            this.add(this.cateringTable);
            this.add(this.cateringTitle);
        }
        if (this.taxZone != null) {
            this.add(this.taxZone);
            this.add(this.supplier);
        }
    }

    private void readRecipeVariantComplete(Node<ProductComponentComplete> node, Date validityDate, Node<QuantityComplete> targetAmount) throws Exception {
        if (node.getValue() instanceof CompoundComponentComplete) {
            CompoundComponentComplete ccc = (CompoundComponentComplete)node.getValue();
            this.recipeAccessor = new RecipeVariantAccessorImpl();
            RecipeVariantComplete rv = (RecipeVariantComplete)this.recipeAccessor.loadData((Object)ccc.getRecipe(), new Timestamp(validityDate.getTime()));
            double amountOrigin = rv.getYield().getQuantity();
            double amountTarget = UnitConversionToolkit.convertUnit((UnitComplete)((UnitComplete)targetAmount.getChildNamed(QuantityComplete_.unit).getValue()), (UnitComplete)rv.getYield().getUnit(), (double)((Double)targetAmount.getChildNamed(QuantityComplete_.quantity).getValue()), null, (Timestamp)new Timestamp(validityDate.getTime()));
            double factor = amountTarget / amountOrigin;
            for (CateringPointCostComplete cp : rv.getCateringPointCosts()) {
                CateringPointCostComplete ncp = CopyTemplateToolkit.copyCateringPointCost(cp);
                ncp.setPoints(Double.valueOf(ncp.getPoints() * factor));
                Node nCp = INodeCreator.getDefaultImpl().getNode4DTO((Object)ncp, true, true);
                this.cateringPointView.addChild(nCp, 0L);
            }
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.department.setEnabled(isEnabled && !this.isClosed);
        if (this.instructionField != null) {
            this.instructionField.setEnabled(isEnabled && !this.isClosed);
        }
        this.showAllergens.setEnabled(isEnabled && !this.isClosed && this.changeShowAllergenInfoSheet);
        this.showInCatalog.setEnabled(isEnabled && !this.isClosed);
        if (this.cateringTable != null) {
            this.cateringTable.setEnabled(isEnabled && !this.isClosed);
        }
        if (this.taxZone != null) {
            this.taxZone.setEnabled(isEnabled && !this.isClosed);
            this.supplier.setEnabled(isEnabled && !this.isClosed);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.department.getFocusComponents();
        CheckedListAdder.addToList(a, this.showInCatalog);
        CheckedListAdder.addToList(a, this.showAllergens);
        CheckedListAdder.addToList(a, this.taxZone);
        CheckedListAdder.addToList(a, this.supplier);
        CheckedListAdder.addToList(a, this.instructionField);
        CheckedListAdder.addToList(a, this.cateringTable);
        return a;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.department.getElement().getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.department.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.department.kill();
        this.showInCatalog.kill();
        this.showAllergens.kill();
        if (this.instructionField != null) {
            this.instructionField.kill();
        }
        this.sep1.kill();
        if (this.cateringTable != null) {
            this.cateringTable.kill();
            this.cateringTitle.kill();
        }
        if (this.taxZone != null) {
            this.taxZone.kill();
            this.supplier.kill();
        }
        this.taxZone = null;
        this.supplier = null;
        this.department = null;
        this.showInCatalog = null;
        this.showAllergens = null;
        this.instructionField = null;
        this.cateringTable = null;
        this.sep1 = null;
        this.cateringTitle = null;
    }

    @Override
    public boolean tryToGrabFocus() {
        this.department.requestFocusInWindowNow();
        return true;
    }

    public void valueChanged(Node<?> node) {
    }

    public void childAdded(Node<?> source, Node<?> child) {
        this.cateringPointView.addChild(child, 0L);
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        this.cateringPointView.removeChild(child, 0L);
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        for (Node<?> n : nodes) {
            this.cateringPointView.addChild(n, 0L);
        }
    }

    public boolean isSwingOnly() {
        return false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            ComponentOptionsPopupInsert.this.department.setLocation(0, 0);
            ComponentOptionsPopupInsert.this.department.setSize(parent.getWidth(), (int)ComponentOptionsPopupInsert.this.department.getPreferredSize().getHeight());
            ComponentOptionsPopupInsert.this.showInCatalog.setLocation(0, ComponentOptionsPopupInsert.this.department.getY() + ComponentOptionsPopupInsert.this.department.getHeight() + border);
            ComponentOptionsPopupInsert.this.showInCatalog.setSize(ComponentOptionsPopupInsert.this.showInCatalog.getPreferredSize());
            ComponentOptionsPopupInsert.this.showAllergens.setLocation(0, ComponentOptionsPopupInsert.this.showInCatalog.getY() + ComponentOptionsPopupInsert.this.showInCatalog.getHeight() + border);
            ComponentOptionsPopupInsert.this.showAllergens.setSize(ComponentOptionsPopupInsert.this.showAllergens.getPreferredSize());
            int y = ComponentOptionsPopupInsert.this.showAllergens.getY() + ComponentOptionsPopupInsert.this.showAllergens.getHeight() + border;
            if (ComponentOptionsPopupInsert.this.taxZone != null) {
                ComponentOptionsPopupInsert.this.taxZone.setLocation(0, y);
                ComponentOptionsPopupInsert.this.taxZone.setSize(parent.getWidth() - 2 * border, (int)ComponentOptionsPopupInsert.this.taxZone.getPreferredSize().getHeight());
                ComponentOptionsPopupInsert.this.supplier.setLocation(0, ComponentOptionsPopupInsert.this.taxZone.getY() + ComponentOptionsPopupInsert.this.taxZone.getHeight() + border);
                ComponentOptionsPopupInsert.this.supplier.setSize(parent.getWidth() - 2 * border, (int)ComponentOptionsPopupInsert.this.supplier.getPreferredSize().getHeight());
                y = ComponentOptionsPopupInsert.this.supplier.getY() + ComponentOptionsPopupInsert.this.supplier.getHeight() + border;
            }
            if (ComponentOptionsPopupInsert.this.instructionField != null) {
                ComponentOptionsPopupInsert.this.instructionField.setLocation(0, y);
                ComponentOptionsPopupInsert.this.instructionField.setSize(parent.getWidth(), 100);
                y = ComponentOptionsPopupInsert.this.instructionField.getY() + ComponentOptionsPopupInsert.this.instructionField.getHeight() + border / 2;
            }
            ComponentOptionsPopupInsert.this.sep1.setLocation(0, y);
            ComponentOptionsPopupInsert.this.sep1.setSize(parent.getWidth(), (int)ComponentOptionsPopupInsert.this.sep1.getPreferredSize().getHeight());
            if (ComponentOptionsPopupInsert.this.cateringTable != null) {
                ComponentOptionsPopupInsert.this.cateringTitle.setLocation(0, ComponentOptionsPopupInsert.this.sep1.getY() + ComponentOptionsPopupInsert.this.sep1.getHeight() + border / 2);
                ComponentOptionsPopupInsert.this.cateringTitle.setSize(parent.getWidth(), (int)ComponentOptionsPopupInsert.this.cateringTitle.getPreferredSize().getHeight());
                ComponentOptionsPopupInsert.this.cateringTable.setLocation(0, ComponentOptionsPopupInsert.this.cateringTitle.getY() + ComponentOptionsPopupInsert.this.cateringTitle.getHeight() + 2);
                ComponentOptionsPopupInsert.this.cateringTable.setSize(parent.getWidth(), parent.getHeight() - ComponentOptionsPopupInsert.this.cateringTable.getY());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(270, 480);
        }
    }
}

