/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.requisition.receive.tableui;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.screentemplates.SubModuleScreenInsert;
import ch.icit.pegasus.client.gui.submodules.tool.requisition.deliver.tableui.chargebased.OrderComparator;
import ch.icit.pegasus.client.gui.submodules.tool.requisition.receive.tableui.TableRowPanelImpl;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.fake.FakeSmartScreenTableRow;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.RowTransferObject;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RequisitionOrderAccess;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class RequisitionReceivingSubModule<T extends IDTO>
extends SubModuleScreenInsert<T>
implements RemoteLoader,
ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    protected final RDProvider provider = new RDProvider(HUDToolkit.getCurrentAccessRight(RequisitionOrderAccess.MODULE_REQUISITION, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser()), false);
    protected Table2 table;
    protected RequisitionOrderComplete currentOrder;
    protected FakeSmartScreenTableRow currentRowView;
    protected LoadingAnimation animationPanel;
    protected TextButton selectAll;
    protected int currentLoadingState;
    private int currentSelectionType = 0;

    public RequisitionOrderComplete getCurrentOrder() {
        return this.currentOrder;
    }

    public void createFocusCycle() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.addAll(this.table.getFocusComponents());
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
    }

    @Override
    public void saveAndBackDocument() {
        this.currentLoadingState = 11;
        this.showAnimation();
        this.animationPanel.stateChanged(Words.SAVE_DATA);
        this.doSave();
    }

    @Override
    public void saveDocument() {
        this.currentLoadingState = 7;
        this.showAnimation();
        this.animationPanel.stateChanged(Words.SAVE_DATA);
        this.doSave();
    }

    public abstract void doSave();

    private void init(RequisitionOrderLight order, FakeSmartScreenTableRow model) {
        this.currentRowView = model;
        this.setRow(model);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (Boolean.TRUE.equals(settings.getShowSelectAllInRequisitionSubModules())) {
            this.selectAll = new TextButton();
            this.selectAll.addButtonListener(this);
        }
        this.table = new Table2(false, "", true, true, Words.ORDER_POSITIONS);
        this.table.setComparator(ComparatorRegistry.getComparator(OrderComparator.class));
        List<TableColumnInfo> columns = this.createColumns();
        this.table.setModel(new Table2Model(columns, model1 -> this.getRowPanel(model1, this.provider)));
        this.table.getModel().allInitiated();
        List<Component> a = this.table.getFocusComponents();
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
        this.setOpaque(false);
        this.setLayout(new Layout());
        if (this.selectAll != null) {
            this.selectAll.setProgress(1.0f);
            this.add(this.selectAll);
        }
        this.add(this.table);
        this.showAnimation();
    }

    public abstract List<TableColumnInfo> createColumns();

    protected void showAnimation() {
        this.setEnabled(false);
        if (this.animationPanel == null) {
            this.animationPanel = new LoadingAnimation();
            this.animationPanel.stateChanged(Words.SAVE_DATA);
            this.animationPanel.start();
            this.animationPanel.fadeIn();
            this.add((Component)this.animationPanel, 0);
        }
        this.revalidate();
    }

    private void hideAnimation() {
        this.setEnabled(true);
        if (this.animationPanel != null) {
            this.animationPanel.stop();
            this.animationPanel.fadeOut(false);
            this.animationPanel = null;
        }
    }

    public abstract Table2RowPanel getPanel(Table2RowModel var1, RDProvider var2);

    private Table2RowPanel getRowPanel(Table2RowModel m, RDProvider provider) {
        Table2RowPanel p = this.getPanel(m, provider);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    public void loadArticles(final Node node) {
        this.currentLoadingState = 5;
        this.showAnimation();
        this.animationPanel.stateChanged(Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RequisitionOrderComplete c;
                RequisitionOrderLight l = (RequisitionOrderLight)node.getValue(RequisitionOrderLight.class);
                RequisitionReceivingSubModule.this.currentOrder = c = (RequisitionOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getRequisitionOrderByReference(new RequisitionOrderReference(l.getId())).getValue();
                SystemSettingsComplete setting = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                node.removeExistingValues();
                node.setValue((Object)c, 0L);
                node.updateNode();
                Iterator it = node.getChildNamed(new String[]{"orderPositions"}).getChilds();
                while (it.hasNext()) {
                    Node pos = (Node)it.next();
                    Node art = pos.getChildNamed(new String[]{"article"});
                    if (art.getValue(BasicArticleComplete.class) != null) continue;
                    BasicArticleComplete a = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)((BasicArticleLight)art.getValue())).getValue();
                    art.setValue((Object)a, 0L);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return RequisitionReceivingSubModule.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    @Override
    public void setRowAttributes(RowTransferObject o) {
        this.init(null, o.getFakeRow());
    }

    public void redo() {
    }

    public void undo() {
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.currentLoadingState == 5) {
            this.hideAnimation();
            this.table.getModel().setNode(this.currentRowView.getNode().getChildNamed(new String[]{"orderPositions"}));
            this.table.getModel().allInitiated();
            this.table.setProgress(1.0f);
            this.ensureButtonState();
            List<Component> a = this.table.getFocusComponents();
            CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
        } else if (this.currentLoadingState == 7) {
            this.currentLoadingState = 13;
            TransactionToolkit.ensureErrorPopup(node, "Transaction performed:", this, this);
        } else if (this.currentLoadingState == 13) {
            this.startDataDownload();
        } else if (this.currentLoadingState == 11) {
            TransactionToolkit.ensureErrorPopup(node, "Transaction performed:", this, this);
        }
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.hideAnimation();
        this.setEnabled(true);
        super.errorOccurred(exception);
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (this.currentLoadingState == 11) {
            this.cancelDocument();
        } else if (this.currentLoadingState == 13) {
            this.reloadOrder();
        }
    }

    protected void ensureButtonState() {
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowPanelImpl pp = (TableRowPanelImpl)p;
            if (pp.isChecked()) continue;
            this.currentSelectionType = 0;
            if (this.selectAll != null) {
                this.selectAll.setText("Select All");
            }
            return;
        }
        this.currentSelectionType = 1;
        if (this.selectAll != null) {
            this.selectAll.setText("Deselect All");
        }
    }

    private void reloadOrder() {
        if (this.currentOrder != null) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    RequisitionOrderComplete uOrder;
                    RequisitionReceivingSubModule.this.currentOrder = uOrder = (RequisitionOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).getRequisitionOrderByReference(new RequisitionOrderReference(RequisitionReceivingSubModule.this.currentOrder.getId())).getValue();
                    SystemSettingsComplete setting = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    if (Boolean.TRUE.equals(uOrder.getRedirectOrder()) && Boolean.TRUE.equals(setting.getRequisitionReceiveStoreDefaultIgnored())) {
                        for (RequisitionOrderPositionComplete orderPosition : uOrder.getOrderPositions()) {
                            orderPosition.setReceivingStore(null);
                        }
                    }
                    RequisitionReceivingSubModule.this.currentRowView.getNode().removeExistingValues();
                    RequisitionReceivingSubModule.this.currentRowView.getNode().setValue((Object)RequisitionReceivingSubModule.this.currentOrder, 0L);
                    RequisitionReceivingSubModule.this.currentRowView.getNode().updateNode();
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return RequisitionReceivingSubModule.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void screenSet() {
    }

    @Override
    public void startDataDownload() {
        if (this.currentRowView != null) {
            this.loadArticles(this.currentRowView.getNode());
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        if (this.selectAll != null) {
            this.selectAll.setEnabled(isEnabled);
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (this.currentSelectionType == 0) {
            this.selectAll(true);
        } else if (this.currentSelectionType == 1) {
            this.selectAll(false);
        }
    }

    private void selectAll(boolean select) {
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowPanelImpl pp = (TableRowPanelImpl)p;
            if (!pp.isEnabled()) continue;
            pp.setChecked(select);
        }
    }

    public Table2 getTable() {
        return this.table;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = RequisitionReceivingSubModule.this.layoutTitle(parent);
            y = RequisitionReceivingSubModule.this.layoutTitleBar(y, parent.getWidth());
            double offset = RequisitionReceivingSubModule.this.selectAll != null ? RequisitionReceivingSubModule.this.selectAll.getPreferredSize().getHeight() : 0.0;
            RequisitionReceivingSubModule.this.table.setLocation(0, y + 10);
            RequisitionReceivingSubModule.this.table.setSize(parent.getWidth(), (int)((double)parent.getHeight() - ((double)RequisitionReceivingSubModule.this.table.getY() + offset + 10.0)));
            if (RequisitionReceivingSubModule.this.selectAll != null) {
                RequisitionReceivingSubModule.this.selectAll.setLocation((int)((double)parent.getWidth() - RequisitionReceivingSubModule.this.selectAll.getPreferredSize().getWidth()), (int)((double)parent.getHeight() - RequisitionReceivingSubModule.this.selectAll.getPreferredSize().getHeight()));
                RequisitionReceivingSubModule.this.selectAll.setSize(RequisitionReceivingSubModule.this.selectAll.getPreferredSize());
            }
            if (RequisitionReceivingSubModule.this.animationPanel != null) {
                RequisitionReceivingSubModule.this.animationPanel.setSize(RequisitionReceivingSubModule.this.animationPanel.getPreferredSize());
                RequisitionReceivingSubModule.this.animationPanel.setLocation(RequisitionReceivingSubModule.this.table.getX() + (RequisitionReceivingSubModule.this.table.getWidth() - RequisitionReceivingSubModule.this.animationPanel.getWidth()) / 2, RequisitionReceivingSubModule.this.table.getY() + (RequisitionReceivingSubModule.this.table.getHeight() - RequisitionReceivingSubModule.this.animationPanel.getHeight()) / 2);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

