/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew;

import ch.icit.pegasus.client.converter.ArticleCategoryConverter2;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.SubModuleScreenInsert;
import ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.AddBatchPanelNEW;
import ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.TableRowImplNEW;
import ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.utils.IInventoryCountImportUtil;
import ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.utils.InventoryCountImportUtil;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.RowTransferObject;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.RemarkButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.ArticleMiniComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.tooltip.impls.PackagingQuantityFormulaCoverter;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.ArticleChargeBatchSearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.InventoryReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryCheckinComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.StoreAccess;
import ch.icit.pegasus.server.core.dtos.search.ArticleChargeBatchSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionContentComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.CirculationStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.CirculationStockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.IStockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.util.DeletedStateE;
import ch.icit.pegasus.server.core.dtos.util.InUseStateE;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.ExcelToolkitException;
import ch.icit.utils.StyledWorkbook;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryCBSubModuleNEW
extends SubModuleScreenInsert<StoreLight>
implements ItemListener,
InnerPopUpListener2,
ButtonListener,
IInventoryCountImportUtil {
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(InventoryCBSubModuleNEW.class);
    protected static final int STATE_INVALID = 0;
    private static final int STATE_LOADING_STORE = 16;
    private static final int STATE_LOADING_STORE2 = 31;
    private static final int STATE_WARNING = 63;
    private static final int STATE_NO_WARNING = 121;
    protected PageableTable2 upperTable;
    protected PageableTable2 lowerTable;
    protected StoreLight storeDTO;
    private SearchAlgorithm searcher;
    protected ArticleMiniComboBox miniCombo;
    private ArticleChargeBatchComplete currentStockCheckin;
    private List<Tuple<Integer, String>> notOkList = new ArrayList<Tuple<Integer, String>>();
    protected static final String FILTER_ARTICLE_ID = "Article";
    protected static final String FILTER_POSITION_ID = "Position";
    protected static final String FILTER_CUSTOMER_ID = "Customer";
    protected static final String FILTER_MAINCAT = "MainCat";
    protected static final String FILTER_MAINGROUP = "MainGroup";
    protected static final String FILTER_SUBGROUP = "SubGroup";
    protected static final String FILTER_BONDED = "Bonded";
    protected static final String FILTER_DELETED = "Deleted";
    protected static final String FILTER_INUSE = "Inuse";
    protected static final String FILTER_ORDER_FIELD = "orderField";
    protected String currentArticle;
    protected String currentPosition;
    protected CustomerReference customer;
    protected ArticleCategoryReference mainCat;
    protected ArticleCategoryReference mainGroup;
    protected ArticleCategoryReference subGroup;
    protected DeletedStateE fc8;
    protected InUseStateE fc9;
    protected static final int ART_NO = 1;
    protected static final int CUSTOMER_ART_NO = 2;
    protected static final int NAME = 3;
    protected int sortRow = 1;
    protected Boolean isBonded;
    private ComboBox mainCatCombo;
    private ComboBox mainGroupCombo;
    private ComboBox subGroupCombo;
    private ComboBox bonded;
    private ComboBox deleted;
    private ComboBox inUse;
    private ComboBox sortBy;
    private TextButton addAll;
    private int warnState;

    public InventoryCBSubModuleNEW() {
        this.setOpaque(false);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.upperTable != null) {
            this.upperTable.kill();
        }
        this.upperTable = null;
        if (this.lowerTable != null) {
            this.lowerTable.kill();
        }
        this.lowerTable = null;
        this.searcher = null;
        if (this.miniCombo != null) {
            this.miniCombo.kill();
        }
        this.miniCombo = null;
        if (this.mainCatCombo != null) {
            this.mainCatCombo.kill();
        }
        this.mainCatCombo = null;
        if (this.mainGroupCombo != null) {
            this.mainGroupCombo.kill();
        }
        this.mainGroupCombo = null;
        if (this.subGroupCombo != null) {
            this.subGroupCombo.kill();
        }
        this.subGroupCombo = null;
        if (this.bonded != null) {
            this.bonded.kill();
        }
        this.bonded = null;
        if (this.deleted != null) {
            this.deleted.kill();
        }
        this.deleted = null;
        if (this.inUse != null) {
            this.inUse.kill();
        }
        this.inUse = null;
        if (this.sortBy != null) {
            this.sortBy.kill();
        }
        this.sortBy = null;
        if (this.addAll != null) {
            this.addAll.kill();
        }
        this.addAll = null;
    }

    public boolean isChargeBased() {
        return true;
    }

    public String getPanelTitle() {
        return Words.ARTICLE_CHARGES;
    }

    protected void createFocusCycle() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.upperTable);
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
    }

    @Override
    public void stopAnimationsImmediately() {
    }

    public void setStockCheckin(ArticleChargeBatchComplete s) {
        this.currentStockCheckin = s;
    }

    public ArticleChargeBatchComplete getStockCheckin() {
        return this.currentStockCheckin;
    }

    @Override
    public String getScreenTitle() {
        return StoreAccess.TOOL_STORE_INVENTORY_CB.getDisplayName();
    }

    public void init() {
        this.upperTable = new PageableTable2("", true){
            private static final long serialVersionUID = 1L;

            @Override
            public SearchAlgorithm getSearchAlgorithm() {
                return InventoryCBSubModuleNEW.this.searcher;
            }

            @Override
            public void newResultsFound() {
                InventoryCBSubModuleNEW.this.revalidateTables();
                InventoryCBSubModuleNEW.this.createFocusCycle();
            }

            @Override
            public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
                ASearchConfiguration<? extends ADTO, ? extends Enum<?>> s = InventoryCBSubModuleNEW.this.getSearchConfig(id, value);
                return s;
            }

            @Override
            public void fillFilterChain() {
                this.filterChain.setDefault_searchFieldWidth(200);
                InventoryCBSubModuleNEW.this.miniCombo = new ArticleMiniComboBox(true, false);
                this.filterChain.addConfigurableSearchField(InventoryCBSubModuleNEW.FILTER_ARTICLE_ID, Words.ARTICLE, "", InventoryCBSubModuleNEW.this.miniCombo);
                this.filterChain.addSeachField(InventoryCBSubModuleNEW.FILTER_POSITION_ID, Words.STORE_POSITION);
                this.filterChain.addCustomerSearchField(InventoryCBSubModuleNEW.FILTER_CUSTOMER_ID);
                InventoryCBSubModuleNEW.this.mainCatCombo = new ComboBox(null, null, ConverterRegistry.getConverter(ArticleCategoryConverter2.class));
                InventoryCBSubModuleNEW.this.mainCatCombo.addItem(Words.ALL);
                InventoryCBSubModuleNEW.this.mainGroupCombo = new ComboBox(null, null, ConverterRegistry.getConverter(ArticleCategoryConverter2.class));
                InventoryCBSubModuleNEW.this.mainGroupCombo.addItem(Words.ALL);
                InventoryCBSubModuleNEW.this.subGroupCombo = new ComboBox(null, null, ConverterRegistry.getConverter(ArticleCategoryConverter2.class));
                InventoryCBSubModuleNEW.this.subGroupCombo.addItem(Words.ALL);
                this.filterChain.addSelectionCombo(InventoryCBSubModuleNEW.FILTER_MAINCAT, Words.CATEGORY, InventoryCBSubModuleNEW.this.mainCatCombo);
                this.filterChain.addSelectionCombo(InventoryCBSubModuleNEW.FILTER_MAINGROUP, Words.MAIN_GROUP, InventoryCBSubModuleNEW.this.mainGroupCombo);
                this.filterChain.addSelectionCombo(InventoryCBSubModuleNEW.FILTER_SUBGROUP, Words.SUB_GROUP, InventoryCBSubModuleNEW.this.subGroupCombo);
                InventoryCBSubModuleNEW.this.mainCatCombo.addItemListener(InventoryCBSubModuleNEW.this);
                InventoryCBSubModuleNEW.this.mainGroupCombo.addItemListener(InventoryCBSubModuleNEW.this);
                InventoryCBSubModuleNEW.this.subGroupCombo.addItemListener(InventoryCBSubModuleNEW.this);
                InventoryCBSubModuleNEW.this.bonded = new ComboBox();
                InventoryCBSubModuleNEW.this.bonded.addItem(BondedStateE.ALL);
                InventoryCBSubModuleNEW.this.bonded.addItem(BondedStateE.NOT_BONDED);
                InventoryCBSubModuleNEW.this.bonded.addItem(BondedStateE.ONLY_BONDED);
                InventoryCBSubModuleNEW.this.deleted = new ComboBox();
                InventoryCBSubModuleNEW.this.deleted.addItem(DeletedStateE.ALL);
                InventoryCBSubModuleNEW.this.deleted.addItem(DeletedStateE.NOT_DELETED);
                InventoryCBSubModuleNEW.this.deleted.addItem(DeletedStateE.ONLY_DELETED);
                InventoryCBSubModuleNEW.this.inUse = new ComboBox();
                InventoryCBSubModuleNEW.this.inUse.addItem(InUseStateE.ALL);
                InventoryCBSubModuleNEW.this.inUse.addItem(InUseStateE.NOT_USED);
                InventoryCBSubModuleNEW.this.inUse.addItem(InUseStateE.ONLY_USED);
                InventoryCBSubModuleNEW.this.sortBy = new ComboBox();
                InventoryCBSubModuleNEW.this.sortBy.addItem(Words.ARTICLE_NUMBER);
                InventoryCBSubModuleNEW.this.sortBy.addItem(Words.CUSTOMER_ARTICLE_NUMBER);
                InventoryCBSubModuleNEW.this.sortBy.addItem(Words.ARTICLE_NAME);
                this.filterChain.addSelectionCombo(InventoryCBSubModuleNEW.FILTER_BONDED, InventoryCBSubModuleNEW.FILTER_BONDED, InventoryCBSubModuleNEW.this.bonded);
                this.filterChain.addSelectionCombo(InventoryCBSubModuleNEW.FILTER_DELETED, Words.DELETED, InventoryCBSubModuleNEW.this.deleted);
                this.filterChain.addSelectionCombo(InventoryCBSubModuleNEW.FILTER_INUSE, Words.IN_USE, InventoryCBSubModuleNEW.this.inUse);
                this.filterChain.addSelectionCombo(InventoryCBSubModuleNEW.FILTER_ORDER_FIELD, Words.SORT_BY, InventoryCBSubModuleNEW.this.sortBy);
            }

            @Override
            public String isPageSwitchReady() {
                for (Table2RowPanel p : InventoryCBSubModuleNEW.this.upperTable.getRows()) {
                    TableRowImplNEW tableRowImplNEW = (TableRowImplNEW)p;
                }
                return super.isPageSwitchReady();
            }
        };
        this.upperTable.setComparator((n1, n2) -> {
            TableRowImplNEW i1 = (TableRowImplNEW)n1;
            TableRowImplNEW i2 = (TableRowImplNEW)n2;
            int i = 0;
            if (i1.getPositionName().startsWith("[")) {
                if (!i2.getPositionName().startsWith("[")) return -1;
                i = 0;
            } else {
                if (i2.getPositionName().startsWith("[")) {
                    return 1;
                }
                i = i1.getPositionName().compareTo(i2.getPositionName());
            }
            if (i != 0) return i;
            if (this.sortBy.getSelectedItem().equals(Words.ARTICLE_NAME)) {
                return i1.getArticleName().compareTo(i2.getArticleName());
            }
            if (this.sortBy.getSelectedItem().equals(Words.ARTICLE_NUMBER)) {
                return i1.getArticleNumber().compareTo(i2.getArticleNumber());
            }
            if (!this.sortBy.getSelectedItem().equals(Words.CUSTOMER_ARTICLE_NUMBER)) return i1.getArticleName().compareTo(i2.getArticleName());
            String c1 = i1.getArticleCustomerNumber();
            String c2 = i2.getArticleCustomerNumber();
            if (c1 != null && c1.trim().isEmpty()) {
                c1 = null;
            }
            if (c2 != null && c2.trim().isEmpty()) {
                c2 = null;
            }
            if (c1 != null) {
                if (c2 != null) return c1.compareTo(c2);
            }
            if (c1 == null) {
                if (c2 != null) return -1;
                i = i1.getArticleNumber().compareTo(i2.getArticleNumber());
            }
            if (c2 != null) return i;
            if (c1 != null) return 1;
            return i1.getArticleNumber().compareTo(i2.getArticleNumber());
        });
        this.upperTable.setTitleText(this.getPanelTitle());
        this.upperTable.setSortDirection(true);
        this.upperTable.setModel(new Table2Model(this.getTableHeaders(), model1 -> new TableRowImplNEW(model1, this, true)));
        this.upperTable.setSortable(false);
        this.upperTable.showLoadingAnimation(Words.LOAD_ARTICLES);
        this.addAll = new TextButton("Add All");
        this.addAll.addButtonListener(this);
        this.add(this.addAll);
        this.lowerTable = new PageableTable2("", false){

            @Override
            public SearchAlgorithm getSearchAlgorithm() {
                return InventoryCBSubModuleNEW.this.searcher;
            }

            @Override
            public void newResultsFound() {
                InventoryCBSubModuleNEW.this.createFocusCycle();
            }

            @Override
            public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
                return InventoryCBSubModuleNEW.this.getSearchConfig(id, value);
            }

            @Override
            public void fillFilterChain() {
            }

            @Override
            public String isPageSwitchReady() {
                for (Table2RowPanel p : InventoryCBSubModuleNEW.this.lowerTable.getRows()) {
                    TableRowImplNEW tableRowImplNEW = (TableRowImplNEW)p;
                }
                return super.isPageSwitchReady();
            }
        };
        this.lowerTable.setTitleText("Counted Charges");
        this.lowerTable.setType(3);
        this.lowerTable.setModel(new Table2Model(this.getTableHeaders(), model -> new TableRowImplNEW(model, this, false)));
        this.lowerTable.setFooterPanel(new AddBatchPanelNEW(this));
        this.lowerTable.setSortable(false);
        this.lowerTable.getModel().setNode((Node)new ViewNode(""));
        this.setLayout(new Layout());
        this.setEnabled(false);
        this.add(this.upperTable);
        this.add(this.lowerTable);
    }

    public List<TableColumnInfo> getTableHeaders() {
        ArrayList<TableColumnInfo> headers = new ArrayList<TableColumnInfo>();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        int tw = TableColumnInfo.numberColumnWidth;
        headers.add(new TableColumnInfo(0.0, 0.0, Words.NO_NUMBER, null, null, null, "", tw, tw, tw));
        tw = TableColumnInfo.numberColumnWithExpandWidth;
        headers.add(new TableColumnInfo(0.0, 0.0, Words.CUSTOMER_ARTICLE_NUMBER, null, null, null, "", tw, tw, tw));
        headers.add(new TableColumnInfo(1.0, 0.0, Words.NAME, null, null, null, "", 70, 70, 70));
        if (Boolean.TRUE.equals(settings.getShowImageOnInventoryWorkTools())) {
            headers.add(new TableColumnInfo(0.0, 0.0, Words.IMAGE, null, null, null, "", 70, 70, 70));
        }
        tw = TableColumnInfo.numberColumnWidth;
        headers.add(new TableColumnInfo(0.0, 0.0, Words.POSITION, null, null, null, "", 150, 150, 150));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.IN_USE, null, null, null, "", 45, 45, 45));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.DELETED, null, null, null, "", 45, 45, 45));
        if (this.isChargeBased()) {
            headers.add(new TableColumnInfo(0.0, 0.0, Words.CHARGE, null, null, null, "", tw, tw, tw));
        }
        tw = DateChooser.getPreferredWidth(this, false) + 2 * this.upperTable.getCellPadding();
        headers.add(new TableColumnInfo(0.0, 0.0, Words.LATEST_INVENTORY, null, null, null, "", tw, tw, tw));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.STOCK, null, null, null, "", tw, tw, tw));
        tw = 2 * this.upperTable.getCellPadding() + ArrowConnectorIcon.getPreferredWidth();
        headers.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", tw, tw, tw));
        tw = 2 * this.upperTable.getCellPadding() + InputComboBox2.getPreferredWidth(this, 11) + 2 * this.upperTable.getInnerCellPadding() + RemarkButton.getPreferredWidth() + InfoButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        headers.add(new TableColumnInfo(0.0, 0.0, Words.COUNT, null, null, null, "", tw, tw, tw));
        tw = 2 * this.upperTable.getCellPadding() + CheckBox.getPreferredWidth();
        headers.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", tw, tw, tw));
        return headers;
    }

    protected ASearchConfiguration<? extends ADTO, ? extends Enum<?>> getSearchConfig(String id, Object value) {
        if (FILTER_ARTICLE_ID.equals(id)) {
            this.currentArticle = (String)value;
            if (this.currentArticle != null && this.currentArticle.trim().isEmpty()) {
                this.currentArticle = null;
            }
        } else if (FILTER_POSITION_ID.equals(id)) {
            this.currentPosition = (String)value;
            if (this.currentPosition != null && this.currentPosition.trim().isEmpty()) {
                this.currentPosition = null;
            }
        } else if (FILTER_CUSTOMER_ID.equals(id)) {
            this.customer = value instanceof Node ? (CustomerReference)((Node)value).getValue() : (value instanceof CustomerLight ? (CustomerReference)value : null);
        } else if (FILTER_MAINCAT.equals(id)) {
            if (value instanceof Node) {
                this.mainCat = (ArticleCategoryReference)((Node)value).getValue();
            } else {
                this.mainCat = null;
                this.mainGroup = null;
                this.subGroup = null;
            }
        } else if (FILTER_MAINGROUP.equals(id)) {
            if (value instanceof Node) {
                this.mainGroup = (ArticleCategoryReference)((Node)value).getValue();
            } else {
                this.mainGroup = null;
                this.subGroup = null;
            }
        } else if (FILTER_SUBGROUP.equals(id)) {
            this.subGroup = value instanceof Node ? (ArticleCategoryReference)((Node)value).getValue() : null;
        } else if (FILTER_BONDED.equals(id)) {
            BondedStateE state = BondedStateE.ALL;
            if (value instanceof BondedStateE) {
                state = (BondedStateE)value;
            } else if (value instanceof Node && ((Node)value).getValue() instanceof BondedStateE) {
                state = (BondedStateE)((Node)value).getValue();
            }
            switch (state) {
                case ALL: {
                    this.isBonded = null;
                    break;
                }
                case NOT_BONDED: {
                    this.isBonded = false;
                    break;
                }
                case ONLY_BONDED: {
                    this.isBonded = true;
                }
            }
        } else if (FILTER_DELETED.equals(id)) {
            if (value instanceof DeletedStateE) {
                this.fc8 = (DeletedStateE)value;
            }
        } else if (FILTER_INUSE.equals(id)) {
            if (value instanceof InUseStateE) {
                this.fc9 = (InUseStateE)value;
            }
        } else if (FILTER_ORDER_FIELD.equals(id) && value instanceof String) {
            if (Words.ARTICLE_NUMBER.equals(value)) {
                this.sortRow = 1;
            } else if (Words.ARTICLE_NAME.equals(value)) {
                this.sortRow = 3;
            } else if (Words.CUSTOMER_ARTICLE_NUMBER.equals(value)) {
                this.sortRow = 2;
            }
        }
        ArticleChargeBatchSearchConfiguration c = new ArticleChargeBatchSearchConfiguration();
        String t = this.currentArticle;
        Integer ti = null;
        try {
            ti = Integer.valueOf(t);
        }
        catch (NumberFormatException e) {
            ti = null;
        }
        switch (this.miniCombo.getSelectedType()) {
            case ALL: {
                c.setArticleNumber(ti);
                c.setArticleName(t);
                c.setCustomerArticleNumber(t);
                break;
            }
            case ARTICLE_NAME: {
                c.setArticleName(t);
                break;
            }
            case ARTICLE_NUMBER: {
                c.setArticleNumber(ti);
                break;
            }
            case CUSTOMER_NUMBER: {
                c.setCustomerArticleNumber(t);
                break;
            }
            case SUPPLIER_NUMBER: {
                break;
            }
        }
        c.setCurrentStore(this.storeDTO);
        c.setStorePositionName(this.currentPosition);
        c.setCustomer(this.customer);
        c.setMainCategory(this.mainCat);
        c.setMainGroup(this.mainGroup);
        c.setSubGroup(this.subGroup);
        c.setBonded(this.isBonded);
        c.getLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
        if (this.storeDTO.getInventoryInProgress() != null) {
            c.setInventory(new InventoryReference(this.storeDTO.getInventoryInProgress().getId()));
        }
        if (this.fc8 != null) {
            switch (this.fc8) {
                case ALL: {
                    c.setIsDeleted(null);
                    break;
                }
                case NOT_DELETED: {
                    c.setIsDeleted(Boolean.valueOf(false));
                    break;
                }
                case ONLY_DELETED: {
                    c.setIsDeleted(Boolean.valueOf(true));
                    break;
                }
                default: {
                    c.setIsDeleted(null);
                }
            }
        }
        if (this.fc9 != null) {
            switch (this.fc9) {
                case ALL: {
                    c.setInUse(null);
                    break;
                }
                case NOT_USED: {
                    c.setInUse(Boolean.valueOf(false));
                    break;
                }
                case ONLY_USED: {
                    c.setInUse(Boolean.valueOf(true));
                    break;
                }
                default: {
                    c.setInUse(null);
                }
            }
        }
        c.setSortDirection(SortDirection.ASCENDING);
        switch (this.sortRow) {
            case 1: {
                c.setSortColumn((Enum)ArticleChargeBatchSearchConfiguration.ARTICLE_CHARGE_BATCH_COLUMN.NUMBER);
                break;
            }
            case 2: {
                c.setSortColumn((Enum)ArticleChargeBatchSearchConfiguration.ARTICLE_CHARGE_BATCH_COLUMN.CUSTOMER_ARTICLE_NO);
                break;
            }
            case 3: {
                c.setSortColumn((Enum)ArticleChargeBatchSearchConfiguration.ARTICLE_CHARGE_BATCH_COLUMN.NAME);
            }
        }
        c.setNumResults(30);
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        boolean b = false;
        if (this.currentState == 5) {
            if (this.upperTable != null) {
                this.upperTable.getModel().setNode((Node)new ViewNode(""));
                this.searcher = this.getSearchAlgorithm();
                ((AddBatchPanelNEW)this.lowerTable.getFootablePanel()).setCurrentStore(this.storeDTO);
                ((AddBatchPanelNEW)this.lowerTable.getFootablePanel()).setBatchesNode(this.lowerTable.getModel().getNode());
                this.upperTable.getFilterChain().setBlind(true);
                this.mainCatCombo.refreshPossibleValues(NodeToolkit.getAffixList(ArticleCategoryComplete.class));
                this.mainCatCombo.addItem(Words.ALL);
                this.mainCatCombo.setSelectedItem(Words.ALL);
                this.upperTable.getFilterChain().setBlind(false);
                this.upperTable.invokeDefaultSearch();
                this.setEnabled(true);
                b = true;
            }
        } else if (this.currentState == 16) {
            this.startDownloadInner(node);
        } else {
            b = this.currentState == 11 ? TransactionToolkit.ensureErrorPopup(node, "Unable to save inventory data:", this, this) : (this.currentState == 7 ? TransactionToolkit.ensureErrorPopup(node, "Unable to save inventory data:", this, this) : false);
        }
        if (!b) {
            if (this.upperTable != null) {
                this.upperTable.hideLoadingAnimation();
            }
            if (this.lowerTable != null) {
                this.lowerTable.hideLoadingAnimation();
            }
            this.setEnabled(true);
        }
        this.createFocusCycle();
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.setEnabled(true);
        super.errorOccurred(exception);
    }

    protected SearchAlgorithm getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(ArticleChargeBatchSearchAlgorithm.class);
    }

    public void redo() {
    }

    public void undo() {
    }

    @Override
    public void saveAndBackDocument() {
        this.currentState = 11;
        this.upperTable.showLoadingAnimation(Words.SAVE_DATA);
        this.doSaveDocument();
    }

    @Override
    public void saveDocument() {
        this.currentState = 7;
        this.upperTable.showLoadingAnimation("Correcting Stock");
        this.addAll.setEnabled(false);
        this.doSaveDocument();
    }

    private void doSaveDocument() {
        this.setEnabled(false);
        InventoryReference id = this.storeDTO.getInventoryInProgress();
        if (id != null) {
            id = new InventoryReference(id.getId());
        }
        final ArrayList<IStockInventoryComplete> list = new ArrayList<IStockInventoryComplete>();
        ArrayList<ScreenValidationObject> warnings = new ArrayList<ScreenValidationObject>();
        boolean warning = false;
        for (Table2RowPanel p : this.lowerTable.getRows()) {
            IStockInventoryComplete scc;
            TableRowImplNEW pp = (TableRowImplNEW)p;
            if (!pp.isWarningRow() && this.warnState != 63) {
                warning = true;
                warnings.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "New Value exceeds Inventory Threshold"));
            }
            if ((scc = pp.getTransaction()) instanceof StockInventoryComplete) {
                scc.setUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                scc.setInventory(id);
            } else if (scc instanceof InventoryCheckinComplete) {
                scc.setUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                scc.setInventory(id);
            } else if (scc instanceof CirculationStockCheckinComplete) {
                scc.setUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                scc.setInventory(id);
            } else if (scc instanceof CirculationStockCheckoutComplete) {
                scc.setUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                scc.setInventory(id);
            }
            list.add(scc);
        }
        if (warning) {
            InnerPopupFactory.showWarningDialog(warnings, "", (Component)this);
            this.warnState = 63;
            this.currentState = 0;
            this.remoteObjectLoaded(null);
            return;
        }
        this.warnState = 121;
        try {
            this.lowerTable.resetTable();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (list.size() > 0) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    int count = 1;
                    int max = list.size();
                    ArrayList<IStockInventoryComplete> notCorrectedList = new ArrayList<IStockInventoryComplete>();
                    ArrayList<IStockInventoryComplete> correctedList = new ArrayList<IStockInventoryComplete>();
                    ArrayList<String> errors = new ArrayList<String>();
                    HashMap ret = new HashMap();
                    for (IStockInventoryComplete correction : list) {
                        block7: {
                            try {
                                InventoryCBSubModuleNEW.this.upperTable.updateLoadingAnimation("Processing " + count + " of " + max);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (correction != null && !ret.keySet().contains(correction)) {
                                try {
                                    Map ret1 = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).correct(Collections.singletonList(correction), InventoryCBSubModuleNEW.this.isChargeBased(), false);
                                    ret.putAll(ret1);
                                    correctedList.add(correction);
                                }
                                catch (ClientServerCallException e) {
                                    notCorrectedList.add(correction);
                                    errors.add(e.getMessage());
                                    if (!(correction instanceof StockInventoryComplete)) break block7;
                                    ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).logInventoryException(correction.getInventory(), (BasicArticleReference)correction.getArticle(), correction.getAmount(), ((StockInventoryComplete)correction).getStorePosition());
                                }
                            }
                        }
                        ++count;
                    }
                    SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    if (Boolean.TRUE.equals(settings.getReturnInventoryCountReceipt())) {
                        InventoryCBSubModuleNEW.this.showErrorAndDownloadExcel(correctedList, notCorrectedList, errors);
                    }
                    ViewNode n = new ViewNode("");
                    n.setValue(ret, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return InventoryCBSubModuleNEW.this;
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            this.remoteObjectLoaded(null);
        }
    }

    private void showErrorAndDownloadExcel(List<IStockInventoryComplete> list, List<IStockInventoryComplete> notCorrectedList, List<String> errors) {
        ArrayList<ScreenValidationObject> validations = new ArrayList<ScreenValidationObject>();
        if (errors.isEmpty()) {
            validations.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, "All entries have been saved successfully."));
            validations.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, "An Inventory Count Receipt will be generated."));
        } else {
            validations.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Some entries have not been saved due to errors."));
            validations.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Be sure to check the generated Inventory Count Receipt"));
        }
        InnerPopupFactory.showDialog(validations, "Save Inventory", "Receipt", "", (source, xargs) -> {
            try {
                File pegFile = this.createInventoryCountReceipt(list, notCorrectedList, errors);
                Desktop.getDesktop().open(pegFile);
                PegasusFileComplete r = new PegasusFileComplete();
                r.setCategory(FileCategoryE.IMPORT);
                r.setLocalFile(pegFile);
                PegasusFileComplete uploaded = FileTransferUtil.upload((PegasusFileComplete)r, (FileTransferListener[])new FileTransferListener[0]);
                InventoryReference iRef = this.storeDTO.getInventoryInProgress();
                ((InventoryReportServiceManager)ServiceManagerRegistry.getService(InventoryReportServiceManager.class)).addInventoryCountReceipt(iRef, uploaded, new StoreReference(this.storeDTO.getId()), !errors.isEmpty());
            }
            catch (ExcelToolkitException | IOException e) {
                this.log.error("Unable to preview Excel", e);
            }
            catch (Exception e) {
                this.log.error("Unable to upload Excel", (Throwable)e);
            }
        }, this, PopupType.NORMAL);
    }

    private File createInventoryCountReceipt(List<IStockInventoryComplete> list, List<IStockInventoryComplete> notCorrectedList, List<String> errors) throws IOException, ExcelToolkitException {
        File tempFile = File.createTempFile("CATIT_Inventory_Count_Receipt", ".xlsx");
        StyledWorkbook fastWorkbook = ExcelToolkit.createFastWorkbook();
        Sheet savedSheet = ExcelToolkit.insertSheet((StyledWorkbook)fastWorkbook, (String)"Saved");
        Sheet notSavedSheet = ExcelToolkit.insertSheet((StyledWorkbook)fastWorkbook, (String)"Not Saved");
        Sheet errorsSheet = ExcelToolkit.insertSheet((StyledWorkbook)fastWorkbook, (String)"Errors");
        Sheet infoSheet = ExcelToolkit.insertSheet((StyledWorkbook)fastWorkbook, (String)"Info");
        this.writeHeader(fastWorkbook, savedSheet);
        this.writeRows(list, fastWorkbook, savedSheet, 1);
        this.writeHeader(fastWorkbook, notSavedSheet);
        this.writeRows(notCorrectedList, fastWorkbook, notSavedSheet, 1);
        this.writeErrors(errors, fastWorkbook, errorsSheet);
        this.writeInfo(fastWorkbook, infoSheet);
        ExcelToolkit.writeWorkBook((File)tempFile, (StyledWorkbook)fastWorkbook);
        return tempFile;
    }

    private void writeInfo(StyledWorkbook fastWorkbook, Sheet errorsSheet) {
        ExcelRow h = new ExcelRow();
        h.addCell((Object)"Config", new String[0]);
        h.addCell((Object)"Value", new String[0]);
        h.writeRow(fastWorkbook, errorsSheet, true, 0);
        ExcelRow userRow = new ExcelRow();
        userRow.addCell((Object)"User", new String[0]);
        userRow.addCell((Object)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getUserName(), new String[0]);
        userRow.writeRow(fastWorkbook, errorsSheet, false, 1);
        ExcelRow timeStampRow = new ExcelRow();
        timeStampRow.addCell((Object)"Timestamp", new String[0]);
        timeStampRow.addCell((Object)new Timestamp(System.currentTimeMillis()), new String[0]);
        timeStampRow.writeRow(fastWorkbook, errorsSheet, false, 2);
    }

    private void writeErrors(List<String> errors, StyledWorkbook fastWorkbook, Sheet errorsSheet) {
        ExcelRow h = new ExcelRow();
        h.addCell((Object)"Message", new String[0]);
        h.writeRow(fastWorkbook, errorsSheet, true, 0);
        int i = 1;
        for (String error : errors) {
            ExcelRow row = new ExcelRow();
            row.addCell((Object)error, new String[0]);
            row.writeRow(fastWorkbook, errorsSheet, false, i++);
        }
    }

    private void writeHeader(StyledWorkbook fastWorkbook, Sheet saved) {
        ExcelRow header = new ExcelRow();
        header.addCell((Object)"No", new String[0]);
        header.addCell((Object)"Customer No", new String[0]);
        header.addCell((Object)"Name", new String[0]);
        header.addCell((Object)"Conversion", new String[0]);
        header.addCell((Object)"UoM", new String[0]);
        header.addCell((Object)"Amount", new String[0]);
        header.addCell((Object)"Counted", new String[0]);
        header.addCell((Object)"Store", new String[0]);
        header.addCell((Object)FILTER_POSITION_ID, new String[0]);
        header.addCell((Object)"Charge", new String[0]);
        header.writeRow(fastWorkbook, saved, true, 0);
    }

    private void writeRows(List<IStockInventoryComplete> list, StyledWorkbook fastWorkbook, Sheet saved, int i) {
        PackagingQuantityFormulaCoverter converter = (PackagingQuantityFormulaCoverter)ConverterRegistry.getConverter(PackagingQuantityFormulaCoverter.class);
        for (IStockInventoryComplete entry : list) {
            ExcelRow articleRow;
            StoreQuantityComplete amount;
            StockInventoryComplete inv;
            if (entry instanceof StockInventoryComplete) {
                inv = (StockInventoryComplete)entry;
                Integer number = inv.getCharge().getBasicArticle().getNumber();
                String customerArticleNumber = inv.getCharge().getBasicArticle().getCustomerArticleNumber();
                String name = inv.getCharge().getBasicArticle().getName();
                String store = inv.getStorePosition().getStore().getCode();
                String position = inv.getStorePosition().getName();
                Integer chargeNo = inv.getCharge().getNumber();
                amount = inv.getAmount();
                articleRow = new ExcelRow();
                articleRow.addCell((Object)number, new String[0]);
                articleRow.addCell((Object)customerArticleNumber, new String[0]);
                articleRow.addCell((Object)name, new String[0]);
                articleRow.addCell((Object)"", new String[0]);
                articleRow.addCell((Object)amount.getUnit().getShortName(), new String[0]);
                articleRow.addCell((Object)"", new String[0]);
                articleRow.addCell((Object)amount.getAmount(), new String[0]);
                articleRow.addCell((Object)store, new String[0]);
                articleRow.addCell((Object)position, new String[0]);
                articleRow.addCell((Object)chargeNo, new String[0]);
                articleRow.writeRow(fastWorkbook, saved, false, i++);
                continue;
            }
            if (!(entry instanceof InventoryCheckinComplete)) continue;
            inv = (InventoryCheckinComplete)entry;
            BasicArticleLight article = inv.getArticle();
            Integer number = article.getNumber();
            String customerArticleNumber = article.getCustomerArticleNumber();
            String name = article.getName();
            String store = inv.getStorePosition().getStore().getCode();
            String position = inv.getStorePosition().getName();
            amount = inv.getAmount();
            articleRow = new ExcelRow();
            articleRow.addCell((Object)number, new String[0]);
            articleRow.addCell((Object)customerArticleNumber, new String[0]);
            articleRow.addCell((Object)name, new String[0]);
            articleRow.addCell((Object)"", new String[0]);
            articleRow.addCell((Object)amount.getUnit().getShortName(), new String[0]);
            articleRow.addCell((Object)"", new String[0]);
            articleRow.addCell((Object)amount.getAmount(), new String[0]);
            articleRow.addCell((Object)store, new String[0]);
            articleRow.addCell((Object)position, new String[0]);
            articleRow.addCell(((InventoryCheckinComplete)entry).getCharge() == null ? "" : ((InventoryCheckinComplete)entry).getCharge().getNumber(), new String[0]);
            articleRow.writeRow(fastWorkbook, saved, false, i++);
        }
    }

    public void importInventoryCountData(final File file) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                List<ExcelRow> excelRows;
                boolean importedWithoutProblems = true;
                try {
                    StoreComplete store = (StoreComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStoreByReference(new StoreReference(InventoryCBSubModuleNEW.this.storeDTO.getId())).getValue();
                    excelRows = ExcelToolkit.readRows((File)file, (int)0, (boolean)true);
                    excelRows.removeIf(excelRow -> {
                        boolean foundValue = false;
                        for (Object cell : excelRow.getCells()) {
                            if (cell == null) continue;
                            if (cell instanceof String) {
                                if (StringUtil.isBlank((String)((String)cell))) continue;
                                foundValue = true;
                                continue;
                            }
                            foundValue = true;
                        }
                        return !foundValue;
                    });
                    InventoryCountImportUtil util = new InventoryCountImportUtil(InventoryCBSubModuleNEW.this, InventoryCBSubModuleNEW.this.isChargeBased());
                    InventoryCBSubModuleNEW.this.notOkList = util.importRows(excelRows, store);
                    if (InventoryCBSubModuleNEW.this.notOkList == null) {
                        InventoryCBSubModuleNEW.this.notOkList = new ArrayList();
                        importedWithoutProblems = false;
                    }
                }
                catch (ExcelToolkitException e) {
                    excelRows = new ArrayList();
                    InnerPopupFactory.showErrorDialog("Could not read Excel file. Ensure file is closed.", (Component)InventoryCBSubModuleNEW.this);
                    importedWithoutProblems = false;
                }
                if (!InventoryCBSubModuleNEW.this.notOkList.isEmpty()) {
                    ArrayList<ScreenValidationObject> validations = new ArrayList<ScreenValidationObject>();
                    for (Tuple tuple : InventoryCBSubModuleNEW.this.notOkList) {
                        validations.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article : " + tuple.getS() + " " + (String)tuple.getT()));
                    }
                    importedWithoutProblems = false;
                    InventoryCBSubModuleNEW.this.showErrorsAndDownloadExcel(validations, excelRows);
                }
                Node n = new Node();
                n.setValue((Object)new Boolean(importedWithoutProblems), 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        Boolean importedWithoutProblems = (Boolean)node.getValue();
                        if (Boolean.TRUE.equals(importedWithoutProblems)) {
                            InnerPopupFactory.showMessageDialog("Inventory data imported", InventoryCBSubModuleNEW.this);
                        }
                        InventoryCBSubModuleNEW.this.upperTable.hideLoadingAnimation();
                        InventoryCBSubModuleNEW.this.upperTable.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)InventoryCBSubModuleNEW.this);
                        if (InventoryCBSubModuleNEW.this.upperTable != null) {
                            InventoryCBSubModuleNEW.this.upperTable.setEnabled(true);
                        }
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void showErrorsAndDownloadExcel(List<ScreenValidationObject> validations, List<ExcelRow> excelRows) {
        this.lowerTable.hideLoadingAnimation();
        InnerPopupFactory.showErrorDialog(validations, "Import Inventory", "Unable to import", (source, xargs) -> {
            try {
                File pegFile = new InventoryCountImportUtil(this, this.isChargeBased()).createExcelWithErrors(excelRows);
                Desktop.getDesktop().open(pegFile);
            }
            catch (IOException e) {
                this.log.error("Unable to generate Excel File", (Throwable)e);
            }
        }, this);
    }

    @Override
    public void showLoadingAnimation(int current, int max) {
        this.upperTable.updateLoadingAnimation("Importing " + (int)((double)current / (double)max * 100.0) + "%");
    }

    @Override
    public boolean addToLower(StorePositionContentComplete content, QuantityComplete quantityComplete) {
        return this.addToLowerTable(content, quantityComplete);
    }

    @Override
    public boolean checkForDuplicationsInLower(int chargeNumber, InventoryCheckinComplete scc) {
        String already_counted = "Already counted";
        boolean alreadyCounted = false;
        boolean doRemove = true;
        Iterator it = this.lowerTable.getModel().getNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            boolean samePosition;
            boolean sameNumber;
            Object o = it.next();
            Object value = ((DTONode)o).getValue();
            if (value instanceof ArticleChargeBatchComplete) {
                sameNumber = ((ArticleChargeBatchComplete)value).getCharge().getNumber().equals(chargeNumber);
                samePosition = ((ArticleChargeBatchComplete)value).getPosition().getId().equals(scc.getStorePosition().getId());
                if (sameNumber && samePosition) {
                    this.addToNotOkList(chargeNumber, already_counted);
                    alreadyCounted = true;
                    doRemove = false;
                    continue;
                }
            }
            if (!(value instanceof InventoryCheckinComplete)) continue;
            sameNumber = ((InventoryCheckinComplete)value).getArticle().getNumber().equals(chargeNumber);
            samePosition = ((InventoryCheckinComplete)value).getStorePosition().getId().equals(scc.getStorePosition().getId());
            if (!sameNumber || !samePosition) continue;
            this.addToNotOkList(chargeNumber, already_counted);
            alreadyCounted = true;
            doRemove = false;
        }
        if (!alreadyCounted) {
            Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)scc, true, false);
            n.setManuallyAdded(true);
            this.lowerTable.getModel().getNode().addChild(n, 0L);
            this.getAlgorithm().addNodeToAll(n);
        }
        return doRemove;
    }

    private void addToNotOkList(Integer artNo, String message) {
        this.notOkList.add((Tuple<Integer, String>)new Tuple((Object)artNo, (Object)message));
    }

    @Override
    public void openErrorDialog(String message) {
        InnerPopupFactory.showErrorDialog(message, (Component)this);
    }

    @Override
    public String getDuplicationText() {
        return "Already added to counted list";
    }

    @Override
    public void escapeKeyPressed() {
    }

    @Override
    public void saveKeyPressed() {
    }

    @Override
    public void screenSet() {
    }

    @Override
    public void startDataDownload() {
        this.currentState = 16;
        this.remoteObjectLoaded(null);
    }

    public void startDownloadInner(Node n) {
        this.currentState = 5;
        this.remoteObjectLoaded(n);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.upperTable != null) {
            this.upperTable.setEnabled(isEnabled);
            this.addAll.setEnabled(isEnabled);
            this.lowerTable.setEnabled(isEnabled);
        }
    }

    public StoreLight getStore() {
        return this.storeDTO;
    }

    public SearchAlgorithm getAlgorithm() {
        return this.searcher;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.upperTable.getFilterChain().isBlind()) {
            return;
        }
        this.upperTable.getFilterChain().setBlind(true);
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.mainCatCombo) {
                if (this.mainCatCombo.getSelectedItem() instanceof Node) {
                    this.mainGroupCombo.refreshPossibleValues(((Node)this.mainCatCombo.getSelectedItem()).getChildNamed(new String[]{"subCategories"}));
                    this.mainGroupCombo.addItem(Words.ALL);
                    this.mainGroupCombo.setSelectedItem(Words.ALL);
                } else {
                    this.mainGroupCombo.removeAllItems();
                    this.mainGroupCombo.addItem(Words.ALL);
                }
                this.subGroupCombo.removeAllItems();
                this.subGroupCombo.addItem(Words.ALL);
            } else if (e.getSource() == this.mainGroupCombo) {
                if (this.mainGroupCombo.getSelectedItem() instanceof Node) {
                    this.subGroupCombo.refreshPossibleValues(((Node)this.mainGroupCombo.getSelectedItem()).getChildNamed(new String[]{"subCategories"}));
                    this.subGroupCombo.addItem(Words.ALL);
                    this.subGroupCombo.setSelectedItem(Words.ALL);
                } else {
                    this.subGroupCombo.removeAllItems();
                    this.subGroupCombo.addItem(Words.ALL);
                }
            }
        }
        this.upperTable.getFilterChain().setBlind(false);
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (this.currentState == 7) {
            this.lowerTable.getModel().setNode((Node)new ViewNode(""));
            ((AddBatchPanelNEW)this.lowerTable.getFootablePanel()).setBatchesNode(this.lowerTable.getModel().getNode());
            this.lowerTable.hideLoadingAnimation();
            this.upperTable.hideLoadingAnimation();
            this.upperTable.invokeDefaultSearch();
            this.setEnabled(true);
        } else if (this.currentState == 11) {
            this.lowerTable.hideLoadingAnimation();
            this.cancelDocument();
        }
    }

    @Override
    public void setRowAttributes(RowTransferObject<StoreLight> o) {
        this.setRow(o.getFakeRow());
        this.init();
        this.storeDTO = (StoreLight)o.getDto();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        ArrayList<Table2RowPanel> panels = new ArrayList<Table2RowPanel>();
        for (Table2RowPanel row : this.upperTable.getRows()) {
            if (((TableRowImplNEW)row).isBlocked()) continue;
            panels.add(row);
        }
        for (Table2RowPanel row : panels) {
            ((TableRowImplNEW)row).removeAndAddToLowerTable();
        }
    }

    public void addToLowerTable(Table2RowModel model, QuantityComplete quantityComplete) {
        boolean isNew = true;
        for (Table2RowPanel row : this.lowerTable.getRows()) {
            if (!row.getModel().getNode().equals(model.getNode())) continue;
            isNew = false;
        }
        if (isNew) {
            Node countedNode = model.getNode().getChildNamed(new String[]{"count"});
            if (countedNode == null) {
                countedNode = new EmbeddedDTONode();
                countedNode.setName("count");
                model.getNode().addChild(countedNode, 0L);
            }
            countedNode.setValue((Object)quantityComplete, 0L);
            countedNode.getChildNamed(QuantityComplete_.quantity).setValue((Object)quantityComplete.getQuantity(), 0L);
            countedNode.getChildNamed(QuantityComplete_.unit).setValue((Object)quantityComplete.getUnit(), 0L);
            this.lowerTable.getModel().getNode().addChild(model.getNode(), 0L);
        }
        this.revalidateTables();
    }

    public boolean addToLowerTable(StorePositionContentComplete content, QuantityComplete quantityComplete) {
        Iterator it = this.lowerTable.getModel().getNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            boolean samePosition;
            boolean sameNumber;
            Object o = it.next();
            Object value = ((DTONode)o).getValue();
            if (value instanceof StorePositionContentComplete) {
                sameNumber = ((StorePositionContentComplete)value).getArticle().getNumber().equals(content.getArticle().getNumber());
                samePosition = ((StorePositionContentComplete)value).getStorePosition().getId().equals(content.getStorePosition().getId());
                if (sameNumber && samePosition) {
                    return false;
                }
            }
            if (!(value instanceof InventoryCheckinComplete)) continue;
            sameNumber = ((InventoryCheckinComplete)value).getArticle().getNumber().equals(content.getArticle().getNumber());
            samePosition = ((InventoryCheckinComplete)value).getStorePosition().getId().equals(content.getStorePosition().getId());
            if (!sameNumber || !samePosition) continue;
            return false;
        }
        Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)content, false, false);
        Node countedQuantity = INodeCreator.getDefaultImpl().getNode4DTO((Object)quantityComplete, false, false);
        countedQuantity.setName("count");
        node.addChild(countedQuantity, 0L);
        this.lowerTable.getModel().getNode().addChild(node, 0L);
        this.revalidateTables();
        return true;
    }

    @Override
    public boolean addToLower(ArticleChargeBatchComplete content, QuantityComplete quantityComplete) {
        Iterator it = this.lowerTable.getModel().getNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            boolean samePosition;
            boolean sameNumber;
            Object o = it.next();
            Object value = ((DTONode)o).getValue();
            if (value instanceof ArticleChargeBatchComplete) {
                sameNumber = ((ArticleChargeBatchComplete)value).getCharge().getNumber().equals(content.getCharge().getNumber());
                samePosition = ((ArticleChargeBatchComplete)value).getPosition().getId().equals(content.getPosition().getId());
                if (sameNumber && samePosition) {
                    return false;
                }
            }
            if (!(value instanceof InventoryCheckinComplete)) continue;
            sameNumber = ((InventoryCheckinComplete)value).getCharge().getNumber().equals(content.getCharge().getNumber());
            samePosition = ((InventoryCheckinComplete)value).getStorePosition().getId().equals(content.getPosition().getId());
            if (!sameNumber || !samePosition) continue;
            return false;
        }
        Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)content, false, false);
        Node countedQuantity = INodeCreator.getDefaultImpl().getNode4DTO((Object)quantityComplete, false, false);
        countedQuantity.setName("count");
        node.addChild(countedQuantity, 0L);
        this.lowerTable.getModel().getNode().addChild(node, 0L);
        this.revalidateTables();
        return true;
    }

    public void removeFromLowerTable(TableRowImplNEW tableRowImplNEW) {
        this.lowerTable.removeRow(tableRowImplNEW, true);
        this.revalidateTables();
    }

    public void revalidateTables() {
        HashSet<Tuple> used = new HashSet<Tuple>();
        ArrayList<Table2RowPanel> usedRows = new ArrayList<Table2RowPanel>(this.lowerTable.getModel().getTable().getRows());
        for (Table2RowPanel tableRowPanel : usedRows) {
            ADTO adto = (ADTO)tableRowPanel.getModel().getNode().getValue();
            if (!(adto instanceof ArticleChargeBatchComplete)) continue;
            used.add(new Tuple((Object)((ArticleChargeBatchComplete)adto).getCharge().getId(), (Object)((ArticleChargeBatchComplete)adto).getPosition().getId()));
        }
        ArrayList<Table2RowPanel> rows = new ArrayList<Table2RowPanel>(this.upperTable.getModel().getTable().getRows());
        for (Table2RowPanel tableRowPanel : rows) {
            ADTO adto = (ADTO)tableRowPanel.getModel().getNode().getValue();
            if (!(adto instanceof ArticleChargeBatchComplete)) continue;
            if (used.contains(new Tuple((Object)((ArticleChargeBatchComplete)adto).getCharge().getId(), (Object)((ArticleChargeBatchComplete)adto).getPosition().getId()))) {
                ((TableRowImplNEW)tableRowPanel).setBlocked(true);
                continue;
            }
            ((TableRowImplNEW)tableRowPanel).setBlocked(false);
        }
    }

    @Override
    public SubModuleDefinitionComplete getSubModuleDefinition() {
        return StoreAccess.getSubModuleDefinition((SubModuleAccessDefinition)StoreAccess.TOOL_STORE_INVENTORY_CB);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = InventoryCBSubModuleNEW.this.layoutTitle(parent);
            y = InventoryCBSubModuleNEW.this.layoutTitleBar(y, parent.getWidth());
            InventoryCBSubModuleNEW.this.upperTable.setLocation(0, y + 10);
            InventoryCBSubModuleNEW.this.upperTable.setSize(parent.getWidth(), (parent.getHeight() - y - 30) / 2);
            InventoryCBSubModuleNEW.this.addAll.setLocation(parent.getWidth() - ((InventoryCBSubModuleNEW)InventoryCBSubModuleNEW.this).addAll.getPreferredSize().width, InventoryCBSubModuleNEW.this.upperTable.getY() + InventoryCBSubModuleNEW.this.upperTable.getSize().height + 10);
            InventoryCBSubModuleNEW.this.addAll.setSize(InventoryCBSubModuleNEW.this.addAll.getPreferredSize());
            InventoryCBSubModuleNEW.this.lowerTable.setLocation(0, InventoryCBSubModuleNEW.this.addAll.getY() + InventoryCBSubModuleNEW.this.addAll.getHeight() + 10);
            InventoryCBSubModuleNEW.this.lowerTable.setSize(parent.getWidth(), (parent.getHeight() - y - 30) / 2 - InventoryCBSubModuleNEW.this.addAll.getHeight() - 10);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

