/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.Stringable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.TypedSkin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.InternalConsumptionStateSkin;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class CellViewInternalConsumptionStateRenderer
extends CellRenderer
implements AttributeListener,
Stringable {
    private static final long serialVersionUID = 1L;
    private TypedSkin3Field skin;
    private InternalConsumptionStateE currentState;

    public CellViewInternalConsumptionStateRenderer(InternalConsumptionStateE state) {
        this.currentState = state;
        this.setOpaque(false);
        this.skin = SkinRegistry.getSkin(InternalConsumptionStateSkin.class);
        this.attributeChanged("All attributes changed");
    }

    public InternalConsumptionStateE getState() {
        return this.currentState;
    }

    @Override
    public Dimension getPreferredSize() {
        int currentX = 0;
        return new Dimension(currentX += this.skin.getImageLeft(Button.ButtonState.UP, (Enum)this.currentState).getWidth() * 3 + 2, this.skin.getImageLeft(Button.ButtonState.UP, (Enum)this.currentState).getHeight());
    }

    public static int getPreferredWidth() {
        return (int)new CellViewInternalConsumptionStateRenderer(InternalConsumptionStateE.COMPLETE).getPreferredSize().getWidth();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int y = (this.getHeight() - this.skin.getImageLeft(Button.ButtonState.UP, (Enum)this.currentState).getHeight()) / 2;
        this.skin.paint(g2, 5, y, this.getWidth(), Button.ButtonState.UP, (Enum)this.currentState);
        this.paintChildren(g2);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.repaint(32L);
        }
    }

    @Override
    public String getStringValue() {
        return this.currentState.toString();
    }

    public static String getValueString(OrderStateE value) {
        return value.toString();
    }
}

