/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.StateIndicatorThree;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class FlightSubstitutionStateRenderer
extends CellRenderer
implements AttributeListener {
    private static final long serialVersionUID = 1L;
    private StateIndicatorThree skin = SkinRegistry.getSkin(StateIndicatorThree.class);
    private int xInsert;
    private FlightSubstitutionStateE currentState;

    public FlightSubstitutionStateRenderer(FlightLight flight) {
        this.attributeChanged("All attributes changed");
        this.currentState = flight != null ? (flight.getSubstitutionsApproved().booleanValue() ? FlightSubstitutionStateE.FLIGHT_APPROVED : (flight.getHasSubstitutions().booleanValue() ? FlightSubstitutionStateE.HAS_SUBSTITUTIONS : FlightSubstitutionStateE.NONE)) : FlightSubstitutionStateE.NONE;
    }

    @Override
    public Dimension getPreferredSize() {
        int a = this.skin.getImage(Button.ButtonState.UP, this.currentState).getWidth();
        int b = this.skin.getImage(Button.ButtonState.UP, this.currentState).getHeight();
        return new Dimension(a * 3 + 2, b);
    }

    @Override
    public String getStringValue() {
        return this.getValueString(this.currentState);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int currentX = 0;
        int currentY = 0;
        currentX = this.isFirstColumn ? this.firstColumnInset : this.xInsert;
        currentY = (this.getHeight() - this.skin.getImage(Button.ButtonState.UP, this.currentState).getHeight()) / 2;
        this.skin.paint(g2, currentX, currentY, Button.ButtonState.UP, this.currentState);
        this.paintChildren(g2);
    }

    protected int getState() {
        return this.currentState.ordinal();
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.xInsert = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding"));
            this.firstColumnInset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_first_column_inset"));
            this.repaint(32L);
        }
    }

    public String getValueString(FlightSubstitutionStateE currentState2) {
        if (currentState2 == null) {
            return "";
        }
        return currentState2.toString();
    }

    private static enum FlightSubstitutionStateE {
        NONE,
        HAS_SUBSTITUTIONS,
        FLIGHT_APPROVED;


        public String toString() {
            switch (this) {
                case FLIGHT_APPROVED: {
                    return "Flight approved";
                }
                case HAS_SUBSTITUTIONS: {
                    return "Has Substitution";
                }
                case NONE: {
                    return "None";
                }
            }
            return "-";
        }
    }
}

