/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.smartaccess.popup;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.batch.BatchList;
import ch.icit.pegasus.client.gui.screentemplates.ScreenLoader;
import ch.icit.pegasus.client.gui.table.smartaccess.popup.Entry;
import ch.icit.pegasus.client.gui.table.smartaccess.popup.SubModuleNameConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleTypeE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ARequisitionOrderAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.BasicArticleAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.CustomerAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.HandlingCostAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InventoryAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InvoiceAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.PurchaseOrderAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RetailAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.StoreAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.SupplierAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.IUniversal;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class SmartScreenAccessPopupInsert<T extends IUniversal>
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private TreeMap<SubModuleTypeE, List<Entry>> entries;
    private final ScreenLoader<T> screenLoader;
    private final BatchList<?, ?> batchList;
    private ScrollPane scrollPane;
    private JPanelKillable contentPane;

    public SmartScreenAccessPopupInsert(List<SubModuleAccessRightComplete> sentries, MainFrame mainFrame, ScreenLoader<T> screenLoader, BatchList<?, ?> batchList) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.entries = new TreeMap(this.getSubModuleTypesComparator());
        this.batchList = batchList;
        this.screenLoader = screenLoader;
        this.contentPane = new JPanelKillable(){};
        this.scrollPane = new ScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setViewportView(this.contentPane);
        this.contentPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setOpaque(false);
        this.scrollPane.getHorizontalScrollBar().setOpaque(false);
        this.scrollPane.getVerticalScrollBar().setOpaque(false);
        this.setLayout(new Layout());
        this.contentPane.setLayout(new ContentLayout());
        boolean isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
        SubModuleNameConverter converter = access -> {
            if (isSolarCompany) {
                if (access.getModule().getInvokingName().equals(BasicArticleAccess.ANALYSIS_ARTICLE_CHANGES.getIdentifier())) {
                    return Words.ANALYSIS_ARTICLE_CHANGES;
                }
                if (access.getModule().getInvokingName().equals(BasicArticleAccess.ANALYSIS_ARTICLE_ACTUAL_STOCK.getIdentifier())) {
                    return Words.ANALYSIS_ARTICLE_ACTUAL_STOCK;
                }
                if (access.getModule().getInvokingName().equals(BasicArticleAccess.ANALYSIS_ARTICLE_USAGE_DETAILED.getIdentifier())) {
                    return Words.ANALYSIS_ARTICLE_USAGE_DETAILED;
                }
                if (access.getModule().getInvokingName().equals(BasicArticleAccess.ANALYSIS_ARTICLE_ACTUAL_CHARGE.getIdentifier())) {
                    return Words.ANALYSIS_ARTICLE_ACTUAL_CHARGE;
                }
                if (access.getModule().getInvokingName().equals(BasicArticleAccess.ANALYSIS_ARTICLE_PURCHASE_ABC.getIdentifier())) {
                    return Words.ANALYSIS_ARTICLE_PURCHASE_ABC;
                }
                if (access.getModule().getInvokingName().equals(BasicArticleAccess.ANALYSIS_ARTICLE_PURCHASE_DETAIL.getIdentifier())) {
                    return Words.ANALYSIS_ARTICLE_PURCHASE_DETAIL;
                }
                if (access.getModule().getInvokingName().equals(BasicArticleAccess.ANALYSIS_ARTICLE_PURCHASE_SUMMARY.getIdentifier())) {
                    return Words.ANALYSIS_ARTICLE_PURCHASE_SUMMARY;
                }
                if (access.getModule().getInvokingName().equals(BasicArticleAccess.ANALYSIS_ARTICLE_TRANSACTIONS.getIdentifier())) {
                    return Words.ANALYSIS_ARTICLE_TRANSACTIONS;
                }
                if (access.getModule().getInvokingName().equals(BasicArticleAccess.ANALYSIS_ARTICLE_EXPORT.getIdentifier())) {
                    return Words.ANALYSIS_ARTICLE_EXPORT;
                }
                if (access.getModule().getInvokingName().equals(BasicArticleAccess.ANALYSIS_ARTICLE_ACTUAL_CHARGE.getIdentifier())) {
                    return Words.ANALYSIS_CHARGE_DETAILS;
                }
                if (access.getModule().getInvokingName().equals(BasicArticleAccess.ANALYSIS_ARTICLE_FACT_SHEETS.getIdentifier())) {
                    return Words.FACT_SHEETS;
                }
                if (access.getModule().getInvokingName().equals(BasicArticleAccess.ANALYSIS_ARTICLE_STORE_INFO_SHEETS.getIdentifier())) {
                    return Words.STORE_INFO_SHEET;
                }
                if (access.getModule().getInvokingName().equals(RetailAccess.ANALYSIS_ARTICLE_LOADING.getIdentifier())) {
                    return Words.ARTICLE_SUMMARY;
                }
                if (access.getModule().getInvokingName().equals(RetailAccess.ANALYSIS_FLIGHT_ARTICLE_LOADING_SHEET.getIdentifier())) {
                    return Words.ARTICLE_DETAILED;
                }
                if (access.getModule().getInvokingName().equals(RetailAccess.ANALYSIS_FLIGHT_PRODUCT_FACT_SHEETS.getIdentifier())) {
                    return Words.PRODUCT_FACT_SHEETS;
                }
                if (access.getModule().getInvokingName().equals(RetailAccess.ANALYSIS_FLIGHT_MATERIAL_DISPOSITION.getIdentifier())) {
                    return Words.MAT_DISPO;
                }
                if (access.getModule().getInvokingName().equals(RetailAccess.ANALYSIS_FLIGHT_DAILY_OPS_PLAN.getIdentifier())) {
                    return Words.DAILY_OPS;
                }
                if (access.getModule().getInvokingName().equals(RetailAccess.ANALYSIS_SALES_EXPORT.getIdentifier())) {
                    return Words.RETAIL_EXPORT;
                }
                if (access.getModule().getInvokingName().equals(PurchaseOrderAccess.ANALYSIS_PURCHASE_ORDER_OPEN_POSITIONS.getIdentifier())) {
                    return Words.ANALYSIS_PURCHASE_ORDER_OPEN_POSITIONS;
                }
                if (access.getModule().getInvokingName().equals(PurchaseOrderAccess.ANALYSIS_PURCHASE_ORDER_ORDERED_RECEIVED.getIdentifier())) {
                    return Words.ANALYSIS_PURCHASE_ORDER_ORDERED_RECEIVED;
                }
                if (access.getModule().getInvokingName().equals(PurchaseOrderAccess.ANALYSIS_PURCHASE_ORDER_RECEIVE_LIST.getIdentifier())) {
                    return Words.ANALYSIS_PURCHASE_ORDER_RECEIVE_LIST;
                }
                if (access.getModule().getInvokingName().equals(PurchaseOrderAccess.ANALYSIS_PURCHASE_ORDER_EXPORT.getIdentifier())) {
                    return Words.ANALYSIS_PURCHASE_ORDER_EXPORT;
                }
                if (access.getModule().getInvokingName().equals(PurchaseOrderAccess.PRINT_PURCHASE_POSITIONS.getIdentifier())) {
                    return Words.PRINT_PURCHASE_DAILY_OPS;
                }
                if (access.getModule().getInvokingName().equals(PurchaseOrderAccess.ACTION_CORRECT_ORDER.getIdentifier())) {
                    return Words.CORRECTION;
                }
                if (access.getModule().getInvokingName().equals(InventoryAccess.ANALYSIS_INVENTORY_DIFFERENCES.getIdentifier())) {
                    return Words.DIFFERENCE_SHEET;
                }
                if (access.getModule().getInvokingName().equals(InventoryAccess.ANALYSIS_INVENTORY_OVERVIEW.getIdentifier())) {
                    return Words.OVERVIEW;
                }
                if (access.getModule().getInvokingName().equals(InventoryAccess.ANALYSIS_INVENTORY_EXPORT.getIdentifier())) {
                    return Words.ANALYSIS_INVENTORY_EXPORT;
                }
                if (access.getModule().getInvokingName().equals(CustomerAccess.ANALYSIS_CUSTOMER_EXPORT.getIdentifier())) {
                    return Words.ANALYSIS_CUSTOMER_EXPORT;
                }
                if (access.getModule().getInvokingName().equals(StoreAccess.ANALYSIS_STORE_EXPORT.getIdentifier())) {
                    return Words.ANALYSIS_STORE_EXPORT;
                }
                if (access.getModule().getInvokingName().equals(StoreAccess.ANALYSIS_STORE_TRANSACTIONS.getIdentifier())) {
                    return Words.ANALYSIS_STORE_TRANSACTIONS;
                }
                if (access.getModule().getInvokingName().equals(SupplierAccess.ANALYSIS_SUPPLIER_PURCHASE_ANALYSIS.getIdentifier())) {
                    return Words.ANALYSIS_SUPPLIER_PURCHASE_ANALYSIS;
                }
                if (access.getModule().getInvokingName().equals(SupplierAccess.ANALYSIS_SUPPLIER_PURCHASE_DETAILS.getIdentifier())) {
                    return Words.ANALYSIS_SUPPLIER_PURCHASE_DETAILS;
                }
                if (access.getModule().getInvokingName().equals(SupplierAccess.ANALYSIS_SUPPLIER_EXPORT.getIdentifier())) {
                    return Words.ANALYSIS_SUPPLIER_EXPORT;
                }
                if (access.getModule().getInvokingName().equals(ProductAccess.ANALYSIS_PRODUCT_FACT_SHEETS.getIdentifier())) {
                    return Words.ANALYSIS_PRODUCT_FACT_SHEETS;
                }
                if (access.getModule().getInvokingName().equals(ProductAccess.ANALYSIS_PRODUCT_PRICE_LIST_EXPORT.getIdentifier())) {
                    return Words.ANALYSIS_PRODUCT_PRICE_LIST_EXPORT;
                }
                if (access.getModule().getInvokingName().equals(ProductAccess.ANALYSIS_PRODUCT_PRICE_LIST_DETAILED.getIdentifier())) {
                    return Words.ANALYSIS_PRODUCT_PRICE_LIST_DETAILED;
                }
                if (access.getModule().getInvokingName().equals(ProductAccess.ANALYSIS_PRODUCT_EXPORT.getIdentifier())) {
                    return Words.ANALYSIS_PRODUCT_EXPORT;
                }
                if (access.getModule().getInvokingName().equals(InvoiceAccess.ANALYSIS_INVOICE_MONTHLY_SUMMARY.getIdentifier())) {
                    return Words.ANALYSIS_INVOICE_MONTHLY_SUMMARY;
                }
                if (access.getModule().getInvokingName().equals(InvoiceAccess.ANALYSIS_INVOICE_SUMMARY.getIdentifier())) {
                    return Words.ANALYSIS_INVOICE_SUMMARY;
                }
                if (access.getModule().getInvokingName().equals(InvoiceAccess.ANALYSIS_INVOICE_EXPORT.getIdentifier())) {
                    return Words.ANALYSIS_INVOICE_EXPORT;
                }
                if (access.getModule().getInvokingName().equals(HandlingCostAccess.ANALYSIS_HANDLING_COSTS_EXPORT.getIdentifier())) {
                    return Words.ANALYSIS_HANDLING_COSTS_EXPORT;
                }
            } else if (CompanyUtil.isLSGFC((SystemSettingsComplete)settings)) {
                if (access.getModule().getInvokingName().equals(ARequisitionOrderAccess.PRINT_REQUISITION_DELIVER_SHEET.getIdentifier())) {
                    return Words.DELIVER_REQUISITION_WORKSHEET;
                }
                if (access.getModule().getInvokingName().equals(ARequisitionOrderAccess.PRINT_REQUISITION_RECEIVE_SHEET.getIdentifier())) {
                    return Words.RECEIVE_REQUISITION_WORKSHEET;
                }
            }
            return access.getModule().getDisplayName();
        };
        for (SubModuleAccessRightComplete subModuleAccessRightComplete : sentries) {
            if (!this.getAcceptedSubModuleTypes().contains(subModuleAccessRightComplete.getModule().getType())) continue;
            if (!this.entries.containsKey(subModuleAccessRightComplete.getModule().getType())) {
                this.entries.put(subModuleAccessRightComplete.getModule().getType(), new ArrayList());
            }
            if (this.containsElement(subModuleAccessRightComplete)) continue;
            Entry e = new Entry(this, subModuleAccessRightComplete, converter);
            this.entries.get(subModuleAccessRightComplete.getModule().getType()).add(e);
            this.contentPane.add(e);
        }
        for (List list : this.entries.values()) {
            Collections.sort(list, (o1, o2) -> o1.getScreenObject().getModule().getDisplayName().compareTo(o2.getScreenObject().getModule().getDisplayName()));
        }
        this.add(this.scrollPane);
        this.validate();
    }

    private boolean containsElement(SubModuleAccessRightComplete o) {
        for (List<Entry> e : this.entries.values()) {
            for (Entry entry : e) {
                SubModuleAccessRightComplete a = (SubModuleAccessRightComplete)entry.getUserObject();
                if (!a.getModule().getInvokingName().equals(o.getModule().getInvokingName())) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract List<SubModuleTypeE> getAcceptedSubModuleTypes();

    protected abstract Comparator<SubModuleTypeE> getSubModuleTypesComparator();

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        for (SubModuleTypeE type : this.entries.keySet()) {
            for (Entry e : this.entries.get(type)) {
                e.kill();
            }
        }
        this.entries.clear();
        this.entries = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    public int getPreferredScrollBarWidth() {
        if (this.scrollPane != null) {
            int vH;
            int aWidth = this.scrollPane.getWidth();
            if (Math.abs(this.getWidth() - aWidth) > 5) {
                aWidth = this.getWidth() - 4;
            }
            aWidth += 0;
            int preSize = this.preCalcViewPortHeight();
            if (preSize > (vH = this.scrollPane.getHeight())) {
                aWidth = (int)((double)aWidth - this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            }
            return aWidth;
        }
        return 0;
    }

    private int preCalcViewPortHeight() {
        int y = 0;
        for (Map.Entry<SubModuleTypeE, List<Entry>> e : this.entries.entrySet()) {
            y += e.getValue().size() * 30;
        }
        return y;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (SubModuleTypeE a : this.entries.keySet()) {
            for (Entry e : this.entries.get(a)) {
                e.setEnabled(enabled);
            }
        }
    }

    void loadScreen(SubModuleAccessRightComplete object, int x, int y, Component comp) {
        this.setEnabled(false);
        this.validate();
        this.screenLoader.loadScreen(object.getModule(), x, y, comp, this.batchList);
    }

    private class ContentLayout
    extends DefaultLayout {
        private ContentLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int aHeight = 30;
            int currentY = 0;
            int types = 0;
            for (SubModuleTypeE type : SmartScreenAccessPopupInsert.this.entries.keySet()) {
                if (types != 0 && types != SmartScreenAccessPopupInsert.this.entries.keySet().size()) {
                    HorizontalSeparator hs = new HorizontalSeparator();
                    hs.setVisible(true);
                    SmartScreenAccessPopupInsert.this.contentPane.add(hs);
                    hs.setLocation(0, currentY + 3);
                    hs.setSize(parent.getWidth(), (int)hs.getPreferredSize().getHeight());
                    currentY += 3 + hs.getHeight() + 3;
                }
                ++types;
                for (Entry entry : (List)SmartScreenAccessPopupInsert.this.entries.get(type)) {
                    entry.setLocation(0, currentY);
                    entry.setSize(SmartScreenAccessPopupInsert.this.getPreferredScrollBarWidth(), aHeight);
                    currentY += aHeight;
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 30;
            int aHeight = 0;
            for (SubModuleTypeE type : SmartScreenAccessPopupInsert.this.entries.keySet()) {
                aHeight += ((List)SmartScreenAccessPopupInsert.this.entries.get(type)).size() * h;
            }
            if (SmartScreenAccessPopupInsert.this.entries.keySet().size() > 1) {
                aHeight = (int)((double)aHeight + (double)(SmartScreenAccessPopupInsert.this.entries.keySet().size() - 1) * (3.0 + new HorizontalSeparator().getPreferredSize().getHeight() + 3.0));
            }
            Dimension d = new Dimension(200, aHeight);
            return d;
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container arg0) {
            SmartScreenAccessPopupInsert.this.scrollPane.setLocation(0, 0);
            SmartScreenAccessPopupInsert.this.scrollPane.setSize(arg0.getSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return SmartScreenAccessPopupInsert.this.scrollPane.getPreferredSize();
        }
    }
}

