/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class VerticalSeparator
extends JPanelKillable
implements LafListener {
    private static final long serialVersionUID = 1L;
    private Color separatorColor;
    private int customPrefHeight = 0;

    public VerticalSeparator() {
        this.lafAttributeChanged("All attribues changed");
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.separatorColor);
        if (this.getWidth() >= 2) {
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            g2.drawLine(0, 0, 0, this.getHeight());
        }
    }

    @Override
    public void setBackground(Color c) {
        this.separatorColor = c;
    }

    public void setPreferredHeight(int h) {
        this.customPrefHeight = h;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(1, this.customPrefHeight);
    }

    @Override
    public void lafAttributeChanged(String att) {
        if ("All attribues changed".equals(att)) {
            this.separatorColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_editor_default_separator_color"));
            this.repaint(32L);
        }
    }

    public void setSeparatorColor(Color s) {
        this.separatorColor = s;
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }
}

