/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.calendar;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.calendar.JobsView;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.CalendarView;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.TimeComponent;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.stock.StockUsage;
import ch.icit.pegasus.client.gui.utils.calendar.agenda.timecomponents.TaskTimeComponent;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.calculator.IQuantity;
import ch.icit.pegasus.server.core.calculator.IUnit;
import ch.icit.pegasus.server.core.calculator.UnitCalculator;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanLight_;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.DeliveryJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.DeliveryPreparationJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.RecipeProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.productiontargets.DeliveryProductionTargetComplete;
import ch.icit.pegasus.server.core.dtos.production_new.productiontargets.ProductProductionTargetComplete;
import ch.icit.pegasus.server.core.dtos.production_new.productiontargets.ProductionTargetComplete;
import ch.icit.pegasus.server.core.dtos.production_new.productiontargets.RecipeProductionTargetComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class WeeklyPlanView
extends DefaultPanel {
    private final RDProvider provider;
    private final JobsView jobsView;
    private final CalendarView calendarView;
    private ProductComplete treeSelectedProduct;
    private RecipeComplete treeSelectedRecipe;
    private CostCenterComplete filterDepartment;
    private CustomerLight filterCustomer;
    private Map<RecipeReference, QuantityComplete> recipeStartStock = new HashMap<RecipeReference, QuantityComplete>();
    private Map<ProductReference, QuantityComplete> productStartStock = new HashMap<ProductReference, QuantityComplete>();
    private Node<WeeklyPlanLight> node;
    private List<StockUsage> stockUsages = new ArrayList<StockUsage>();
    private Thread stockControllerThread;

    public WeeklyPlanView(RDProvider provider) {
        this.provider = provider;
        this.jobsView = new JobsView(provider);
        this.calendarView = new CalendarView(provider);
        this.calendarView.injectMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WeeklyPlanView.this.jobsView.getProductionTable().getModel().selectRow(null, false, false, 3);
                WeeklyPlanView.this.calendarView.removeStockPrediction();
            }
        });
        this.calendarView.setStockController(stockUsage -> this.stockUsages.add(stockUsage));
        this.jobsView.getProductionTable().getModel().addTableSelectionListener((sourceTable, panel) -> {
            ArrayList<Object> tTarget = new ArrayList<Object>();
            this.stockUsages.clear();
            if (panel != null) {
                Node node = panel.getModel().getNode();
                Iterator it = node.getChildNamed(new String[]{"items"}).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    tTarget.add(n.getValue());
                    if (n.getValue() instanceof RecipeProductionTargetComplete) {
                        this.treeSelectedRecipe = ((RecipeProductionTargetComplete)n.getValue()).getRecipe();
                        this.treeSelectedProduct = null;
                    }
                    if (!(n.getValue() instanceof ProductProductionTargetComplete)) continue;
                    this.treeSelectedProduct = ((ProductProductionTargetComplete)n.getValue()).getProduct();
                    this.treeSelectedRecipe = null;
                }
            }
            if (panel != null) {
                this.calendarView.highLightTasks(component -> {
                    for (ProductionTargetComplete target : tTarget) {
                        if (!this.isMatchingJob(target, component)) continue;
                        return true;
                    }
                    return false;
                });
                this.ensureStockUpdater();
            } else {
                this.stopStockUpdater();
                this.calendarView.highLightTasks(component -> true);
            }
            this.calendarView.revalidate();
            if (!tTarget.isEmpty()) {
                this.calendarView.updateStockEvent(item -> {
                    for (ProductionTargetComplete target : tTarget) {
                        if (!(item instanceof TaskTimeComponent)) continue;
                        TaskTimeComponent task = (TaskTimeComponent)item;
                        JobComplete job = (JobComplete)task.getNode().getValue();
                        if (!this.isMatchingJob(target, task) || !(target instanceof ProductionTargetComplete)) continue;
                        if (target instanceof RecipeProductionTargetComplete) {
                            if (job instanceof RecipeProductionJobComplete) {
                                return () -> new Tuple((Object)job.getJobSchedule(), (Object)new QuantityComplete(((RecipeProductionJobComplete)job).getQuantity()));
                            }
                            if (job instanceof ProductProductionJobComplete) {
                                return () -> {
                                    QuantityComplete recipeUsage = this.loadRecipeUsageForProductJob(((RecipeProductionTargetComplete)target).getRecipe(), (ProductProductionJobComplete)job);
                                    Tuple value = new Tuple((Object)job.getJobSchedule(), (Object)new QuantityComplete(Double.valueOf(-1.0 * recipeUsage.getQuantity()), recipeUsage.getUnit()));
                                    this.ensureRecipeStartStockExists(((RecipeProductionTargetComplete)target).getRecipe());
                                    return value;
                                };
                            }
                        }
                        if (!(target instanceof ProductProductionTargetComplete)) continue;
                        if (job instanceof ProductProductionJobComplete) {
                            return () -> new Tuple((Object)job.getJobSchedule(), (Object)new QuantityComplete(((ProductProductionJobComplete)job).getQuantity()));
                        }
                        if (!(job instanceof DeliveryPreparationJobComplete)) continue;
                        return () -> {
                            QuantityComplete productCount = this.loadProductUsageFromPreparationJob((ProductReference)((ProductProductionTargetComplete)target).getProduct(), (DeliveryPreparationJobComplete)job);
                            Tuple value = new Tuple((Object)job.getJobSchedule(), (Object)new QuantityComplete(Double.valueOf(-1.0 * productCount.getQuantity()), productCount.getUnit()));
                            this.ensureProductStartStockExists(((ProductProductionTargetComplete)target).getProduct());
                            return value;
                        };
                    }
                    return null;
                });
                this.calendarView.repaint(32L);
            }
        });
        this.setLayout(new Layout());
        this.add(this.jobsView);
        this.add(this.calendarView);
    }

    private void stopStockUpdater() {
    }

    private void ensureStockUpdater() {
        if (this.stockControllerThread == null) {
            this.stockControllerThread = new Thread(() -> {
                while (true) {
                    this.updateStock();
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            });
            this.stockControllerThread.start();
        }
    }

    private void ensureProductStartStockExists(ProductComplete product) {
        QuantityComplete quantity = this.productStartStock.get(product);
        if (quantity == null) {
            try {
                QuantityComplete actualStock = ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getProductStock(new ProductReference(product.getId()), new TimestampWrapper(new Timestamp(((Date)this.node.getChildNamed(new DtoField[]{WeeklyPlanLight_.period, PeriodComplete_.startDate}).getValue()).getTime())));
                this.productStartStock.put((ProductReference)product, actualStock);
            }
            catch (ClientServerCallException e) {
                e.printStackTrace();
            }
        }
    }

    private void ensureRecipeStartStockExists(RecipeComplete recipe) {
        QuantityComplete quantity = this.recipeStartStock.get(recipe);
        if (quantity == null) {
            try {
                QuantityComplete actualStock = ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getRecipeStock(new RecipeReference(recipe.getId()), new TimestampWrapper(new Timestamp(((Date)this.node.getChildNamed(new DtoField[]{WeeklyPlanLight_.period, PeriodComplete_.startDate}).getValue()).getTime())));
                this.recipeStartStock.put((RecipeReference)recipe, actualStock);
            }
            catch (ClientServerCallException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateStock() {
        QuantityComplete startStock = null;
        if (this.treeSelectedRecipe != null) {
            startStock = this.recipeStartStock.get(this.treeSelectedRecipe);
        }
        if (this.treeSelectedProduct != null) {
            startStock = this.productStartStock.get(this.productStartStock);
        }
        if (startStock != null) {
            startStock = new QuantityComplete(startStock);
            ArrayList<StockUsage> list = new ArrayList<StockUsage>(this.stockUsages);
            Collections.sort(list);
            QuantityComplete currentStock = new QuantityComplete(startStock);
            for (StockUsage stockUsage : list) {
                QuantityComplete usageQuantity = stockUsage.getQuantity();
                double factor = UnitCalculator.getConversionFactorForRecipe((IQuantity)usageQuantity, (IUnit)currentStock.getUnit());
                currentStock = new QuantityComplete(Double.valueOf(currentStock.getQuantity() + factor), currentStock.getUnit());
                QuantityComplete fCurrentStock = new QuantityComplete(currentStock);
                SwingUtilities.invokeLater(() -> stockUsage.setStock(fCurrentStock));
            }
        }
        SwingUtilities.invokeLater(() -> this.calendarView.revalidate());
    }

    private QuantityComplete loadProductUsageFromPreparationJob(ProductReference product, DeliveryPreparationJobComplete job) {
        Map map = null;
        try {
            map = ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getProductUsageForFlight((FlightReference)job.getFlight()).getMap();
        }
        catch (ClientServerCallException e) {
            e.printStackTrace();
        }
        Integer qty = (Integer)map.get(product);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        QuantityComplete newValue = new QuantityComplete(Double.valueOf(qty.doubleValue()), settings.getPieceUnit());
        return newValue;
    }

    private QuantityComplete loadRecipeUsageForProductJob(RecipeComplete recipe, ProductProductionJobComplete job) {
        Map map = null;
        try {
            map = ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getRecipeUsageForProduct(new ProductReference(job.getProduct().getId()), Integer.valueOf(job.getQuantity().getQuantity().intValue()), new TimestampWrapper(job.getJobSchedule())).getMap();
        }
        catch (ClientServerCallException e) {
            e.printStackTrace();
        }
        QuantityComplete qty = (QuantityComplete)map.get(recipe);
        QuantityComplete newValue = new QuantityComplete(qty);
        return newValue;
    }

    public void hideNotHighLightedTasks(boolean hideNotHighLightedTasks) {
        this.calendarView.setHideNotActiveTasks(hideNotHighLightedTasks);
        this.calendarView.revalidate();
    }

    private void updateFiltering() {
        this.calendarView.updateFiltering(component -> {
            if (this.filterCustomer == null && this.filterDepartment == null) {
                return false;
            }
            TaskTimeComponent comp = (TaskTimeComponent)component;
            if (this.filterCustomer != null) {
                for (ProductionTargetComplete target : ((JobComplete)comp.getNode().getValue()).getAssociatedTargets()) {
                    if (!this.filterCustomer.equals((Object)target.getCustomer()) && !this.filterCustomer.equals((Object)target.getFlight().getCustomer())) continue;
                    return false;
                }
            }
            if (this.filterDepartment != null) {
                for (ProductionTargetComplete target : ((JobComplete)comp.getNode().getValue()).getAssociatedTargets()) {
                    if (!this.filterDepartment.equals((Object)target.getDepartment())) continue;
                    return false;
                }
            }
            return true;
        });
        this.calendarView.revalidate();
    }

    private boolean isMatchingJob(ProductionTargetComplete target, TimeComponent component) {
        if (target == null) {
            return true;
        }
        if (component instanceof TaskTimeComponent) {
            Node<JobComplete> itemNode = ((TaskTimeComponent)component).getNode();
            JobComplete job = (JobComplete)itemNode.getValue();
            if (target instanceof ProductionTargetComplete) {
                if (target instanceof RecipeProductionTargetComplete) {
                    if (job instanceof RecipeProductionJobComplete && ((RecipeProductionJobComplete)job).getRecipe().equals((Object)((RecipeProductionTargetComplete)target).getRecipe())) {
                        return true;
                    }
                    if (job instanceof ProductProductionJobComplete && ((ProductProductionJobComplete)job).getProduct().equals((Object)((RecipeProductionTargetComplete)target).getProduct())) {
                        return true;
                    }
                }
                if (target instanceof ProductProductionTargetComplete) {
                    if (job instanceof RecipeProductionJobComplete && ((RecipeProductionJobComplete)job).getProduct().equals((Object)((ProductProductionTargetComplete)target).getProduct())) {
                        return true;
                    }
                    if (job instanceof ProductProductionJobComplete && ((ProductProductionJobComplete)job).getProduct().equals((Object)((ProductProductionTargetComplete)target).getProduct())) {
                        return true;
                    }
                }
                if (job instanceof DeliveryJobComplete && ((DeliveryJobComplete)job).getFlight().equals((Object)target.getFlight())) {
                    return true;
                }
            }
            if (target instanceof DeliveryProductionTargetComplete) {
                if (job instanceof DeliveryJobComplete && ((DeliveryJobComplete)job).getFlight().equals((Object)target.getFlight())) {
                    return true;
                }
                for (ProductionTargetComplete associatedTarget : job.getAssociatedTargets()) {
                    if (!associatedTarget.getFlight().equals((Object)target.getFlight())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public void setNode(Node<WeeklyPlanLight> node) {
        this.jobsView.setNode(node);
        this.node = node;
        Node<WeeklyPlanLight> n = node;
        this.calendarView.setNode(n);
    }

    public void filterByDepartment(CostCenterComplete department) {
        this.filterDepartment = department;
        this.jobsView.getProductionTable().filterByDepartment(department);
        this.updateFiltering();
    }

    public void filterByCustomer(CustomerLight customer) {
        this.filterCustomer = customer;
        this.jobsView.getProductionTable().filterByCustomer(customer);
        this.updateFiltering();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            int jobsWidth = 400;
            WeeklyPlanView.this.jobsView.setLocation(0, 0);
            WeeklyPlanView.this.jobsView.setSize(jobsWidth, h);
            WeeklyPlanView.this.calendarView.setLocation(jobsWidth, 0);
            WeeklyPlanView.this.calendarView.setSize(w - jobsWidth, h);
        }
    }
}

