/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.combobox.multiselection;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.prototypes.Skin3FieldButton_NEW;
import ch.icit.pegasus.client.gui.utils.combobox.CustomScrollBarUI;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.icons.impl.CheckBoxRO;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public abstract class MultiSelectionComboBox
extends Skin3FieldButton_NEW
implements LafListener,
ButtonListener,
InnerPopUpListener2,
AttributeListener,
NodeListener,
Validatable,
Nodable,
ItemSelectable {
    private static final long serialVersionUID = 1L;
    private static int minimalWidth = 0;
    private static int defaultInset;
    protected String id;
    private boolean noneChooseable = false;
    private InnerPopUp2 popUp;
    protected TextLabel valueLabel;
    private MCInset insert;
    private AWTEventListener listener;
    private boolean isInit = true;
    private static final int POPUP_STATE_CLOSED = 3;
    private static final int POPUP_STATE_OPENED = 5;
    private int popupState = 3;
    protected Object[] returnValues;
    private boolean isWritable = true;
    protected Node node;
    protected String allNodes;
    private boolean noneSelected = false;
    private Converter itemViewConverterOverview;
    private Converter itemViewConverterList;
    private Class sorterClass;
    private List<ItemListener> itemListeners;

    public MultiSelectionComboBox(String allNodes, Converter c, Converter cl, Class sorterClass) {
        super(DefaultSkins.ComboBoxTexture, true);
        this.sorterClass = sorterClass;
        this.allNodes = allNodes;
        this.itemViewConverterOverview = c;
        this.itemViewConverterList = cl;
        this.itemListeners = new ArrayList<ItemListener>();
        this.setLayout(new Layout());
        this.valueLabel = new TextLabel();
        this.addButtonListener(this);
        this.deactivateKeyListener();
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.add(this.valueLabel);
        this.isInit = false;
        this.createLabelText();
        this.registerKeyEvents();
    }

    public MultiSelectionComboBox(Node node, String allNodes, Converter c, Converter cl, Class sorterClass) {
        this(allNodes, c, cl, sorterClass);
        this.setNode(node);
    }

    public void setWritable(boolean b) {
        this.isWritable = b;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.valueLabel.setEnabled(isEnabled);
    }

    public boolean isSwingOnly() {
        return true;
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }

    public boolean isInnerComponent(Component c) {
        if (c.equals(this)) {
            return true;
        }
        return this.insert != null && this.insert.isInnerComponent(c);
    }

    @Override
    public void setValid() {
        if (this.hasFocus()) {
            this.changeState(Button.ButtonState.STATE_SELECTED);
        } else if (this.isOver) {
            this.changeState(Button.ButtonState.OVER);
        } else {
            this.changeState(Button.ButtonState.UP);
        }
    }

    @Override
    public void setInvalid() {
        this.changeState(Button.ButtonState.ERROR);
    }

    @Override
    public void setWarning() {
        this.changeState(Button.ButtonState.ERROR);
    }

    public void setNode(Node newNode) {
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = newNode;
        if (this.node != null) {
            this.node.addNodeListener((NodeListener)this);
            this.createLabelText();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        this.registerKeyEvents();
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        if (this.popUp == null) {
            this.deregisterKeyEvents();
        }
    }

    private void downPressed() {
        if (this.popupState == 3) {
            this.buttonPressed(this, 0, 0);
        } else {
            this.insert.selectLower();
        }
    }

    private void upPressed() {
        if (this.popupState == 3) {
            this.buttonPressed(this, 0, 0);
        } else {
            this.insert.selectUpper();
        }
    }

    private void enterPressed() {
        this.popUp.hidePopUp(new Object[0]);
        this.requestFocusInWindow();
    }

    private void registerKeyEvents() {
        this.listener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                KeyEvent ke;
                if (event instanceof KeyEvent && (MultiSelectionComboBox.this.state == Button.ButtonState.FOCUS || MultiSelectionComboBox.this.state == Button.ButtonState.STATE_SELECTED) && (ke = (KeyEvent)event).getID() == 401) {
                    if (ke.getKeyCode() == 40) {
                        MultiSelectionComboBox.this.downPressed();
                        ke.consume();
                    } else if (ke.getKeyCode() == 38) {
                        MultiSelectionComboBox.this.upPressed();
                        ke.consume();
                    } else if (ke.getKeyCode() == 10 && MultiSelectionComboBox.this.popUp != null) {
                        MultiSelectionComboBox.this.enterPressed();
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 8L);
    }

    private void deregisterKeyEvents() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(minimalWidth, ((Skin3Field)this.getSkin()).getImageLeft(this.state).getHeight());
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.valueLabel.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        if (this.popUp != null) {
            this.popUp.kill();
            this.popUp = null;
        }
        this.valueLabel.kill();
        this.valueLabel = null;
        this.deregisterKeyEvents();
    }

    protected void createLabelText() {
        if (!this.isInit && this.valueLabel != null) {
            this.valueLabel.setText(this.createShownString(this.node));
            this.valueLabel.invalidate();
        }
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (this.popUp == null) {
            this.popUp = InnerPopUp2.getInnerPopUp();
            this.popUp.setAttributes(null, false, false, "");
            this.insert = new MCInset(this.createSelectableList(), this.node, this.isWritable);
            this.popUp.setView(this.insert);
            this.popUp.showPopUp(2, 0, this.getWidth() - 4, -1, this, this, PopupType.COMBO);
            this.popupState = 5;
        }
    }

    public Node<?> createSelectableList() {
        return NodeToolkit.getAffixNamed((String)this.allNodes);
    }

    @Override
    protected void changeState(Button.ButtonState newState) {
        if (this.popUp != null) {
            this.setState(Button.ButtonState.FOCUS);
        } else {
            super.changeState(newState);
        }
    }

    public boolean isObjectSelected(Object dto, Node selected) {
        if (selected != null) {
            Iterator it = selected.getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (!n.getValue().equals(dto)) continue;
                return true;
            }
        }
        return false;
    }

    public void selectAll() {
        ArrayList<Object> objects = new ArrayList<Object>();
        Iterator it = this.createSelectableList().getChilds();
        if (it.hasNext()) {
            while (it.hasNext()) {
                Node n = (Node)it.next();
                Object o = n.getValue();
                objects.add(o);
            }
        }
        if (this.noneChooseable) {
            this.noneSelected = true;
        }
        this.returnValues = objects.toArray();
        this.stateChanged(this.returnValues);
        this.popUpClosed(null, new Object[0]);
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        this.deregisterKeyEvents();
        Object[] selectedClasses = this.returnValues;
        this.isInit = true;
        this.ensureNode(selectedClasses);
        this.isInit = false;
        this.createLabelText();
        this.popUp = null;
        this.popupState = 3;
        this.ensureComponentState();
    }

    private void ensureComponentState() {
        if (!this.isOver) {
            if (this.hasFocus()) {
                this.setState(Button.ButtonState.FOCUS);
            } else {
                this.setState(Button.ButtonState.UP);
            }
        } else if (this.hasFocus()) {
            this.setState(Button.ButtonState.FOCUS);
        } else if (this.isDown) {
            this.setState(Button.ButtonState.DOWN);
        } else {
            this.setState(Button.ButtonState.OVER);
        }
    }

    public void ensureNode(Object[] selectedEntries) {
        long currentID = System.currentTimeMillis();
        if (selectedEntries == null) {
            return;
        }
        for (int i = 0; i < selectedEntries.length; ++i) {
            if (this.hasNode4Object(selectedEntries[i])) continue;
            Node l = INodeCreator.getDefaultImpl().getNode4DTO(selectedEntries[i], true, true);
            l.setValue(selectedEntries[i], 0L);
            this.node.addChild(l, currentID);
        }
        Iterator it = this.node.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (!this.isNodeOrphan(selectedEntries, n.getValue())) continue;
            this.node.removeChild(n, currentID);
        }
    }

    private boolean isNodeOrphan(Object[] selectedEntries, Object searched) {
        for (Object o : selectedEntries) {
            if (!o.equals(searched)) continue;
            return false;
        }
        return true;
    }

    private boolean hasNode4Object(Object dto) {
        Iterator it = this.node.getChilds();
        while (it.hasNext()) {
            Node d = (Node)it.next();
            if (!d.getValue().equals(dto)) continue;
            return true;
        }
        return false;
    }

    public void childAdded(Node<?> source, Node<?> child) {
        if (source == this.node) {
            this.createLabelText();
        }
    }

    public void childRemoved(Node<?> source, Node<?> child) {
        if (source == this.node) {
            this.createLabelText();
        }
    }

    public void valueChanged(Node<?> node) {
    }

    @Override
    public void attributeChanged(String attributeName) {
        minimalWidth = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("minimal_combo_width"));
        defaultInset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("combobox_default_inset"));
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    protected String createShownString(Node ccL) {
        String t = "";
        if (ccL != null) {
            Iterator it = ccL.getChilds();
            ArrayList<String> list = new ArrayList<String>();
            while (it.hasNext()) {
                Node d = (Node)it.next();
                list.add((String)this.itemViewConverterOverview.convert(d.getValue(), d, new Object[]{null}));
            }
            if (this.sorterClass != null) {
                Collections.sort(list, ComparatorRegistry.getComparator((Class)this.sorterClass));
            }
            for (String str : list) {
                t = t + str + ", ";
            }
            if (t.length() >= 2) {
                t = t.substring(0, t.length() - 2);
            }
        }
        if (this.isNoneChooseable() && this.isNoneSelected()) {
            if ("".equals(t)) {
                return WordsToolkit.toCapitalLetter((String)Words.NONE);
            }
            t = t + ", " + WordsToolkit.toCapitalLetter((String)Words.NONE);
        }
        return t;
    }

    public String createShownString(List ccL) {
        String t = "";
        Iterator it = ccL.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            Object d = it.next();
            list.add((String)this.itemViewConverterOverview.convert(d, null, new Object[]{null}));
        }
        Collections.sort(list, ComparatorRegistry.getComparator((Class)this.sorterClass));
        for (String str : list) {
            t = t + str + ", ";
        }
        if (t.length() >= 2) {
            t = t.substring(0, t.length() - 2);
        }
        return t;
    }

    protected void stateChanged(Object[] returnValues) {
        for (ItemListener l : this.itemListeners) {
            l.itemStateChanged(new ItemEvent(this, 0, this, 1));
        }
    }

    @Override
    public void setPermanent(boolean isPermantent) {
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.returnValues;
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.itemListeners.add(l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.itemListeners.remove(l);
    }

    public boolean isNoneChooseable() {
        return this.noneChooseable;
    }

    public void setNoneChooseable(boolean noneChooseable) {
        this.noneChooseable = noneChooseable;
    }

    public boolean isNoneSelected() {
        return this.noneSelected;
    }

    public void setNoneSelected(boolean noneSelected) {
        this.noneSelected = noneSelected;
    }

    private class MCInset
    extends PopUpInsert
    implements VisibleContainer {
        private static final long serialVersionUID = 1L;
        private Comparator<TitledItem> itemsComparator = new Comparator<TitledItem>(){

            @Override
            public int compare(TitledItem o1, TitledItem o2) {
                return o1.getTitle().getText().compareTo(o2.getTitle().getText());
            }
        };
        private List<TitledItem> childs = new ArrayList<TitledItem>();
        private JScrollPane scrollPane;
        private JPanel viewPort;
        private int minHeight = 100;
        private int hGap = 16;
        private boolean isWritable = true;

        public MCInset(Node allList, Node node, boolean isWritables) {
            this.isWritable = isWritables;
            this.setOpaque(false);
            this.setLayout(new MCSLayout());
            this.scrollPane = new JScrollPane();
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.scrollPane.getHorizontalScrollBar().setUI(new CustomScrollBarUI(0));
            this.scrollPane.getVerticalScrollBar().setUI(new CustomScrollBarUI(1));
            this.scrollPane.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.scrollPane.getHorizontalScrollBar().setBackground(this.scrollPane.getBackground());
            this.scrollPane.getVerticalScrollBar().setBackground(this.scrollPane.getBackground());
            this.viewPort = new JPanel();
            this.viewPort.setBackground(this.scrollPane.getBackground());
            this.viewPort.setLayout(new MCLayout());
            this.scrollPane.setViewportView(this.viewPort);
            this.add(this.scrollPane);
            this.generateContent(allList, node);
        }

        @Override
        public void popupClosed() {
            super.popupClosed();
            MultiSelectionComboBox.this.returnValues = this.getValues(PopupAction.OK_FOREGROUND);
            MultiSelectionComboBox.this.stateChanged(MultiSelectionComboBox.this.returnValues);
        }

        protected void selectLower() {
            boolean found = false;
            for (TitledItem tic : this.childs) {
                if (((CheckBox)tic.getElement()).hasFocus()) {
                    found = true;
                    continue;
                }
                if (!found) continue;
                ((CheckBox)tic.getElement()).requestFocusInWindow();
                return;
            }
        }

        protected void selectUpper() {
            boolean found = false;
            int count = 0;
            for (TitledItem tic : this.childs) {
                if (((CheckBox)tic.getElement()).hasFocus()) {
                    found = true;
                    if (count > 0) {
                        ((Component)this.childs.get(count - 1).getElement()).requestFocusInWindow();
                        return;
                    }
                }
                ++count;
            }
        }

        private void generateContent(Node ccList, Node selected) {
            if (ccList == null) {
                return;
            }
            Iterator it = ccList.getChilds();
            int count = 1;
            if (it.hasNext()) {
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    TitledItem<JPanelFadable> box = null;
                    if (this.isWritable) {
                        box = new TitledItem<CheckBox>(new CheckBox(), (String)MultiSelectionComboBox.this.itemViewConverterList.convert(n.getValue(), n, new Object[0]), TitledItem.TitledItemOrientation.EAST);
                        box.setVisibleContainer(this);
                        box.setInnerGap(10);
                        ((CheckBox)box.getElement()).setUserObject(n.getValue());
                        ((CheckBox)box.getElement()).setChecked(MultiSelectionComboBox.this.isObjectSelected(n.getValue(), selected));
                        box.setTitleShouldDelegateMouseEvents(true);
                    } else {
                        box = new TitledItem<CheckBoxRO>(new CheckBoxRO(), (String)MultiSelectionComboBox.this.itemViewConverterList.convert(n.getValue(), n, new Object[0]), TitledItem.TitledItemOrientation.EAST);
                        box.setVisibleContainer(this);
                        box.setInnerGap(10);
                        ((CheckBoxRO)box.getElement()).setUserObject(n.getValue());
                        ((CheckBoxRO)box.getElement()).setChecked(MultiSelectionComboBox.this.isObjectSelected(n.getValue(), selected));
                        box.setTitleShouldDelegateMouseEvents(true);
                    }
                    this.childs.add(box);
                    this.viewPort.add(box);
                }
                if (MultiSelectionComboBox.this.sorterClass != null) {
                    Collections.sort(this.childs, ComparatorRegistry.getComparator((Class)MultiSelectionComboBox.this.sorterClass));
                } else {
                    Collections.sort(this.childs, this.itemsComparator);
                }
            }
            if (MultiSelectionComboBox.this.isNoneChooseable()) {
                TitledItem<CheckBox> box = new TitledItem<CheckBox>(new CheckBox(), "None", TitledItem.TitledItemOrientation.EAST);
                box.setVisibleContainer(this);
                box.setInnerGap(10);
                box.getElement().setChecked(MultiSelectionComboBox.this.isNoneSelected());
                box.setTitleShouldDelegateMouseEvents(true);
                this.childs.add(box);
                this.viewPort.add(box);
                ++count;
            }
        }

        @Override
        public Object[] getValues(PopupAction isOK) {
            boolean noneFound = false;
            if (isOK == PopupAction.CANCEL) {
                return null;
            }
            ArrayList<Object> l = new ArrayList<Object>();
            for (TitledItem cc : this.childs) {
                Object object;
                if (cc.getElement() instanceof CheckBox) {
                    if (!((CheckBox)cc.getElement()).isChecked()) continue;
                    if (((CheckBox)cc.getElement()).getUserObject() == null && cc.getTitle().getText().equals("None")) {
                        noneFound = true;
                        continue;
                    }
                    object = ((CheckBox)cc.getElement()).getUserObject();
                    l.add(object);
                    continue;
                }
                if (!(cc.getElement() instanceof CheckBoxRO) || !((CheckBoxRO)cc.getElement()).isChecked()) continue;
                object = ((CheckBoxRO)cc.getElement()).getUserObject();
                l.add(object);
            }
            if (noneFound && MultiSelectionComboBox.this.isNoneChooseable()) {
                MultiSelectionComboBox.this.setNoneSelected(true);
            } else if (MultiSelectionComboBox.this.isNoneChooseable()) {
                MultiSelectionComboBox.this.setNoneSelected(false);
            }
            return l.toArray();
        }

        @Override
        public boolean tryToGrabFocus() {
            if (this.childs.isEmpty()) {
                return false;
            }
            ((Component)this.childs.get(0).getElement()).requestFocusInWindow();
            return true;
        }

        @Override
        public boolean isInnerComponent(Component c) {
            Component cc = c;
            while (cc.getParent() != null) {
                if (cc.equals(this)) {
                    return true;
                }
                cc = cc.getParent();
            }
            return cc.equals(this);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            for (TitledItem cc : this.childs) {
                a.add((Component)cc.getElement());
            }
            return a;
        }

        @Override
        public boolean isClosableWithEnter() {
            return false;
        }

        @Override
        public void scrollTo(Focusable f) {
            if (f instanceof Component) {
                int i = (int)((double)this.scrollPane.getVerticalScrollBar().getValue() + this.scrollPane.getViewport().getBounds().getHeight());
                Point p = SwingUtilities.convertPoint((Component)((Object)f), ((Component)((Object)f)).getX(), ((Component)((Object)f)).getY(), this.viewPort);
                int y = (int)(p.getY() - 40.0);
                if (y < this.scrollPane.getVerticalScrollBar().getValue()) {
                    this.scrollPane.getVerticalScrollBar().setValue(y);
                    return;
                }
                y = (int)p.getY() + 40;
                if (y > i) {
                    int dif = y - i;
                    dif += 40;
                    dif = this.scrollPane.getVerticalScrollBar().getValue() + dif;
                    this.scrollPane.getVerticalScrollBar().setValue(dif);
                    return;
                }
            }
        }

        private class MCSLayout
        extends DefaultLayout {
            private MCSLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                MCInset.this.scrollPane.setLocation(0, 0);
                MCInset.this.scrollPane.setSize(parent.getWidth(), parent.getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int w = (int)MCInset.this.viewPort.getPreferredSize().getWidth();
                int h = MCInset.this.minHeight;
                return new Dimension(w, h);
            }
        }

        private class MCLayout
        extends DefaultLayout {
            private MCLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentY = 5;
                for (TitledItem t : MCInset.this.childs) {
                    t.setLocation(0, currentY);
                    t.setSize(parent.getWidth(), (int)t.getPreferredSize().getHeight());
                    currentY += t.getHeight();
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int currentY = 5;
                int maxWidth = 0;
                for (TitledItem t : MCInset.this.childs) {
                    currentY = (int)((double)currentY + t.getPreferredSize().getHeight());
                    if (!((double)maxWidth < t.getPreferredSize().getWidth())) continue;
                    maxWidth = (int)t.getPreferredSize().getWidth();
                }
                return new Dimension(maxWidth, currentY += 5);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            MultiSelectionComboBox.this.valueLabel.setLocation(((Skin3Field)MultiSelectionComboBox.this.getSkin()).getImageLeft(Button.ButtonState.DISABLED).getWidth() + defaultInset, (int)(((double)parent.getHeight() - MultiSelectionComboBox.this.valueLabel.getPreferredSize().getHeight()) / 2.0));
            MultiSelectionComboBox.this.valueLabel.setSize(parent.getWidth() - (((Skin3Field)MultiSelectionComboBox.this.getSkin()).getImageRight(Button.ButtonState.DISABLED).getWidth() + ((Skin3Field)MultiSelectionComboBox.this.getSkin()).getImageLeft(Button.ButtonState.DISABLED).getWidth() + 2 * defaultInset), (int)MultiSelectionComboBox.this.valueLabel.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(minimalWidth, ((Skin3Field)MultiSelectionComboBox.this.getSkin()).getImageLeft(Button.ButtonState.UP).getHeight());
        }
    }
}

