/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.combobox.multiselection;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;

public class MultiSelectionPanel<T extends MultiSelectionComboBox>
extends JPanelKillable
implements ButtonListener,
ItemListener,
ItemSelectable,
UIStateLoadable,
Focusable,
MutableFocusContainer {
    private static final long serialVersionUID = 1L;
    private static String ISSET = "isset";
    private static String ISNOTSET = "isnotset";
    private CheckBox checkbox;
    private T combobox;
    private List<ItemListener> itemListeners = new ArrayList<ItemListener>();
    private String id;
    private boolean shouldPersist;
    private VisibleContainer pane;
    private List<MutableFocusContainerListener> listeners = new ArrayList<MutableFocusContainerListener>();

    public MultiSelectionPanel(T combo) {
        this.setOpaque(false);
        this.combobox = combo;
        ((MultiSelectionComboBox)this.combobox).addItemListener(this);
        this.checkbox = new CheckBox();
        this.checkbox.addButtonListener(this);
        this.setLayout(new Layout());
        this.add((Component)this.combobox, "Center");
        this.add((Component)this.checkbox, "West");
    }

    public void setID(String id) {
        this.id = id;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.itemListeners.clear();
        this.itemListeners = null;
        this.listeners.clear();
        this.listeners = null;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setProgress(float f) {
        ((JPanelFadable)this.combobox).setProgress(f);
        this.checkbox.setProgress(f);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkbox.setEnabled(enabled);
        if (this.checkbox.isChecked()) {
            ((MultiSelectionComboBox)this.combobox).setEnabled(true);
        } else {
            ((MultiSelectionComboBox)this.combobox).setEnabled(false);
        }
        this.revalidate();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> items = new ArrayList<Component>();
        CheckedListAdder.addToList(items, this.checkbox);
        CheckedListAdder.addToList(items, this.combobox);
        return items;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.pane = pane;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.checkbox.requestFocusInWindow();
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.listeners.remove(listener);
    }

    private void filreFocusCycleEvent() {
        this.listeners.forEach(mutableFocusContainerListener -> mutableFocusContainerListener.focusCycleChanged(this));
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.checkbox) {
            for (ItemListener itemListener : this.itemListeners) {
                itemListener.itemStateChanged(new ItemEvent(this, 0, this.checkbox.isChecked(), 1));
            }
            this.setEnabled(this.isEnabled());
            ((MultiSelectionComboBox)this.combobox).stateChanged(this.getSelectedObjects());
            this.filreFocusCycleEvent();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.combobox) {
            for (ItemListener itemListener : this.itemListeners) {
                itemListener.itemStateChanged(new ItemEvent(this, 0, this.getSelectedObjects(), 1));
            }
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.checkbox.isChecked()) {
            return ((MultiSelectionComboBox)this.combobox).getSelectedObjects();
        }
        return new Object[0];
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.itemListeners.remove(l);
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.itemListeners.add(l);
    }

    @Override
    public String getPersistString() {
        String persString = "";
        String combo = "";
        if (this.combobox instanceof UIStateLoadable) {
            combo = ((UIStateLoadable)this.combobox).getPersistString();
        }
        persString = this.checkbox.isChecked() ? combo + ";" + ISSET : combo + ";" + ISNOTSET;
        return persString;
    }

    @Override
    public void loadState(String state, String id) {
        if (state != null && !state.isEmpty()) {
            String[] split = state.split(";");
            if (this.combobox instanceof UIStateLoadable) {
                ((UIStateLoadable)this.combobox).loadState(split[0], null);
            }
            if (split[1].equals(ISSET)) {
                this.checkbox.setChecked(true);
                this.buttonPressed(this.checkbox, 0, 0);
            } else if (split[1].equals(ISNOTSET)) {
                this.checkbox.setChecked(false);
                this.buttonPressed(this.checkbox, 0, 0);
            }
        }
    }

    @Override
    public boolean shouldPersist() {
        return this.shouldPersist;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
        this.shouldPersist = isPersisting;
        if (this.combobox instanceof UIStateLoadable) {
            ((UIStateLoadable)this.combobox).setShouldPersist(isPersisting);
        }
    }

    public boolean isActivated() {
        return this.checkbox.isChecked();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            MultiSelectionPanel.this.checkbox;
            return new Dimension((int)((double)CheckBox.getPreferredWidth() + MultiSelectionPanel.this.combobox.getPreferredSize().getWidth() + 5.0), (int)MultiSelectionPanel.this.combobox.getPreferredSize().getHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            MultiSelectionPanel.this.checkbox.setLocation(0, (parent.getHeight() - ((MultiSelectionPanel)MultiSelectionPanel.this).checkbox.getPreferredSize().height) / 2);
            MultiSelectionPanel.this.checkbox.setSize(MultiSelectionPanel.this.checkbox.getPreferredSize());
            MultiSelectionPanel.this.combobox.setLocation(MultiSelectionPanel.this.checkbox.getX() + MultiSelectionPanel.this.checkbox.getWidth() + 5, (parent.getHeight() - ((MultiSelectionPanel)MultiSelectionPanel.this).combobox.getPreferredSize().height) / 2);
            MultiSelectionPanel.this.combobox.setSize(MultiSelectionPanel.this.combobox.getPreferredSize());
        }
    }
}

