/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.animators.AnimationProvider;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class AsynchronLoaderAnimation
extends Button
implements ImageConsumer,
LafListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static BufferedImage[] imageArray;
    private int currentIndex = 0;
    private boolean stopRequested = false;

    public AsynchronLoaderAnimation() {
        super(false);
        this.setOpaque(false);
        this.lafAttributeChanged(null);
    }

    public static int getPreferredWidth() {
        AsynchronLoaderAnimation.ensureImages();
        return imageArray[0].getWidth();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        BufferedImage i = imageArray[this.currentIndex];
        g2.drawImage(i, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), null);
        this.paintChildren(g2);
    }

    public void startAnimation() {
        if (this.stopRequested) {
            this.stopRequested = false;
        } else {
            AnimationProvider.registerAnimater(this);
            this.fadeIn();
        }
    }

    public void stopAnimation() {
        this.stopRequested = true;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(imageArray[0].getWidth(), imageArray[0].getHeight());
    }

    private static void ensureImages() {
        if (imageArray != null) {
            return;
        }
        String path = LafLoader.getLafLoader().getAttribute("asynchronloader_image_path");
        Integer lastImg = AttributesConverter.getInteger4String(LafLoader.getLafLoader().getAttribute("asynchronloader_image_end"));
        String preFix = LafLoader.getLafLoader().getAttribute("asynchronloader_image_prefix");
        String postFix = LafLoader.getLafLoader().getAttribute("asynchronloader_image_postfix");
        imageArray = new BufferedImage[lastImg.intValue()];
        String maxLength = "" + lastImg;
        for (int i = 1; i <= lastImg; ++i) {
            String nr = "" + i;
            while (nr.length() != maxLength.length()) {
                nr = "0" + nr;
            }
            String f2load = path + preFix + nr + postFix;
            AsynchronLoaderAnimation.imageArray[i - 1] = AttributesConverter.getBufferedImage4String(f2load);
        }
    }

    @Override
    public void loadImages() {
        AsynchronLoaderAnimation.ensureImages();
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.stopRequested) {
            this.stopRequested = false;
            AnimationProvider.deregisterAnimater(this);
            if (this.getFader() != null) {
                this.fadeOut(false);
            }
        }
        ++this.currentIndex;
        if (this.currentIndex > imageArray.length - 1) {
            this.currentIndex = 1;
        }
        this.repaint(32L);
    }

    @Override
    public void clearImages() {
        this.loadImages();
    }
}

