/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PaxLegTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private List<Node<SeatConfigurationComplete>> clazzes;
    private List<Node<? extends ALegComplete>> legs;
    private Map<FlightScheduleLegComplete, Map<CabinClassComplete, Integer>> map;

    public PaxLegTable(List<Node<SeatConfigurationComplete>> clazzes, List<Node<? extends ALegComplete>> legs, Map<FlightScheduleLegComplete, Map<CabinClassComplete, Integer>> map) {
        super(false, "", true, false);
        this.map = map;
        this.clazzes = clazzes;
        this.legs = legs;
        this.setDontUseScrollBar(15);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("CLASS", null, null, null, "", 80, 80, 80));
        int count = 1;
        for (Node<? extends ALegComplete> leg : legs) {
            String t = "LEG " + count + " (" + ((ALegComplete)leg.getValue()).getDepartureAirport().getCode() + " - " + ((ALegComplete)leg.getValue()).getArrivalAirport().getCode() + ")";
            columns.add(new TableColumnInfo(t, null, null, null, "", 30, 30, 30));
            ++count;
        }
        double factor = 0.0;
        if (!legs.isEmpty()) {
            factor = 1.0 / (double)legs.size();
        }
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        for (int i = 1; i < columns.size(); ++i) {
            ((TableColumnInfo)columns.get(i)).setxExpand(factor);
        }
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.model.setNode(this.createNodes(clazzes, legs));
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        int c = 0;
        for (TableColumnInfo i : this.getModel().getColumns()) {
            for (Table2RowPanel p : this.getRows()) {
                TableRowImpl pp = (TableRowImpl)p;
                a.addAll(pp.getFocusComponentsAt(c));
            }
            ++c;
        }
        return a;
    }

    public boolean validateMaxPax() {
        boolean isValid = true;
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (pp.validateMaxPax()) continue;
            isValid = false;
        }
        return isValid;
    }

    public List<ScreenValidationObject> validatePaxTable() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        ArrayList<Integer> legPaxCounts = new ArrayList<Integer>();
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl row = (TableRowImpl)p;
            int i = 0;
            for (PaxEdit cell : row.getFields()) {
                Integer legPaxCount;
                if (i >= legPaxCounts.size()) {
                    legPaxCount = 0;
                    legPaxCounts.add(legPaxCount);
                } else {
                    legPaxCount = (Integer)legPaxCounts.get(i);
                }
                legPaxCount = legPaxCount + cell.getPaxCount();
                legPaxCounts.set(i, legPaxCount);
                ++i;
            }
        }
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        for (Integer legPaxCount : legPaxCounts) {
            if (legPaxCount <= s.getMaxNumPax()) continue;
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Entered Pax count is bigger than the Max Pax count (" + s.getMaxNumPax() + ") for a Leg. "));
        }
        if (!this.validateMaxPax()) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Pax Count is smaller than Max Pax Count"));
        }
        return a;
    }

    private Node<?> createNodes(List<Node<SeatConfigurationComplete>> clazzes, List<Node<? extends ALegComplete>> legs) {
        ViewNode rootNode = new ViewNode("");
        for (Node<SeatConfigurationComplete> c : clazzes) {
            ViewNode row = new ViewNode("");
            row.addChild(c, 0L);
            for (Node<? extends ALegComplete> n : legs) {
                row.addChild(n, 0L);
            }
            rootNode.addChild((Node)row, 0L);
        }
        return rootNode;
    }

    public Map<? extends ALegComplete, Map<CabinClassComplete, Integer>> getMap() {
        HashMap ret = new HashMap();
        int count = 0;
        for (Node<? extends ALegComplete> l : this.legs) {
            ALegComplete ll = (ALegComplete)l.getValue();
            HashMap<CabinClassComplete, Integer> scm = (HashMap<CabinClassComplete, Integer>)ret.get(ll);
            if (scm == null) {
                scm = new HashMap<CabinClassComplete, Integer>();
                ret.put(ll, scm);
            }
            for (Table2RowPanel p : this.getRows()) {
                TableRowImpl i = (TableRowImpl)p;
                CabinClassComplete cc = i.getCabinClass();
                Integer c = i.getNumber(count);
                scm.put(cc, c);
            }
            ++count;
        }
        return ret;
    }

    private class PaxEdit
    extends JPanelKillable
    implements Focusable {
        private TextField enterField;
        private TextLabel maxCount;

        public PaxEdit(TextField enterField, TextLabel maxCount) {
            this.enterField = enterField;
            this.maxCount = maxCount;
            this.setOpaque(false);
            this.setLayout(new Layout2());
            this.add(this.enterField);
            this.add(this.maxCount);
        }

        public void setInvalid() {
            this.enterField.setInvalid();
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.enterField.getFocusComponents();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
        }

        public int getPaxCount() {
            String t = this.enterField.getText();
            int i = 0;
            try {
                i = Integer.valueOf(t);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return i;
        }

        public int getMaxCount() {
            String t = this.maxCount.getText().substring(1, this.maxCount.getText().length());
            int i = 0;
            try {
                i = Integer.valueOf(t);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            return i;
        }

        @Override
        public Selectable getSelectDelegationComponent() {
            return null;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.enterField.requestFocusInWindowNow();
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.enterField.kill();
            this.maxCount.kill();
            this.enterField = null;
            this.maxCount = null;
        }

        private class Layout2
        extends DefaultLayout {
            private Layout2() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return PaxEdit.this.enterField.getPreferredSize();
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = (int)PaxEdit.this.maxCount.getPreferredSize().getWidth();
                PaxEdit.this.enterField.setLocation(0, (int)(((double)parent.getHeight() - PaxEdit.this.enterField.getPreferredSize().getHeight()) / 2.0));
                PaxEdit.this.enterField.setSize(parent.getWidth() - (w + 3), (int)PaxEdit.this.enterField.getPreferredSize().getHeight());
                PaxEdit.this.maxCount.setLocation(PaxEdit.this.enterField.getX() + PaxEdit.this.enterField.getWidth() + 3, (int)(((double)parent.getHeight() - PaxEdit.this.maxCount.getPreferredSize().getHeight()) / 2.0));
                PaxEdit.this.maxCount.setSize(parent.getWidth() - PaxEdit.this.maxCount.getX(), (int)PaxEdit.this.maxCount.getPreferredSize().getHeight());
            }
        }
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel cabinClass;
        private List<PaxEdit> paxes;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.paxes = new ArrayList<PaxEdit>();
            this.setLayout(new Layout());
            int maxCount = 0;
            Iterator it = m.getNode().getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (n.getValue() instanceof SeatConfigurationComplete) {
                    this.cabinClass = new TextLabel(n.getChildNamed(SeatConfigurationComplete_.cabinClass), ConverterRegistry.getConverter(CabinClassConverter.class));
                    maxCount = (Integer)n.getChildNamed(SeatConfigurationComplete_.number).getValue();
                    this.add(this.cabinClass);
                    continue;
                }
                NumberTextField f = new NumberTextField(TextFieldType.INT);
                f.setUserObject(n);
                Integer i = maxCount;
                if (PaxLegTable.this.map != null) {
                    Map o = (Map)PaxLegTable.this.map.get(n.getValue());
                    i = (Integer)o.get(this.cabinClass.getNode().getValue());
                }
                if (i == null) {
                    i = maxCount;
                }
                f.setText("" + i);
                TextLabel l = new TextLabel("/" + maxCount);
                PaxEdit p = new PaxEdit(f, l);
                this.paxes.add(p);
                this.add(p);
            }
        }

        public List<PaxEdit> getFields() {
            return this.paxes;
        }

        public int getPaxCount() {
            int i = 0;
            for (PaxEdit pe : this.paxes) {
                i += pe.getPaxCount();
            }
            return i;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            for (PaxEdit f : this.paxes) {
                CheckedListAdder.addToList(a, f);
            }
            return a;
        }

        public List<Component> getFocusComponentsAt(int column) {
            if (column < this.paxes.size() && column >= 0) {
                return this.paxes.get(column).getFocusComponents();
            }
            return new ArrayList<Component>();
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.cabinClass.setEnabled(isEnabled);
            for (PaxEdit f : this.paxes) {
                f.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.cabinClass.kill();
            this.cabinClass = null;
            for (PaxEdit f : this.paxes) {
                f.kill();
            }
            this.paxes.clear();
        }

        public CabinClassComplete getCabinClass() {
            return (CabinClassComplete)this.cabinClass.getNode().getValue();
        }

        public Integer getNumber(int i) {
            PaxEdit r = this.paxes.get(i);
            String t = r.enterField.getText();
            int v = 0;
            try {
                v = Integer.valueOf(t);
            }
            catch (NumberFormatException e) {
                v = 0;
            }
            return v;
        }

        public boolean validateMaxPax() {
            boolean isValid = true;
            for (PaxEdit p : this.paxes) {
                if (p.getMaxCount() >= p.getPaxCount()) continue;
                p.setInvalid();
                isValid = false;
            }
            return isValid;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = 0;
                int currentX = 0;
                int currentCount = 0;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(currentCount);
                ++currentCount;
                TableRowImpl.this.cabinClass.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cabinClass.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cabinClass.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.cabinClass.getPreferredSize().getHeight());
                for (PaxEdit f : TableRowImpl.this.paxes) {
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(currentCount);
                    ++currentCount;
                    f.setLocation((currentX += w) + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - f.getPreferredSize().getHeight()) / 2.0));
                    f.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)f.getPreferredSize().getHeight());
                }
            }
        }
    }
}

