/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts;

import ch.icit.pegasus.client.converter.CustomsDocumentTypeConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class CustomDocumentsPopup
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private boolean isEditable = true;

    public CustomDocumentsPopup(Node docs, RDProvider provider, boolean isEditable) {
        this(docs, provider, isEditable, "documents");
    }

    public CustomDocumentsPopup(Node docs, RDProvider provider, boolean isEditable, String overrideName) {
        this.isEditable = isEditable;
        this.table = new Table2(isEditable, Words.ADD, false, false);
        this.table.setOverrideName(overrideName);
        this.table.setProvider(provider);
        this.table.setUseWriteAccessRight(true);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                CustomDocumentsPopup.this.table.validate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                CustomsDocumentComplete d = new CustomsDocumentComplete();
                if (!((List)NodeToolkit.getAffixList(CustomsDocumentTypeComplete.class).getValue()).isEmpty()) {
                    CustomsDocumentTypeComplete t = (CustomsDocumentTypeComplete)((List)NodeToolkit.getAffixList(CustomsDocumentTypeComplete.class).getValue()).get(0);
                    d.setCustomsDocumentType(t);
                }
                d.setCustomsDocumentId("");
                d.setReceiveTime(new Timestamp(System.currentTimeMillis()));
                d.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, true, false);
                CustomDocumentsPopup.this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DOC_TYPE, null, null, null, "", 200, 200, 200));
        columns.add(new TableColumnInfo(Words.DOC_ID, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.CUSTOM_OFFICE, null, null, null, "", 80, 80, 80));
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", 190));
        columns.add(new TableColumnInfo(Words.COMMENT, null, null, null, "", 30, 30, 30));
        if (isEditable) {
            int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
            columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        }
        ((TableColumnInfo)columns.get(0)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.3);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.4);
        if (isEditable) {
            ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        }
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.getModel().setNode(docs);
        this.setLayout(new Layout());
        this.add(this.table);
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (!pp.isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel typeRo;
        private TextLabel idRo;
        private TextLabel commentRo;
        private TextLabel customOfficeRo;
        private TextLabel timeRo;
        private ComboBox type;
        private TextField id;
        private TextField comment;
        private TextField customOffice;
        private DateTimeChooser timeChooser;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.setLayout(new InnerLayout());
            if (CustomDocumentsPopup.this.isEditable) {
                this.type = new ComboBox(m.getNode().getChildNamed(CustomsDocumentComplete_.customsDocumentType), NodeToolkit.getAffixList(CustomsDocumentTypeComplete.class), ConverterRegistry.getConverter(CustomsDocumentTypeConverter.class), false, true);
                this.id = new TextField(m.getNode().getChildNamed(CustomsDocumentComplete_.customsDocumentId));
                this.type.setProgress(1.0f);
                this.deleteButton = new DeleteButton();
                this.deleteButton.addButtonListener(this);
                this.comment = new TextField(m.getNode().getChildNamed(CustomsDocumentComplete_.comment), TextFieldType.NORMAL);
                this.customOffice = new TextField(m.getNode().getChildNamed(CustomsDocumentComplete_.customOffice), TextFieldType.NORMAL);
                this.timeChooser = new DateTimeChooser((Node<Timestamp>)m.getNode().getChildNamed(CustomsDocumentComplete_.receiveTime));
                this.add(this.type);
                this.add(this.id);
                this.add(this.comment);
                this.add(this.customOffice);
                this.add(this.timeChooser);
                this.add(this.deleteButton);
            } else {
                this.typeRo = new TextLabel(m.getNode().getChildNamed(CustomsDocumentComplete_.customsDocumentType), ConverterRegistry.getConverter(CustomsDocumentTypeConverter.class));
                this.idRo = new TextLabel(m.getNode().getChildNamed(CustomsDocumentComplete_.customsDocumentId));
                this.commentRo = new TextLabel(m.getNode().getChildNamed(CustomsDocumentComplete_.comment));
                this.customOfficeRo = new TextLabel(m.getNode().getChildNamed(CustomsDocumentComplete_.customOffice));
                this.timeRo = new TextLabel(m.getNode().getChildNamed(CustomsDocumentComplete_.receiveTime), ConverterRegistry.getConverter(DateTimeConverter.class));
                this.add(this.typeRo);
                this.add(this.idRo);
                this.add(this.commentRo);
                this.add(this.customOfficeRo);
                this.add(this.timeRo);
            }
        }

        @Override
        public boolean isInnerComponent(Component c) {
            boolean innerComponent;
            if (this.type != null && this.type.getCurrentPopUp() != null) {
                for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                    if (!currentC.equals(this.type.getCurrentPopUp())) continue;
                    return true;
                }
            }
            return this.timeChooser != null && (innerComponent = this.timeChooser.getDateChooser().isInnerComponent(c));
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            if (CustomDocumentsPopup.this.isEditable) {
                CheckedListAdder.addToList(focusList, this.type);
                CheckedListAdder.addToList(focusList, this.id);
                CheckedListAdder.addToList(focusList, this.customOffice);
                CheckedListAdder.addToList(focusList, this.timeChooser);
                CheckedListAdder.addToList(focusList, this.comment);
                CheckedListAdder.addToList(focusList, this.deleteButton);
            }
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            if (CustomDocumentsPopup.this.isEditable) {
                this.type.setEnabled(isEnabled);
                this.id.setEnabled(isEnabled);
                this.comment.setEnabled(isEnabled);
                this.deleteButton.setEnabled(isEnabled);
                this.timeChooser.setEnabled(isEnabled);
                this.customOffice.setEnabled(isEnabled);
            } else {
                this.typeRo.setEnabled(isEnabled);
                this.idRo.setEnabled(isEnabled);
                this.customOfficeRo.setEnabled(isEnabled);
                this.commentRo.setEnabled(isEnabled);
                this.timeRo.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (CustomDocumentsPopup.this.isEditable) {
                this.type.kill();
                this.id.kill();
                this.deleteButton.kill();
                this.comment.kill();
                this.customOffice.kill();
                this.timeChooser.kill();
            } else {
                this.typeRo.kill();
                this.idRo.kill();
                this.commentRo.kill();
                this.customOfficeRo.kill();
                this.timeRo.kill();
            }
            this.typeRo = null;
            this.idRo = null;
            this.timeChooser = null;
            this.timeRo = null;
            this.customOffice = null;
            this.customOfficeRo = null;
            this.type = null;
            this.id = null;
            this.deleteButton = null;
            this.comment = null;
            this.commentRo = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton && this.model != null && this.model.getNode() != null && this.model.getNode().getParent() != null) {
                CustomDocumentsPopup.this.table.getModel().getNode().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                if (CustomDocumentsPopup.this.isEditable) {
                    TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                    TableRowImpl.this.id.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.id.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.id.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.id.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                    TableRowImpl.this.customOffice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customOffice.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.customOffice.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customOffice.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                    TableRowImpl.this.timeChooser.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.timeChooser.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.timeChooser.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.timeChooser.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                    TableRowImpl.this.comment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.comment.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.comment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.comment.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                    TableRowImpl.this.setControlsX(currentX);
                    TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
                } else {
                    TableRowImpl.this.typeRo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.typeRo.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.typeRo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.typeRo.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                    TableRowImpl.this.idRo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.idRo.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.idRo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.idRo.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                    TableRowImpl.this.customOfficeRo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customOfficeRo.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.customOfficeRo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customOfficeRo.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                    TableRowImpl.this.timeRo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.timeRo.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.timeRo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.timeRo.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                    TableRowImpl.this.commentRo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.commentRo.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.commentRo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.commentRo.getPreferredSize().getHeight());
                }
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(350, 450);
        }

        @Override
        public void layoutContainer(Container parent) {
            CustomDocumentsPopup.this.table.setLocation(0, 0);
            CustomDocumentsPopup.this.table.setSize(parent.getSize());
        }
    }
}

