/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.productionweeklyplan;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeListenerAdaptor;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductionJobComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.RecipeProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;

public class StockForwardCalculator {
    private final Node<WeeklyPlanComplete> node;
    private final Node stockNode;

    public StockForwardCalculator(Node<WeeklyPlanComplete> node, Node stockNode) {
        this.node = node;
        this.stockNode = stockNode;
        NodeListenerAdaptor listener = new NodeListenerAdaptor(){

            public void valueChanged(Node<?> node) {
                StockForwardCalculator.this.forwardCalculateStock();
            }

            public boolean isSwingOnly() {
                return false;
            }
        };
        this.register((NodeListener)listener, stockNode, "startStock");
        Iterator it = node.getChildNamed(WeeklyPlanComplete_.jobs).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (!(n.getValue() instanceof ProductionJobComplete)) continue;
            this.register((NodeListener)listener, (Node<QuantityComplete>)n.getChildNamed(ProductionJobComplete_.quantity));
            n.getChildNamed(ProductionJobComplete_.forecastQuantity).addNodeListener((NodeListener)listener);
            n.getChildNamed(ProductionJobComplete_.forecastQuantityUnit).addNodeListener((NodeListener)listener);
            n.getChildNamed(ProductionJobComplete_.wasteQuantity).addNodeListener((NodeListener)listener);
            n.getChildNamed(ProductionJobComplete_.wasteQuantityUnit).addNodeListener((NodeListener)listener);
            n.getChildNamed(ProductionJobComplete_.correctionQuantity).addNodeListener((NodeListener)listener);
            n.getChildNamed(ProductionJobComplete_.correctionQuantityUnit).addNodeListener((NodeListener)listener);
        }
    }

    private void register(NodeListener listener, Node stockNode, String name) {
        Node qty = stockNode.getChildNamed(new String[]{name});
        qty.addNodeListener(listener);
        if (qty.getChildNamed(QuantityComplete_.quantity) != null) {
            qty.getChildNamed(QuantityComplete_.quantity).addNodeListener(listener);
            qty.getChildNamed(QuantityComplete_.unit).addNodeListener(listener);
        }
    }

    private void register(NodeListener listener, Node<QuantityComplete> node) {
        node.addNodeListener(listener);
        if (node.getChildNamed(QuantityComplete_.quantity) != null) {
            node.getChildNamed(QuantityComplete_.quantity).addNodeListener(listener);
            node.getChildNamed(QuantityComplete_.unit).addNodeListener(listener);
        }
    }

    private void forwardCalculateStock() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                Object item = StockForwardCalculator.this.stockNode.getChildNamed(new String[]{"item"}).getValue();
                QuantityComplete startQty = (QuantityComplete)StockForwardCalculator.this.stockNode.getChildNamed(new String[]{"startStock"}).getValue();
                if (startQty == null) {
                    startQty = new QuantityComplete(Double.valueOf(0.0), null);
                    if (item instanceof ProductComplete) {
                        startQty.setUnit(settings.getPieceUnit());
                    } else if (item instanceof RecipeComplete) {
                        startQty.setUnit(((RecipeComplete)item).getCurrentVariant().getYield().getUnit());
                    }
                }
                ArrayList<Node> sortedJobs = new ArrayList<Node>();
                Iterator it = StockForwardCalculator.this.node.getChildNamed(WeeklyPlanComplete_.jobs).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node job = (Node)it.next();
                    if (item instanceof ProductComplete && job.getValue() instanceof ProductProductionJobComplete && item.equals(((ProductProductionJobComplete)job.getValue()).getProduct())) {
                        sortedJobs.add(job);
                    }
                    if (!(item instanceof RecipeComplete) || !(job.getValue() instanceof RecipeProductionJobComplete) || !item.equals(((RecipeProductionJobComplete)job.getValue()).getRecipe())) continue;
                    sortedJobs.add(job);
                }
                Collections.sort(sortedJobs, (o1, o2) -> {
                    Timestamp v1 = (Timestamp)o1.getChildNamed(JobComplete_.jobSchedule).getValue();
                    Timestamp v2 = (Timestamp)o2.getChildNamed(JobComplete_.jobSchedule).getValue();
                    return v1.compareTo(v2);
                });
                QuantityComplete totalDeliver = new QuantityComplete(Double.valueOf(0.0), startQty.getUnit());
                QuantityComplete totalProduce = new QuantityComplete(Double.valueOf(0.0), startQty.getUnit());
                QuantityComplete currentQuantity = new QuantityComplete(startQty);
                for (Node job : sortedJobs) {
                    QuantityComplete deliverQuantity = new QuantityComplete((Double)job.getChildNamed(ProductionJobComplete_.forecastQuantity).getValue(), (UnitComplete)job.getChildNamed(ProductionJobComplete_.forecastQuantityUnit).getValue());
                    QuantityComplete produceQuantity = new QuantityComplete((Double)job.getChildNamed(new DtoField[]{ProductionJobComplete_.quantity, QuantityComplete_.quantity}).getValue(), (UnitComplete)job.getChildNamed(new DtoField[]{ProductionJobComplete_.quantity, QuantityComplete_.unit}).getValue());
                    QuantityComplete correctionQuantity = new QuantityComplete((Double)job.getChildNamed(ProductionJobComplete_.correctionQuantity).getValue(), (UnitComplete)job.getChildNamed(ProductionJobComplete_.correctionQuantityUnit).getValue());
                    QuantityComplete wasteQuantity = new QuantityComplete((Double)job.getChildNamed(ProductionJobComplete_.wasteQuantity).getValue(), (UnitComplete)job.getChildNamed(ProductionJobComplete_.wasteQuantityUnit).getValue());
                    if (correctionQuantity.getAmount() == 0.0) {
                        currentQuantity.setQuantity(Double.valueOf(currentQuantity.getQuantity() - deliverQuantity.getQuantity()));
                        totalDeliver.setQuantity(Double.valueOf(totalDeliver.getQuantity() + deliverQuantity.getQuantity()));
                    } else {
                        currentQuantity.setQuantity(Double.valueOf(currentQuantity.getQuantity() - correctionQuantity.getQuantity()));
                        totalDeliver.setQuantity(Double.valueOf(totalDeliver.getQuantity() + correctionQuantity.getQuantity()));
                    }
                    currentQuantity.setQuantity(Double.valueOf(currentQuantity.getQuantity() + produceQuantity.getQuantity()));
                    totalProduce.setQuantity(Double.valueOf(totalProduce.getQuantity() + produceQuantity.getQuantity()));
                    String dayShortName = DateUtil.getDayShortName((Date)((Date)job.getChildNamed(JobComplete_.jobSchedule).getValue()));
                    Node endStock = StockForwardCalculator.this.stockNode.getChildNamed(new String[]{dayShortName});
                    endStock.setValue((Object)new QuantityComplete(currentQuantity), 0L);
                    currentQuantity.setQuantity(Double.valueOf(currentQuantity.getQuantity() - wasteQuantity.getQuantity()));
                }
                Node endStock = StockForwardCalculator.this.stockNode.getChildNamed(new String[]{"endStock"});
                Node totDeliver = StockForwardCalculator.this.stockNode.getChildNamed(new String[]{"totDeliver"});
                Node totProduce = StockForwardCalculator.this.stockNode.getChildNamed(new String[]{"totProduce"});
                endStock.setValue((Object)new QuantityComplete(currentQuantity), 0L);
                totDeliver.setValue((Object)new QuantityComplete(totalDeliver), 0L);
                totProduce.setValue((Object)new QuantityComplete(totalProduce), 0L);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                    }

                    public void errorOccurred(ClientException exception) {
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void calculateStock() {
        this.forwardCalculateStock();
    }
}

