/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.productionweeklyplan.label;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeListenerAdaptor;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductionJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductionJobComplete_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BoxLabelCalculator {
    private Map<ProductComplete, Node<Integer>> sum = new HashMap<ProductComplete, Node<Integer>>();
    private final NodeListenerAdaptor adaptor = new NodeListenerAdaptor(){

        public void valueChanged(Node<?> node) {
            BoxLabelCalculator.this.calculateBoxLabelSum();
        }
    };
    private Node<WeeklyPlanComplete> node;

    private void calculateBoxLabelSum() {
        HashMap<ProductComplete, QuantityComplete> sumIndex = new HashMap<ProductComplete, QuantityComplete>();
        Iterator it = this.node.getChildNamed(WeeklyPlanComplete_.jobs).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node job = (Node)it.next();
            if (!(job.getValue() instanceof ProductionJobComplete)) continue;
            Double qty = (Double)job.getChildNamed(new DtoField[]{ProductionJobComplete_.quantity, QuantityComplete_.quantity}).getValue();
            ProductComplete product = ((ProductionJobComplete)job.getValue()).getProduct();
            QuantityComplete quantityComplete = (QuantityComplete)sumIndex.get(product);
            if (quantityComplete == null) {
                quantityComplete = new QuantityComplete(Double.valueOf(0.0), ((ProductionJobComplete)job.getValue()).getQuantity().getUnit());
                sumIndex.put(product, quantityComplete);
            }
            quantityComplete.setQuantity(Double.valueOf(quantityComplete.getQuantity() + qty));
        }
        for (Map.Entry set : sumIndex.entrySet()) {
            Node<Integer> quantityCompleteNode = this.sum.get(set.getKey());
            if (quantityCompleteNode == null) continue;
            quantityCompleteNode.setValue((Object)((QuantityComplete)set.getValue()).getQuantity().intValue(), 0L);
        }
    }

    public void updateSum() {
        this.calculateBoxLabelSum();
    }

    public void registerProduct(ProductComplete product, Node<Integer> qty) {
        this.sum.put(product, qty);
    }

    public void setNode(Node<WeeklyPlanComplete> node) {
        if (this.node != null) {
            this.removeListeners(this.node);
        }
        this.node = node;
        if (this.node != null) {
            this.addListeners(this.node);
        }
    }

    private void addListeners(Node<WeeklyPlanComplete> node) {
        Iterator it = node.getChildNamed(WeeklyPlanComplete_.jobs).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node job = (Node)it.next();
            if (!(job.getValue() instanceof ProductionJobComplete)) continue;
            job.getChildNamed(ProductionJobComplete_.quantity).addNodeListener((NodeListener)this.adaptor);
            job.getChildNamed(new DtoField[]{ProductionJobComplete_.quantity, QuantityComplete_.quantity}).addNodeListener((NodeListener)this.adaptor);
        }
    }

    private void removeListeners(Node<WeeklyPlanComplete> node) {
        Iterator it = node.getChildNamed(WeeklyPlanComplete_.jobs).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node job = (Node)it.next();
            if (!(job.getValue() instanceof ProductionJobComplete)) continue;
            job.getChildNamed(ProductionJobComplete_.quantity).removeNodeListener((NodeListener)this.adaptor);
            job.getChildNamed(new DtoField[]{ProductionJobComplete_.quantity, QuantityComplete_.quantity}).removeNodeListener((NodeListener)this.adaptor);
        }
    }
}

