/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.textfield;

import ch.icit.pegasus.client.gui.modules.invoice.InvoiceToolkit;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.textfield.AbstractTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class InvoiceNoFormatEditor
extends DefaultPanel
implements Nodable,
TextFieldListener,
Validatable {
    private static final long serialVersionUID = 1L;
    private TextField text = new TextField();
    private InfoButton info;
    private Node<String> node;

    public InvoiceNoFormatEditor() {
        this.text.addTextFieldListener(this);
        this.info = new InfoButton();
        this.info.installStringViewer(InvoiceToolkit.createInvoiceNumberConfigInfoText());
        this.setLayout(new Layout());
        this.add(this.text);
        this.add(this.info);
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.text.getFocusComponents();
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.text.requestFocusInWindowNow();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.text.setEnabled(isEnabled);
        this.info.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.text.kill();
        this.text = null;
        this.info.kill();
        this.info = null;
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        if (node.getValue() != null) {
            String t = (String)node.getValue();
            this.text.setText(t);
        }
    }

    public List<ScreenValidationObject> validateFormat() {
        ArrayList<ScreenValidationObject> errors = new ArrayList<ScreenValidationObject>();
        String nodeValue = this.text.getText();
        if (!nodeValue.isEmpty()) {
            boolean hasNo = nodeValue.contains("{No}");
            if (!hasNo) {
                errors.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Invoice Number Format is defined correctly"));
                this.text.setInvalid();
            } else {
                this.text.setValid();
            }
        } else {
            errors.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Invoice Number Format is defined correctly"));
            this.text.setInvalid();
        }
        return errors;
    }

    @Override
    public void valueChanged(AbstractTextField field) {
        String t = field.getText();
        if (this.validateFormat().isEmpty()) {
            this.text.setValid();
            if (this.node != null) {
                String nv = (String)this.node.getValue();
                if (nv != null && nv.equals(t)) {
                    return;
                }
                nv = t;
                this.node.setValue((Object)nv, 0L);
            }
        } else {
            this.text.setInvalid();
        }
    }

    @Override
    public void setValid() {
        this.text.setValid();
    }

    @Override
    public void setInvalid() {
        this.text.setInvalid();
    }

    @Override
    public void setWarning() {
        this.text.setWarning();
    }

    @Override
    public void setPermanent(boolean isPermantent) {
        this.text.setPermanent(isPermantent);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return InvoiceNoFormatEditor.this.text.getPreferredSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            InvoiceNoFormatEditor.this.text.setLocation(0, 0);
            InvoiceNoFormatEditor.this.text.setSize((int)((double)parent.getWidth() - (3.0 + InvoiceNoFormatEditor.this.info.getPreferredSize().getWidth())), (int)InvoiceNoFormatEditor.this.text.getPreferredSize().getHeight());
            InvoiceNoFormatEditor.this.info.setLocation(InvoiceNoFormatEditor.this.text.getWidth() + 3, (int)(((double)parent.getHeight() - InvoiceNoFormatEditor.this.info.getPreferredSize().getHeight()) / 2.0));
            InvoiceNoFormatEditor.this.info.setSize(InvoiceNoFormatEditor.this.info.getPreferredSize());
        }
    }
}

