/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tooltip.impls;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.tooltip.ToolTipCreator;
import ch.icit.pegasus.client.gui.utils.tooltip.impls.PackagingQuantityFormulaCoverter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class PackagingTableToolTipCreator
implements ToolTipCreator,
NodeListener {
    protected Node<BasicArticleComplete> node;
    protected List<JComponent> toolTippedComponent = new ArrayList<JComponent>();
    private boolean isKilled;

    @Override
    public String getToolTipText() {
        if (this.node != null && this.node.getValue(BasicArticleComplete.class) != null) {
            Converter c = ConverterRegistry.getConverter(PackagingQuantityFormulaCoverter.class);
            String t = (String)c.convert(this.node.getValue(BasicArticleComplete.class), this.node, new Object[0]);
            return t;
        }
        return "variantNode not set";
    }

    public void setNode(Node node) {
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = node;
        if (this.node != null) {
            this.node.addNodeListener((NodeListener)this);
        }
    }

    @Override
    public void updateToolTip() {
        this.valueChanged(this.node);
    }

    @Override
    public void setToolTippedComponent(JComponent c) {
        if (!this.toolTippedComponent.contains(c)) {
            this.toolTippedComponent.add(c);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public void valueChanged(Node<?> node) {
        for (JComponent c : this.toolTippedComponent) {
            c.setToolTipText(this.getToolTipText());
        }
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.toolTippedComponent.clear();
    }

    public boolean isSwingOnly() {
        return true;
    }
}

