/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.loaders;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;

public class BasicArticleLoader
extends ThreadSafeExecutable {
    private BasicArticleReference artL;
    private RemoteLoader loader;
    private Node cn;

    public BasicArticleLoader(BasicArticleReference artL, RemoteLoader loader, Node cn, Object caller) {
        super(caller);
        this.artL = artL;
        this.loader = loader;
        this.cn = cn;
        ThreadSafeLoader.run(this);
    }

    @Override
    public Node<?> loadData() throws Exception {
        try {
            BasicArticleComplete a = BasicArticleLoader.loadArticle(this.artL);
            this.cn.removeExistingValues(a.getClass());
            this.cn.setValue((Object)a, 0L);
            return this.cn;
        }
        catch (ClientGetFromServerException e) {
            ViewNode r = new ViewNode("Error");
            r.setValue((Object)e, 0L);
            return r;
        }
    }

    @Override
    public RemoteLoader getInvoker() {
        return this.loader;
    }

    @Override
    public long getID() {
        return 0L;
    }

    public static BasicArticleComplete loadArticle(BasicArticleReference l) throws ClientServerCallException {
        return (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(l.getId())).getValue();
    }
}

