/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui;

import ch.icit.pegasus.client.gui.InternationalizedConverter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class InternationalizedHourMinuteSecondConverter
extends InternationalizedConverter {
    public InternationalizedHourMinuteSecondConverter() {
        this("{**$hour}:{**$minute}.{**$second}#HH:MM.SS$0123456789HM$0123456789$0123456789");
    }

    public InternationalizedHourMinuteSecondConverter(String pattern) {
        super(pattern);
    }

    public String convert(Object o, Node currentNode, Object ... param) {
        if (o instanceof Timestamp) {
            Timestamp d = (Timestamp)o;
            Calendar c = TimeUtil.createCalendar();
            c.setTime(d);
            String retString = "";
            for (String pat : this.getAllPatterns()) {
                if (pat.contains("$")) {
                    String hS;
                    int h;
                    if (pat.equals("$hour")) {
                        h = c.get(11);
                        hS = "" + h;
                        if (hS.length() == 1) {
                            hS = "0" + hS;
                        }
                        retString = retString + hS;
                        continue;
                    }
                    if (pat.equals("$minute")) {
                        h = c.get(12);
                        hS = "" + h;
                        if (hS.length() == 1) {
                            hS = "0" + hS;
                        }
                        retString = retString + hS;
                        continue;
                    }
                    if (!pat.equals("$second")) continue;
                    h = c.get(13);
                    hS = "" + h;
                    if (hS.length() == 1) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                retString = retString + pat;
            }
            return retString;
        }
        if (o instanceof Time) {
            Time d = (Time)o;
            Calendar c = TimeUtil.createCalendar();
            c.setTime(d);
            String retString = "";
            for (String pat : this.getAllPatterns()) {
                if (pat.contains("$")) {
                    String hS;
                    int h;
                    if (pat.equals("$hour")) {
                        h = c.get(11);
                        hS = "" + h;
                        if (hS.length() == 1) {
                            hS = "0" + hS;
                        }
                        retString = retString + hS;
                        continue;
                    }
                    if (pat.equals("$minute")) {
                        h = c.get(12);
                        hS = "" + h;
                        if (hS.length() == 1) {
                            hS = "0" + hS;
                        }
                        retString = retString + hS;
                        continue;
                    }
                    if (!pat.equals("$second")) continue;
                    h = c.get(13);
                    hS = "" + h;
                    if (hS.length() == 1) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                retString = retString + pat;
            }
            return retString;
        }
        if (o instanceof Date) {
            Time d = new Time(((Date)o).getTime());
            Calendar c = TimeUtil.createCalendar();
            c.setTime(d);
            String retString = "";
            for (String pat : this.getAllPatterns()) {
                if (pat.contains("$")) {
                    String hS;
                    int h;
                    if (pat.equals("$hour")) {
                        h = c.get(11);
                        hS = "" + h;
                        if (hS.length() == 1) {
                            hS = "0" + hS;
                        }
                        retString = retString + hS;
                        continue;
                    }
                    if (pat.equals("$minute")) {
                        h = c.get(12);
                        hS = "" + h;
                        if (hS.length() == 1) {
                            hS = "0" + hS;
                        }
                        retString = retString + hS;
                        continue;
                    }
                    if (!pat.equals("$second")) continue;
                    h = c.get(13);
                    hS = "" + h;
                    if (hS.length() == 1) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                retString = retString + pat;
            }
            return retString;
        }
        if (o instanceof Double) {
            Long d = ((Double)o).longValue();
            String retString = "";
            for (String pat : this.getAllPatterns()) {
                if (pat.contains("$")) {
                    String hS;
                    int h;
                    if (pat.equals("$hour")) {
                        h = (int)(d / 3600L);
                        hS = "" + h;
                        if (hS.length() == 1) {
                            hS = "0" + hS;
                        }
                        retString = retString + hS;
                        continue;
                    }
                    if (pat.equals("$minute")) {
                        h = (int)(d / 60L % 60L);
                        hS = "" + h;
                        if (hS.length() == 1) {
                            hS = "0" + hS;
                        }
                        retString = retString + hS;
                        continue;
                    }
                    if (!pat.equals("$second")) continue;
                    h = (int)(d % 60L);
                    hS = "" + h;
                    if (hS.length() == 1) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                retString = retString + pat;
            }
            return retString;
        }
        return null;
    }

    public Object inverseConvert(Object o, Object userObj) {
        if (userObj instanceof Timestamp) {
            Timestamp d = (Timestamp)userObj;
            String dString = (String)o;
            if (dString == null || dString.trim().equals("")) {
                return null;
            }
            String h = this.getStringValueOfGroupNamed("hour", dString);
            String m = this.getStringValueOfGroupNamed("minute", dString);
            String s = this.getStringValueOfGroupNamed("second", dString);
            try {
                int hour = Integer.valueOf(h);
                int minute = Integer.valueOf(m);
                int second = Integer.valueOf(s);
                Calendar c = TimeUtil.createCalendar();
                if (d != null) {
                    c.setTimeInMillis(d.getTime());
                }
                c.set(11, hour);
                c.set(12, minute);
                c.set(13, second);
                return new Timestamp(c.getTimeInMillis());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (userObj instanceof Time) {
            Time d = (Time)userObj;
            String dString = (String)o;
            if (dString == null || dString.trim().equals("")) {
                return null;
            }
            String h = this.getStringValueOfGroupNamed("hour", dString);
            String m = this.getStringValueOfGroupNamed("minute", dString);
            String s = this.getStringValueOfGroupNamed("second", dString);
            try {
                int hour = Integer.valueOf(h);
                int minute = Integer.valueOf(m);
                int second = Integer.valueOf(s);
                Calendar c = TimeUtil.createCalendar();
                if (d != null) {
                    c.setTimeInMillis(d.getTime());
                }
                c.set(11, hour);
                c.set(12, minute);
                c.set(13, second);
                return new Time(c.getTimeInMillis());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (userObj instanceof Date) {
            Time d = new Time(((Date)userObj).getTime());
            String dString = (String)o;
            if (dString == null || dString.trim().equals("")) {
                return null;
            }
            String h = this.getStringValueOfGroupNamed("hour", dString);
            String m = this.getStringValueOfGroupNamed("minute", dString);
            String s = this.getStringValueOfGroupNamed("second", dString);
            try {
                int hour = Integer.valueOf(h);
                int minute = Integer.valueOf(m);
                int second = Integer.valueOf(s);
                Calendar c = TimeUtil.createCalendar();
                if (d != null) {
                    c.setTimeInMillis(d.getTime());
                }
                c.set(11, hour);
                c.set(12, minute);
                c.set(13, second);
                return new Timestamp(c.getTimeInMillis());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (userObj instanceof Double) {
            String dString = (String)o;
            if (dString == null || dString.trim().equals("")) {
                return null;
            }
            String h = this.getStringValueOfGroupNamed("hour", dString);
            String m = this.getStringValueOfGroupNamed("minute", dString);
            String s = this.getStringValueOfGroupNamed("second", dString);
            try {
                int hour = Integer.valueOf(h);
                int minute = Integer.valueOf(m);
                int second = Integer.valueOf(s);
                double millis = second;
                millis += (double)minute * 60.0;
                userObj = millis += (double)hour * 60.0 * 60.0;
                return userObj;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public boolean validateInput(Object input) {
        String dString = (String)input;
        String h = this.getStringValueOfGroupNamed("hour", dString);
        String m = this.getStringValueOfGroupNamed("minute", dString);
        String s = this.getStringValueOfGroupNamed("second", dString);
        try {
            int hour = Integer.valueOf(h);
            int minute = Integer.valueOf(m);
            int second = Integer.valueOf(s);
            if (hour < 0 || hour > 23) {
                return false;
            }
            if (minute < 0 || minute > 59) {
                return false;
            }
            if (second < 0 || second > 59) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

