/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.changelog;

import ch.icit.pegasus.client.ApplicationSettingsLoader;
import ch.icit.pegasus.client.gui.changelog.ChangeLogViewer;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.inserts.AboutPopupInsert;
import ch.icit.pegasus.client.gui.utils.popup.myway.SimpleComponentPopupInsert;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.net.URL;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtils {
    static Logger log = LoggerFactory.getLogger(VersionUtils.class);

    public static Boolean showChangeLog(UserComplete user, JComponent parent, boolean checkForVersion) {
        String userVersion;
        String version = null;
        if (checkForVersion && (version = ApplicationSettingsLoader.getLoader().getAttribute("application_version")).equals(userVersion = user.getLastLoginVersion())) {
            return false;
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource("Changelog.html");
        if (url != null) {
            VersionUtils.showHTML(parent, url);
            if (checkForVersion) {
                VersionUtils.setUserVersion(user, version);
            }
            return true;
        }
        log.debug("ERROR: Changelog.html not found!");
        return null;
    }

    public static void showAboutWindow(JComponent parent) {
        InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
        pop.setAttributes(parent, true, true, Words.ABOUT);
        pop.enableCancelButton(false);
        pop.setView(new AboutPopupInsert());
        pop.setResizeAllowed(false);
        pop.showPopUpWithinScreenMiddle(600, 265, null, parent);
    }

    public static String getAppVersion() {
        String version = ApplicationSettingsLoader.getLoader().getAttribute("application_version");
        String buildNumber = ApplicationSettingsLoader.getLoader().getAttribute("build_number");
        return version.contains("SNAPSHOT") ? "build " + buildNumber : version;
    }

    private static void showHTML(JComponent parent, URL url) {
        InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
        pop.setAttributes(parent, true, true, Words.CHANGE_LOG);
        pop.enableCancelButton(false);
        pop.setView(new SimpleComponentPopupInsert(new ChangeLogViewer(url)));
        pop.showPopUpWithinScreenMiddle(400, 500, null, parent);
    }

    private static void setUserVersion(final UserComplete user, final String version) {
        user.setLastLoginVersion(version);
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                UserComplete nUser = (UserComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).updateLoginVersion((UserReference)user, version).getValue();
                Node node4DTO = INodeCreator.getDefaultImpl().getNode4DTO((Object)nUser, false, false);
                node4DTO.setValue((Object)nUser, 0L);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return null;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }
}

