/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.hud.view;

import ch.icit.pegasus.client.gui.hud.view.FavoriteButton;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.animators.AnimationContainer;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.panels.AsynchronLoaderAnimation;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public class FavoriteButtonContainer
extends BorderedInletPanel
implements RemoteLoader,
AnimationContainer {
    private static final long serialVersionUID = 1L;
    private FavoriteButton fav;
    private FavoriteButton tempFav;
    private int index;
    private AsynchronLoaderAnimation animator;

    public FavoriteButtonContainer(boolean b, boolean c, int index) {
        super(b, c);
        this.setIndex(index);
        this.animator = new AsynchronLoaderAnimation();
        this.setLayout(new FavLayout());
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.fav != null) {
            this.fav.kill();
        }
        this.fav = null;
        if (this.tempFav != null) {
            this.tempFav.kill();
        }
        this.tempFav = null;
        this.animator = null;
    }

    public void setFavorite(FavoriteButton fav) {
        this.fav = fav;
        this.fav.setVisible(true);
        this.fav.setSize(46, 52);
        this.fav.setLocation(0, 0);
        this.add(fav);
    }

    public void hideFavorite() {
        if (this.fav != null) {
            this.fav.setVisible(false);
        }
    }

    public void showFavorite() {
        if (this.fav != null) {
            this.fav.setVisible(true);
        }
    }

    public void removeFavorite() {
        if (this.fav != null) {
            this.removeFavorite(this.fav);
            this.remove(this.fav);
        }
    }

    public void setTemporalFavorite(FavoriteButton tempFav) {
        this.tempFav = tempFav;
        this.tempFav.setVisible(true);
        this.tempFav.setSize(46, 52);
        this.tempFav.setLocation(0, 0);
        this.add(this.tempFav);
    }

    public void hideTemporalFavorite() {
        if (this.tempFav != null) {
            this.tempFav.setVisible(false);
        }
    }

    public void showTemporalFavorite() {
        if (this.tempFav != null) {
            this.tempFav.setVisible(true);
        }
    }

    public void removeTemporalFavorite() {
        if (this.tempFav != null) {
            this.remove(this.tempFav);
            this.tempFav = null;
        }
    }

    public void changeTemporalToReal() {
        if (this.tempFav != null) {
            this.fav = this.tempFav;
            this.tempFav = null;
            this.saveFavorite(this.fav);
        }
    }

    public FavoriteButton getFavorite() {
        return this.fav;
    }

    public FavoriteButton getTemporalFavorite() {
        return this.tempFav;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void startAnimation() {
        this.animator.getFader().setAnimationContainer(this);
        this.add((Component)this.animator, 0);
        this.animator.fadeIn();
        this.animator.setProgress(1.0f);
        this.animator.startAnimation();
        for (Component comp : this.getComponents()) {
            comp.setEnabled(false);
        }
        this.invalidate();
        this.validate();
    }

    public void stopAnimation() {
        if (this.animator == null) {
            return;
        }
        this.animator.stopAnimation();
        for (Component comp : this.getComponents()) {
            comp.setEnabled(true);
        }
        this.invalidate();
        this.validate();
    }

    public void saveFavorite(final FavoriteButton fav) {
        this.startAnimation();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ModuleAccessRightComplete accessright = fav.getModule().getAccessright();
                if (accessright.getModule() == null) {
                    return null;
                }
                if (accessright.getModule().getId() == null) {
                    return null;
                }
                ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).updateFavorite(accessright, FavoriteButtonContainer.this.getIndex());
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return FavoriteButtonContainer.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void removeFavorite(final FavoriteButton fav) {
        this.startAnimation();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).removeFavorite(fav.getModule().getAccessright(), FavoriteButtonContainer.this.getIndex());
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return FavoriteButtonContainer.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void remoteObjectLoaded(Node<?> node) {
        this.stopAnimation();
    }

    public void errorOccurred(ClientException exception) {
        this.stopAnimation();
    }

    @Override
    public void removeScheduled(Fadable comp) {
    }

    private class FavLayout
    extends DefaultLayout {
        private FavLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void layoutContainer(Container parent) {
            if (FavoriteButtonContainer.this.animator != null) {
                FavoriteButtonContainer.this.animator.setSize(FavoriteButtonContainer.this.animator.getPreferredSize());
                FavoriteButtonContainer.this.animator.setLocation((parent.getWidth() - FavoriteButtonContainer.this.animator.getWidth()) / 2, (parent.getHeight() - FavoriteButtonContainer.this.animator.getHeight()) / 2);
            }
        }
    }
}

