/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules;

import ch.icit.pegasus.client.gui.hud.model.HUDModelCategory;
import ch.icit.pegasus.client.gui.modules.AppModules;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.ModuleDefinitionToolkit;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.BasicArticleAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InternalConsumptionAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InvoiceAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.PurchaseOrderAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RecipeAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ServiceProductAccess;
import ch.icit.pegasus.server.core.i18n.Words;

public class AppModulesUtils {
    public static String getSubModuleName(SubModuleAccessDefinition definition) {
        return AppModulesUtils.getSubModuleName(definition.getIdentifier(), definition.getDisplayName());
    }

    public static String getSubModuleName(String definition, String defaultValue) {
        if (definition.equals(InternalConsumptionAccess.ANALYSIS_INTERNAL_CONSUMPTION_EXPORT.getIdentifier())) {
            return Words.INTERNAL_CONSUMPTION_EXPORT;
        }
        if (definition.equals(InternalConsumptionAccess.ANALYSIS_INTERNAL_CONSUMPTION_DETAILS.getIdentifier())) {
            return Words.INTERNAL_CONSUMPTION_DETAILS;
        }
        if (definition.equals(InvoiceAccess.ANALYSIS_INVOICE_EXPORT.getIdentifier())) {
            return Words.INVOICE_EXPORT;
        }
        if (definition.equals(ServiceProductAccess.ANALYSIS_SERVICE_PRODUCT_EXPORT.getIdentifier())) {
            return Words.SERVICE_PRODUCT_EXPORT;
        }
        if (definition.equals(BasicArticleAccess.ANALYSIS_ARTICLE_EXPORT.getIdentifier())) {
            return Words.ARTICLE_EXPORT;
        }
        if (definition.equals(ProductAccess.ANALYSIS_PRODUCT_EXPORT.getIdentifier())) {
            return Words.PRODUCT_EXPORT;
        }
        if (definition.equals(PurchaseOrderAccess.ANALYSIS_PURCHASE_ORDER_EXPORT.getIdentifier())) {
            return Words.ANALYSIS_PURCHASE_ORDER_EXPORT;
        }
        if (definition.equals(RecipeAccess.ANALYSIS_RECIPE_EXPORT.getIdentifier())) {
            return Words.RECIPE_EXPORT;
        }
        return defaultValue;
    }

    public String getModuleDisplayName(AccessDefinitionComplete definitionComplete) {
        for (AppModules value : AppModules.values()) {
            if (value.getDefaultPath() == null || !value.getDefaultPath().equals((Object)definitionComplete)) continue;
            if (value == AppModules.Article) {
                return Words.ARTICLE_MODULE;
            }
            if (value == AppModules.Sales) {
                return Words.RETAIL_MODULE;
            }
            if (value == AppModules.Purchase) {
                return Words.PURCHASE_MODULE;
            }
            if (value == AppModules.ManualPurchaseCreator) {
                return Words.MANUAL_PURCHASE_ORDER;
            }
            if (value == AppModules.Invoice) {
                return Words.INVOICE_MODULE;
            }
            if (value == AppModules.InvoiceCreator) {
                return Words.INVOICE_CREATOR_MODULE;
            }
            if (value == AppModules.Customer) {
                return Words.CUSTOMER_MODULE;
            }
            if (value == AppModules.Supplier) {
                return Words.SUPPLIER_MODULE;
            }
            if (value == AppModules.Product) {
                return Words.PRODUCT_MODULE;
            }
            if (value == AppModules.Stock) {
                return Words.STOCK_MODULE;
            }
            if (value == AppModules.InventoryManager) {
                return Words.INVENTORY_MANAGER_MODULE;
            }
            if (value == AppModules.HandlingCosts) {
                return Words.HANDLING_COST_MODULE;
            }
            if (value == AppModules.Product) {
                return Words.PRODUCT_MODULE;
            }
            if (value != AppModules.InternalConsumption) continue;
            return Words.INTERNAL_CONSUMPTION_MODULE;
        }
        return definitionComplete.getDisplayName();
    }

    public String getCategoryDisplayName(HUDModelCategory category) {
        if (category.getCategoryID().equals(ModuleDefinitionToolkit.CATEGORY_ALL.getIdentifier())) {
            return Words.ALL;
        }
        if (category.getCategoryID().equals(ModuleDefinitionToolkit.CATEGORY_ADMIN.getIdentifier())) {
            return Words.ADMINISTRATION;
        }
        if (category.getCategoryID().equals(ModuleDefinitionToolkit.CATEGORY_DISPACH.getIdentifier())) {
            return Words.DISPATCH;
        }
        if (category.getCategoryID().equals(ModuleDefinitionToolkit.CATEGORY_FINANCE.getIdentifier())) {
            return Words.FINANCE;
        }
        if (category.getCategoryID().equals(ModuleDefinitionToolkit.CATEGORY_PRODUCTION.getIdentifier())) {
            return Words.PRODUCTION;
        }
        if (category.getCategoryID().equals(ModuleDefinitionToolkit.CATEGORY_CUSTOMER_SERVICE.getIdentifier())) {
            return Words.CUSTOMER_SERVICE;
        }
        if (category.getCategoryID().equals(ModuleDefinitionToolkit.CATEGORY_QUALITY.getIdentifier())) {
            return Words.QUALITY;
        }
        if (category.getCategoryID().equals(ModuleDefinitionToolkit.CATEGORY_SCM.getIdentifier())) {
            return Words.SUPPLY_CHAIN;
        }
        return category.getName();
    }
}

