/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.admin.inserts;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.PasswordTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.SlaveServerSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SlaveServerSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class SlaveServerInsert
extends DefaultDataInsert {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> useSlaveServer;
    private TitledItem<TextField> userName;
    private TitledItem<PasswordTextField> password;
    private TitledItem<TextField> ftpURL;
    private TitledItem<NumberTextField> port;
    private TitledItem<TextField> folder;
    private Node<SlaveServerSettingsComplete> settings;

    public SlaveServerInsert(AbstractDataInsertModule parent) {
        super(parent);
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SFTPDataExchangeSettingsComplete c;
                SlaveServerSettingsComplete sssc = (SlaveServerSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSlaveServerSettings().getValue();
                if (sssc == null) {
                    SlaveServerSettingsComplete s = new SlaveServerSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    sssc = s;
                }
                if (sssc.getDataExchangeSettings() == null) {
                    c = new SFTPDataExchangeSettingsComplete();
                    c.setClientOId(Long.valueOf(ADTO.getNextId()));
                    EncryptedStringComplete pwd = new EncryptedStringComplete();
                    c.setLoginPwd(pwd);
                    sssc.setDataExchangeSettings(c);
                } else {
                    c = sssc.getDataExchangeSettings();
                    if (c.getLoginPwd() == null) {
                        EncryptedStringComplete pwd = new EncryptedStringComplete();
                        c.setLoginPwd(pwd);
                    }
                }
                SlaveServerInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)sssc, false, false);
                return SlaveServerInsert.this.settings;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SlaveServerInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.useSlaveServer != null) {
            this.useSlaveServer.setEnabled(isEnabled);
            this.userName.setEnabled(isEnabled);
            this.password.setEnabled(isEnabled);
            this.ftpURL.setEnabled(isEnabled);
            this.port.setEnabled(isEnabled);
            this.folder.setEnabled(isEnabled);
        }
    }

    @Override
    public void insertElements() {
        this.useSlaveServer = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(SlaveServerSettingsComplete_.useSlaveServer)), Words.ENABLE_SLAVE_SERVER, TitledItem.TitledItemOrientation.EAST);
        this.ftpURL = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{SlaveServerSettingsComplete_.dataExchangeSettings, SFTPDataExchangeSettingsComplete_.dataExchangeURL})), Words.FTP_URL, TitledItem.TitledItemOrientation.NORTH);
        this.port = new TitledItem<NumberTextField>(new NumberTextField(this.settings.getChildNamed(new DtoField[]{SlaveServerSettingsComplete_.dataExchangeSettings, SFTPDataExchangeSettingsComplete_.dataExchangePort}), TextFieldType.INT_NULLABLE), Words.FTP_PORT, TitledItem.TitledItemOrientation.NORTH);
        this.userName = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{SlaveServerSettingsComplete_.dataExchangeSettings, SFTPDataExchangeSettingsComplete_.loginUser})), Words.USER, TitledItem.TitledItemOrientation.NORTH);
        this.password = new TitledItem<PasswordTextField>(new PasswordTextField(this.settings.getChildNamed(new DtoField[]{SlaveServerSettingsComplete_.dataExchangeSettings, SFTPDataExchangeSettingsComplete_.loginPwd, EncryptedStringComplete_.password})), Words.PASSWORD, TitledItem.TitledItemOrientation.NORTH);
        this.folder = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{SlaveServerSettingsComplete_.dataExchangeSettings, SFTPDataExchangeSettingsComplete_.dataExchangeFolder})), Words.FOLDER, TitledItem.TitledItemOrientation.NORTH);
        this.add(this.useSlaveServer);
        this.add(this.userName);
        this.add(this.password);
        this.add(this.ftpURL);
        this.add(this.port);
        this.add(this.folder);
        this.setLayout(new Layout());
    }

    @Override
    public String getInsertName() {
        return Words.SLAVE_SERVER;
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SlaveServerInsert.this.settings.commitThis(SlaveServerSettingsComplete.class);
                SlaveServerSettingsComplete s = (SlaveServerSettingsComplete)SlaveServerInsert.this.settings.getValue(SlaveServerSettingsComplete.class);
                s = (SlaveServerSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSlaveServer(s).getValue();
                SlaveServerInsert.this.settings.removeExistingValues();
                SlaveServerInsert.this.settings.setValue((Object)s, 0L);
                SlaveServerInsert.this.settings.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SlaveServerInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (SlaveServerInsert.this.useSlaveServer != null) {
                SlaveServerInsert.this.useSlaveServer.setLocation(border, border);
                SlaveServerInsert.this.useSlaveServer.setSize(SlaveServerInsert.this.useSlaveServer.getPreferredSize());
                SlaveServerInsert.this.userName.setLocation(border, (int)(SlaveServerInsert.this.useSlaveServer.getLocation().getY() + (double)SlaveServerInsert.this.useSlaveServer.getHeight() + (double)border));
                SlaveServerInsert.this.userName.setSize(SlaveServerInsert.this.userName.getPreferredSize());
                SlaveServerInsert.this.password.setLocation(border, (int)(SlaveServerInsert.this.userName.getLocation().getY() + (double)SlaveServerInsert.this.userName.getHeight() + (double)border));
                SlaveServerInsert.this.password.setSize(200, (int)SlaveServerInsert.this.password.getPreferredSize().getHeight());
                SlaveServerInsert.this.ftpURL.setLocation(border, (int)(SlaveServerInsert.this.password.getLocation().getY() + (double)SlaveServerInsert.this.password.getHeight() + (double)border));
                SlaveServerInsert.this.ftpURL.setSize(200, (int)SlaveServerInsert.this.ftpURL.getPreferredSize().getHeight());
                SlaveServerInsert.this.port.setLocation(border, SlaveServerInsert.this.ftpURL.getY() + SlaveServerInsert.this.ftpURL.getHeight() + border * 2);
                SlaveServerInsert.this.port.setSize(SlaveServerInsert.this.port.getPreferredSize());
                SlaveServerInsert.this.folder.setLocation(border, SlaveServerInsert.this.port.getY() + SlaveServerInsert.this.port.getHeight() + border * 2);
                SlaveServerInsert.this.folder.setSize(200, (int)SlaveServerInsert.this.folder.getPreferredSize().getHeight());
            }
        }
    }
}

