/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.articlepricecontract.details;

import ch.icit.pegasus.client.converter.ArticlePriceContractStateConverter;
import ch.icit.pegasus.client.converter.SupplierConverter;
import ch.icit.pegasus.client.converter.TaxZoneConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.icons.impl.EditOnAddOnlyIcon;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractComplete_;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractLight;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractStateE;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<ArticlePriceContractLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<Component> supplierSearch;
    private EditOnAddOnlyIcon editOnAddOnly;
    private TitledPeriodEditor periodEditor;
    private TitledItem<ComboBox> state;
    private TitledItem<RDCheckBox> isDayPriceContract;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<RDComboBox> taxZone;
    private TitledItem<RDCheckBox> useTaxZone;
    private boolean isExported = true;

    public SpecificationDetailsPanel(RowEditor<ArticlePriceContractLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.setCustomLayouter(new Layout());
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.addToView(this.number);
        if (editor.getModel().isAddRow()) {
            this.supplierSearch = new TitledItem<SearchTextField2<SupplierLight>>(SearchTextField2Factory.getSupplierSearchField(false, null), Words.SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
            this.editOnAddOnly = new EditOnAddOnlyIcon();
            this.addToView(this.editOnAddOnly);
        } else {
            this.supplierSearch = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(SupplierConverter.class)), Words.SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
        }
        this.addToView(this.supplierSearch);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.isDayPriceContract = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.DAY_PRICE_CONTRACT, TitledItem.TitledItemOrientation.EAST);
        this.addToView(this.isDayPriceContract);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)new PeriodComplete(), false, false);
        this.periodEditor = new TitledPeriodEditor((Node<PeriodComplete>)n, true, provider, ArticlePriceContractComplete_.contractPeriod);
        this.state = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(ArticlePriceContractStateConverter.class)), Words.STATE, TitledItem.TitledItemOrientation.NORTH);
        this.taxZone = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(TaxZoneConverter.class), true), Words.TAX_ZONE, TitledItem.TitledItemOrientation.NORTH);
        this.useTaxZone = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.USE_TAX_ZONE, TitledItem.TitledItemOrientation.EAST);
        this.addToView(this.periodEditor);
        this.addToView(this.state);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        this.addToView(this.taxZone);
        this.addToView(this.useTaxZone);
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.editor.getModel().isAddRow()) {
            ((SearchTextField2)this.supplierSearch.getElement()).requestFocusInWindowNow();
        } else {
            this.periodEditor.requestFocusInWindowNow();
        }
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        validationObjects.addAll(ValidationUtil.validatePeriod((Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{ArticlePriceContractComplete_.contractPeriod, PeriodComplete_.startDate}), (Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{ArticlePriceContractComplete_.contractPeriod, PeriodComplete_.endDate}), this.periodEditor));
        if (this.editor.getModel().isAddRow() && !((SearchTextField2)this.supplierSearch.getElement()).isItemSelected()) {
            ((SearchTextField2)this.supplierSearch.getElement()).setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_SUPPLIER_IS_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_LOCATION_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean isAccepted = this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.state).getValue() == ArticlePriceContractStateE.ACCPTED;
        this.number.setEnabled(isEnabled && !isAccepted);
        this.supplierSearch.setEnabled(isEnabled && !isAccepted);
        this.periodEditor.setEnabled(isEnabled && !this.isExported && !isAccepted);
        this.state.setEnabled(isEnabled && !isAccepted);
        this.isDayPriceContract.setEnabled(isEnabled && !isAccepted);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(isEnabled && !isAccepted);
        }
        this.taxZone.setEnabled(isEnabled && !isAccepted);
        this.useTaxZone.setEnabled(isEnabled && !isAccepted);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.editor != null && this.editor.getModel().getNode() != null && this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.exported) != null) {
            this.editor.getModel().getNode().getChildNamed(ArticlePriceContractComplete_.exported).removeNodeListener((NodeListener)this);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.state.kill();
        this.number.kill();
        this.supplierSearch.kill();
        this.periodEditor.kill();
        this.isDayPriceContract.kill();
        this.taxZone.kill();
        this.useTaxZone.kill();
        this.state = null;
        this.locations = null;
        this.number = null;
        this.supplierSearch = null;
        this.periodEditor = null;
        this.isDayPriceContract = null;
        this.taxZone = null;
        this.useTaxZone = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.supplierSearch);
        CheckedListAdder.addToList(focusList, this.isDayPriceContract);
        CheckedListAdder.addToList(focusList, this.periodEditor);
        CheckedListAdder.addToList(focusList, this.state);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.useTaxZone);
        CheckedListAdder.addToList(focusList, this.taxZone);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            ArticlePriceContractComplete dto = (ArticlePriceContractComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        if (this.editor.getModel().isAddRow()) {
            ((SearchTextField2)this.supplierSearch.getElement()).setNode(node.getChildNamed(ArticlePriceContractComplete_.supplier));
        } else {
            ((TextLabel)this.supplierSearch.getElement()).setNode(node.getChildNamed(ArticlePriceContractComplete_.supplier));
        }
        this.number.getElement().setNode(node.getChildNamed(ArticlePriceContractComplete_.number));
        if (node.getChildNamed(ArticlePriceContractComplete_.contractPeriod).getValue() == null) {
            PeriodComplete contractPeriod = new PeriodComplete();
            contractPeriod.setClientOId(Long.valueOf(contractPeriod.getNextId()));
            node.getChildNamed(ArticlePriceContractComplete_.contractPeriod).setValue((Object)contractPeriod, 0L);
        }
        if (node.getChildNamed(new DtoField[]{ArticlePriceContractComplete_.contractPeriod, PeriodComplete_.startDate}).getValue() == null) {
            Date startDate = DateChooser.getFirstDayOfMonthDate(System.currentTimeMillis());
            node.getChildNamed(new DtoField[]{ArticlePriceContractComplete_.contractPeriod, PeriodComplete_.startDate}).setValue((Object)startDate, 0L);
        }
        if (node.getChildNamed(new DtoField[]{ArticlePriceContractComplete_.contractPeriod, PeriodComplete_.endDate}).getValue() == null) {
            Date endDate = DateChooser.getLastDayOfMonthDate(System.currentTimeMillis());
            node.getChildNamed(new DtoField[]{ArticlePriceContractComplete_.contractPeriod, PeriodComplete_.endDate}).setValue((Object)endDate, 0L);
        }
        this.periodEditor.setStartDateNode(node.getChildNamed(new DtoField[]{ArticlePriceContractComplete_.contractPeriod, PeriodComplete_.startDate}));
        this.periodEditor.setEndDateNode(node.getChildNamed(new DtoField[]{ArticlePriceContractComplete_.contractPeriod, PeriodComplete_.endDate}));
        this.isDayPriceContract.getElement().setNode(node.getChildNamed(ArticlePriceContractComplete_.isDayPriceContract));
        this.state.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ArticlePriceContractStateE.class));
        this.state.getElement().setNode(node.getChildNamed(ArticlePriceContractComplete_.state));
        node.getChildNamed(ArticlePriceContractComplete_.exported).addNodeListener((NodeListener)this);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(ArticlePriceContractComplete_.eligibleLocations));
        }
        this.useTaxZone.getElement().setNode(node.getChildNamed(ArticlePriceContractComplete_.useTaxZone));
        this.taxZone.getElement().refreshPossibleValues(NodeToolkit.getAffixList(TaxZoneComplete.class));
        this.taxZone.getElement().setNode(node.getChildNamed(ArticlePriceContractComplete_.taxZone));
        Object exportedState = node.getChildNamed(ArticlePriceContractComplete_.exported).getValue();
        if (exportedState == null) {
            exportedState = false;
        }
        this.isExported = (Boolean)exportedState;
    }

    public void valueChanged(Node<?> node) {
        Object exportedState = node.getValue();
        if (exportedState == null) {
            exportedState = false;
        }
        this.isExported = (Boolean)exportedState;
        this.setEnabled(this.isEnabled());
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.periodEditor.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.isDayPriceContract.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.taxZone.getPreferredSize().getHeight());
            return new Dimension(0, h += SpecificationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - (2 * SpecificationDetailsPanel.this.horizontalBorder + SpecificationDetailsPanel.this.inner_horizontalBorder);
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            int tw = w / 3;
            if (tw > 150) {
                tw = 150;
            }
            SpecificationDetailsPanel.this.number.setSize(tw, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.supplierSearch.setLocation(SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.number.getY());
            if (SpecificationDetailsPanel.this.editor.getModel().isAddRow()) {
                SpecificationDetailsPanel.this.supplierSearch.setSize((int)((double)w - ((double)(4 * SpecificationDetailsPanel.this.horizontalBorder) + SpecificationDetailsPanel.this.editOnAddOnly.getPreferredSize().getWidth() + (double)SpecificationDetailsPanel.this.number.getWidth())), (int)SpecificationDetailsPanel.this.supplierSearch.getPreferredSize().getHeight());
                SpecificationDetailsPanel.this.editOnAddOnly.setLocation(SpecificationDetailsPanel.this.supplierSearch.getX() + SpecificationDetailsPanel.this.supplierSearch.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, (int)((double)(SpecificationDetailsPanel.this.supplierSearch.getY() + SpecificationDetailsPanel.this.supplierSearch.getHeight()) - SpecificationDetailsPanel.this.editOnAddOnly.getPreferredSize().getHeight()));
                SpecificationDetailsPanel.this.editOnAddOnly.setSize(SpecificationDetailsPanel.this.editOnAddOnly.getPreferredSize());
            } else {
                SpecificationDetailsPanel.this.supplierSearch.setSize(w - (3 * SpecificationDetailsPanel.this.horizontalBorder + SpecificationDetailsPanel.this.number.getWidth()), (int)SpecificationDetailsPanel.this.supplierSearch.getPreferredSize().getHeight());
            }
            SpecificationDetailsPanel.this.isDayPriceContract.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.number.getY() + SpecificationDetailsPanel.this.number.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.isDayPriceContract.setSize(SpecificationDetailsPanel.this.isDayPriceContract.getPreferredSize());
            SpecificationDetailsPanel.this.periodEditor.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.isDayPriceContract.getY() + SpecificationDetailsPanel.this.isDayPriceContract.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.periodEditor.setSize(SpecificationDetailsPanel.this.periodEditor.getPreferredSize());
            SpecificationDetailsPanel.this.state.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.periodEditor.getY() + SpecificationDetailsPanel.this.periodEditor.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.state.setSize(150, (int)SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.locations.setLocation(SpecificationDetailsPanel.this.state.getX() + SpecificationDetailsPanel.this.state.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.state.getY());
                SpecificationDetailsPanel.this.locations.setSize(150, (int)SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            }
            SpecificationDetailsPanel.this.useTaxZone.setLocation(SpecificationDetailsPanel.this.horizontalBorder, (int)((double)(SpecificationDetailsPanel.this.state.getY() + SpecificationDetailsPanel.this.state.getHeight() + SpecificationDetailsPanel.this.verticalBorder) + SpecificationDetailsPanel.this.taxZone.getPreferredSize().getHeight() - SpecificationDetailsPanel.this.useTaxZone.getPreferredSize().getHeight()));
            SpecificationDetailsPanel.this.useTaxZone.setSize(150, (int)SpecificationDetailsPanel.this.useTaxZone.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.taxZone.setLocation(SpecificationDetailsPanel.this.useTaxZone.getX() + SpecificationDetailsPanel.this.useTaxZone.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.state.getY() + SpecificationDetailsPanel.this.state.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.taxZone.setSize(150, (int)SpecificationDetailsPanel.this.taxZone.getPreferredSize().getHeight());
        }
    }
}

