/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.converter.RetailInMotionLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.SFTPDataExchangeSettingsPanel;
import ch.icit.pegasus.client.gui.utils.panels.TabbedItem;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.tabbed.TabButton;
import ch.icit.pegasus.client.gui.utils.tables.RetailInMotionImportSheetListTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.MailTypeE;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDataImportLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RetailInMotionFlightDataExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useRetailInMotionSync;
    private TitledItem<CheckBox> autoReceiveActive;
    private TitledItem<TextField> companyID;
    private TabbedItem<SFTPDataExchangeSettingsPanel> ftpConfigurations;
    private TitledItem<CheckBox> useFlightDayMatching;
    private TitledItem<CheckBox> useProductSupplierNoMatching;
    private TitledItem<CheckBox> useProductNameMatching;
    private TitledItem<CheckBox> addUnmatchedTransactionToAdHocFlight;
    private TitledItem<CheckBox> useStandardProducts;
    private TitledItem<SearchTextField2<StowingListTemplateComplete>> defaultAdHoc;
    private TitledItem<TextField> adHocDefaultFlightCode;
    private TitledItem<CheckBox> performTransactionsImmediately;
    private TitledItem<CheckBox> useTopUpMode;
    private TitledItem<CheckBox> enableCorrections;
    private TitledItem<CheckBox> autoTriggerFlightStockTransactions;
    private TitledItem<CheckBox> sendErrorNotification;
    private TitledItem<TextField> notificationAddress;
    private Node<List<RetailInMotionDataImportLight>> retailInMotionData;
    private TextLabel lastUpdates;
    private RetailInMotionImportSheetListTable history;
    private TablePanelAddSaveButton receiveButton;
    private TablePanelAddSaveButton saveButton;
    private TextButton resetLastReceiveDate;
    private final DataExchangeModule module;
    protected Node<RetailInMotionSettingsComplete> settings;
    protected RetailInMotionSettingsComplete rimsc;

    public RetailInMotionFlightDataExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useRetailInMotionSync = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionSettingsComplete_.useRetailInMotionInterface)), Words.ENABLE_RETAIL_IN_MOTION, TitledItem.TitledItemOrientation.EAST);
        this.useRetailInMotionSync.getElement().addButtonListener(this);
        this.autoReceiveActive = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionSettingsComplete_.autoReceiveData)), Words.AUTO_RECEIVE, TitledItem.TitledItemOrientation.EAST);
        this.ftpConfigurations = new TabbedItem<SFTPDataExchangeSettingsPanel>(){
            private static final long serialVersionUID = 1L;

            @Override
            public void updateFocusCycle() {
            }
        };
        int count = 1;
        Iterator it = this.settings.getChildNamed(RetailInMotionSettingsComplete_.receiveDataExchangeSettingsList).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node setting = (Node)it.next();
            SFTPDataExchangeSettingsPanel panel = new SFTPDataExchangeSettingsPanel();
            panel.setNode(setting);
            this.ftpConfigurations.addView(panel, new TabButton("Config " + count++));
        }
        this.companyID = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(RetailInMotionSettingsComplete_.companyID)), Words.RETAIL_IN_MOTION_COMPANY_ID, TitledItem.TitledItemOrientation.NORTH);
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(RetailInMotionLastUpdateConverter.class));
        this.enableCorrections = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionSettingsComplete_.enableCorrections)), Words.ENABLE_CORRECTIONS, TitledItem.TitledItemOrientation.EAST);
        this.autoTriggerFlightStockTransactions = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionSettingsComplete_.autoTriggerFlightStockTransactions)), Words.AUTO_TRIGGER_FLIGHT_UPDATE, TitledItem.TitledItemOrientation.EAST);
        this.useStandardProducts = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionSettingsComplete_.stowItemsAsStandards)), Words.USE_STANDARD_PRODUCTS, TitledItem.TitledItemOrientation.EAST);
        this.useFlightDayMatching = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionSettingsComplete_.useFlightDayMatch)), Words.USE_FLIGHT_DAY_MATCHING, TitledItem.TitledItemOrientation.EAST);
        this.useProductSupplierNoMatching = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionSettingsComplete_.useSupplierNoMatch)), Words.USE_PRODUCT_SUPPLIER_NO_MATCHING, TitledItem.TitledItemOrientation.EAST);
        this.useProductNameMatching = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionSettingsComplete_.useProductNameMatch)), Words.USE_PRODUCT_NAME_MATCHING, TitledItem.TitledItemOrientation.EAST);
        this.addUnmatchedTransactionToAdHocFlight = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionSettingsComplete_.addUnmatchedTransactionToAdHocFlight)), Words.ADD_UNMATCHED_TRANSACTION_TO_ADHOC_FLIGHT, TitledItem.TitledItemOrientation.EAST);
        this.performTransactionsImmediately = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionSettingsComplete_.performTransactionsImmediately)), Words.PERFORM_TRANSACTIONS_IMMEDIATELY, TitledItem.TitledItemOrientation.EAST);
        this.useTopUpMode = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionSettingsComplete_.topUpMode)), "Top Up Mode", TitledItem.TitledItemOrientation.EAST);
        this.adHocDefaultFlightCode = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(RetailInMotionSettingsComplete_.defaultAdHocFlightCode)), Words.DEFAULT_ADHOC_FLIGHT_CODE_PREFIX, TitledItem.TitledItemOrientation.NORTH);
        this.defaultAdHoc = new TitledItem<SearchTextField2<StowingListTemplateComplete>>(SearchTextField2Factory.getStowingTemplateSearchField(true, this.settings.getChildNamed(RetailInMotionSettingsComplete_.defaultAdHocStowing)), Words.DEFUALT_ADHOC_STOWING, TitledItem.TitledItemOrientation.NORTH);
        this.sendErrorNotification = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(RetailInMotionSettingsComplete_.sendErrorNotification)), "Send Error Notification", TitledItem.TitledItemOrientation.EAST);
        this.notificationAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(RetailInMotionSettingsComplete_.notificationAddress)), "Notification Address", TitledItem.TitledItemOrientation.NORTH);
        this.history = new RetailInMotionImportSheetListTable();
        this.history.setNode(this.retailInMotionData);
        this.resetLastReceiveDate = new TextButton("Reset last receive Date");
        this.resetLastReceiveDate.setProgress(1.0f);
        this.resetLastReceiveDate.addButtonListener(this);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.receiveButton = new TablePanelAddSaveButton();
        this.receiveButton.setText(Words.RECEIVE);
        this.receiveButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useRetailInMotionSync);
        this.configPanel.add(this.autoReceiveActive);
        this.configPanel.add(this.companyID);
        this.configPanel.add(this.ftpConfigurations);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.resetLastReceiveDate);
        this.configPanel.add(this.useFlightDayMatching);
        this.configPanel.add(this.enableCorrections);
        this.configPanel.add(this.autoTriggerFlightStockTransactions);
        this.configPanel.add(this.useProductSupplierNoMatching);
        this.configPanel.add(this.useProductNameMatching);
        this.configPanel.add(this.addUnmatchedTransactionToAdHocFlight);
        this.configPanel.add(this.defaultAdHoc);
        this.configPanel.add(this.adHocDefaultFlightCode);
        this.configPanel.add(this.useStandardProducts);
        this.configPanel.add(this.performTransactionsImmediately);
        this.configPanel.add(this.useTopUpMode);
        this.configPanel.add(this.sendErrorNotification);
        this.configPanel.add(this.notificationAddress);
        this.sendPanel.add(this.history);
        this.sendPanel.add(this.receiveButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RetailInMotionSettingsComplete s;
                StaticEnumServiceManager.getAllTimeDurations();
                try {
                    RetailInMotionFlightDataExchangeInsert.this.rimsc = (RetailInMotionSettingsComplete)((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (RetailInMotionFlightDataExchangeInsert.this.rimsc == null) {
                    s = new RetailInMotionSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    RetailInMotionFlightDataExchangeInsert.this.rimsc = s;
                }
                if (RetailInMotionFlightDataExchangeInsert.this.rimsc.getReceiveDataExchangeSettingsList().isEmpty()) {
                    s = new SFTPDataExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(SFTPDataExchangeSettingsComplete.getNextId()));
                    s.setLastDataTransaction(new Timestamp(0L));
                    RetailInMotionFlightDataExchangeInsert.this.rimsc.getReceiveDataExchangeSettingsList().add(s);
                    s = new SFTPDataExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(SFTPDataExchangeSettingsComplete.getNextId()));
                    s.setLastDataTransaction(new Timestamp(0L));
                    RetailInMotionFlightDataExchangeInsert.this.rimsc.getReceiveDataExchangeSettingsList().add(s);
                }
                for (SFTPDataExchangeSettingsComplete ftpList : RetailInMotionFlightDataExchangeInsert.this.rimsc.getReceiveDataExchangeSettingsList()) {
                    if (ftpList.getLoginPwd() != null) continue;
                    ftpList.setLoginPwd(new EncryptedStringComplete());
                }
                RetailInMotionFlightDataExchangeInsert.this.rimsc.setTimerServiceSettings(RetailInMotionFlightDataExchangeInsert.this.createTimerService());
                RetailInMotionFlightDataExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)RetailInMotionFlightDataExchangeInsert.this.rimsc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                RetailInMotionFlightDataExchangeInsert.this.retailInMotionData = (Node)new ViewNode("data");
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return RetailInMotionFlightDataExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        s.setTimerServiceConfig((TimerServiceConfigComplete)new TimeDurationComplete(TimeUnitE.MINUTE, Double.valueOf(20.0)));
        s.setIntervallRateUnit(TimeUnitE.MINUTE);
        s.setIntervallRateValue(Double.valueOf(60.0));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useRetailInMotionSync.setEnabled(isEnabled);
            boolean b = isEnabled && this.useRetailInMotionSync.getElement().isChecked();
            this.receiveButton.setEnabled(b);
            this.autoReceiveActive.setEnabled(b);
            this.ftpConfigurations.setEnabled(b);
            this.companyID.setEnabled(b);
            this.useFlightDayMatching.setEnabled(b);
            this.enableCorrections.setEnabled(b);
            this.autoTriggerFlightStockTransactions.setEnabled(b);
            this.useProductSupplierNoMatching.setEnabled(b);
            this.useProductNameMatching.setEnabled(b);
            this.defaultAdHoc.setEnabled(b);
            this.adHocDefaultFlightCode.setEnabled(b);
            this.useStandardProducts.setEnabled(b);
            this.sendErrorNotification.setEnabled(b);
            this.notificationAddress.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.history.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            this.resetLastReceiveDate.setEnabled(b);
            this.addUnmatchedTransactionToAdHocFlight.setEnabled(b);
            this.performTransactionsImmediately.setEnabled(b);
            this.useTopUpMode.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.ftpConfigurations.kill();
            this.autoReceiveActive.kill();
            this.history.kill();
            this.adHocDefaultFlightCode.kill();
            this.adHocDefaultFlightCode = null;
            this.addUnmatchedTransactionToAdHocFlight.kill();
            this.addUnmatchedTransactionToAdHocFlight = null;
            this.sendErrorNotification.kill();
            this.notificationAddress.kill();
            this.sendErrorNotification = null;
            this.notificationAddress = null;
            this.useStandardProducts.kill();
            this.useStandardProducts = null;
            this.defaultAdHoc.kill();
            this.defaultAdHoc = null;
            this.companyID.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.useRetailInMotionSync.kill();
            this.resetLastReceiveDate.kill();
            this.resetLastReceiveDate = null;
            this.useFlightDayMatching.kill();
            this.useFlightDayMatching = null;
            this.enableCorrections.kill();
            this.enableCorrections = null;
            this.autoTriggerFlightStockTransactions.kill();
            this.autoTriggerFlightStockTransactions = null;
            this.useProductSupplierNoMatching.kill();
            this.useProductSupplierNoMatching = null;
            this.useProductNameMatching.kill();
            this.useProductNameMatching = null;
            this.performTransactionsImmediately.kill();
            this.performTransactionsImmediately = null;
            this.useTopUpMode.kill();
            this.useTopUpMode = null;
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.receiveButton = null;
        this.ftpConfigurations = null;
        this.history = null;
        this.autoReceiveActive = null;
        this.lastUpdates = null;
        this.companyID = null;
        this.saveButton = null;
        this.useRetailInMotionSync = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.RETAIL_INMOTION;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.receiveButton || source == this.saveButton) {
            this.setEnabled(false);
            if (source == this.receiveButton) {
                this.ensureAnimation(Words.EXCHANGE_DATA_WITH_RETAIL_IN_MOTION);
                this.processFiles();
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateRetailinMotionConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else if (source == this.resetLastReceiveDate) {
            Iterator it = this.settings.getChildNamed(RetailInMotionSettingsComplete_.receiveDataExchangeSettingsList).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                n.getChildNamed(SFTPDataExchangeSettingsComplete_.lastDataTransaction).setValue((Object)new Timestamp(0L), 0L);
            }
            this.settings.commit();
            this.lastUpdates.setNode((Node)this.settings);
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateRetailinMotionConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                RetailInMotionFlightDataExchangeInsert.this.settings.commit(RetailInMotionSettingsComplete.class);
                RetailInMotionSettingsComplete rimsc = (RetailInMotionSettingsComplete)RetailInMotionFlightDataExchangeInsert.this.settings.getValue();
                for (SFTPDataExchangeSettingsComplete sftpDataExchangeSettingsComplete : rimsc.getReceiveDataExchangeSettingsList()) {
                    sftpDataExchangeSettingsComplete.setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                }
                if (rimsc != null && Boolean.TRUE.equals(rimsc.getUseRetailInMotionInterface())) {
                    rimsc.setTimerServiceSettings(RetailInMotionFlightDataExchangeInsert.this.createTimerService());
                    RetailInMotionSettingsComplete retailInMotion = rimsc = (RetailInMotionSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                    retailInMotion.setMailType(MailTypeE.SendMail);
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(retailInMotion.getTimerServiceSettings()).getValue();
                    retailInMotion.setTimerServiceSettings(ts);
                    retailInMotion = (RetailInMotionSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)retailInMotion).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.RETAIL_INMOTION_RECEIVE_DATA, retailInMotion.getAutoReceiveData().booleanValue(), ts, -1L);
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    RetailInMotionFlightDataExchangeInsert.this.retailInMotionData = (Node)new ViewNode("");
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsc, false, false);
                    RetailInMotionFlightDataExchangeInsert.this.lastUpdates.setNode(settings);
                    RetailInMotionFlightDataExchangeInsert.this.history.setNode(RetailInMotionFlightDataExchangeInsert.this.retailInMotionData);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.RETAIL_INMOTION_RECEIVE_DATA);
                    rimsc = (RetailInMotionSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsc).getValue();
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    RetailInMotionFlightDataExchangeInsert.this.retailInMotionData = (Node)new ViewNode("data");
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsc, false, false);
                    RetailInMotionFlightDataExchangeInsert.this.lastUpdates.setNode(settings);
                    RetailInMotionFlightDataExchangeInsert.this.history.setNode(RetailInMotionFlightDataExchangeInsert.this.retailInMotionData);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        RetailInMotionFlightDataExchangeInsert.this.hideAnimation();
                        RetailInMotionFlightDataExchangeInsert.this.module.ended();
                        RetailInMotionFlightDataExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)RetailInMotionFlightDataExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).readRetailInMotionData();
                n.setValue((Object)true, 0L);
                RetailInMotionFlightDataExchangeInsert.this.rimsc = (RetailInMotionSettingsComplete)((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionSettings().getValue();
                RetailInMotionFlightDataExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)RetailInMotionFlightDataExchangeInsert.this.rimsc, false, false);
                RetailInMotionFlightDataExchangeInsert.this.lastUpdates.setNode((Node)RetailInMotionFlightDataExchangeInsert.this.settings);
                RetailInMotionFlightDataExchangeInsert.this.history.setNode(RetailInMotionFlightDataExchangeInsert.this.retailInMotionData);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        RetailInMotionFlightDataExchangeInsert.this.hideAnimation();
                        RetailInMotionFlightDataExchangeInsert.this.module.ended();
                        RetailInMotionFlightDataExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, RetailInMotionFlightDataExchangeInsert.this.receiveButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_CREATE_RETAIL_IN_MOTION_IMPORT, (Component)RetailInMotionFlightDataExchangeInsert.this.receiveButton);
                        RetailInMotionFlightDataExchangeInsert.this.hideAnimation();
                        RetailInMotionFlightDataExchangeInsert.this.setEnabled(true);
                        RetailInMotionFlightDataExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            RetailInMotionFlightDataExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            RetailInMotionFlightDataExchangeInsert.this.useRetailInMotionSync.setLocation(border, border + RetailInMotionFlightDataExchangeInsert.this.configPanel.getTitleHeight());
            RetailInMotionFlightDataExchangeInsert.this.useRetailInMotionSync.setSize(RetailInMotionFlightDataExchangeInsert.this.useRetailInMotionSync.getPreferredSize());
            RetailInMotionFlightDataExchangeInsert.this.autoReceiveActive.setLocation(border, RetailInMotionFlightDataExchangeInsert.this.useRetailInMotionSync.getY() + RetailInMotionFlightDataExchangeInsert.this.useRetailInMotionSync.getHeight());
            RetailInMotionFlightDataExchangeInsert.this.autoReceiveActive.setSize(RetailInMotionFlightDataExchangeInsert.this.autoReceiveActive.getPreferredSize());
            RetailInMotionFlightDataExchangeInsert.this.companyID.setLocation(border, RetailInMotionFlightDataExchangeInsert.this.autoReceiveActive.getY() + RetailInMotionFlightDataExchangeInsert.this.autoReceiveActive.getHeight() + border);
            RetailInMotionFlightDataExchangeInsert.this.companyID.setSize(220, (int)RetailInMotionFlightDataExchangeInsert.this.companyID.getPreferredSize().getHeight());
            RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.setLocation(border, RetailInMotionFlightDataExchangeInsert.this.companyID.getY() + RetailInMotionFlightDataExchangeInsert.this.companyID.getHeight() + border);
            RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.setSize(parent.getWidth() - 2 * border, (int)RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getPreferredSize().getHeight());
            RetailInMotionFlightDataExchangeInsert.this.enableCorrections.setLocation(RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getX(), RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getY() + RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getHeight() + border * 2);
            RetailInMotionFlightDataExchangeInsert.this.enableCorrections.setSize(RetailInMotionFlightDataExchangeInsert.this.enableCorrections.getPreferredSize());
            RetailInMotionFlightDataExchangeInsert.this.autoTriggerFlightStockTransactions.setLocation(RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getX(), RetailInMotionFlightDataExchangeInsert.this.enableCorrections.getY() + RetailInMotionFlightDataExchangeInsert.this.enableCorrections.getHeight());
            RetailInMotionFlightDataExchangeInsert.this.autoTriggerFlightStockTransactions.setSize(RetailInMotionFlightDataExchangeInsert.this.autoTriggerFlightStockTransactions.getPreferredSize());
            RetailInMotionFlightDataExchangeInsert.this.useFlightDayMatching.setLocation(RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getX(), RetailInMotionFlightDataExchangeInsert.this.autoTriggerFlightStockTransactions.getY() + RetailInMotionFlightDataExchangeInsert.this.autoTriggerFlightStockTransactions.getHeight());
            RetailInMotionFlightDataExchangeInsert.this.useFlightDayMatching.setSize(RetailInMotionFlightDataExchangeInsert.this.useFlightDayMatching.getPreferredSize());
            RetailInMotionFlightDataExchangeInsert.this.useProductSupplierNoMatching.setLocation(RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getX(), RetailInMotionFlightDataExchangeInsert.this.useFlightDayMatching.getY() + RetailInMotionFlightDataExchangeInsert.this.useFlightDayMatching.getHeight());
            RetailInMotionFlightDataExchangeInsert.this.useProductSupplierNoMatching.setSize(RetailInMotionFlightDataExchangeInsert.this.useProductSupplierNoMatching.getPreferredSize());
            RetailInMotionFlightDataExchangeInsert.this.useProductNameMatching.setLocation(RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getX(), RetailInMotionFlightDataExchangeInsert.this.useProductSupplierNoMatching.getY() + RetailInMotionFlightDataExchangeInsert.this.useProductSupplierNoMatching.getHeight());
            RetailInMotionFlightDataExchangeInsert.this.useProductNameMatching.setSize(RetailInMotionFlightDataExchangeInsert.this.useProductNameMatching.getPreferredSize());
            RetailInMotionFlightDataExchangeInsert.this.addUnmatchedTransactionToAdHocFlight.setLocation(RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getX(), RetailInMotionFlightDataExchangeInsert.this.useProductNameMatching.getY() + RetailInMotionFlightDataExchangeInsert.this.useProductNameMatching.getHeight());
            RetailInMotionFlightDataExchangeInsert.this.addUnmatchedTransactionToAdHocFlight.setSize(RetailInMotionFlightDataExchangeInsert.this.addUnmatchedTransactionToAdHocFlight.getPreferredSize());
            RetailInMotionFlightDataExchangeInsert.this.useStandardProducts.setLocation(RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getX(), RetailInMotionFlightDataExchangeInsert.this.addUnmatchedTransactionToAdHocFlight.getY() + RetailInMotionFlightDataExchangeInsert.this.addUnmatchedTransactionToAdHocFlight.getHeight());
            RetailInMotionFlightDataExchangeInsert.this.useStandardProducts.setSize(RetailInMotionFlightDataExchangeInsert.this.useStandardProducts.getPreferredSize());
            RetailInMotionFlightDataExchangeInsert.this.performTransactionsImmediately.setLocation(RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getX(), RetailInMotionFlightDataExchangeInsert.this.useStandardProducts.getY() + RetailInMotionFlightDataExchangeInsert.this.useStandardProducts.getHeight());
            RetailInMotionFlightDataExchangeInsert.this.performTransactionsImmediately.setSize(RetailInMotionFlightDataExchangeInsert.this.performTransactionsImmediately.getPreferredSize());
            RetailInMotionFlightDataExchangeInsert.this.useTopUpMode.setLocation(RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getX(), RetailInMotionFlightDataExchangeInsert.this.performTransactionsImmediately.getY() + RetailInMotionFlightDataExchangeInsert.this.performTransactionsImmediately.getHeight() + border);
            RetailInMotionFlightDataExchangeInsert.this.useTopUpMode.setSize(400, (int)RetailInMotionFlightDataExchangeInsert.this.useTopUpMode.getPreferredSize().getHeight());
            RetailInMotionFlightDataExchangeInsert.this.sendErrorNotification.setLocation(RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getX(), RetailInMotionFlightDataExchangeInsert.this.useTopUpMode.getY() + RetailInMotionFlightDataExchangeInsert.this.useTopUpMode.getHeight() + border);
            RetailInMotionFlightDataExchangeInsert.this.sendErrorNotification.setSize(RetailInMotionFlightDataExchangeInsert.this.sendErrorNotification.getPreferredSize());
            RetailInMotionFlightDataExchangeInsert.this.notificationAddress.setLocation(RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getX(), RetailInMotionFlightDataExchangeInsert.this.sendErrorNotification.getY() + RetailInMotionFlightDataExchangeInsert.this.sendErrorNotification.getHeight() + border);
            RetailInMotionFlightDataExchangeInsert.this.notificationAddress.setSize(400, (int)RetailInMotionFlightDataExchangeInsert.this.notificationAddress.getPreferredSize().getHeight());
            RetailInMotionFlightDataExchangeInsert.this.defaultAdHoc.setLocation(RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getX(), RetailInMotionFlightDataExchangeInsert.this.notificationAddress.getY() + RetailInMotionFlightDataExchangeInsert.this.notificationAddress.getHeight() + border);
            RetailInMotionFlightDataExchangeInsert.this.defaultAdHoc.setSize(400, (int)RetailInMotionFlightDataExchangeInsert.this.defaultAdHoc.getPreferredSize().getHeight());
            RetailInMotionFlightDataExchangeInsert.this.adHocDefaultFlightCode.setLocation(RetailInMotionFlightDataExchangeInsert.this.ftpConfigurations.getX(), RetailInMotionFlightDataExchangeInsert.this.defaultAdHoc.getY() + RetailInMotionFlightDataExchangeInsert.this.defaultAdHoc.getHeight());
            RetailInMotionFlightDataExchangeInsert.this.adHocDefaultFlightCode.setSize(400, (int)RetailInMotionFlightDataExchangeInsert.this.adHocDefaultFlightCode.getPreferredSize().getHeight());
            RetailInMotionFlightDataExchangeInsert.this.lastUpdates.setLocation(border, RetailInMotionFlightDataExchangeInsert.this.adHocDefaultFlightCode.getY() + RetailInMotionFlightDataExchangeInsert.this.adHocDefaultFlightCode.getHeight());
            RetailInMotionFlightDataExchangeInsert.this.lastUpdates.setSize(RetailInMotionFlightDataExchangeInsert.this.lastUpdates.getPreferredSize());
            RetailInMotionFlightDataExchangeInsert.this.resetLastReceiveDate.setLocation(RetailInMotionFlightDataExchangeInsert.this.lastUpdates.getX() + RetailInMotionFlightDataExchangeInsert.this.lastUpdates.getWidth() + border, RetailInMotionFlightDataExchangeInsert.this.lastUpdates.getY());
            RetailInMotionFlightDataExchangeInsert.this.resetLastReceiveDate.setSize(RetailInMotionFlightDataExchangeInsert.this.resetLastReceiveDate.getPreferredSize());
            RetailInMotionFlightDataExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - RetailInMotionFlightDataExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + RetailInMotionFlightDataExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            RetailInMotionFlightDataExchangeInsert.this.saveButton.setSize(RetailInMotionFlightDataExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            RetailInMotionFlightDataExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            RetailInMotionFlightDataExchangeInsert.this.history.setLocation(0, RetailInMotionFlightDataExchangeInsert.this.sendPanel.getTitleHeight());
            RetailInMotionFlightDataExchangeInsert.this.history.setSize(parent.getWidth(), RetailInMotionFlightDataExchangeInsert.this.sendPanel.getHeight() - (border + RetailInMotionFlightDataExchangeInsert.this.sendPanel.getTitleHeight() + 100));
            RetailInMotionFlightDataExchangeInsert.this.receiveButton.setLocation((int)((double)parent.getWidth() - RetailInMotionFlightDataExchangeInsert.this.receiveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (RetailInMotionFlightDataExchangeInsert.this.receiveButton.getPreferredSize().getHeight() + (double)border)));
            RetailInMotionFlightDataExchangeInsert.this.receiveButton.setSize(RetailInMotionFlightDataExchangeInsert.this.receiveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (RetailInMotionFlightDataExchangeInsert.this.animation != null) {
                RetailInMotionFlightDataExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - RetailInMotionFlightDataExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - RetailInMotionFlightDataExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                RetailInMotionFlightDataExchangeInsert.this.animation.setSize(RetailInMotionFlightDataExchangeInsert.this.animation.getPreferredSize());
            }
            if (RetailInMotionFlightDataExchangeInsert.this.isInserted) {
                RetailInMotionFlightDataExchangeInsert.this.configPanel.setLocation(border, border);
                RetailInMotionFlightDataExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                RetailInMotionFlightDataExchangeInsert.this.sendPanel.setLocation(RetailInMotionFlightDataExchangeInsert.this.configPanel.getX() + RetailInMotionFlightDataExchangeInsert.this.configPanel.getWidth() + border, border);
                RetailInMotionFlightDataExchangeInsert.this.sendPanel.setSize(RetailInMotionFlightDataExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

