/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.FlightCategoryConverter;
import ch.icit.pegasus.client.converter.FlightReturnsCountStateConverter;
import ch.icit.pegasus.client.converter.FlightStateEWithWarningConverter;
import ch.icit.pegasus.client.converter.FlightTypeConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.LegFromAirportConverter;
import ch.icit.pegasus.client.converter.LegToAirportConverter;
import ch.icit.pegasus.client.converter.LogTimeConverter;
import ch.icit.pegasus.client.converter.LogUserConverter;
import ch.icit.pegasus.client.converter.PaxFigureTypeConverter;
import ch.icit.pegasus.client.converter.RetailInMotionCheckinBooleanConverter;
import ch.icit.pegasus.client.converter.RetailInMotionCheckoutBooleanConverter;
import ch.icit.pegasus.client.converter.RetailInMotionHasTransactionsBooleanConverter;
import ch.icit.pegasus.client.converter.RetailInMotionImportStateConverter;
import ch.icit.pegasus.client.converter.RetailInMotionTransactionStateConverter;
import ch.icit.pegasus.client.converter.StockIrregularityConverter;
import ch.icit.pegasus.client.converter.StowingListAircraftConverter;
import ch.icit.pegasus.client.converter.StowingListNameConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.flight.FlightModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.flight.details.AdHocFlightDataDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.AdHocStwDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.AdditionalOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.AlaCarteMenusDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.BondedEquipmentSealsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.CustomsDocumentsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.DelaysDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.EditPaxDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.FlightStateDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.GalleyLoadingDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.RegularOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.RemarkDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SealDefinitionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SpecialMenusDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.TimeDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.TrucksDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.HandlingCostDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.StowingListDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.InputMessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.MiniComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.minicombobox.MiniComboBoxConfiguration;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiHaulTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionPanel;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.ConfigurableSearchTextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.FlightSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.EdelweissSettingsComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ReturnsCountStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.IStowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.AFlightAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.search.FlightScheduleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchTypeE;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.TrolleyScanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class FlightModule
extends ScreenTableView<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_STATE = "flight_state";
    private static final String FILTER_PERIOD = "flight_period";
    private static final String FILTER_CARRIER = "flight_carrier";
    private static final String FILTER_LAST_UPDATE = "flight_last_update";
    private static final String FILTER_STOWAGE_TYPE = "flight_stowage_type";
    private static final String FILTER_AUTOCHECKOUT = "flight_autocheckout";
    private static final String FILTER_HAUL_TYPE = "flightHaulType";
    private static final String FILTER_HAS_STOCK_TRANSACTION = "hasStockTransactions";
    private static final String FILTER_HAS_IRREGLARITY = "hasIrregularity";
    private static final String FILTER_RC_STATE = "rcState";
    private static final String FILTER_FLIGHT_CAT = "category";
    private static final String FILTER_HAS_SUBSTITUTIONS = "hasSubstitutions";
    private static final String FILTER_AIS_NEEDED = "aisPrintNeeded";
    private static final String FILTER_SELECTED_PAX = "selectedPax";
    private static final String FILTER_STOWING_LIST = "stowingList";
    private static final String FILTER_NUMBER_CUSDOCID = "Number_CustumsDocumentId";
    private static final String FITLER_RIM_CHECKOUT_DONE = "RimCheckoutOut";
    private static final String FITLER_RIM_CHECKIN_DONE = "RimCheckoutIn";
    private static final String FILTER_DELIVERY_AIRPORT = "DeliveryAirport";
    private static final String FILTER_HAS_RETAIL_IN_MOTION_DATA = "hasRetailInMotionData";
    private static final String FILTER_CHECKOUT_PERFORMED = "CheckoutPerformed";
    private static final String FILTER_EDELWEISS_PAX_UPDATE = "edelweissPaxUpdate";
    private static final String FILTER_FLIGHT_ORDER_RECEIVED = "flightOrderReceived";
    private static String WITHIN_HOUR = "WITHIN 1 HOUR";
    private static String WITHIN_4_HOURS = "WITHIN 4 HOURS";
    private static String WITHIN_8_HOURS = "WITHIN 8 HOURS";
    private String filterCriteria1;
    private FlightStateE filterCriteria2;
    private PeriodComplete filterCriteria3;
    private CustomerLight filterCriteria4;
    private TimestampPeriodComplete filterCriteria5;
    private FlightSearchConfiguration.STOWAGE_TYPE_COLUMN filterCriteria6 = FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.ALL;
    private Boolean autoCheckout = null;
    private List<HaulTypeComplete> haulType;
    private Boolean onlyOpenFlights = false;
    private Boolean ignoreCancelledFlights = false;
    private Boolean hasIrregularity;
    private Boolean hasStockTransactions;
    private ReturnsCountStateE rcState;
    private FlightCategoryComplete flightCategoryFilter;
    private Boolean hasSubstitutions;
    private Boolean aisPrintNeeded;
    private PaxFigureTypeComplete filterPaxType;
    private StowingListTemplateComplete filterStowingList;
    private Boolean hasRetailInMotionData;
    private FlightSearchTypeE filterCriteria11;
    private Boolean rimCheckoutDoneCriteria;
    private Boolean rimCheckinDoneCriteria;
    private Boolean checkoutPerformedCriteria;
    private AirportComplete selectedDeliveryAirport;
    private Boolean edelweissPaxUpdateCriteria;
    private Boolean flightOrderReceivedCriteria;
    private TitledPeriodEditor periodeditor;
    public static IStowingListLight currentStowingList;
    private ComboBox stateCombo;
    private ComboBox stowageTypeCombo;
    private ComboBox lastUpdateCombo;
    private ComboBox autoCheckoutCombo;
    private MultiSelectionPanel<MultiHaulTypeSelectionComboBox> haulPanel;
    private ComboBox rcCombo;
    private ComboBox substitutionCombo;
    private ComboBox hasTransactions;
    private ComboBox hasStockIrregularity;
    private ComboBox periodSearchMode;
    private Boolean haultypeActivated = Boolean.FALSE;
    private ComboBox flightCategories;
    private ComboBox aisPrintBox;
    private ComboBox selectedPaxType;
    private ComboBox retailInMotionData;
    private boolean filterShowFinalPax;
    private ComboBox rimCheckoutDone;
    private ComboBox rimCheckinDone;
    private ComboBox checkoutPerformed;
    private ComboBox edelweissPaxUpdateBox;
    private ComboBox flightOrderReceivedBox;

    public FlightModule() {
        super(FlightLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.periodeditor.kill();
        this.stateCombo.kill();
        if (this.stowageTypeCombo != null) {
            this.stowageTypeCombo.kill();
        }
        if (this.lastUpdateCombo != null) {
            this.lastUpdateCombo.kill();
        }
        if (this.autoCheckout != null) {
            this.autoCheckoutCombo.kill();
        }
        if (this.haulPanel != null) {
            this.haulPanel.kill();
        }
        if (this.rcCombo != null) {
            this.rcCombo.kill();
        }
        if (this.hasTransactions != null) {
            this.hasTransactions.kill();
        }
        if (this.hasStockIrregularity != null) {
            this.hasStockIrregularity.kill();
        }
        this.periodSearchMode.kill();
        if (this.flightCategories != null) {
            this.flightCategories.kill();
        }
        if (this.aisPrintBox != null) {
            this.aisPrintBox.kill();
        }
        if (this.selectedPaxType != null) {
            this.selectedPaxType.kill();
        }
        if (this.retailInMotionData != null) {
            this.retailInMotionData.kill();
        }
        this.retailInMotionData = null;
        if (this.substitutionCombo != null) {
            this.substitutionCombo.kill();
        }
        if (this.substitutionCombo != null) {
            this.substitutionCombo = null;
        }
        if (this.rimCheckoutDone != null) {
            this.rimCheckoutDone.kill();
        }
        if (this.rimCheckoutDone != null) {
            this.rimCheckoutDone = null;
        }
        if (this.rimCheckinDone != null) {
            this.rimCheckinDone.kill();
        }
        if (this.rimCheckinDone != null) {
            this.rimCheckinDone = null;
        }
        if (this.checkoutPerformed != null) {
            this.checkoutPerformed.kill();
        }
        if (this.checkoutPerformed != null) {
            this.checkoutPerformed = null;
        }
        if (this.edelweissPaxUpdateBox != null) {
            this.edelweissPaxUpdateBox.kill();
        }
        if (this.flightOrderReceivedBox != null) {
            this.flightOrderReceivedBox.kill();
        }
        this.edelweissPaxUpdateBox = null;
        this.periodeditor = null;
        this.stateCombo = null;
        this.stowageTypeCombo = null;
        this.lastUpdateCombo = null;
        this.autoCheckoutCombo = null;
        this.haulPanel = null;
        this.rcCombo = null;
        this.hasTransactions = null;
        this.hasStockIrregularity = null;
        this.periodSearchMode = null;
        this.flightCategories = null;
        this.aisPrintBox = null;
        this.selectedPaxType = null;
        this.flightOrderReceivedBox = null;
    }

    private boolean showAutoCheckoutColumns() {
        return ((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getAutoCheckout();
    }

    private boolean showAdditionalStateColumns() {
        return this.showRetailInMotionColumns();
    }

    private boolean showLimeFlightUpdate() {
        EdelweissSettingsComplete edwSettings = (EdelweissSettingsComplete)NodeToolkit.getAffixClass(EdelweissSettingsComplete.class).getValue();
        return Boolean.TRUE.equals(edwSettings.getShowLimeFlightColumns());
    }

    private boolean showReturnCounts() {
        return false;
    }

    private boolean showRetailInMotionColumns() {
        RetailInMotionSettingsComplete rimSettings = (RetailInMotionSettingsComplete)NodeToolkit.getAffixClass(RetailInMotionSettingsComplete.class).getValue();
        return rimSettings != null && Boolean.TRUE.equals(rimSettings.getUseRetailInMotionInterface());
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return FlightAccess.MODULE_FLIGHT;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.OUTBOUND_CODE + "<>" + true);
        c.addProperty(FILTER_PERIOD, FilterChainConfiguration.getDefaultSearchPeriodString());
        return c;
    }

    @Override
    protected boolean showDeletedComboBox() {
        return false;
    }

    @Override
    protected void createFilterChain(long id) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean isFpb = CompanyUtil.isFPB((SystemSettingsComplete)settings);
        MiniComboBoxConfiguration mcbc = new MiniComboBoxConfiguration(FlightSearchTypeE.FLIGHT_CODE);
        MiniComboBox mcomboBox = new MiniComboBox();
        mcomboBox.setVisible(true);
        mcomboBox.addItem(FlightSearchTypeE.FLIGHT_CODE, mcbc.getPicture(FlightSearchTypeE.FLIGHT_CODE));
        mcomboBox.addItem(FlightSearchTypeE.CUSTOMS_DOCUMENT_ID, mcbc.getPicture(FlightSearchTypeE.CUSTOMS_DOCUMENT_ID));
        mcomboBox.setSelectedItem(FlightSearchTypeE.FLIGHT_CODE);
        this.filterChain.addConfigurableSearchField(FILTER_NUMBER_CUSDOCID, Words.FLIGHT_NUMBER, "", mcomboBox);
        this.filterChain.setDefaultComboWidth(100);
        this.filterChain.overrideDefaultComboBoxWidth(140);
        this.filterChain.overrideDefaultSearchBoxWidth(140);
        this.filterChain.overrideDefaultSearchField2Width(130);
        RetailInMotionSettingsComplete rimSettings = (RetailInMotionSettingsComplete)NodeToolkit.getAffixClass(RetailInMotionSettingsComplete.class).getValue();
        boolean autoCheckout = settings.getAutoCheckout();
        boolean isRetailInMotion = Boolean.TRUE.equals(rimSettings.getUseRetailInMotionInterface());
        boolean isCheckout = Boolean.TRUE.equals(rimSettings.getUseRetailInMotionInterface()) && Boolean.TRUE.equals(rimSettings.getAutoReceiveData());
        this.stateCombo = ComboBoxFactory.getFlightStateComboBox(true);
        this.stateCombo.setSelectedItem(Words.ALL);
        this.flightCategories = new ComboBox(null, null, ConverterRegistry.getConverter(FlightCategoryConverter.class));
        this.selectedPaxType = new ComboBox(null, null, ConverterRegistry.getConverter(PaxFigureTypeConverter.class));
        this.lastUpdateCombo = new ComboBox();
        this.lastUpdateCombo.addItem(Words.ALL);
        this.lastUpdateCombo.addItem(WITHIN_HOUR);
        this.lastUpdateCombo.addItem(WITHIN_4_HOURS);
        this.lastUpdateCombo.addItem(WITHIN_8_HOURS);
        this.lastUpdateCombo.setSelectedItem(Words.ALL);
        this.stowageTypeCombo = ComboBoxFactory.getStowageTypeComboBox(true);
        if (autoCheckout) {
            this.autoCheckoutCombo = ComboBoxFactory.getOffOnComboBox(true);
        }
        this.rcCombo = ComboBoxFactory.getReturnCountStateComboBox(true);
        if (autoCheckout) {
            this.hasTransactions = ComboBoxFactory.getYesNoComboBox(true);
            this.hasStockIrregularity = ComboBoxFactory.getYesNoComboBox(true);
        }
        if (isRetailInMotion) {
            this.retailInMotionData = ComboBoxFactory.getYesNoComboBox(true);
            this.rimCheckoutDone = ComboBoxFactory.getYesNoComboBox(true);
            this.rimCheckinDone = ComboBoxFactory.getYesNoComboBox(true);
        }
        this.aisPrintBox = ComboBoxFactory.getAISPrintNeededComboBox(true);
        this.filterChain.addSelectionComboBox(this.stateCombo, FILTER_STATE, Words.STATE, Words.ALL);
        this.periodSearchMode = new ComboBox();
        this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.staOnly);
        this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.stdOnly);
        this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
        this.periodSearchMode.setSelectedItem(FlightSearchConfiguration.FLIGHT_STD_STA.stdOnly);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.periodeditor = this.filterChain.addPeriodSelection(FILTER_PERIOD, p.getStartDate(), p.getEndDate(), "", true);
        this.periodeditor.setCommitOnFocusLost(true);
        this.periodeditor.setComboBox(this.periodSearchMode);
        this.periodeditor.setComboBoxWidth(100);
        if (isCheckout) {
            this.checkoutPerformed = ComboBoxFactory.getYesNoComboBox(true);
        }
        this.filterChain.addCustomerSearchField(FILTER_CARRIER);
        if (!isFpb) {
            this.filterChain.addStowingListTemplateField(FILTER_STOWING_LIST);
            this.filterChain.addSelectionComboBox(this.lastUpdateCombo, 120, FILTER_LAST_UPDATE, Words.LAST_UPDATE, Words.ALL);
            this.filterChain.addSelectionComboBox(this.stowageTypeCombo, 130, FILTER_STOWAGE_TYPE, Words.STOWAGE_TYPE, FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.ALL);
            if (autoCheckout) {
                this.filterChain.addSelectionComboBox(this.autoCheckoutCombo, 100, FILTER_AUTOCHECKOUT, Words.AUTOCHECKOUT, Words.ALL);
            }
            this.filterChain.addSelectionComboBox(this.rcCombo, FILTER_RC_STATE, Words.RC_STATE, Words.ALL);
            if (autoCheckout) {
                this.filterChain.addSelectionComboBox(this.hasTransactions, 100, FILTER_HAS_STOCK_TRANSACTION, Words.TRANSACTIONS, Words.ALL);
                this.filterChain.addSelectionComboBox(this.hasStockIrregularity, 90, FILTER_HAS_IRREGLARITY, Words.IRREGULARITY, Words.ALL);
            }
            this.filterChain.addSelectionComboBox(this.flightCategories, FILTER_FLIGHT_CAT, Words.CATEGORY, Words.ALL);
            this.filterChain.addSelectionComboBox(this.aisPrintBox, 110, FILTER_AIS_NEEDED, Words.AIS_PRINT, Words.ALL);
            this.filterChain.addSelectionComboBox(this.selectedPaxType, FILTER_SELECTED_PAX, Words.PAX_TYPE, Words.ALL);
            MultiHaulTypeSelectionComboBox haulCombo = new MultiHaulTypeSelectionComboBox(INodeCreator.getDefaultImpl().createNodes(new ArrayList(), false));
            this.haulPanel = new MultiSelectionPanel<MultiHaulTypeSelectionComboBox>(haulCombo);
            this.haulPanel.setShouldPersist(true);
            this.filterChain.addMultiSelection(this.haulPanel, FILTER_HAUL_TYPE, Words.HAUL_TYPE);
            if (isRetailInMotion) {
                this.filterChain.addSelectionComboBox(this.retailInMotionData, 110, FILTER_HAS_RETAIL_IN_MOTION_DATA, Words.RETAIL_INMOTION, Words.ALL);
                this.filterChain.addSelectionComboBox(this.rimCheckoutDone, 110, FITLER_RIM_CHECKOUT_DONE, Words.RETAIL_INMOTION_CHECKOUT_DONE, Words.ALL);
                this.filterChain.addSelectionComboBox(this.rimCheckinDone, 110, FITLER_RIM_CHECKIN_DONE, Words.RETAIL_INMOTION_CHECKIN_DONE, Words.ALL);
            }
            if (CompanyUtil.isSCK((SystemSettingsComplete)settings)) {
                this.filterChain.addAirportSearchField(FILTER_DELIVERY_AIRPORT);
            }
            if (isCheckout) {
                this.filterChain.addSelectionComboBox(this.checkoutPerformed, 110, FILTER_CHECKOUT_PERFORMED, Words.CHECKOUT_PERFORMED, Words.ALL);
            }
        } else {
            this.flightOrderReceivedBox = ComboBoxFactory.getYesNoComboBox(true);
            this.filterChain.addSelectionComboBox(this.flightOrderReceivedBox, FILTER_FLIGHT_ORDER_RECEIVED, "Checked Orders", Words.ALL);
        }
        if (CompanyUtil.isLSGFC((SystemSettingsComplete)settings)) {
            this.edelweissPaxUpdateBox = ComboBoxFactory.getYesNoComboBox(true);
            this.filterChain.addSelectionComboBox(this.edelweissPaxUpdateBox, 110, FILTER_EDELWEISS_PAX_UPDATE, "EDW Pax Update", Words.ALL);
        }
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        String v;
        String v2;
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteria2 = null;
            PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
            ((DateChooser)this.periodeditor.getStartDateChooser().getEditor()).setSelectedDate(p.getStartDate());
            ((DateChooser)this.periodeditor.getEndDateChooser().getEditor()).setSelectedDate(p.getEndDate());
            this.filterCriteria3 = p;
            this.filterCriteria4 = null;
            this.filterCriteria5 = null;
            this.filterCriteria6 = FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.ALL;
            this.autoCheckout = null;
            this.onlyOpenFlights = false;
            this.ignoreCancelledFlights = false;
            this.haultypeActivated = Boolean.FALSE;
            this.hasIrregularity = null;
            this.hasStockTransactions = null;
            this.rcState = null;
            this.flightCategoryFilter = null;
            this.hasSubstitutions = null;
            this.aisPrintNeeded = null;
            this.filterPaxType = null;
            this.filterStowingList = null;
            this.hasRetailInMotionData = null;
            this.filterCriteria11 = null;
            this.rimCheckinDoneCriteria = null;
            this.rimCheckoutDoneCriteria = null;
            this.selectedDeliveryAirport = null;
            this.checkoutPerformedCriteria = null;
            this.edelweissPaxUpdateCriteria = null;
            this.flightOrderReceivedCriteria = null;
        } else if (name == FILTER_NUMBER_CUSDOCID) {
            ConfigurableSearchTextField textfield = (ConfigurableSearchTextField)source;
            this.filterCriteria11 = (FlightSearchTypeE)textfield.getSearchType();
            this.filterCriteria1 = (String)value;
        } else if (name == FILTER_STATE) {
            if (value instanceof FlightStateE) {
                this.filterCriteria2 = (FlightStateE)value;
                this.onlyOpenFlights = false;
            } else if (value instanceof String) {
                if (value.equals(Words.ALL)) {
                    this.filterCriteria2 = null;
                    this.onlyOpenFlights = false;
                } else if (value.equals(Words.ALL_EXCEPT_PLANNED)) {
                    this.filterCriteria2 = null;
                    this.onlyOpenFlights = true;
                    this.ignoreCancelledFlights = false;
                } else if (value.equals(Words.ALL_EXCEPT_PLANNED_AND_CANCELLED)) {
                    this.filterCriteria2 = null;
                    this.onlyOpenFlights = true;
                    this.ignoreCancelledFlights = true;
                } else {
                    this.filterCriteria2 = null;
                    this.onlyOpenFlights = false;
                }
            } else {
                this.filterCriteria2 = null;
                this.onlyOpenFlights = false;
            }
        } else if (name == FILTER_PERIOD) {
            TitledPeriodEditor ed = (TitledPeriodEditor)value;
            PeriodComplete per = new PeriodComplete();
            per.setStartDate(ed.getStartDate());
            per.setEndDate(ed.getEndDate());
            this.filterCriteria3 = per;
        } else if (name == FILTER_CARRIER) {
            this.filterCriteria4 = value == Words.ALL ? null : (CustomerLight)value;
        } else if (name == FILTER_STOWING_LIST) {
            this.filterStowingList = value == Words.ALL ? null : (StowingListTemplateComplete)value;
        } else if (name == FILTER_LAST_UPDATE) {
            Object[] start;
            DateTime end = new DateTime();
            if (value == WITHIN_HOUR) {
                start = new DateTime().minusHours(1);
                this.filterCriteria5 = new TimestampPeriodComplete(new Timestamp(start.getMillis()), new Timestamp(end.getMillis()));
            } else if (value == WITHIN_4_HOURS) {
                start = new DateTime().minusHours(4);
                this.filterCriteria5 = new TimestampPeriodComplete(new Timestamp(start.getMillis()), new Timestamp(end.getMillis()));
            } else if (value == WITHIN_8_HOURS) {
                start = new DateTime().minusHours(8);
                this.filterCriteria5 = new TimestampPeriodComplete(new Timestamp(start.getMillis()), new Timestamp(end.getMillis()));
            } else {
                this.filterCriteria5 = null;
            }
        } else if (name == FILTER_STOWAGE_TYPE) {
            this.filterCriteria6 = (FlightSearchConfiguration.STOWAGE_TYPE_COLUMN)value;
        } else if (name == FILTER_AUTOCHECKOUT) {
            if (value != null) {
                if (value.equals(Words.ALL)) {
                    this.autoCheckout = null;
                } else if (value.equals(Words.ON)) {
                    this.autoCheckout = true;
                } else if (value.equals(Words.OFF)) {
                    this.autoCheckout = false;
                }
            } else {
                this.autoCheckout = null;
            }
        } else if (name == FILTER_HAUL_TYPE) {
            if (value instanceof Object[]) {
                this.haulType = new ArrayList<HaulTypeComplete>();
                for (Object a : (Object[])value) {
                    this.haulType.add((HaulTypeComplete)a);
                }
            } else if (value instanceof Boolean) {
                this.haultypeActivated = (Boolean)value;
            } else {
                this.haulType = null;
            }
        } else if (name == FILTER_HAS_STOCK_TRANSACTION) {
            this.hasStockTransactions = value instanceof String ? ((v2 = (String)value).equals(Words.YES) ? Boolean.valueOf(true) : (v2.equals(Words.NO_ANSWER) ? Boolean.valueOf(false) : null)) : null;
        } else if (name == FILTER_HAS_IRREGLARITY) {
            this.hasIrregularity = value instanceof String ? ((v2 = (String)value).equals(Words.YES) ? Boolean.valueOf(true) : (v2.equals(Words.NO_ANSWER) ? Boolean.valueOf(false) : null)) : null;
        } else if (name == FILTER_HAS_RETAIL_IN_MOTION_DATA) {
            this.hasRetailInMotionData = value instanceof String ? ((v2 = (String)value).equals(Words.YES) ? Boolean.valueOf(true) : (v2.equals(Words.NO_ANSWER) ? Boolean.valueOf(false) : null)) : null;
        } else if (name == FILTER_FLIGHT_ORDER_RECEIVED) {
            this.flightOrderReceivedCriteria = value instanceof String ? ((v2 = (String)value).equals(Words.YES) ? Boolean.valueOf(true) : (v2.equals(Words.NO_ANSWER) ? Boolean.valueOf(false) : null)) : null;
        } else if (name == FITLER_RIM_CHECKOUT_DONE) {
            this.rimCheckoutDoneCriteria = value instanceof String ? ((v2 = (String)value).equals(Words.YES) ? Boolean.valueOf(true) : (v2.equals(Words.NO_ANSWER) ? Boolean.valueOf(false) : null)) : null;
        } else if (name == FITLER_RIM_CHECKIN_DONE) {
            this.rimCheckinDoneCriteria = value instanceof String ? ((v2 = (String)value).equals(Words.YES) ? Boolean.valueOf(true) : (v2.equals(Words.NO_ANSWER) ? Boolean.valueOf(false) : null)) : null;
        } else if (name == FILTER_EDELWEISS_PAX_UPDATE) {
            this.edelweissPaxUpdateCriteria = value instanceof String ? ((v2 = (String)value).equals(Words.YES) ? Boolean.valueOf(true) : (v2.equals(Words.NO_ANSWER) ? Boolean.valueOf(false) : null)) : null;
        } else if (name == FILTER_RC_STATE) {
            this.rcState = value instanceof ReturnsCountStateE ? (ReturnsCountStateE)value : null;
        } else if (name == FILTER_FLIGHT_CAT) {
            this.flightCategoryFilter = value instanceof FlightCategoryComplete ? (FlightCategoryComplete)value : (value instanceof Node ? (FlightCategoryComplete)((Node)value).getValue() : null);
        } else if (name == FILTER_SELECTED_PAX) {
            if (value instanceof PaxFigureTypeComplete) {
                this.filterPaxType = (PaxFigureTypeComplete)value;
                this.filterShowFinalPax = false;
            } else if (value instanceof Node) {
                this.filterPaxType = (PaxFigureTypeComplete)((Node)value).getValue();
                this.filterShowFinalPax = false;
            } else if (value instanceof String) {
                if (Words.ALL.equals(value)) {
                    this.filterShowFinalPax = false;
                    this.filterPaxType = null;
                } else if (Words.INVOICED.equals(value)) {
                    this.filterShowFinalPax = true;
                    this.filterPaxType = null;
                }
            } else {
                this.filterShowFinalPax = false;
                this.filterPaxType = null;
            }
        } else if (name == FILTER_HAS_SUBSTITUTIONS) {
            this.hasSubstitutions = value != null ? (value.equals(Words.ALL) ? null : (value.equals(Words.HAS_SUBSTITUTIONS) ? Boolean.valueOf(true) : (value.equals(Words.NO_SUBSTITUTIONS) ? Boolean.valueOf(false) : null))) : null;
        } else if (name == FILTER_AIS_NEEDED) {
            this.aisPrintNeeded = value != null ? (value.equals(Words.ALL) ? null : (value.equals(Words.HAS_CHANGES) ? Boolean.valueOf(true) : (value.equals(Words.NO_CHANGES) ? Boolean.valueOf(false) : null))) : null;
        } else if (name == FILTER_DELIVERY_AIRPORT) {
            this.selectedDeliveryAirport = value instanceof AirportComplete ? (AirportComplete)value : (value instanceof Node ? (AirportComplete)((Node)value).getValue() : null);
        } else if (name == FILTER_CHECKOUT_PERFORMED) {
            this.checkoutPerformedCriteria = value instanceof String ? ((v2 = (String)value).equals(Words.YES) ? Boolean.valueOf(true) : (v2.equals(Words.NO_ANSWER) ? Boolean.valueOf(false) : null)) : null;
        }
        FlightSearchConfiguration c = new FlightSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setCustomer(this.filterCriteria4);
        c.setFlightState(this.filterCriteria2);
        c.setLastUpdate(this.filterCriteria5);
        c.setDayPeriod(this.filterCriteria3);
        c.setStowageType(this.filterCriteria6);
        c.setAutoCheckout(this.autoCheckout);
        c.setHaulTypeList(this.haulType);
        c.setShowNullHaulTypes(this.haultypeActivated);
        c.setCategory(this.flightCategoryFilter);
        c.setHasSubstitions(this.hasSubstitutions);
        c.setAisPrintNeeded(this.aisPrintNeeded);
        c.setPaxType(this.filterPaxType);
        c.setPaxTypeFinalOnly(Boolean.valueOf(this.filterShowFinalPax));
        c.setHasRetailInMotionData(this.hasRetailInMotionData);
        c.setIgnoreCancelledFlights(this.ignoreCancelledFlights);
        c.setOnlyOpenFlights(this.onlyOpenFlights);
        c.setHasStockTransactions(this.hasStockTransactions);
        c.setHasIrregularity(this.hasIrregularity);
        c.setRcState(this.rcState);
        c.setRetailInMotionCheckinDone(this.rimCheckinDoneCriteria);
        c.setRetailInMotionCheckoutDone(this.rimCheckoutDoneCriteria);
        c.setDeliveryAirport(this.selectedDeliveryAirport);
        c.setCheckoutPerformed(this.checkoutPerformedCriteria);
        c.setEdelweissPaxUpdate(this.edelweissPaxUpdateCriteria);
        c.setFlightOrderReceived(this.flightOrderReceivedCriteria);
        if (this.filterStowingList != null) {
            c.setStowingListTemplate(new StowingListTemplateReference(this.filterStowingList.getId()));
        }
        if ((v = this.filterCriteria1) != null) {
            c.setFlightNumber(v);
            c.setCustomsDocumentId(v);
        }
        if (this.filterCriteria11 == null) {
            c.setSearchFlightType(FlightSearchTypeE.FLIGHT_CODE);
        } else {
            c.setSearchFlightType(this.filterCriteria11);
        }
        c.setFlightStdSta((FlightSearchConfiguration.FLIGHT_STD_STA)this.periodSearchMode.getSelectedItem());
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public boolean isAnalysisModuleAllowed(SubModuleAccessRightComplete subModule) {
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_UPDATE_PRE_ORDERS.getIdentifier())) {
            return false;
        }
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_UPDATE_MAX_PAX.getIdentifier())) {
            return false;
        }
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_UPDATE_PAX_FORECAST_FILE_BASED.getIdentifier())) {
            return false;
        }
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_FLIGHT_RETAIL_IN_MOTION.getIdentifier())) {
            RetailInMotionSettingsComplete settings = (RetailInMotionSettingsComplete)NodeToolkit.getAffixClass(RetailInMotionSettingsComplete.class).getValue();
            return settings != null && Boolean.TRUE.equals(settings.getUseRetailInMotionInterface());
        }
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_FLIGHT_VECTOR_SALES_VALIDATION.getIdentifier())) {
            RetailInMotionSettingsComplete settings = (RetailInMotionSettingsComplete)NodeToolkit.getAffixClass(RetailInMotionSettingsComplete.class).getValue();
            return settings != null && Boolean.TRUE.equals(settings.getUseRetailInMotionInterface());
        }
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_EDELWEISS_PAX_VALIDATION.getIdentifier())) {
            EdelweissSettingsComplete settings = (EdelweissSettingsComplete)NodeToolkit.getAffixClass(EdelweissSettingsComplete.class).getValue();
            return settings != null && Boolean.TRUE.equals(settings.getUseEdelweissInterface());
        }
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_FLIGHT_REFRESH_RETAIL_INMOTION.getIdentifier())) {
            RetailInMotionSettingsComplete settings = (RetailInMotionSettingsComplete)NodeToolkit.getAffixClass(RetailInMotionSettingsComplete.class).getValue();
            return settings != null && Boolean.TRUE.equals(settings.getUseRetailInMotionInterface());
        }
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_FLIGHT_RIM_VALIDATION.getIdentifier())) {
            RetailInMotionSettingsComplete settings = (RetailInMotionSettingsComplete)NodeToolkit.getAffixClass(RetailInMotionSettingsComplete.class).getValue();
            return settings != null && Boolean.TRUE.equals(settings.getUseRetailInMotionInterface());
        }
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_FLIGHT_2L_VALIDATION.getIdentifier())) {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            return settings != null && CompanyUtil.isLSGFC((SystemSettingsComplete)settings);
        }
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_LIME_FLIGHT_SYNC.getIdentifier())) {
            EdelweissSettingsComplete settings = (EdelweissSettingsComplete)NodeToolkit.getAffixClass(EdelweissSettingsComplete.class).getValue();
            return settings != null && Boolean.TRUE.equals(settings.getUseEdelweissInterface());
        }
        if (subModule.getModule().getInvokingName().equals(FlightAccess.ANALYSIS_GUDD_PICKUP_LIST.getIdentifier())) {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            return settings != null && CompanyUtil.isFPB((SystemSettingsComplete)settings);
        }
        return true;
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<FlightLight> model) {
        Object o;
        try {
            if (model == null || model.getNode() == null || model.getNode().getValue() == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (((ADTO)model.getNode().getValue()).getId() == null) {
            return screen.getInvokingName().equals(FlightAccess.PRINT_FLIGHT_MATERIAL_DISPOSITION.getIdentifier());
        }
        if (screen.getInvokingName().equals(FlightAccess.ACTION_ADD_DELIVERY_SLIP.getIdentifier())) {
            FlightLight flight = model.getDTO();
            switch (flight.getFlightState()) {
                case CANCELLED: 
                case CLOSED: 
                case DELETED: 
                case DISPATCHED: 
                case EN_ROUTE: 
                case OPEN: {
                    return true;
                }
                case PLANNED: {
                    return false;
                }
            }
            return true;
        }
        if (screen.getInvokingName().equals(FlightAccess.ACTION_CLOSE_FLIGHT.getIdentifier())) {
            FlightLight flight = model.getDTO();
            if (flight == null) {
                return false;
            }
            switch (flight.getFlightState()) {
                case CANCELLED: 
                case CLOSED: {
                    return false;
                }
                case DELETED: 
                case DISPATCHED: 
                case EN_ROUTE: 
                case OPEN: 
                case PLANNED: {
                    break;
                }
            }
            return true;
        }
        if (screen.getInvokingName().equals(FlightAccess.ACTION_UPDATE_FORECAST_PAX.getIdentifier())) {
            FlightLight flight = model.getDTO();
            switch (flight.getFlightState()) {
                case CANCELLED: 
                case CLOSED: 
                case DELETED: 
                case DISPATCHED: 
                case EN_ROUTE: {
                    RDProvider p = new RDProvider(this.getCurrentAccessRight(this.getInvoker()), false);
                    boolean ignoreRestriction = p.isWritable("ignore_en_route_restrictions");
                    return ignoreRestriction;
                }
                case OPEN: {
                    return true;
                }
                case PLANNED: {
                    break;
                }
            }
        }
        if (screen.getInvokingName().equals(FlightAccess.PRINT_FLIGHT_KITCHEN_FORECAST.getIdentifier()) && model.getNode().getChildNamed(FlightLight_.excludeFromKitchenForecast) != null && (o = model.getNode().getChildNamed(FlightLight_.excludeFromKitchenForecast).getValue()) != null) {
            return (Boolean)o == false;
        }
        if (model.getNode().getChildNamed(FlightLight_.upliftCount) != null && (o = model.getNode().getChildNamed(FlightLight_.upliftCount).getValue()) != null) {
            boolean uplift = (Boolean)o;
            if (screen.getInvokingName().equals(FlightAccess.TOOL_RETURNS_COUNT_DRAWER_BASED.getIdentifier())) {
                return !uplift;
            }
            if (screen.getInvokingName().equals(FlightAccess.TOOL_RETURNS_COUNT_EQUIPMENT_BASED.getIdentifier())) {
                return !uplift;
            }
            if (screen.getInvokingName().equals(FlightAccess.TOOL_UPLIFT_COUNT.getIdentifier())) {
                return uplift;
            }
            if (screen.getInvokingName().equals(FlightAccess.PRINT_RETURNS_COUNT_WORK_SHEET.getIdentifier())) {
                return !uplift;
            }
            if (screen.getInvokingName().equals(FlightAccess.PRINT_UPLIFT_COUNT_WORK_SHEET.getIdentifier())) {
                return uplift;
            }
            if (screen.getInvokingName().equals(FlightAccess.PRINT_UPLIFT_COUNT_SLIP.getIdentifier())) {
                return uplift;
            }
            if (screen.getInvokingName().equals(FlightAccess.PRINT_RETURNS_COUNT_SLIP.getIdentifier())) {
                return !uplift;
            }
        }
        if (screen.getInvokingName().equals(FlightAccess.EXPORT_RETAIL_IN_MOTION.getIdentifier()) || screen.getInvokingName().equals(FlightAccess.TOOL_EDIT_RIM_TRANSACTIONS.getIdentifier()) || screen.getInvokingName().equals(FlightAccess.ACTION_MOVE_RIM_TRANSACTIONS.getIdentifier()) || screen.getInvokingName().equals(FlightAccess.ACTION_SWITCH_RIM_PRODUCT_CUSTOMER.getIdentifier()) || screen.getInvokingName().equals(FlightAccess.ACTION_CHECKOUT_SOB_DATA.getIdentifier())) {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            RetailInMotionSettingsComplete rimSettings = (RetailInMotionSettingsComplete)NodeToolkit.getAffixClass(RetailInMotionSettingsComplete.class).getValue();
            boolean showCheckout = true;
            if (settings != null && Boolean.TRUE.equals(rimSettings.getUseRetailInMotionInterface())) {
                FlightLight flight;
                if ((screen.getInvokingName().equals(AFlightAccess.ACTION_SWITCH_RIM_PRODUCT_CUSTOMER.getIdentifier()) || screen.getInvokingName().equals(AFlightAccess.ACTION_MOVE_RIM_TRANSACTIONS.getIdentifier())) && !Boolean.TRUE.equals((flight = model.getDTO()).getHasRetailInMotionTransactions())) {
                    showCheckout = false;
                }
                if (screen.getInvokingName().equals(AFlightAccess.ACTION_CHECKOUT_SOB_DATA.getIdentifier())) {
                    flight = model.getDTO();
                    if (Boolean.TRUE.equals(flight.getRetailInMotionCheckoutDone())) {
                        showCheckout = false;
                    }
                    if (!Boolean.TRUE.equals(rimSettings.getAutoReceiveData())) {
                        showCheckout = false;
                    }
                }
            } else {
                showCheckout = false;
            }
            if (showCheckout) {
                return true;
            }
            return Boolean.TRUE.equals(settings.getChangeFlightStateToEnRouteWhenRcCheckout());
        }
        if (screen.getInvokingName().equals(FlightAccess.TOOL_FLIGHT_STOWING_EDITOR.getIdentifier())) {
            Object n = model.getNode().getValueForNamed("activeStowingList");
            return n != null;
        }
        return true;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.flightCategories.refreshPossibleValues(NodeToolkit.getAffixList(FlightCategoryComplete.class));
        this.flightCategories.addItem(Words.ALL);
        this.flightCategories.setSelectedItem(Words.ALL);
        this.selectedPaxType.refreshPossibleValues(NodeToolkit.getAffixClass(PaxFigureTypeComplete.class));
        this.selectedPaxType.addItem(Words.ALL);
        this.selectedPaxType.addItem(Words.INVOICED);
        this.selectedPaxType.setSelectedItem(Words.ALL);
        super.remoteObjectLoaded(node);
    }

    @Override
    public boolean isDeletable(RowModel<FlightLight> model) {
        return false;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<FlightLight> getRowEditorFactory() {
        return model -> {
            InputMessageProvidedRowEditor<FlightLight> rowEditor = new InputMessageProvidedRowEditor<FlightLight>(model, Words.ARE_YOU_SURE_TO_SAVE_FLIGHT);
            RDProvider p = this.createProvider(model.isAddRow());
            if (rowEditor.getModel().isAddRow()) {
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                boolean isFpb = CompanyUtil.isFPB((SystemSettingsComplete)settings);
                AdHocStwDetailsPanel d2 = new AdHocStwDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                AdHocFlightDataDetailsPanel d3 = new AdHocFlightDataDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                FlightStateDetailsPanel d1 = new FlightStateDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                d2.setDetailsPanel(d3);
                d3.setStwDetailsPanel(d2);
                d2.setReferencedLegTable(d2.getLegTable());
                d3.setReferencedLegTable(d2.getLegTable());
                CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
                c1.add((Component)d3, new TableLayoutConstraint(0, 0, 1.0, 0.5));
                c1.add((Component)d1, new TableLayoutConstraint(0, 1, 1.0, 0.5));
                CombinedDetailsParagraph c2 = new CombinedDetailsParagraph();
                c2.add((Component)c1, new TableLayoutConstraint(0, 0, 0.3f, 1.0));
                c2.add((Component)d2, new TableLayoutConstraint(1, 0, 0.7f, 1.0));
                rowEditor.add(c2, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.addToFocusQueue(d3);
                rowEditor.addToFocusQueue(d2);
                rowEditor.addToFocusQueue(d1);
            } else {
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                boolean isFpb = CompanyUtil.isFPB((SystemSettingsComplete)settings);
                FlightStateDetailsPanel d1 = new FlightStateDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                TimeDetailsPanel d = null;
                if (isFpb) {
                    d = new TimeDetailsPanel((RowEditor<FlightLight>)rowEditor, p, true, true);
                }
                RegularOrderDetailsPanel d40 = null;
                AlaCarteMenusDetailsPanel d41 = null;
                SpecialMenusDetailsPanel d4 = null;
                AdditionalOrderDetailsPanel d5 = null;
                StowingListDetailsPanel<FlightLight> d6 = null;
                RemarkDetailsPanel d7 = null;
                CombinedDetailsParagraph h1 = null;
                CombinedDetailsParagraph h11 = null;
                CombinedDetailsParagraph h12 = null;
                CombinedDetailsParagraph h2 = null;
                DelaysDetailsPanel d9 = null;
                HandlingCostDetailsPanel<FlightLight> d10 = null;
                HandlingCostDetailsPanel<FlightLight> d102 = null;
                TrucksDetailsPanel d11 = null;
                SealDefinitionDetailsPanel d12 = null;
                BondedEquipmentSealsDetailsPanel d13 = null;
                GalleyLoadingDetailsPanel loadingDetailsPanel = null;
                TrolleyScanSettingsComplete trolleyConfig = (TrolleyScanSettingsComplete)NodeToolkit.getAffixClass(TrolleyScanSettingsComplete.class).getValue();
                if (Boolean.TRUE.equals(trolleyConfig.getUseTrolleyScan()) && ((FlightLight)model.getDTO()).getFlightState() != FlightStateE.PLANNED) {
                    loadingDetailsPanel = new GalleyLoadingDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                    d11 = new TrucksDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                }
                if (!isFpb) {
                    d12 = new SealDefinitionDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                    d13 = new BondedEquipmentSealsDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                } else {
                    d12 = null;
                    d13 = null;
                }
                h1 = new CombinedDetailsParagraph();
                h2 = new CombinedDetailsParagraph();
                if (!isFpb) {
                    d7 = new RemarkDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                }
                if (!isFpb) {
                    d9 = new DelaysDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                }
                if (!isFpb) {
                    d10 = new HandlingCostDetailsPanel<FlightLight>(rowEditor, p, false, false);
                    d102 = new HandlingCostDetailsPanel<FlightLight>(rowEditor, p, false, true);
                }
                EditPaxDetailsPanel d2 = new EditPaxDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                d40 = !isFpb ? new RegularOrderDetailsPanel((RowEditor<FlightLight>)rowEditor, p) : null;
                if (!isFpb) {
                    d4 = new SpecialMenusDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                    d41 = new AlaCarteMenusDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                }
                d5 = new AdditionalOrderDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                if (!isFpb) {
                    d6 = new StowingListDetailsPanel<FlightLight>(rowEditor, p, FlightLight_.activeStowingList, true, (FlightModuleDataHandler)this.getTable().getModel().getDataHandler(), d4, d5, d12, d2.getPaxTable());
                }
                CustomsDocumentsDetailsPanel d8 = new CustomsDocumentsDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
                h12 = new CombinedDetailsParagraph();
                h12.add((Component)d8, new TableLayoutConstraint(0, 0, 1.0, 1.0));
                if (isFpb) {
                    h1.add((Component)d1, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                    h1.add((Component)d, new TableLayoutConstraint(1, 0, 0.25, 1.0));
                    h1.add((Component)d2, new TableLayoutConstraint(2, 0, 0.25, 1.0));
                } else {
                    h1.add((Component)d1, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                    h1.add((Component)d2, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                }
                if (!isFpb) {
                    h11 = new CombinedDetailsParagraph();
                    h11.add((Component)d9, new TableLayoutConstraint(0, 0, 0.2f, 1.0));
                    h11.add(d6, new TableLayoutConstraint(1, 0, 0.8f, 1.0));
                    h2.add(d10, new TableLayoutConstraint(0, 0, 0.5, 1.0));
                    h2.add(d102, new TableLayoutConstraint(1, 0, 0.5, 1.0));
                }
                int nextIndex = 0;
                rowEditor.add(h1, (Object)new TableLayoutConstraint(0, nextIndex++, 1.0, 0.0));
                if (!isFpb) {
                    rowEditor.add(h11, (Object)new TableLayoutConstraint(0, nextIndex++, 1.0, 0.0));
                }
                rowEditor.add(h12, (Object)new TableLayoutConstraint(0, nextIndex++, 1.0, 0.0));
                rowEditor.add(h2, (Object)new TableLayoutConstraint(0, nextIndex++, 1.0, 0.0));
                if (!isFpb) {
                    rowEditor.add(d7, (Object)new TableLayoutConstraint(0, nextIndex++, 1.0, 0.0));
                }
                if (!isFpb) {
                    rowEditor.add(d40, (Object)new TableLayoutConstraint(0, nextIndex++, 1.0, 0.0));
                }
                if (d4 != null) {
                    rowEditor.add(d4, (Object)new TableLayoutConstraint(0, nextIndex++, 1.0, 0.0));
                }
                if (!isFpb) {
                    rowEditor.add(d41, (Object)new TableLayoutConstraint(0, nextIndex++, 1.0, 0.0));
                }
                rowEditor.add(d5, (Object)new TableLayoutConstraint(0, nextIndex++, 1.0, 0.0));
                if (!isFpb) {
                    rowEditor.add(d12, (Object)new TableLayoutConstraint(0, nextIndex++, 1.0, 1.0));
                    rowEditor.add(d13, (Object)new TableLayoutConstraint(0, nextIndex++, 1.0, 1.0));
                }
                if (loadingDetailsPanel != null) {
                    rowEditor.add(loadingDetailsPanel, (Object)new TableLayoutConstraint(0, nextIndex++, 1.0, 1.0));
                    rowEditor.add(d11, (Object)new TableLayoutConstraint(0, nextIndex++, 1.0, 1.0));
                }
                rowEditor.addToFocusQueue(d1);
                rowEditor.addToFocusQueue(d2);
                rowEditor.addToFocusQueue(d9);
                rowEditor.addToFocusQueue(d6);
                rowEditor.addToFocusQueue(d8);
                rowEditor.addToFocusQueue(d10);
                rowEditor.addToFocusQueue(d102);
                if (!isFpb) {
                    rowEditor.addToFocusQueue(d7);
                }
                if (!isFpb) {
                    rowEditor.addToFocusQueue(d40);
                }
                rowEditor.addToFocusQueue(d4);
                rowEditor.addToFocusQueue(d41);
                rowEditor.addToFocusQueue(d5);
                if (!isFpb) {
                    rowEditor.addToFocusQueue(d12);
                    rowEditor.addToFocusQueue(d13);
                }
                if (loadingDetailsPanel != null) {
                    rowEditor.addToFocusQueue(loadingDetailsPanel);
                    rowEditor.addToFocusQueue(d11);
                }
            }
            rowEditor.allInstalled();
            rowEditor.updateEnableStateToDetailsPanel();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new FlightModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean isFpb = CompanyUtil.isFPB((SystemSettingsComplete)s);
        boolean isSCK = CompanyUtil.isSCK((SystemSettingsComplete)s);
        boolean isFcp = CompanyUtil.isLSGFC((SystemSettingsComplete)s);
        if (isFpb) {
            info.add(new TableColumnInfo(Words.STATE, "", (Class)FlightStateEWithWarningConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.STATE, "", 131, 131, 131));
            info.add(new TableColumnInfo(Words.CHECKED_ORDER, "", BooleanConverter.class, null, FlightLight_.flightOrderReceived, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
            info.add(new TableColumnInfo(Words.OUTBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.OUTBOUND_CODE, FlightLight_.outboundCode, 60, Integer.MAX_VALUE, 60));
            info.add(new TableColumnInfo(Words.STD, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_DEPARTURE, FlightLight_.realstd, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
            info.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.CARRIER, FlightLight_.customer, 80, 160, 80));
            info.add(new TableColumnInfo(Words.DELIVERY_SLIP_SENT, "", BooleanConverter.class, null, FlightLight_.deliverySlipSent, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
            info.add(new TableColumnInfo(Words.LAST_UPDATE, "", (Class)LogTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.LAST_UPDATE, FlightLight_.log, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
            info.add(new TableColumnInfo(Words.DISPATCH, "", (Class)LogUserConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.DISPATCH, FlightLight_.log, 70, 180, 70));
        } else {
            info.add(new TableColumnInfo(Words.STATE, "", (Class)FlightStateEWithWarningConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.STATE, "", 131, 131, 131));
            info.add(new TableColumnInfo(Words.TYPE, "", (Class)FlightTypeConverter.class, null, "", 27));
            if (isSCK) {
                info.add(new TableColumnInfo(Words.INBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.INBOUND_CODE, FlightLight_.inboundCode, 70, 90, 70));
                info.add(new TableColumnInfo(Words.STA, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_ARRIVAL, FlightLight_.realsta, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
                info.add(new TableColumnInfo(Words.FROM, "", LegFromAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
                info.add(new TableColumnInfo(Words.OUTBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.OUTBOUND_CODE, FlightLight_.outboundCode, 70, 90, 70));
                info.add(new TableColumnInfo(Words.STD, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_DEPARTURE, FlightLight_.realstd, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
                info.add(new TableColumnInfo(Words.TO, "", LegToAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
            } else {
                info.add(new TableColumnInfo(Words.OUTBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.OUTBOUND_CODE, FlightLight_.outboundCode, 60, Integer.MAX_VALUE, 60));
                info.add(new TableColumnInfo(Words.STD, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_DEPARTURE, FlightLight_.realstd, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
                info.add(new TableColumnInfo(Words.TO, "", LegToAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
                info.add(new TableColumnInfo(Words.INBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.INBOUND_CODE, FlightLight_.inboundCode, 60, Integer.MAX_VALUE, 60));
                info.add(new TableColumnInfo(Words.STA, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_ARRIVAL, FlightLight_.realsta, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
                info.add(new TableColumnInfo(Words.FROM, "", LegFromAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
            }
            if (isFcp) {
                info.add(new TableColumnInfo(Words.FS, "", IntegerConverter.class, null, FlightLight_.flightScheduleNo, 80, 80, 80));
            }
            if (isSCK) {
                info.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.CARRIER, FlightLight_.customer, 55, 55, 55));
            } else {
                info.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.CARRIER, FlightLight_.customer, 80, 80, 80));
            }
            if (isSCK) {
                info.add(new TableColumnInfo(Words.STOWING, "", (Class)StowingListNameConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.STOWINGLIST, FlightLight_.activeStowingList, 120, Integer.MAX_VALUE, 120));
            } else {
                info.add(new TableColumnInfo(Words.STOWING, "", (Class)StowingListNameConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.STOWINGLIST, FlightLight_.activeStowingList, 85, Integer.MAX_VALUE, 85));
            }
            info.add(new TableColumnInfo(Words.AIRCRAFT, "", StowingListAircraftConverter.class, null, FlightLight_.activeStowingList, 85, 85, 85));
            if (!isSCK) {
                info.add(new TableColumnInfo(Words.PAX_TYPE, "", PaxFigureTypeConverter.class, null, FlightLight_.selectedPaxType, 100, 100, 100));
            }
            if (this.showAutoCheckoutColumns()) {
                info.add(new TableColumnInfo(Words.TRANSACTIONS, "", BooleanConverter.class, null, FlightLight_.hasStockTransactions, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
                info.add(new TableColumnInfo(Words.IRREGULARITY_SHORT, "", StockIrregularityConverter.class, null, FlightLight_.noStockIrregularities, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
                info.add(new TableColumnInfo(Words.AUTO_CHECKOUT_SHORT, "", BooleanConverter.class, null, FlightLight_.autoCheckout, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
            }
            if (this.showAdditionalStateColumns() && this.showRetailInMotionColumns()) {
                info.add(new TableColumnInfo(Words.RETAIL_TRANSACTION_STATE, "", RetailInMotionTransactionStateConverter.class, null, "", TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
                info.add(new TableColumnInfo(Words.RETAIL_IMPORT_STATE, "", RetailInMotionImportStateConverter.class, null, "", TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
                info.add(new TableColumnInfo(Words.HAS_RETAIL_TRANSACTIONS, "", RetailInMotionHasTransactionsBooleanConverter.class, null, "", TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
                info.add(new TableColumnInfo(Words.SOB_CHECKOUT, "", RetailInMotionCheckoutBooleanConverter.class, null, "", TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
                info.add(new TableColumnInfo(Words.SOB_CHECKIN, "", RetailInMotionCheckinBooleanConverter.class, null, "", TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
            }
            if (this.showReturnCounts()) {
                info.add(new TableColumnInfo(Words.RETURNSCOUNT, "", FlightReturnsCountStateConverter.class, null, "", 46, 46, 46));
            }
            if (this.showLimeFlightUpdate()) {
                info.add(new TableColumnInfo("LM Type", "", DateTimeConverter.class, null, FlightLight_.lastLimeFlightUpdateType, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
                info.add(new TableColumnInfo("LM Update", "", DateTimeConverter.class, null, FlightLight_.lastLimeFlightUpdate, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
            }
            info.add(new TableColumnInfo(Words.LAST_UPDATE, "", (Class)LogTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.LAST_UPDATE, FlightLight_.log, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
            info.add(new TableColumnInfo(Words.DISPATCH, "", (Class)LogUserConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.DISPATCH, FlightLight_.log, 70, 160, 70));
        }
        return info;
    }

    @Override
    public SearchAlgorithm<FlightLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(FlightSearchAlgorithm.class);
    }
}

