/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight;

import ch.icit.pegasus.client.ClientIDToolkit;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.EdelweissServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationList;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.FlightToolkit;
import ch.icit.pegasus.client.util.toolkits.StowingToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.EdelweissSettingsComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ILegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.GalleyEquipmentSetLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.handlingcost.FlightHandlingCostConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AlaCarteMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Coordinate3dComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.LanguageCodeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PreparationGroupComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ProductTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.search.GalleyEquipmentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.sob.SalesOnBoardStateE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.EquipmentSealsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.FlightSealsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.ServiceReturnWithMessage;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightModuleDataHandler
extends DefaultDataHandler<FlightReference, FlightComplete> {
    static Logger log = LoggerFactory.getLogger(FlightModuleDataHandler.class);
    private StowingListLight latestStwLoaded;

    public FlightModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    private void ensureHandlingCost(FlightComplete flight) {
        for (FlightHandlingCostConfigurationComplete c : flight.getFlightHandlingCostConfiguration()) {
            if (flight.getId() != null) {
                c.setFlight(new FlightReference(flight.getId()));
                continue;
            }
            c.setFlight((FlightReference)flight);
        }
    }

    @Override
    public boolean reloadDataAfterClosing(final Node<?> node, final RemoteLoader listener, ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightLight f = (FlightLight)node.getValue();
                if (f.getId() != null) {
                    f = (FlightLight)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightLight(new FlightReference(f.getId())).getValue();
                }
                Node flightNode = node;
                NodeToolkit.removeAffixNamed((String)"SealedEQs");
                flightNode.removeExistingValues();
                flightNode.setValue((Object)f, 0L);
                flightNode.updateNode();
                return flightNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    private void ensurePax(FlightComplete flight) {
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        for (FlightLegComplete l : flight.getLegs()) {
            if (!l.getDepartureAirport().equals((Object)s.getNightStop()) && !l.getArrivalAirport().equals((Object)s.getNightStop()) && !l.getDepartureAirport().equals((Object)s.getDayStop()) && !l.getArrivalAirport().equals((Object)s.getDayStop())) continue;
            for (PaxFigureComplete pf : l.getPaxFigures()) {
                pf.setNumber(Integer.valueOf(0));
            }
        }
        for (FlightHandlingCostConfigurationComplete c : flight.getFlightHandlingCostConfiguration()) {
            if (flight.getId() != null) {
                c.setFlight(new FlightReference(flight.getId()));
                continue;
            }
            c.setFlight((FlightReference)flight);
        }
    }

    @Override
    public void updateData(final Node<FlightReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node writeNode = node;
                Node retNode = null;
                ArrayList<Object> legs = new ArrayList<Object>();
                Iterator it = writeNode.getChildNamed(FlightLight_.legs).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node leg = (Node)it.next();
                    FlightLegComplete l = (FlightLegComplete)leg.getValue();
                    for (PaxFigureComplete f : l.getPaxFigures()) {
                        f.setLeg(l);
                    }
                    legs.add(leg.getValue());
                }
                ((FlightComplete)writeNode.getValue(FlightComplete.class)).setLegs(legs);
                Node id = writeNode.getChildNamed(FlightLight.ID_);
                FlightComplete newDTO = null;
                boolean isNewlyCreated = false;
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                Node seals = NodeToolkit.getAffixNamed((String)"SealedEQs");
                FlightSealsComplete fsc = seals != null ? (FlightSealsComplete)seals.getValue() : null;
                boolean wasChange = false;
                final ArrayList errorCallback = new ArrayList();
                if (id.getValue() == null) {
                    FlightComplete oldDTO = (FlightComplete)node.getValue(FlightComplete.class);
                    if (!settings.getAutoCheckout().booleanValue()) {
                        oldDTO.setAutoCheckout(Boolean.valueOf(false));
                    }
                    FlightModuleDataHandler.this.ensureAdditionalOrders(oldDTO);
                    FlightModuleDataHandler.this.ensureHandlingCost(oldDTO);
                    FlightToolkit.syncInOutCodeAndLegCode((FlightComplete)oldDTO);
                    FlightToolkit.syncStdStaAndLegTime((FlightComplete)oldDTO);
                    oldDTO.setFlightOrderReceived(Boolean.valueOf(!Boolean.TRUE.equals(oldDTO.getCustomer().getNotifyFlightOrderReceived())));
                    Boolean canCreateFlight = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).canCreate(oldDTO.getOutboundCode(), new TimestampWrapper(oldDTO.getStd()), oldDTO.getInboundCode(), new TimestampWrapper(oldDTO.getSta()));
                    if (!Boolean.TRUE.equals(canCreateFlight)) {
                        DateTimeConverter c = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
                        throw new ClientGetFromServerException("A Flight with Outbound (" + oldDTO.getOutboundCode() + ") at " + c.convert((Object)oldDTO.getStd(), null, new Object[0]) + " and Inbound (" + oldDTO.getInboundCode() + ") at " + c.convert((Object)oldDTO.getSta(), null, new Object[0]) + " already exists.");
                    }
                    switch (oldDTO.getFlightState()) {
                        case CANCELLED: 
                        case OPEN: {
                            List spmlOrders = oldDTO.getSpmlOrders();
                            List additionalOrders = oldDTO.getAdditionalOrders();
                            isNewlyCreated = true;
                            oldDTO.setSpmlOrders(new ArrayList());
                            oldDTO.setAdditionalOrders(new ArrayList());
                            String overrideMatriculation = null;
                            overrideMatriculation = oldDTO.getActiveStowingList().getMatriculation();
                            FlightModuleDataHandler.this.ensurePax(oldDTO);
                            if (oldDTO.getKitchenReadyTime() == null) {
                                oldDTO.setKitchenReadyTime(new Timestamp(System.currentTimeMillis()));
                            }
                            FlightComplete o = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).create(oldDTO, new ListWrapper(errorCallback), overrideMatriculation).getValue();
                            FlightModuleDataHandler.revalidateMasterData(o, true, writeNode);
                            FlightToolkit.syncAdditionalSpaces((FlightComplete)o);
                            if (errorCallback.isEmpty()) {
                                newDTO = o;
                                if (additionalOrders.isEmpty() && spmlOrders.isEmpty()) break;
                                Node addSpaces = INodeCreator.getDefaultImpl().createNodes(((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalOrderSpaces(new FlightReference(newDTO.getId())).getList(), false);
                                Node smplSpaces = INodeCreator.getDefaultImpl().createNodes(((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalSPMLOrderSpaces(new FlightReference(newDTO.getId())).getList(), false);
                                ArrayList<Object> spmlOrderWithoutSpace = new ArrayList<Object>();
                                for (Object order : spmlOrders) {
                                    DeliverySpaceComplete s2;
                                    if (!order.getMenuType().getAdditional().booleanValue() || order.getStowingPosition() == null || order.getStowingPosition().getId() == null) {
                                        order.setStowingPosition(null);
                                    }
                                    boolean found = false;
                                    if (order.getStowingPosition() != null) {
                                        for (DeliverySpaceComplete s2 : (List)smplSpaces.getValue()) {
                                            GalleyEquipmentLight eq = s2.getContainingEquipment();
                                            if (eq == null) continue;
                                            GalleyEquipmentSetLight es = eq.getContainingGalley();
                                            GalleyEquipmentLight eq2 = order.getStowingPosition().getContainingEquipment();
                                            GalleyEquipmentSetLight es2 = eq2.getContainingGalley();
                                            if (!eq.getPositionCode().equals(eq2.getPositionCode()) || !es.getGalleyCode().equals(es2.getGalleyCode())) continue;
                                            Coordinate3dComplete c1 = s2.getCoordinates();
                                            Coordinate3dComplete c2 = order.getStowingPosition().getCoordinates();
                                            if (!c1.getX().equals(c2.getX()) || !c1.getY().equals(c2.getY())) continue;
                                            found = true;
                                            order.setStowingPosition(s2);
                                        }
                                    }
                                    if (!found) {
                                        if (!((List)smplSpaces.getValue()).isEmpty()) {
                                            order.setStowingPosition((DeliverySpaceComplete)((List)smplSpaces.getValue()).get(0));
                                        } else {
                                            spmlOrderWithoutSpace.add(order);
                                        }
                                    }
                                    ArrayList<FlightLegComplete> newLegs = new ArrayList<FlightLegComplete>();
                                    s2 = order.getLegs().iterator();
                                    while (s2.hasNext()) {
                                        FlightLegComplete oldLeg = (FlightLegComplete)s2.next();
                                        for (FlightLegComplete l : newDTO.getLegs()) {
                                            if (!oldLeg.getNumber().equals(l.getNumber())) continue;
                                            newLegs.add(l);
                                        }
                                    }
                                    order.setLegs(newLegs);
                                }
                                ArrayList<AdditionalOrderComplete> orderWithoutSpace = new ArrayList<AdditionalOrderComplete>();
                                for (AdditionalOrderComplete order : additionalOrders) {
                                    if (order.getStowingPosition() == null || order.getStowingPosition().getId() == null) {
                                        order.setStowingPosition(null);
                                    }
                                    boolean found = false;
                                    if (order.getStowingPosition() != null) {
                                        String orderPos = order.getStowingPosition().getContainingEquipment() != null ? order.getStowingPosition().getContainingEquipment().getPositionCode() : order.getStowingPosition().getSpaceName();
                                        for (DeliverySpaceComplete s : (List)addSpaces.getValue()) {
                                            String testingSpace = s.getContainingEquipment() != null ? s.getContainingEquipment().getPositionCode() : s.getSpaceName();
                                            if (!orderPos.equals(testingSpace)) continue;
                                            found = true;
                                            order.setStowingPosition(s);
                                        }
                                    } else if (!((List)addSpaces.getValue()).isEmpty()) {
                                        order.setStowingPosition((DeliverySpaceComplete)((List)addSpaces.getValue()).get(0));
                                    }
                                    if (!found && order.getStowingPosition() != null) {
                                        for (DeliverySpaceComplete s : (List)addSpaces.getValue()) {
                                            GalleyEquipmentLight eq = s.getContainingEquipment();
                                            if (eq == null) continue;
                                            GalleyEquipmentSetLight es = eq.getContainingGalley();
                                            GalleyEquipmentLight eq2 = order.getStowingPosition().getContainingEquipment();
                                            GalleyEquipmentSetLight es2 = eq2.getContainingGalley();
                                            if (!eq.getPositionCode().equals(eq2.getPositionCode()) || !es.getGalleyCode().equals(es2.getGalleyCode())) continue;
                                            Coordinate3dComplete c1 = s.getCoordinates();
                                            Coordinate3dComplete c2 = order.getStowingPosition().getCoordinates();
                                            if (!c1.getX().equals(c2.getX()) || !c1.getY().equals(c2.getY())) continue;
                                            found = true;
                                            order.setStowingPosition(s);
                                        }
                                        if (!found) {
                                            if (!((List)addSpaces.getValue()).isEmpty()) {
                                                order.setStowingPosition((DeliverySpaceComplete)((List)addSpaces.getValue()).get(0));
                                            } else {
                                                orderWithoutSpace.add(order);
                                            }
                                        }
                                    }
                                    for (FlightLegComplete l : newDTO.getLegs()) {
                                        if (!order.getLeg().getNumber().equals(l.getNumber())) continue;
                                        order.setLeg((ILegComplete)l);
                                    }
                                }
                                orderWithoutSpace.forEach(additionalOrderComplete -> additionalOrderComplete.setStowingPosition(null));
                                spmlOrderWithoutSpace.forEach(specialMealOrderComplete -> specialMealOrderComplete.setStowingPosition(null));
                                newDTO.setAdditionalOrders(additionalOrders);
                                newDTO.setSpmlOrders(spmlOrders);
                                FlightModuleDataHandler.this.ensurePax(newDTO);
                                FlightToolkit.syncInOutCodeAndLegCode((FlightComplete)newDTO);
                                FlightToolkit.syncStdStaAndLegTime((FlightComplete)newDTO);
                                ServiceReturnWithMessage ret = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(newDTO, new ListWrapper(errorCallback), false, false, false, false);
                                o = (FlightComplete)ret.getObject();
                                List message = ret.getMessage();
                                ScreenValidationList warnings = ScreenValidationObject.convertListFromString((List)message, (ScreenValidationObject.ValidationStateE)ScreenValidationObject.ValidationStateE.WARNING);
                                if (warnings.size() > 0) {
                                    InnerPopupFactory.showMessageDialog((List<ScreenValidationObject>)warnings, "Flight Checkout Validation", (Component)FlightModuleDataHandler.this.getTableView());
                                }
                                if (!errorCallback.isEmpty()) {
                                    retNode = new Node();
                                    retNode.setValue((Object)ScreenValidationObject.convertListFromString(errorCallback), 0L);
                                    break;
                                }
                                newDTO = o;
                                break;
                            }
                            retNode = new Node();
                            retNode.setValue((Object)ScreenValidationObject.convertListFromString(errorCallback), 0L);
                            break;
                        }
                        case CLOSED: {
                            break;
                        }
                        case EN_ROUTE: {
                            break;
                        }
                        case PLANNED: {
                            break;
                        }
                    }
                } else {
                    try {
                        FlightComplete fc;
                        DTOProxyNode aNode = (DTOProxyNode)node.getChildNamed(FlightLight_.activeStowingList);
                        aNode.getRefNode().commitThis(StowingListLight.class);
                        FlightComplete dto = (FlightComplete)node.getValue(FlightComplete.class);
                        if (!settings.getAutoCheckout().booleanValue()) {
                            dto.setAutoCheckout(Boolean.valueOf(false));
                        }
                        FlightModuleDataHandler.this.ensureHandlingCost(dto);
                        FlightModuleDataHandler.this.ensureAdditionalOrders(dto);
                        FlightModuleDataHandler.this.ensurePax(dto);
                        if (!dto.getActiveStowingList().equals((Object)FlightModuleDataHandler.this.latestStwLoaded)) {
                            wasChange = true;
                            if (!dto.getFlightState().equals((Object)FlightStateE.PLANNED)) {
                                Node n = StowingToolkit.switchStowingList((FlightComplete)dto, (StowingListLight)dto.getActiveStowingList(), errorCallback, (boolean)false);
                                if (n.getValue(FlightComplete.class) != null) {
                                    dto = (FlightComplete)n.getValue(FlightComplete.class);
                                }
                                if (!errorCallback.isEmpty()) {
                                    final FlightComplete fDto = dto;
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            DateTimeConverter con = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
                                            InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((List)errorCallback), Phrase.getPhrase((String)Phrase.REVIEW_FLIGHT, (Object[])new Object[]{fDto.getOutboundCode(), con.convert((Object)fDto.getStd(), null, new Object[0])}), FlightModuleDataHandler.this.model.getTable());
                                        }
                                    });
                                }
                                FlightModuleDataHandler.revalidateMasterData(dto, true, writeNode);
                            } else {
                                FlightComplete gettFlight = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight((FlightReference)dto).getValue();
                                dto.setActiveStowingList(gettFlight.getActiveStowingList());
                                dto.setLegs(gettFlight.getLegs());
                            }
                        }
                        if (!Boolean.TRUE.equals((fc = dto).getAdHoc()) || fc.getFlightState() == FlightStateE.PLANNED) {
                            // empty if block
                        }
                        FlightToolkit.syncInOutCodeAndLegCode((FlightComplete)dto);
                        FlightToolkit.syncStdStaAndLegTime((FlightComplete)dto);
                        FlightToolkit.syncAdditionalSpaces((FlightComplete)dto);
                        Boolean canCreateFlight = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).canCreateFlight(dto.getOutboundCode(), new TimestampWrapper(dto.getStd()), dto.getInboundCode(), new TimestampWrapper(dto.getSta()), new FlightReference(dto.getId()));
                        if (!Boolean.TRUE.equals(canCreateFlight)) {
                            DateTimeConverter c = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
                            throw new ClientGetFromServerException("A Flight with Outbound (" + dto.getOutboundCode() + ") at " + c.convert((Object)dto.getStd(), null, new Object[0]) + " and Inbound (" + dto.getInboundCode() + ") at " + c.convert((Object)dto.getSta(), null, new Object[0]) + " already exists.");
                        }
                        if (dto.getKitchenReadyTime() == null) {
                            dto.setKitchenReadyTime(new Timestamp(System.currentTimeMillis()));
                        }
                        ServiceReturnWithMessage ret = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(dto, new ListWrapper(errorCallback), false, false, false, false);
                        dto = (FlightComplete)ret.getObject();
                        List message = ret.getMessage();
                        ScreenValidationList warnings = ScreenValidationObject.convertListFromString((List)message, (ScreenValidationObject.ValidationStateE)ScreenValidationObject.ValidationStateE.WARNING);
                        if (warnings.size() > 0) {
                            InnerPopupFactory.showMessageDialog((List<ScreenValidationObject>)warnings, "Flight Checkout Validation", (Component)FlightModuleDataHandler.this.getTableView());
                        }
                        if (Boolean.TRUE.equals(fc.getAdHoc()) && dto == null) {
                            newDTO = fc;
                            newDTO.setFlightState(FlightStateE.DELETED);
                        }
                        if (dto != null) {
                            FlightToolkit.syncAdditionalSpaces((FlightComplete)dto);
                        }
                        if (errorCallback.isEmpty()) {
                            newDTO = dto == null ? fc : dto;
                        } else {
                            retNode = new Node();
                            retNode.setValue((Object)ScreenValidationObject.convertListFromString(errorCallback), 0L);
                        }
                    }
                    catch (Exception e) {
                        InnerPopupFactory.showErrorDialog(e, "Unable to save Flight", (Component)FlightModuleDataHandler.this.tableView);
                    }
                }
                if (newDTO != null && newDTO.getFlightState() != FlightStateE.PLANNED && newDTO.getFlightState() != FlightStateE.DELETED && !isNewlyCreated && !newDTO.getHasStowingListChanged().booleanValue()) {
                    try {
                        switch (newDTO.getFlightState()) {
                            case CANCELLED: 
                            case CLOSED: 
                            case PLANNED: {
                                break;
                            }
                            case OPEN: 
                            case EN_ROUTE: 
                            case DISPATCHED: {
                                if (wasChange) {
                                    GalleyEquipmentSearchConfiguration g = new GalleyEquipmentSearchConfiguration();
                                    g.setFlight(new FlightReference(newDTO.getId()));
                                    FlightSealsComplete nfsc = (FlightSealsComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightSeals(g).getValue();
                                    StowingToolkit.mergeSeals((FlightSealsComplete)nfsc, (FlightSealsComplete)fsc);
                                    fsc = nfsc;
                                }
                                if (fsc == null) break;
                                StowingToolkit.ensureSealState(newDTO, (FlightSealsComplete)fsc);
                                ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).updateSeals(fsc);
                                break;
                            }
                        }
                    }
                    catch (ClientServerCallException e1) {
                        InnerPopupFactory.showErrorDialog((Exception)((Object)e1), FlightModuleDataHandler.this.model.getTable());
                    }
                }
                NodeToolkit.removeAffixNamed((String)"SealedEQs");
                if (retNode != null) {
                    return retNode;
                }
                node.removeExistingValues();
                if (newDTO != null) {
                    node.setValue(newDTO, 0L);
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void ensureAdditionalOrders(FlightComplete flight) {
        if (flight.getAdditionalOrders() != null) {
            FlightLegComplete leg = flight.getLegs().isEmpty() ? null : (FlightLegComplete)flight.getLegs().get(0);
            for (AdditionalOrderComplete a : flight.getAdditionalOrders()) {
                if (flight.getLegs().contains(a.getLeg())) continue;
                a.setLeg((ILegComplete)leg);
            }
        }
    }

    @Override
    public void createNewData(final Node<FlightComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightComplete fc = (FlightComplete)node.getValue(FlightComplete.class);
                fc.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                fc.setAdHoc(Boolean.valueOf(true));
                fc.setRealsta(fc.getSta());
                fc.setRealstd(fc.getStd());
                if (fc.getKitchenReadyTime() == null) {
                    fc.setKitchenReadyTime(new Timestamp(System.currentTimeMillis()));
                }
                ArrayList warnings = new ArrayList();
                Node newAircraft = node.getChildNamed(DtoFieldConstants.NEW_AIR);
                Node newStowing = node.getChildNamed(DtoFieldConstants.NEW_STW);
                Node newLegs = node.getChildNamed(DtoFieldConstants.NEW_LEGS);
                fc.setLegs(new ArrayList());
                Node newFlightSchedule = node.getChildNamed(DtoFieldConstants.NEW_FS);
                Iterator it = newLegs.getChilds();
                while (it.hasNext()) {
                    Node leg = (Node)it.next();
                    leg.commitThis();
                    fc.getLegs().add(leg.getValue());
                }
                StowingListTemplateVariantLight currentStowingList = (StowingListTemplateVariantLight)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).resolveVariant((StowingListTemplateReference)newStowing.getValue(), new TimestampWrapper(fc.getStd())).getValue();
                Node legMapping = node.getChildNamed(DtoFieldConstants.LEG_MAPPING);
                legMapping.commitThis();
                Node aircraftMapping = node.getChildNamed(DtoFieldConstants.AIRCRAFT_MAPPING);
                if (aircraftMapping != null) {
                    aircraftMapping.commitThis();
                }
                ArrayList errorCallback = new ArrayList();
                for (FlightLegComplete fLeg : fc.getLegs()) {
                    for (SeatConfigurationComplete sc : currentStowingList.getSeatConfigurations()) {
                        boolean found = false;
                        for (PaxFigureComplete figure : fLeg.getPaxFigures()) {
                            if (!sc.getCabinClass().equals((Object)figure.getCabinClass())) continue;
                            found = true;
                        }
                        if (found) continue;
                        PaxFigureComplete p = new PaxFigureComplete();
                        p.setClientOId(Long.valueOf(ADTO.getNextId()));
                        p.setCabinClass(sc.getCabinClass());
                        p.setLeg(fLeg);
                        p.setNumber(Integer.valueOf(0));
                        fLeg.getPaxFigures().add(p);
                    }
                }
                Boolean canCreateFlight = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).canCreate(fc.getOutboundCode(), new TimestampWrapper(fc.getStd()), fc.getInboundCode(), new TimestampWrapper(fc.getSta()));
                if (!Boolean.TRUE.equals(canCreateFlight)) {
                    DateTimeConverter c = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
                    throw new ClientGetFromServerException("A Flight with Outbound (" + fc.getOutboundCode() + ") at " + c.convert((Object)fc.getStd(), null, new Object[0]) + " and Inbound (" + fc.getInboundCode() + ") at " + c.convert((Object)fc.getSta(), null, new Object[0]) + " already exists.");
                }
                fc.setFlightOrderReceived(Boolean.valueOf(!Boolean.TRUE.equals(fc.getCustomer().getNotifyFlightOrderReceived())));
                FlightComplete nfc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).createWithAircraft(fc, (StowingListTemplateReference)newStowing.getValue(), (AircraftReference)newAircraft.getValue(), aircraftMapping != null ? new MapWrapper((Map)aircraftMapping.getValue()) : new MapWrapper(), new MapWrapper((Map)legMapping.getValue()), new ListWrapper(warnings)).getValue();
                if (!errorCallback.isEmpty()) {
                    // empty if block
                }
                NodeToolkit.removeAffixNamed((String)"SealedEQs");
                node.removeExistingValues();
                node.setValue((Object)nfc, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightModuleDataHandler.this.setCurrentLoadMaximum(27);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllFlightStateE();
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AirportComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllTruckTourTypes();
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllSealChecks();
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllSealTypes();
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllLegTypes();
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CustomsDocumentTypeComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllBondedStates();
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllFlightTypes();
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(PaxFigureTypeComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AlaCarteMenuTypeComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SpecialMenuTypeComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(LanguageCodeComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllDateDurations();
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(FlightCategoryComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionSettingsCached();
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ProductTypeComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperProductCategoriesCached();
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(PreparationGroupComplete.class);
                FlightModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getTrolleyScanSettingsCached();
                EdelweissSettingsComplete edwSettings = (EdelweissSettingsComplete)((EdelweissServiceManager)ServiceManagerRegistry.getService(EdelweissServiceManager.class)).getSettings().getValue();
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)edwSettings, false, false);
                n.setName(((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(EdelweissSettingsComplete.class));
                NodeToolkit.addAffix((Node)n);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return FlightModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<FlightComplete> resetData(Node<FlightComplete> node) {
        return null;
    }

    @Override
    public Node<FlightComplete> createEmptyNode() {
        FlightComplete f = new FlightComplete();
        f.setClientOId(Long.valueOf(ADTO.getNextId()));
        f.setFlightState(FlightStateE.OPEN);
        if (((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getDefaultFlightScheduleType() != null) {
            f.setFlightType(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getDefaultFlightScheduleType());
        } else {
            f.setFlightType(FlightTypeE.RETURN);
        }
        f.setSta(new Timestamp(System.currentTimeMillis()));
        f.setStd(new Timestamp(System.currentTimeMillis()));
        f.setKitchenReadyTime(new Timestamp(System.currentTimeMillis()));
        f.setSobBarSetNumber("");
        f.setSobLoadFlightToHandheld(Boolean.valueOf(false));
        f.setSobState(SalesOnBoardStateE.NONE);
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)f, false, false);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node dtoNode = null;
                Long id = (Long)node.getValueForNamed("id");
                FlightComplete nflight = null;
                boolean isOpen = false;
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                if (id != null) {
                    isOpen = true;
                    nflight = FlightModuleDataHandler.this.loadCompleteFlight((FlightReference)node.getValue());
                } else {
                    FlightLight oflight = (FlightLight)node.getValue(FlightLight.class);
                    oflight.setFlightState(FlightStateE.PLANNED);
                    nflight = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getPlannedFlightComplete(oflight).getValue();
                    ClientIDToolkit.initClientIds((ADTO)nflight, new ArrayList());
                }
                for (AdditionalOrderComplete additionalOrder : nflight.getAdditionalOrders()) {
                    if (additionalOrder.getExpiryDate() != null) continue;
                    additionalOrder.setExpiryDate(FlightToolkit.createAdditionalExpiryDate((SystemSettingsComplete)settings, (FlightLight)nflight, (ProductComplete)additionalOrder.getProduct()));
                }
                if (nflight.getId() != null) {
                    List galleyNames = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getGalleys(new FlightReference(nflight.getId())).getList();
                    Node galleyNodes = INodeCreator.getDefaultImpl().createNodes(galleyNames, false, false);
                    galleyNodes.setName("usedGalleys");
                    NodeToolkit.addAffix((Node)galleyNodes);
                }
                List service = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getMappedServices(nflight).getList();
                Node serviceNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)service, true, false);
                serviceNode.setName("usedLegServices");
                NodeToolkit.removeAffixNamed((String)"usedLegServices");
                NodeToolkit.addAffix((Node)serviceNode);
                FlightToolkit.ensurePaxFigureTypesInserted((FlightLight)nflight);
                dtoNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)nflight, false, false);
                dtoNode.removeExistingValues();
                dtoNode.setValue((Object)nflight, 0L);
                dtoNode.updateNode();
                node.removeExistingValues();
                node.setValue((Object)nflight, 0L);
                node.updateNode();
                this.updateMasterData((Node<FlightLight>)node, dtoNode, id, nflight, isOpen);
                return dtoNode;
            }

            public void updateMasterData(Node<FlightLight> node2, Node dtoNode, Long id, FlightComplete nflight, boolean isOpen) throws ClientServerCallException {
                Map spmlsWrapped = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getChoosableSpecialMenuTypes((FlightLight)node2.getValue()).getMap();
                HashMap spmls = new HashMap();
                for (Map.Entry entry : spmlsWrapped.entrySet()) {
                    spmls.put(entry.getKey(), ((ListWrapper)entry.getValue()).getList());
                }
                Map alaCarteWrapped = ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getChoosableALaCarteMenuTypes((FlightLight)node2.getValue()).getMap();
                HashMap alaCarte = new HashMap();
                for (Map.Entry entry : alaCarteWrapped.entrySet()) {
                    alaCarte.put(entry.getKey(), ((ListWrapper)entry.getValue()).getList());
                }
                ArrayList ccs = new ArrayList();
                ccs.addAll(spmls.keySet());
                Node cClasses = NodeToolkit.getAffixNamed((String)"spmlCabinClasses");
                if (cClasses == null) {
                    cClasses = INodeCreator.getDefaultImpl().createNodes(ccs, false);
                    cClasses.setName("spmlCabinClasses");
                    NodeToolkit.addAffix((Node)cClasses);
                } else {
                    cClasses.removeExistingValues();
                    cClasses.setValue(ccs, 0L);
                    cClasses.updateNode();
                }
                Node types = NodeToolkit.getAffixNamed((String)"spmlMenuTypes");
                if (types == null) {
                    types = new ViewNode("spmlMenuTypes");
                    types.setValue(spmls, 0L);
                    NodeToolkit.addAffix((Node)types);
                } else {
                    types.removeExistingValues();
                    types.setValue(spmls, 0L);
                    types.updateNode();
                }
                types = NodeToolkit.getAffixNamed((String)"alaCarteMenuTypes");
                if (types == null) {
                    types = new ViewNode("alaCarteMenuTypes");
                    types.setValue(alaCarte, 0L);
                    NodeToolkit.addAffix((Node)types);
                } else {
                    types.removeExistingValues();
                    types.setValue(alaCarte, 0L);
                    types.updateNode();
                }
                ccs = new ArrayList();
                ccs.addAll(alaCarte.keySet());
                cClasses = NodeToolkit.getAffixNamed((String)"alaCarteCabinClasses");
                if (cClasses == null) {
                    cClasses = INodeCreator.getDefaultImpl().createNodes(ccs, false);
                    cClasses.setName("alaCarteCabinClasses");
                    NodeToolkit.addAffix((Node)cClasses);
                } else {
                    cClasses.removeExistingValues();
                    cClasses.setValue(ccs, 0L);
                    cClasses.updateNode();
                }
                FlightModuleDataHandler.loadSealConfiguration(nflight);
                FlightModuleDataHandler.revalidateMasterData(nflight, isOpen, dtoNode);
                FlightModuleDataHandler.this.latestStwLoaded = nflight.getActiveStowingList();
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    public static void loadSealConfiguration(FlightComplete nflight) throws ClientServerCallException {
        FlightSealsComplete eqs;
        NodeToolkit.removeAffixNamed((String)"SealedEQs");
        if (nflight == null || nflight.getId() == null) {
            return;
        }
        GalleyEquipmentSearchConfiguration g = new GalleyEquipmentSearchConfiguration();
        g.setFlight(new FlightReference(nflight.getId()));
        FlightSealsComplete seals = eqs = (FlightSealsComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightSeals(g).getValue();
        seals.setClientOId(Long.valueOf(ADTO.getNextId()));
        for (EquipmentSealsComplete e : seals.getEquipments()) {
            e.setClientOId(Long.valueOf(ADTO.getNextId()));
        }
        Node sealedEqs = INodeCreator.getDefaultImpl().getNode4DTO((Object)eqs, false, false);
        sealedEqs.setName("SealedEQs");
        NodeToolkit.addAffix((Node)sealedEqs);
    }

    public static <T extends FlightReference> void revalidateMasterData(FlightComplete nflight, boolean isOpen, Node<T> node) throws ClientServerCallException {
        Node r = NodeToolkit.getAffixNamed((String)"plegs");
        if (r != null) {
            Iterator it = r.getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                INodeCreator.getDefaultImpl().removeFromAllNodes(n);
            }
        }
        NodeToolkit.removeAffixNamed((String)"plegs");
        NodeToolkit.removeAffixNamed((String)((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(SpecialMealOrderComplete.class));
        NodeToolkit.removeAffixNamed((String)((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(AdditionalOrderComplete.class));
        Node adSPMLPos = null;
        if (nflight != null && nflight.getActiveStowingList() != null) {
            adSPMLPos = isOpen ? INodeCreator.getDefaultImpl().createNodes(((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalSPMLOrderSpaces((FlightReference)nflight).getList(), false) : INodeCreator.getDefaultImpl().createNodes(((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getAdditionalSPMLOrderSpaces(new StowingListTemplateReference(nflight.getActiveStowingList().getTemplate().getId()), new TimestampWrapper(nflight.getStd())).getList(), false);
            if (adSPMLPos != null) {
                adSPMLPos.setName(((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(SpecialMealOrderComplete.class));
                NodeToolkit.addAffix((Node)adSPMLPos);
            }
            Node addPos = null;
            addPos = isOpen ? INodeCreator.getDefaultImpl().createNodes(((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getAdditionalOrderSpaces((FlightReference)nflight).getList(), false) : INodeCreator.getDefaultImpl().createNodes(((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getAdditionalOrderSpaces(new StowingListTemplateReference(nflight.getActiveStowingList().getTemplate().getId()), new TimestampWrapper(nflight.getStd())).getList(), false);
            if (addPos != null) {
                NodeToolkit.removeAffixNamed((String)((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(AdditionalOrderComplete.class));
                addPos.setName(((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(AdditionalOrderComplete.class));
                NodeToolkit.addAffix((Node)addPos);
            }
        }
        if (node != null) {
            Node legs;
            Node stw = node.getChildNamed(DtoFieldConstants.OLD_STW);
            if (stw == null) {
                stw = new DTONode();
                stw.setName(DtoFieldConstants.OLD_STW);
                node.addChild(stw, 0L);
            }
            if (nflight != null) {
                stw.setValue((Object)nflight.getActiveStowingList(), 0L);
            }
            if ((legs = node.getChildNamed(FlightComplete_.legs)) != null) {
                ViewNode n = new ViewNode("plegs");
                Iterator it = legs.getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node leg = (Node)it.next();
                    n.addChild(leg, 0L);
                }
                n.setName("plegs");
                n.setValue(legs.getValue(), 0L);
                NodeToolkit.addAffix((Node)n);
            }
        }
    }

    public FlightComplete loadCompleteFlight(FlightReference l) throws ClientServerCallException {
        FlightComplete nflight = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(l.getId())).getValue();
        return nflight;
    }

    @Override
    public Class<FlightComplete> getCommittingClass() {
        return FlightComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<FlightReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }

    public void newStwSetted(StowingListLight activeStowingList) {
        this.latestStwLoaded = activeStowingList;
    }
}

