/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventorytransition;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionEntryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionFlightComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Iterator;

public class InventoryTransitionModuleDataHandler
extends DefaultDataHandler<InventoryTransitionReference, InventoryTransitionComplete> {
    public InventoryTransitionModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<InventoryTransitionReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InventoryTransitionComplete nDto;
                InventoryTransitionFlightComplete ef;
                Iterator it;
                InventoryTransitionComplete dto = (InventoryTransitionComplete)node.getValue(InventoryTransitionComplete.class);
                for (InventoryTransitionEntryComplete e : dto.getStartInventories()) {
                    it = e.getExcludedOutFlights().iterator();
                    while (it.hasNext()) {
                        ef = (InventoryTransitionFlightComplete)it.next();
                        if (ef.getFlight() != null) continue;
                        it.remove();
                    }
                    it = e.getExcludedReturnFlights().iterator();
                    while (it.hasNext()) {
                        ef = (InventoryTransitionFlightComplete)it.next();
                        if (ef.getFlight() != null) continue;
                        it.remove();
                    }
                    it = e.getIncludedOutFlights().iterator();
                    while (it.hasNext()) {
                        ef = (InventoryTransitionFlightComplete)it.next();
                        if (ef.getFlight() != null) continue;
                        it.remove();
                    }
                    it = e.getIncludedReturnFlights().iterator();
                    while (it.hasNext()) {
                        ef = (InventoryTransitionFlightComplete)it.next();
                        if (ef.getFlight() != null) continue;
                        it.remove();
                    }
                }
                for (InventoryTransitionEntryComplete e : dto.getEndInventories()) {
                    it = e.getExcludedOutFlights().iterator();
                    while (it.hasNext()) {
                        ef = (InventoryTransitionFlightComplete)it.next();
                        if (ef.getFlight() != null) continue;
                        it.remove();
                    }
                    it = e.getExcludedReturnFlights().iterator();
                    while (it.hasNext()) {
                        ef = (InventoryTransitionFlightComplete)it.next();
                        if (ef.getFlight() != null) continue;
                        it.remove();
                    }
                    it = e.getIncludedOutFlights().iterator();
                    while (it.hasNext()) {
                        ef = (InventoryTransitionFlightComplete)it.next();
                        if (ef.getFlight() != null) continue;
                        it.remove();
                    }
                    it = e.getIncludedReturnFlights().iterator();
                    while (it.hasNext()) {
                        ef = (InventoryTransitionFlightComplete)it.next();
                        if (ef.getFlight() != null) continue;
                        it.remove();
                    }
                }
                dto.getBoundary().setStartTime(CalendarUtil.getTimestampWithoutSecond((Timestamp)dto.getBoundary().getStartTime()));
                dto.getBoundary().setEndTime(CalendarUtil.getTimestampWithoutSecond((Timestamp)dto.getBoundary().getEndTime()));
                if (dto.getInternalConsumptionStart() != null) {
                    dto.setInternalConsumptionStart(CalendarUtil.getTimestampWithoutSecond((Timestamp)dto.getInternalConsumptionStart()));
                }
                if (dto.getInternalConsumptionEnd() != null) {
                    dto.setInternalConsumptionEnd(CalendarUtil.getTimestampWithoutSecond((Timestamp)dto.getInternalConsumptionEnd()));
                }
                if ((nDto = (InventoryTransitionComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).updateInventoryTransition(dto).getValue()) != null) {
                    node.removeExistingValues();
                    node.setValue((Object)nDto, System.currentTimeMillis());
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<InventoryTransitionComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InventoryTransitionComplete dto = (InventoryTransitionComplete)node.getValue();
                if (dto.getEligibleLocations().isEmpty()) {
                    dto.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                InventoryTransitionComplete nDto = (InventoryTransitionComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).createInventoryTransition(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, System.currentTimeMillis());
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InventoryTransitionModuleDataHandler.this.setCurrentLoadMaximum(9);
                InventoryTransitionModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                InventoryTransitionModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                InventoryTransitionModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesCached();
                InventoryTransitionModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllBondedStates();
                InventoryTransitionModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllInUseStates();
                InventoryTransitionModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllNominatedStates();
                InventoryTransitionModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllDeletedStates();
                InventoryTransitionModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllCustomerOwnedStates();
                InventoryTransitionModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllIncludeArticleFromStartInventoryStates();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return InventoryTransitionModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<InventoryTransitionComplete> resetData(Node<InventoryTransitionComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Node<InventoryTransitionComplete> createEmptyNode() {
        InventoryTransitionComplete dto = new InventoryTransitionComplete();
        dto.setClientOId(Long.valueOf(ADTO.getNextId()));
        dto.setDate(new Date(System.currentTimeMillis()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)dto, false, false);
        return n;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InventoryTransitionLight inven = (InventoryTransitionLight)node.getValue(InventoryTransitionLight.class);
                InventoryTransitionComplete ninven = (InventoryTransitionComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).getByTransition(new InventoryTransitionReference(inven.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)ninven, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Class<InventoryTransitionComplete> getCommittingClass() {
        return InventoryTransitionComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<InventoryTransitionReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

