/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.knifetracking.transaction;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.KnifeStateEConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.knifetracking.transaction.KnifeTransactionModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.knifetracking.transaction.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.KnifeTransactionSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.KnifeTransactionAccess;
import ch.icit.pegasus.server.core.dtos.search.KnifeTransactionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeStateE;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeTransactionComplete;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeTransactionComplete_;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class KnifeTransactionModule
extends ScreenTableView<KnifeTransactionComplete, KnifeTransactionSearchConfiguration.KNIFE_TRANSACTION_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_BARCODE = "barcode_filter";
    private static final String FILTER_PERIOD = "period_filter";
    private static final String FILTER_STATE = "state_filter";
    private static final String FILTER_DEPARTMENT = "department_filter";
    private String searchFilter;
    private TitledPeriodEditor periodSearchFilter;
    private KnifeStateE stateFilter;
    private InternalCostCenterComplete costCenterFilter;
    private ComboBox stateBox;
    private ComboBox decisionBox;
    private ComboBox typeBox;
    private ComboBox departmentBox;

    public KnifeTransactionModule() {
        super(KnifeTransactionComplete.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public boolean isDeletable(RowModel<KnifeTransactionComplete> model) {
        return false;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return KnifeTransactionAccess.MODULE_KNIFE_TRANSACTION;
    }

    public KnifeTransactionModuleDataHandler getDataHandler() {
        return (KnifeTransactionModuleDataHandler)this.getTable().getModel().getDataHandler();
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", KnifeTransactionSearchConfiguration.KNIFE_TRANSACTION_COLUMN.BARCODE + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_BARCODE, Words.NAME, "");
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        TitledPeriodEditor periodEditor = this.filterChain.addPeriodSelection(FILTER_PERIOD, p.getStartDate(), p.getEndDate(), Words.DATE, true);
        periodEditor.setCheckBoxEnabled();
        periodEditor.setCheckBoxChecked(false);
        periodEditor.setCommitOnFocusLost(true);
        this.stateBox = ComboBoxFactory.getKnifeState(true);
        this.departmentBox = new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class));
        this.filterChain.addSelectionComboBox(this.stateBox, 150, FILTER_STATE, Words.STATE, Words.ALL);
        this.filterChain.addSelectionComboBox(this.departmentBox, 150, FILTER_DEPARTMENT, Words.DEPARTMENT, Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<KnifeTransactionComplete, KnifeTransactionSearchConfiguration.KNIFE_TRANSACTION_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchFilter = "";
            this.stateFilter = null;
            this.periodSearchFilter = null;
            this.costCenterFilter = null;
        } else if (name == FILTER_BARCODE) {
            this.searchFilter = (String)value;
        } else if (name == FILTER_PERIOD) {
            this.periodSearchFilter = (TitledPeriodEditor)value;
        } else if (name == FILTER_STATE) {
            this.stateFilter = value instanceof KnifeStateE ? (KnifeStateE)value : null;
        } else if (name == FILTER_DEPARTMENT) {
            this.costCenterFilter = value instanceof Node ? (InternalCostCenterComplete)((Node)value).getValue() : (value instanceof InternalCostCenterComplete ? (InternalCostCenterComplete)value : null);
        }
        KnifeTransactionSearchConfiguration c = new KnifeTransactionSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setBarcode(this.searchFilter);
        c.setKnifeState(this.stateFilter);
        c.setDepartment(this.costCenterFilter);
        if (this.periodSearchFilter != null) {
            c.setPeriod(this.periodSearchFilter.getPeriod());
        }
        c.setNumResults(this.numberOfShownResults);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public SearchAlgorithm<KnifeTransactionComplete> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(KnifeTransactionSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        List costCenters = (List)NodeToolkit.getAffixList(InternalCostCenterComplete.class).getValue();
        this.departmentBox.refreshPossibleValues(INodeCreator.getDefaultImpl().createNodes(costCenters, false));
        this.departmentBox.addItem(Words.ALL);
        this.departmentBox.setSelectedItem(Words.ALL);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<KnifeTransactionComplete> model) {
        KnifeTransactionComplete ab = (KnifeTransactionComplete)model.getNode().getValue();
        return model != null;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.ONE;
    }

    @Override
    protected RowEditorFactory<KnifeTransactionComplete> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<KnifeTransactionComplete> rowEditor = new MessageProvidedRowEditor<KnifeTransactionComplete>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<KnifeTransactionComplete>)rowEditor, p);
            rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new KnifeTransactionModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.BARCODE, "", (Class)StringConverter.class, null, "#knife-barcode", TableColumnInfo.numberColumnWithExpandWidth));
        info.add(new TableColumnInfo(Words.DEPARTMENT, "", (Class)CostCenterConverter.class, null, "#knife-department", TableColumnInfo.dateColumnWidth * 2));
        info.add(new TableColumnInfo(Words.STATE, "", (Class)KnifeStateEConverter.class, (Enum<?>)KnifeTransactionSearchConfiguration.KNIFE_TRANSACTION_COLUMN.KNIFE_STATE, KnifeTransactionComplete_.knifeState, TableColumnInfo.dateColumnWidth));
        info.add(new TableColumnInfo(Words.DATE, "", (Class)DateTimeConverter.class, (Enum<?>)KnifeTransactionSearchConfiguration.KNIFE_TRANSACTION_COLUMN.PERIOD, KnifeTransactionComplete_.date, TableColumnInfo.dateTimeColumnWidth));
        return info;
    }
}

