/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.labellayout;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.file.FileServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.ReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete_;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class LabelLayoutModuleDataHandler
extends DefaultDataHandler<ReportFileComplete, ReportFileComplete> {
    public LabelLayoutModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return "Check Files";
    }

    private void fixLocalStyleSheet(File fileToFix) throws IOException {
        String fileContent = FileUtils.readFileToString((File)fileToFix);
        fileContent.replaceAll("textAdjust=\"StretchHeight\"", "isStretchWithOverflow=\"true\"");
        FileUtils.writeStringToFile((File)fileToFix, (String)fileContent);
    }

    @Override
    public void updateData(final Node<ReportFileComplete> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(ReportFileComplete.class);
                ReportFileComplete d = (ReportFileComplete)node.getValue(ReportFileComplete.class);
                if (node.getChildNamed(ReportFileComplete_.localFile) != null && node.getChildNamed(ReportFileComplete_.localFile).getValue() != null) {
                    File jrxmlFile = (File)node.getChildNamed(ReportFileComplete_.localFile).getValue();
                    LabelLayoutModuleDataHandler.this.fixLocalStyleSheet(jrxmlFile);
                    String desc = d.getDescription();
                    d.setCategory(FileCategoryE.STYLESHEET);
                    d.setReportType(ReportTypeE.LABEL);
                    d.setLocalFile(jrxmlFile);
                    d.setDescription(d.getDescription());
                    String fname = jrxmlFile.getName();
                    String sname = "";
                    int i = fname.lastIndexOf(".");
                    if (i != -1) {
                        sname = fname.substring(i + 1, fname.length());
                        fname = fname.substring(0, i);
                    }
                    d.setFileSuffix(sname);
                    d.setFileName(fname);
                    if (d.getId() == null) {
                        d = (ReportFileComplete)FileTransferUtil.upload((PegasusFileComplete)d, (FileTransferListener[])new FileTransferListener[0]);
                    } else {
                        FileTransferUtil.replace((PegasusFileComplete)d, (File)jrxmlFile, (FileTransferListener[])new FileTransferListener[0]);
                    }
                    d.setDescription(desc);
                    if (d.getId() == null) {
                        d = (ReportFileComplete)((FileServiceManager)ServiceManagerRegistry.getService(FileServiceManager.class)).create((PegasusFileComplete)d);
                    } else {
                        ((FileServiceManager)ServiceManagerRegistry.getService(FileServiceManager.class)).update((PegasusFileComplete)d);
                    }
                    ((ReportServiceManager)ServiceManagerRegistry.getService(ReportServiceManager.class)).compileJasperReport(d);
                } else if (d.getId() != null) {
                    ((FileServiceManager)ServiceManagerRegistry.getService(FileServiceManager.class)).update((PegasusFileComplete)d);
                } else {
                    d = (ReportFileComplete)((FileServiceManager)ServiceManagerRegistry.getService(FileServiceManager.class)).create((PegasusFileComplete)d);
                }
                node.removeExistingValues();
                node.setValue((Object)d, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(Node<ReportFileComplete> node, RemoteLoader model, boolean sameNode, ProgressListener l) {
        this.updateData(node, model, l);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                LabelLayoutModuleDataHandler.this.setCurrentLoadMaximum(2);
                LabelLayoutModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return LabelLayoutModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ReportFileComplete> resetData(Node<ReportFileComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Node<ReportFileComplete> createEmptyNode() {
        ReportFileComplete newOne = new ReportFileComplete();
        newOne.setReportType(ReportTypeE.LABEL);
        newOne.setDescription("New Label");
        newOne.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)newOne, false, false);
        INodeCreator.getDefaultImpl().initUpdate(n);
        return n;
    }

    @Override
    public Class<ReportFileComplete> getCommittingClass() {
        return ReportFileComplete.class;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void doRemoteValidation(Node<ReportFileComplete> node, final RemoteLoader listener, ProgressListener l, boolean validateAll) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }
}

