/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.tables.InternalCostCenterPriceTable;
import ch.icit.pegasus.client.gui.utils.tables.ManMinutesOverflowTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete_;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete_;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterManMinutesPriceComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class InternalCostCenterConfig
extends MasterDataInsert<InternalCostCenterComplete> {
    private static final long serialVersionUID = 1L;

    public InternalCostCenterConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new CostCenterConfigPanel();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                return ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllUnCached(InternalCostCenterConfig.this.getMasterDataClass(), true);
            }

            @Override
            public RemoteLoader getInvoker() {
                return InternalCostCenterConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public InternalCostCenterComplete getNewObject() {
        InternalCostCenterComplete a = new InternalCostCenterComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        PriceComplete p = new PriceComplete();
        if (NodeToolkit.getAffixClass(SystemSettingsComplete.class) != null) {
            p.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
        }
        p.setPrice(Double.valueOf(0.0));
        InternalCostCenterManMinutesPriceComplete price = new InternalCostCenterManMinutesPriceComplete();
        price.setValidity(new PeriodComplete(new Date(DateUtil.getDefaultStartDate().getTime()), DateUtil.getSQLInfinityDate()));
        price.setPricePerHour(new PriceComplete(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency(), Double.valueOf(0.0)));
        return a;
    }

    @Override
    public Class<? extends InternalCostCenterComplete> getMasterDataClass() {
        return InternalCostCenterComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Internal Departments";
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean descriptionSet = true;
        boolean pricePerCateringPointSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(InternalCostCenterComplete_.description).getValue() == null) {
                descriptionSet = false;
            }
            if (n.getChildNamed(InternalCostCenterComplete_.pricePerCateringPoint).getValue() == null || n.getChildNamed(new DtoField[]{InternalCostCenterComplete_.pricePerCateringPoint, PriceComplete_.price}).getValue() == null || n.getChildNamed(new DtoField[]{InternalCostCenterComplete_.pricePerCateringPoint, PriceComplete_.currency}).getValue() == null) {
                pricePerCateringPointSet = false;
            }
            if (n.getChildNamed(InternalCostCenterComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(InternalCostCenterComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(InternalCostCenterComplete_.code).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(InternalCostCenterComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!descriptionSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Descriptions are set"));
        }
        if (!pricePerCateringPointSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Man Hour Costs are set"));
        }
        return a;
    }

    private class CostCenterConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> description;
        private TitledItem<TextField> notificationEMail;
        private TitledItem<TextField> incidentNotificationMail;
        private InternalCostCenterPriceTable costPerManHour;
        private TitledItem<CheckBox> showAllPossiblePositionsOnRequisitionDeliverSheet;
        private TitledItem<CheckBox> defaultRCDepartment;
        private TitledItem<CheckBox> isProductionUnit;
        private TitledItem<CheckBox> articleDefaultProductionUnit;
        private TitledItem<CheckBox> articleDefaultRequisitionUnit;
        private TitledItem<CheckBox> recipeDefaultProductionUnit;
        private TitledItem<CheckBox> articleInProductUnit;
        private TitledItem<CheckBox> recipeInProductUnit;
        private TitledItem<CheckBox> productGroupUnit;
        private TitledItem<CheckBox> productUnit;
        private TitledItem<CheckBox> stowingListEquipmentOwnerUnit;
        private TitledItem<CheckBox> articleInProductMMUnit;
        private TitledItem<CheckBox> recipeInProductMMUnit;
        private TitledItem<CheckBox> productGroupMMUnit;
        private TitledItem<CheckBox> productMMUnit;
        private TitledItem<TextField> sequenceNumber;
        private TitledItem<TextField> defaultRequisitionPrinter;
        private TitledItem<CheckBox> autoPrint;
        private ManMinutesOverflowTable manMinutesOverflow;
        private TitledItem<CheckBox> kfcCcpHaccp;
        private TitledItem<CheckBox> kfcComponentOprp;
        private TitledItem<CheckBox> kfcKitchenOrderSheet;
        private TitledItem<CheckBox> kfcOprpLog;
        private TitledItem<CheckBox> kfcProduct;
        private TitledItem<CheckBox> kfcProductComponent;
        private TitledItem<CheckBox> kfcManMinute;
        private TitledItem<CheckBox> kfcProducedByFlight;
        private TitledItem<CheckBox> kfcRecipeAsExcel;
        private TitledItem<CheckBox> kfcRecipeBased;
        private TitledItem<CheckBox> purchaseOrderDepartment;
        private TitledItem<CheckBox> incidentDepartment;

        public CostCenterConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.costPerManHour = new InternalCostCenterPriceTable();
            this.notificationEMail = new TitledItem<TextField>(new TextField(null), Words.NOTIFICATION_MAIL, TitledItem.TitledItemOrientation.NORTH);
            this.notificationEMail.getElement().setMaxChar(Integer.MAX_VALUE);
            this.incidentNotificationMail = new TitledItem<TextField>(new TextField(null), Words.INCIDENT_LOG_REMINDER, TitledItem.TitledItemOrientation.NORTH);
            this.incidentNotificationMail.getElement().setMaxChar(Integer.MAX_VALUE);
            this.showAllPossiblePositionsOnRequisitionDeliverSheet = new TitledItem<CheckBox>(new CheckBox(null), "Show all possible Positions on Requisition Deliver Sheet", TitledItem.TitledItemOrientation.EAST);
            this.articleDefaultProductionUnit = new TitledItem<CheckBox>(new CheckBox(null), Words.ARTICLE_DEFAULT_PRODUCTION_DEPARTMENT, TitledItem.TitledItemOrientation.EAST);
            this.articleDefaultRequisitionUnit = new TitledItem<CheckBox>(new CheckBox(null), Words.ARTICLE_DEFAULT_REQUISITION_DEPARTMENT, TitledItem.TitledItemOrientation.EAST);
            this.recipeDefaultProductionUnit = new TitledItem<CheckBox>(new CheckBox(null), Words.RECIPE_DEFAULT_PRODUCTION_DEPARTMENT, TitledItem.TitledItemOrientation.EAST);
            this.defaultRCDepartment = new TitledItem<CheckBox>(new CheckBox(), Words.DEFAULT_RC_DEPARTMENT, TitledItem.TitledItemOrientation.EAST);
            this.isProductionUnit = new TitledItem<CheckBox>(new CheckBox(), "is Production Unit", TitledItem.TitledItemOrientation.EAST);
            this.stowingListEquipmentOwnerUnit = new TitledItem<CheckBox>(new CheckBox(), "is Stowing List Equipment Owner Unit", TitledItem.TitledItemOrientation.EAST);
            this.articleInProductUnit = new TitledItem<CheckBox>(new CheckBox(), "Article in Product Unit", TitledItem.TitledItemOrientation.EAST);
            this.recipeInProductUnit = new TitledItem<CheckBox>(new CheckBox(), "Recipe in Product Unit", TitledItem.TitledItemOrientation.EAST);
            this.productGroupUnit = new TitledItem<CheckBox>(new CheckBox(), "Product Group Unit", TitledItem.TitledItemOrientation.EAST);
            this.productUnit = new TitledItem<CheckBox>(new CheckBox(), "Product Unit", TitledItem.TitledItemOrientation.EAST);
            this.articleInProductMMUnit = new TitledItem<CheckBox>(new CheckBox(), "Article in Product Man Minute Unit", TitledItem.TitledItemOrientation.EAST);
            this.recipeInProductMMUnit = new TitledItem<CheckBox>(new CheckBox(), "Recipe in Product Man Minute Unit", TitledItem.TitledItemOrientation.EAST);
            this.productGroupMMUnit = new TitledItem<CheckBox>(new CheckBox(), "Product Group Man Minute Unit", TitledItem.TitledItemOrientation.EAST);
            this.productMMUnit = new TitledItem<CheckBox>(new CheckBox(), "Product Man Minute Unit", TitledItem.TitledItemOrientation.EAST);
            this.sequenceNumber = new TitledItem<TextField>(new TextField(null, TextFieldType.INT), Words.SEQUENCE_NUMBER, TitledItem.TitledItemOrientation.NORTH);
            this.defaultRequisitionPrinter = new TitledItem<TextField>(new TextField(null), "Default Requisition Deliver Printer", TitledItem.TitledItemOrientation.EAST);
            this.autoPrint = new TitledItem<CheckBox>(new CheckBox(), "Send Requisition to Global Print Service", TitledItem.TitledItemOrientation.EAST);
            this.manMinutesOverflow = new ManMinutesOverflowTable();
            this.kfcCcpHaccp = new TitledItem<CheckBox>(new CheckBox(), "KFC CCP/HACCP", TitledItem.TitledItemOrientation.EAST);
            this.kfcComponentOprp = new TitledItem<CheckBox>(new CheckBox(), "KFC Component OPRP", TitledItem.TitledItemOrientation.EAST);
            this.kfcKitchenOrderSheet = new TitledItem<CheckBox>(new CheckBox(), "KFC Kitchen Order Sheet", TitledItem.TitledItemOrientation.EAST);
            this.kfcOprpLog = new TitledItem<CheckBox>(new CheckBox(), "KFC OPRP Log", TitledItem.TitledItemOrientation.EAST);
            this.kfcProduct = new TitledItem<CheckBox>(new CheckBox(), "KFC Product", TitledItem.TitledItemOrientation.EAST);
            this.kfcProductComponent = new TitledItem<CheckBox>(new CheckBox(), "KFC Product Component", TitledItem.TitledItemOrientation.EAST);
            this.kfcManMinute = new TitledItem<CheckBox>(new CheckBox(), "KFC Production Man Minutes", TitledItem.TitledItemOrientation.EAST);
            this.kfcProducedByFlight = new TitledItem<CheckBox>(new CheckBox(), "KFC Produced by Flight", TitledItem.TitledItemOrientation.EAST);
            this.kfcRecipeAsExcel = new TitledItem<CheckBox>(new CheckBox(), "KFC Recipe as Excel", TitledItem.TitledItemOrientation.EAST);
            this.kfcRecipeBased = new TitledItem<CheckBox>(new CheckBox(), "KFC Recipe based", TitledItem.TitledItemOrientation.EAST);
            this.purchaseOrderDepartment = new TitledItem<CheckBox>(new CheckBox(), "Purchase Order Department", TitledItem.TitledItemOrientation.EAST);
            this.incidentDepartment = new TitledItem<CheckBox>(new CheckBox(), "Incident Departmet", TitledItem.TitledItemOrientation.EAST);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.description);
            this.add(this.costPerManHour);
            this.add(this.defaultRCDepartment);
            this.add(this.isProductionUnit);
            this.add(this.stowingListEquipmentOwnerUnit);
            this.add(this.notificationEMail);
            this.add(this.incidentNotificationMail);
            this.add(this.articleInProductUnit);
            this.add(this.recipeInProductUnit);
            this.add(this.productGroupUnit);
            this.add(this.productUnit);
            this.add(this.articleInProductMMUnit);
            this.add(this.recipeInProductMMUnit);
            this.add(this.productGroupMMUnit);
            this.add(this.productMMUnit);
            this.add(this.defaultRequisitionPrinter);
            this.add(this.autoPrint);
            this.add(this.sequenceNumber);
            this.add(this.manMinutesOverflow);
            this.add(this.articleDefaultProductionUnit);
            this.add(this.articleDefaultRequisitionUnit);
            this.add(this.recipeDefaultProductionUnit);
            this.add(this.kfcCcpHaccp);
            this.add(this.kfcComponentOprp);
            this.add(this.kfcKitchenOrderSheet);
            this.add(this.kfcOprpLog);
            this.add(this.kfcProduct);
            this.add(this.kfcProductComponent);
            this.add(this.kfcManMinute);
            this.add(this.kfcProducedByFlight);
            this.add(this.kfcRecipeAsExcel);
            this.add(this.kfcRecipeBased);
            this.add(this.purchaseOrderDepartment);
            this.add(this.incidentDepartment);
            this.add(this.showAllPossiblePositionsOnRequisitionDeliverSheet);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            a.addAll(this.description.getFocusComponents());
            CheckedListAdder.addToList(a, this.notificationEMail);
            CheckedListAdder.addToList(a, this.incidentNotificationMail);
            a.addAll(this.costPerManHour.getFocusComponents());
            CheckedListAdder.addToList(a, this.defaultRCDepartment);
            CheckedListAdder.addToList(a, this.showAllPossiblePositionsOnRequisitionDeliverSheet);
            a.addAll(this.isProductionUnit.getFocusComponents());
            CheckedListAdder.addToList(a, this.articleDefaultProductionUnit);
            CheckedListAdder.addToList(a, this.articleDefaultRequisitionUnit);
            CheckedListAdder.addToList(a, this.articleInProductUnit);
            CheckedListAdder.addToList(a, this.articleInProductMMUnit);
            CheckedListAdder.addToList(a, this.recipeDefaultProductionUnit);
            CheckedListAdder.addToList(a, this.recipeInProductUnit);
            CheckedListAdder.addToList(a, this.recipeInProductMMUnit);
            CheckedListAdder.addToList(a, this.productGroupUnit);
            CheckedListAdder.addToList(a, this.productGroupMMUnit);
            CheckedListAdder.addToList(a, this.productUnit);
            CheckedListAdder.addToList(a, this.productMMUnit);
            CheckedListAdder.addToList(a, this.stowingListEquipmentOwnerUnit);
            a.addAll(this.sequenceNumber.getFocusComponents());
            CheckedListAdder.addToList(a, this.autoPrint);
            a.addAll(this.defaultRequisitionPrinter.getFocusComponents());
            CheckedListAdder.addToList(a, this.manMinutesOverflow);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
            this.notificationEMail.setVisibleContainer(pane);
            this.incidentNotificationMail.setVisibleContainer(pane);
            this.costPerManHour.setVisibleContainer(pane);
            this.showAllPossiblePositionsOnRequisitionDeliverSheet.setVisibleContainer(pane);
            this.defaultRCDepartment.setVisibleContainer(pane);
            this.isProductionUnit.setVisibleContainer(pane);
            this.stowingListEquipmentOwnerUnit.setVisibleContainer(pane);
            this.articleDefaultProductionUnit.setVisibleContainer(pane);
            this.articleDefaultRequisitionUnit.setVisibleContainer(pane);
            this.articleInProductUnit.setVisibleContainer(pane);
            this.articleInProductMMUnit.setVisibleContainer(pane);
            this.recipeDefaultProductionUnit.setVisibleContainer(pane);
            this.recipeInProductUnit.setVisibleContainer(pane);
            this.recipeInProductMMUnit.setVisibleContainer(pane);
            this.productGroupUnit.setVisibleContainer(pane);
            this.productGroupMMUnit.setVisibleContainer(pane);
            this.productUnit.setVisibleContainer(pane);
            this.productMMUnit.setVisibleContainer(pane);
            this.autoPrint.setVisibleContainer(pane);
            this.defaultRequisitionPrinter.setVisibleContainer(pane);
            this.sequenceNumber.setVisibleContainer(pane);
            this.manMinutesOverflow.setVisibleContainer(pane);
            this.kfcCcpHaccp.setVisibleContainer(pane);
            this.kfcComponentOprp.setVisibleContainer(pane);
            this.kfcKitchenOrderSheet.setVisibleContainer(pane);
            this.kfcOprpLog.setVisibleContainer(pane);
            this.kfcProduct.setVisibleContainer(pane);
            this.kfcProductComponent.setVisibleContainer(pane);
            this.kfcManMinute.setVisibleContainer(pane);
            this.kfcProducedByFlight.setVisibleContainer(pane);
            this.kfcRecipeAsExcel.setVisibleContainer(pane);
            this.kfcRecipeBased.setVisibleContainer(pane);
            this.purchaseOrderDepartment.setVisibleContainer(pane);
            this.incidentDepartment.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.notificationEMail.kill();
            this.incidentNotificationMail.kill();
            this.costPerManHour.kill();
            this.defaultRCDepartment.kill();
            this.isProductionUnit.kill();
            this.stowingListEquipmentOwnerUnit.kill();
            this.showAllPossiblePositionsOnRequisitionDeliverSheet.kill();
            this.autoPrint.kill();
            this.defaultRequisitionPrinter.kill();
            this.sequenceNumber.kill();
            this.articleDefaultRequisitionUnit.kill();
            this.articleDefaultProductionUnit.kill();
            this.articleInProductUnit.kill();
            this.articleInProductMMUnit.kill();
            this.recipeDefaultProductionUnit.kill();
            this.recipeInProductUnit.kill();
            this.recipeInProductMMUnit.kill();
            this.productGroupUnit.kill();
            this.productGroupMMUnit.kill();
            this.productUnit.kill();
            this.productMMUnit.kill();
            this.manMinutesOverflow.kill();
            this.kfcCcpHaccp.kill();
            this.kfcComponentOprp.kill();
            this.kfcKitchenOrderSheet.kill();
            this.kfcOprpLog.kill();
            this.kfcProduct.kill();
            this.kfcProductComponent.kill();
            this.kfcManMinute.kill();
            this.kfcProducedByFlight.kill();
            this.kfcRecipeAsExcel.kill();
            this.kfcRecipeBased.kill();
            this.purchaseOrderDepartment.kill();
            this.incidentDepartment.kill();
            this.code = null;
            this.showAllPossiblePositionsOnRequisitionDeliverSheet = null;
            this.description = null;
            this.notificationEMail = null;
            this.incidentNotificationMail = null;
            this.costPerManHour = null;
            this.defaultRCDepartment = null;
            this.isProductionUnit = null;
            this.autoPrint = null;
            this.defaultRequisitionPrinter = null;
            this.sequenceNumber = null;
            this.articleDefaultProductionUnit = null;
            this.articleDefaultRequisitionUnit = null;
            this.articleInProductUnit = null;
            this.recipeDefaultProductionUnit = null;
            this.recipeInProductUnit = null;
            this.productGroupUnit = null;
            this.productUnit = null;
            this.articleInProductMMUnit = null;
            this.recipeInProductMMUnit = null;
            this.productGroupMMUnit = null;
            this.productMMUnit = null;
            this.kfcCcpHaccp = null;
            this.kfcComponentOprp = null;
            this.kfcKitchenOrderSheet = null;
            this.kfcOprpLog = null;
            this.kfcProduct = null;
            this.kfcProductComponent = null;
            this.kfcManMinute = null;
            this.kfcProducedByFlight = null;
            this.kfcRecipeAsExcel = null;
            this.kfcRecipeBased = null;
            this.purchaseOrderDepartment = null;
            this.incidentDepartment = null;
            this.stowingListEquipmentOwnerUnit = null;
            this.manMinutesOverflow = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.notificationEMail.setEnabled(b);
            this.incidentNotificationMail.setEnabled(b);
            this.costPerManHour.setEnabled(b);
            this.defaultRCDepartment.setEnabled(b);
            this.isProductionUnit.setEnabled(b);
            this.autoPrint.setEnabled(b);
            this.defaultRequisitionPrinter.setEnabled(b);
            this.sequenceNumber.setEnabled(b);
            this.showAllPossiblePositionsOnRequisitionDeliverSheet.setEnabled(b);
            this.articleDefaultRequisitionUnit.setEnabled(b);
            this.articleDefaultProductionUnit.setEnabled(b);
            this.articleInProductUnit.setEnabled(b);
            this.recipeDefaultProductionUnit.setEnabled(b);
            this.recipeInProductUnit.setEnabled(b);
            this.productGroupUnit.setEnabled(b);
            this.productUnit.setEnabled(b);
            this.articleInProductMMUnit.setEnabled(b);
            this.recipeInProductMMUnit.setEnabled(b);
            this.productGroupMMUnit.setEnabled(b);
            this.productMMUnit.setEnabled(b);
            this.stowingListEquipmentOwnerUnit.setEnabled(b);
            this.manMinutesOverflow.setEnabled(b);
            this.kfcCcpHaccp.setEnabled(b);
            this.kfcComponentOprp.setEnabled(b);
            this.kfcKitchenOrderSheet.setEnabled(b);
            this.kfcOprpLog.setEnabled(b);
            this.kfcProduct.setEnabled(b);
            this.kfcProductComponent.setEnabled(b);
            this.kfcManMinute.setEnabled(b);
            this.kfcProducedByFlight.setEnabled(b);
            this.kfcRecipeAsExcel.setEnabled(b);
            this.kfcRecipeBased.setEnabled(b);
            this.purchaseOrderDepartment.setEnabled(b);
            this.incidentDepartment.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.code));
            this.description.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.description));
            if (node.getChildNamed(InternalCostCenterComplete_.pricePerCateringPoint).getValue() == null) {
                PriceComplete p = new PriceComplete();
                if (NodeToolkit.getAffixClass(SystemSettingsComplete.class) != null) {
                    p.setCurrency(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency());
                }
                p.setPrice(Double.valueOf(0.0));
                node.getChildNamed(InternalCostCenterComplete_.pricePerCateringPoint).setValue((Object)p, 0L);
                node.getChildNamed(InternalCostCenterComplete_.pricePerCateringPoint).updateNode();
            }
            if (node.getChildNamed(InternalCostCenterComplete_.isProductionUnit).getValue() == null) {
                node.getChildNamed(InternalCostCenterComplete_.isProductionUnit).setValue((Object)false, 0L);
            }
            this.costPerManHour.getModel().setNode(node.getChildNamed(InternalCostCenterComplete_.pricePerHour));
            this.defaultRCDepartment.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.defaultRCDepartment));
            this.isProductionUnit.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.isProductionUnit));
            this.autoPrint.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.autoPrint));
            this.defaultRequisitionPrinter.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.defaultRequisitionDeliverPrinter));
            this.sequenceNumber.getElement().setNode(node.getChildNamed(CostCenterComplete_.sequenceNumber));
            this.articleDefaultProductionUnit.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.articleDefaultPreparationUnit));
            this.articleDefaultRequisitionUnit.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.articleDefaultRequisitionUnit));
            this.articleInProductUnit.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.articleInProductUnit));
            this.notificationEMail.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.defaultMailAddress));
            this.incidentNotificationMail.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.incidentNotificationAddress));
            this.recipeDefaultProductionUnit.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.recipeDefaultPreparationUnit));
            this.recipeInProductUnit.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.recipeInProductUnit));
            this.productGroupUnit.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.productGroupUnit));
            this.productUnit.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.productUnit));
            this.articleInProductMMUnit.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.articleInProductManMinuteUnit));
            this.recipeInProductMMUnit.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.recipeInProductManMinuteUnit));
            this.productGroupMMUnit.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.prodcutGroupManMinuteUnit));
            this.productMMUnit.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.productManMinuteUnit));
            this.stowingListEquipmentOwnerUnit.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.stowingListEquipmentOwnerUnit));
            this.manMinutesOverflow.getModel().setNode(node.getChildNamed(InternalCostCenterComplete_.manMinutesOverFlow));
            this.showAllPossiblePositionsOnRequisitionDeliverSheet.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.showAllDeliveryPositionsOnRequisitionDeliverySheet));
            this.kfcCcpHaccp.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.kfcCcpHaccp));
            this.kfcComponentOprp.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.kfcComponentOprp));
            this.kfcKitchenOrderSheet.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.kfcKitchenOrderSheet));
            this.kfcOprpLog.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.kfcOprpLog));
            this.kfcProduct.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.kfcProduct));
            this.kfcProductComponent.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.kfcProductComponent));
            this.kfcManMinute.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.kfcManMinute));
            this.kfcProducedByFlight.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.kfcProducedByFlight));
            this.kfcRecipeAsExcel.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.kfcRecipeAsExcel));
            this.kfcRecipeBased.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.kfcRecipeBased));
            this.purchaseOrderDepartment.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.purchaseDepartment));
            this.incidentDepartment.getElement().setNode(node.getChildNamed(InternalCostCenterComplete_.incidentDepartment));
            this.setEnabled(true);
            InternalCostCenterConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return InternalCostCenterComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                CostCenterConfigPanel.this.code.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.code.setSize(200, (int)CostCenterConfigPanel.this.code.getPreferredSize().getHeight());
                CostCenterConfigPanel.this.description.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.code.getY() + CostCenterConfigPanel.this.code.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.description.setSize(200, (int)CostCenterConfigPanel.this.description.getPreferredSize().getHeight());
                CostCenterConfigPanel.this.notificationEMail.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.description.getY() + CostCenterConfigPanel.this.description.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.notificationEMail.setSize(600, (int)CostCenterConfigPanel.this.notificationEMail.getPreferredSize().getHeight());
                CostCenterConfigPanel.this.incidentNotificationMail.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.notificationEMail.getY() + CostCenterConfigPanel.this.notificationEMail.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.incidentNotificationMail.setSize(600, (int)CostCenterConfigPanel.this.incidentNotificationMail.getPreferredSize().getHeight());
                CostCenterConfigPanel.this.costPerManHour.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.incidentNotificationMail.getY() + CostCenterConfigPanel.this.incidentNotificationMail.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.costPerManHour.setSize(600, 200);
                CostCenterConfigPanel.this.defaultRCDepartment.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.costPerManHour.getY() + CostCenterConfigPanel.this.costPerManHour.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.defaultRCDepartment.setSize(CostCenterConfigPanel.this.defaultRCDepartment.getPreferredSize());
                CostCenterConfigPanel.this.showAllPossiblePositionsOnRequisitionDeliverSheet.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.defaultRCDepartment.getY() + CostCenterConfigPanel.this.defaultRCDepartment.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.showAllPossiblePositionsOnRequisitionDeliverSheet.setSize(CostCenterConfigPanel.this.showAllPossiblePositionsOnRequisitionDeliverSheet.getPreferredSize());
                CostCenterConfigPanel.this.isProductionUnit.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.showAllPossiblePositionsOnRequisitionDeliverSheet.getY() + CostCenterConfigPanel.this.showAllPossiblePositionsOnRequisitionDeliverSheet.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.isProductionUnit.setSize(CostCenterConfigPanel.this.isProductionUnit.getPreferredSize());
                CostCenterConfigPanel.this.articleDefaultProductionUnit.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.isProductionUnit.getY() + CostCenterConfigPanel.this.isProductionUnit.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding() * 2);
                CostCenterConfigPanel.this.articleDefaultProductionUnit.setSize(CostCenterConfigPanel.this.articleDefaultProductionUnit.getPreferredSize());
                CostCenterConfigPanel.this.articleDefaultRequisitionUnit.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.articleDefaultProductionUnit.getY() + CostCenterConfigPanel.this.articleDefaultProductionUnit.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding() / 4);
                CostCenterConfigPanel.this.articleDefaultRequisitionUnit.setSize(CostCenterConfigPanel.this.articleDefaultRequisitionUnit.getPreferredSize());
                CostCenterConfigPanel.this.articleInProductUnit.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.articleDefaultRequisitionUnit.getY() + CostCenterConfigPanel.this.articleDefaultRequisitionUnit.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding() / 4);
                CostCenterConfigPanel.this.articleInProductUnit.setSize(CostCenterConfigPanel.this.articleInProductUnit.getPreferredSize());
                CostCenterConfigPanel.this.articleInProductMMUnit.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding() * 2, CostCenterConfigPanel.this.articleInProductUnit.getY() + CostCenterConfigPanel.this.articleInProductUnit.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding() / 4);
                CostCenterConfigPanel.this.articleInProductMMUnit.setSize(CostCenterConfigPanel.this.articleInProductMMUnit.getPreferredSize());
                CostCenterConfigPanel.this.recipeDefaultProductionUnit.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.articleInProductMMUnit.getY() + CostCenterConfigPanel.this.articleInProductMMUnit.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.recipeDefaultProductionUnit.setSize(CostCenterConfigPanel.this.recipeDefaultProductionUnit.getPreferredSize());
                CostCenterConfigPanel.this.recipeInProductUnit.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.recipeDefaultProductionUnit.getY() + CostCenterConfigPanel.this.recipeDefaultProductionUnit.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding() / 4);
                CostCenterConfigPanel.this.recipeInProductUnit.setSize(CostCenterConfigPanel.this.recipeInProductUnit.getPreferredSize());
                CostCenterConfigPanel.this.recipeInProductMMUnit.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding() * 2, CostCenterConfigPanel.this.recipeInProductUnit.getY() + CostCenterConfigPanel.this.recipeInProductUnit.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding() / 4);
                CostCenterConfigPanel.this.recipeInProductMMUnit.setSize(CostCenterConfigPanel.this.recipeInProductMMUnit.getPreferredSize());
                CostCenterConfigPanel.this.productGroupUnit.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.recipeInProductMMUnit.getY() + CostCenterConfigPanel.this.recipeInProductMMUnit.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.productGroupUnit.setSize(CostCenterConfigPanel.this.productGroupUnit.getPreferredSize());
                CostCenterConfigPanel.this.productGroupMMUnit.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding() * 2, CostCenterConfigPanel.this.productGroupUnit.getY() + CostCenterConfigPanel.this.productGroupUnit.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding() / 4);
                CostCenterConfigPanel.this.productGroupMMUnit.setSize(CostCenterConfigPanel.this.productGroupMMUnit.getPreferredSize());
                CostCenterConfigPanel.this.productUnit.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.productGroupMMUnit.getY() + CostCenterConfigPanel.this.productGroupMMUnit.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.productUnit.setSize(CostCenterConfigPanel.this.productUnit.getPreferredSize());
                CostCenterConfigPanel.this.productMMUnit.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding() * 2, CostCenterConfigPanel.this.productUnit.getY() + CostCenterConfigPanel.this.productUnit.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding() / 4);
                CostCenterConfigPanel.this.productMMUnit.setSize(CostCenterConfigPanel.this.productMMUnit.getPreferredSize());
                CostCenterConfigPanel.this.stowingListEquipmentOwnerUnit.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.productMMUnit.getY() + CostCenterConfigPanel.this.productMMUnit.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.stowingListEquipmentOwnerUnit.setSize(CostCenterConfigPanel.this.stowingListEquipmentOwnerUnit.getPreferredSize());
                CostCenterConfigPanel.this.kfcCcpHaccp.setLocation(CostCenterConfigPanel.this.stowingListEquipmentOwnerUnit.getX() + CostCenterConfigPanel.this.stowingListEquipmentOwnerUnit.getWidth() + InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.articleDefaultProductionUnit.getY());
                CostCenterConfigPanel.this.kfcCcpHaccp.setSize(CostCenterConfigPanel.this.kfcCcpHaccp.getPreferredSize());
                CostCenterConfigPanel.this.kfcComponentOprp.setLocation(CostCenterConfigPanel.this.kfcCcpHaccp.getX(), CostCenterConfigPanel.this.kfcCcpHaccp.getY() + CostCenterConfigPanel.this.kfcCcpHaccp.getHeight() + InternalCostCenterConfig.this.masterDataTable.getInnerCellPadding());
                CostCenterConfigPanel.this.kfcComponentOprp.setSize(CostCenterConfigPanel.this.kfcComponentOprp.getPreferredSize());
                CostCenterConfigPanel.this.kfcKitchenOrderSheet.setLocation(CostCenterConfigPanel.this.kfcCcpHaccp.getX(), CostCenterConfigPanel.this.kfcComponentOprp.getY() + CostCenterConfigPanel.this.kfcComponentOprp.getHeight() + InternalCostCenterConfig.this.masterDataTable.getInnerCellPadding());
                CostCenterConfigPanel.this.kfcKitchenOrderSheet.setSize(CostCenterConfigPanel.this.kfcKitchenOrderSheet.getPreferredSize());
                CostCenterConfigPanel.this.kfcOprpLog.setLocation(CostCenterConfigPanel.this.kfcCcpHaccp.getX(), CostCenterConfigPanel.this.kfcKitchenOrderSheet.getY() + CostCenterConfigPanel.this.kfcKitchenOrderSheet.getHeight() + InternalCostCenterConfig.this.masterDataTable.getInnerCellPadding());
                CostCenterConfigPanel.this.kfcOprpLog.setSize(CostCenterConfigPanel.this.kfcOprpLog.getPreferredSize());
                CostCenterConfigPanel.this.kfcProduct.setLocation(CostCenterConfigPanel.this.kfcCcpHaccp.getX(), CostCenterConfigPanel.this.kfcOprpLog.getY() + CostCenterConfigPanel.this.kfcOprpLog.getHeight() + InternalCostCenterConfig.this.masterDataTable.getInnerCellPadding());
                CostCenterConfigPanel.this.kfcProduct.setSize(CostCenterConfigPanel.this.kfcProduct.getPreferredSize());
                CostCenterConfigPanel.this.kfcProductComponent.setLocation(CostCenterConfigPanel.this.kfcCcpHaccp.getX(), CostCenterConfigPanel.this.kfcProduct.getY() + CostCenterConfigPanel.this.kfcProduct.getHeight() + InternalCostCenterConfig.this.masterDataTable.getInnerCellPadding());
                CostCenterConfigPanel.this.kfcProductComponent.setSize(CostCenterConfigPanel.this.kfcProductComponent.getPreferredSize());
                CostCenterConfigPanel.this.kfcManMinute.setLocation(CostCenterConfigPanel.this.kfcCcpHaccp.getX(), CostCenterConfigPanel.this.kfcProductComponent.getY() + CostCenterConfigPanel.this.kfcProductComponent.getHeight() + InternalCostCenterConfig.this.masterDataTable.getInnerCellPadding());
                CostCenterConfigPanel.this.kfcManMinute.setSize(CostCenterConfigPanel.this.kfcManMinute.getPreferredSize());
                CostCenterConfigPanel.this.kfcProducedByFlight.setLocation(CostCenterConfigPanel.this.kfcCcpHaccp.getX(), CostCenterConfigPanel.this.kfcManMinute.getY() + CostCenterConfigPanel.this.kfcManMinute.getHeight() + InternalCostCenterConfig.this.masterDataTable.getInnerCellPadding());
                CostCenterConfigPanel.this.kfcProducedByFlight.setSize(CostCenterConfigPanel.this.kfcProducedByFlight.getPreferredSize());
                CostCenterConfigPanel.this.kfcRecipeAsExcel.setLocation(CostCenterConfigPanel.this.kfcCcpHaccp.getX(), CostCenterConfigPanel.this.kfcProducedByFlight.getY() + CostCenterConfigPanel.this.kfcProducedByFlight.getHeight() + InternalCostCenterConfig.this.masterDataTable.getInnerCellPadding());
                CostCenterConfigPanel.this.kfcRecipeAsExcel.setSize(CostCenterConfigPanel.this.kfcRecipeAsExcel.getPreferredSize());
                CostCenterConfigPanel.this.kfcRecipeBased.setLocation(CostCenterConfigPanel.this.kfcCcpHaccp.getX(), CostCenterConfigPanel.this.kfcRecipeAsExcel.getY() + CostCenterConfigPanel.this.kfcRecipeAsExcel.getHeight() + InternalCostCenterConfig.this.masterDataTable.getInnerCellPadding());
                CostCenterConfigPanel.this.kfcRecipeBased.setSize(CostCenterConfigPanel.this.kfcRecipeBased.getPreferredSize());
                CostCenterConfigPanel.this.purchaseOrderDepartment.setLocation(CostCenterConfigPanel.this.kfcCcpHaccp.getX(), CostCenterConfigPanel.this.kfcRecipeBased.getY() + CostCenterConfigPanel.this.kfcRecipeBased.getHeight() + InternalCostCenterConfig.this.masterDataTable.getInnerCellPadding());
                CostCenterConfigPanel.this.purchaseOrderDepartment.setSize(CostCenterConfigPanel.this.purchaseOrderDepartment.getPreferredSize());
                CostCenterConfigPanel.this.incidentDepartment.setLocation(CostCenterConfigPanel.this.kfcCcpHaccp.getX(), CostCenterConfigPanel.this.purchaseOrderDepartment.getY() + CostCenterConfigPanel.this.purchaseOrderDepartment.getHeight() + InternalCostCenterConfig.this.masterDataTable.getInnerCellPadding());
                CostCenterConfigPanel.this.incidentDepartment.setSize(CostCenterConfigPanel.this.incidentDepartment.getPreferredSize());
                CostCenterConfigPanel.this.sequenceNumber.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.stowingListEquipmentOwnerUnit.getY() + CostCenterConfigPanel.this.stowingListEquipmentOwnerUnit.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding() * 2);
                CostCenterConfigPanel.this.sequenceNumber.setSize(CostCenterConfigPanel.this.sequenceNumber.getPreferredSize());
                CostCenterConfigPanel.this.autoPrint.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.sequenceNumber.getY() + CostCenterConfigPanel.this.sequenceNumber.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding() * 2);
                CostCenterConfigPanel.this.autoPrint.setSize(CostCenterConfigPanel.this.autoPrint.getPreferredSize());
                CostCenterConfigPanel.this.defaultRequisitionPrinter.setLocation(InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.autoPrint.getY() + CostCenterConfigPanel.this.autoPrint.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.defaultRequisitionPrinter.setSize(CostCenterConfigPanel.this.defaultRequisitionPrinter.getPreferredSize());
                CostCenterConfigPanel.this.manMinutesOverflow.setLocation(CostCenterConfigPanel.this.defaultRequisitionPrinter.getX() + CostCenterConfigPanel.this.defaultRequisitionPrinter.getWidth() + InternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.sequenceNumber.getY() + CostCenterConfigPanel.this.sequenceNumber.getHeight() + InternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.manMinutesOverflow.setSize(350, 240);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

