/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DateDurationPanel;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PasswordSecurityLevelComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PasswordSecurityLevelComplete_;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete_;
import ch.icit.pegasus.server.core.dtos.util.DateUnitE;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PasswordSecurityConfig
extends MasterDataInsert<PasswordSecurityLevelComplete> {
    private static final long serialVersionUID = 1L;

    public PasswordSecurityConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new PasswordSecurityConfigPanel();
    }

    @Override
    public String getInsertName() {
        return "Password Security Level";
    }

    @Override
    public PasswordSecurityLevelComplete getNewObject() {
        PasswordSecurityLevelComplete a = new PasswordSecurityLevelComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends PasswordSecurityLevelComplete> getMasterDataClass() {
        return PasswordSecurityLevelComplete.class;
    }

    @Override
    public void commitSingleRow(Node<?> node) {
        Node dateDuration = node.getChildNamed(PasswordSecurityLevelComplete_.dateDuration);
        Double duration = (Double)dateDuration.getChildNamed(DateDurationComplete_.duration).getValue();
        DateUnitE unit = (DateUnitE)dateDuration.getChildNamed(DateDurationComplete_.unit).getValue();
        DateDurationComplete newDuration = (DateDurationComplete)dateDuration.getValue();
        if (newDuration == null) {
            newDuration = new DateDurationComplete();
            newDuration.setClientOId(Long.valueOf(ADTO.getNextId()));
        }
        newDuration.setDuration(duration);
        newDuration.setUnit(unit);
        dateDuration.setValue((Object)newDuration, 0L);
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        return a;
    }

    private class PasswordSecurityConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> description;
        private TitledItem<TextField> minChar;
        private TitledItem<DateDurationPanel> dateDuration;
        private TitledItem<TextField> passwordStrength;

        public PasswordSecurityConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.description = new TitledItem<TextField>(new TextField(null), "Description", TitledItem.TitledItemOrientation.NORTH);
            this.minChar = new TitledItem<NumberTextField>(new NumberTextField(null, TextFieldType.INT), "Min Character count", TitledItem.TitledItemOrientation.NORTH);
            this.passwordStrength = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), "Password Strength", TitledItem.TitledItemOrientation.NORTH);
            this.dateDuration = new TitledItem<DateDurationPanel>(new DateDurationPanel(), "Time to life", TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.minChar);
            this.add(this.description);
            this.add(this.dateDuration);
            this.add(this.passwordStrength);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.description.getFocusComponents();
            a.addAll(this.minChar.getFocusComponents());
            a.addAll(this.dateDuration.getFocusComponents());
            a.addAll(this.passwordStrength.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.description.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.description.setVisibleContainer(pane);
            this.minChar.setVisibleContainer(pane);
            this.dateDuration.setVisibleContainer(pane);
            this.passwordStrength.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.minChar.kill();
            this.description.kill();
            this.dateDuration.kill();
            this.passwordStrength.kill();
            this.minChar = null;
            this.description = null;
            this.dateDuration = null;
            this.passwordStrength = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.description.setEnabled(b);
            this.minChar.setEnabled(b);
            this.dateDuration.setEnabled(b);
            this.passwordStrength.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            DateDurationComplete value = (DateDurationComplete)node.getChildNamed(PasswordSecurityLevelComplete_.dateDuration).getValue();
            if (value == null) {
                value = new DateDurationComplete(DateUnitE.MONTH, Double.valueOf(3.0));
                value.setClientOId(Long.valueOf(ADTO.getNextId()));
            }
            if (value.getUnit() == null) {
                value.setUnit(DateUnitE.MONTH);
            }
            if (value.getDuration() == null) {
                value.setDuration(Double.valueOf(3.0));
            }
            node.getChildNamed(PasswordSecurityLevelComplete_.dateDuration).setValue((Object)value, 0L);
            this.description.getElement().setNode(node.getChildNamed(PasswordSecurityLevelComplete_.description));
            this.minChar.getElement().setNode(node.getChildNamed(PasswordSecurityLevelComplete_.minChars));
            this.dateDuration.getElement().setNode(node.getChildNamed(PasswordSecurityLevelComplete_.dateDuration));
            this.passwordStrength.getElement().setNode(node.getChildNamed(PasswordSecurityLevelComplete_.passwordStrength));
            this.setEnabled(true);
            PasswordSecurityConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return PasswordSecurityLevelComplete_.description;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                PasswordSecurityConfigPanel.this.description.setLocation(PasswordSecurityConfig.this.masterDataTable.getCellPadding(), PasswordSecurityConfig.this.masterDataTable.getCellPadding());
                PasswordSecurityConfigPanel.this.description.setSize(200, (int)PasswordSecurityConfigPanel.this.description.getPreferredSize().getHeight());
                PasswordSecurityConfigPanel.this.minChar.setLocation(PasswordSecurityConfig.this.masterDataTable.getCellPadding(), PasswordSecurityConfigPanel.this.description.getY() + PasswordSecurityConfigPanel.this.description.getHeight() + PasswordSecurityConfig.this.masterDataTable.getCellPadding());
                PasswordSecurityConfigPanel.this.minChar.setSize(200, (int)PasswordSecurityConfigPanel.this.minChar.getPreferredSize().getHeight());
                PasswordSecurityConfigPanel.this.dateDuration.setLocation(PasswordSecurityConfig.this.masterDataTable.getCellPadding(), PasswordSecurityConfigPanel.this.minChar.getY() + PasswordSecurityConfigPanel.this.minChar.getHeight() + PasswordSecurityConfig.this.masterDataTable.getCellPadding());
                PasswordSecurityConfigPanel.this.dateDuration.setSize(PasswordSecurityConfigPanel.this.dateDuration.getPreferredSize());
                PasswordSecurityConfigPanel.this.passwordStrength.setLocation(PasswordSecurityConfig.this.masterDataTable.getCellPadding(), PasswordSecurityConfigPanel.this.dateDuration.getY() + PasswordSecurityConfigPanel.this.dateDuration.getHeight() + PasswordSecurityConfig.this.masterDataTable.getCellPadding());
                PasswordSecurityConfigPanel.this.passwordStrength.setSize(200, (int)PasswordSecurityConfigPanel.this.passwordStrength.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

