/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.SalesPriceFactorTypeEConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.SalesPriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SalesPriceFactorComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.SalesPriceFactorPriceVariantComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SalesPriceFactorPriceVariantComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.SalesPriceFactorTypeE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ProductSalesPriceFactorsConfig
extends MasterDataInsert<SalesPriceFactorComplete> {
    private static final long serialVersionUID = 1L;

    public ProductSalesPriceFactorsConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new SalesPriceFactorConfigPanel();
    }

    @Override
    public String getInsertName() {
        return "Product Sales Price Factors";
    }

    @Override
    public SalesPriceFactorComplete getNewObject() {
        SalesPriceFactorComplete a = new SalesPriceFactorComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllSalesFactorTypes();
                return ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllUnCached(SalesPriceFactorComplete.class, true);
            }

            @Override
            public RemoteLoader getInvoker() {
                return ProductSalesPriceFactorsConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Class<? extends SalesPriceFactorComplete> getMasterDataClass() {
        return SalesPriceFactorComplete.class;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean nameSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(SalesPriceFactorComplete_.name).getValue() == null) {
                nameSet = false;
            }
            if (n.getChildNamed(SalesPriceFactorComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(SalesPriceFactorComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(SalesPriceFactorComplete_.code).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(SalesPriceFactorComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!nameSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Names are set"));
        }
        return a;
    }

    private class SalesPriceFactorConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> name;
        private TitledItem<TextField> code;
        private TitledItem<CheckBox> defaultPrint;
        private TitledItem<TextField> defaultValue;
        private TitledItem<ComboBox> type;
        private TitledItem<CheckBox> fixPrice;
        private TitledItem<CheckBox> useVariantsPricing;
        private Table2 priceVariantTable;

        public SalesPriceFactorConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), "Name", TitledItem.TitledItemOrientation.NORTH);
            this.code = new TitledItem<TextField>(new TextField(null), "Code", TitledItem.TitledItemOrientation.NORTH);
            this.defaultPrint = new TitledItem<CheckBox>(new CheckBox(), "Default Print", TitledItem.TitledItemOrientation.EAST);
            this.defaultValue = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), "Default Value [%]", TitledItem.TitledItemOrientation.NORTH);
            this.fixPrice = new TitledItem<CheckBox>(new CheckBox(), "Fix Price", TitledItem.TitledItemOrientation.EAST);
            this.type = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(SalesPriceFactorTypeEConverter.class), true), Words.TYPE, TitledItem.TitledItemOrientation.NORTH);
            this.useVariantsPricing = new TitledItem<CheckBox>(new CheckBox(), "Use Variant Pricing", TitledItem.TitledItemOrientation.EAST);
            this.useVariantsPricing.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
            this.priceVariantTable = new Table2(true, Words.ADD, true, false);
            this.priceVariantTable.setButtonHandler(new Table2ButtonHandler(){

                @Override
                public void childRemoved() {
                    SalesPriceFactorConfigPanel.this.priceVariantTable.relayoutRequested();
                }

                @Override
                public void addButtonPressed(int x, int y, Button source) {
                    SalesPriceFactorPriceVariantComplete v = new SalesPriceFactorPriceVariantComplete();
                    v.setClientOId(Long.valueOf(ADTO.getNextId()));
                    v.setValidity(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
                    Node node4DTO = INodeCreator.getDefaultImpl().getNode4DTO((Object)v, true, false);
                    SalesPriceFactorConfigPanel.this.priceVariantTable.getModel().getNode().addChild(node4DTO, 0L);
                }
            });
            int delSpace = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + 2 * this.priceVariantTable.getCellPadding();
            ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
            columns.add(new TableColumnInfo(Words.PERIOD, null, null, null, "", 40, 40, 40));
            columns.add(new TableColumnInfo("Fix Price", null, null, null, "", 40, 40, 40));
            columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", 120, 120, 120));
            columns.add(new TableColumnInfo(Words.UNIT, null, null, null, "", 40, 40, 40));
            columns.add(new TableColumnInfo("", null, null, null, "", delSpace, delSpace, delSpace));
            ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
            ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
            this.priceVariantTable.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.name);
            this.add(this.defaultPrint);
            this.add(this.defaultValue);
            this.add(this.fixPrice);
            this.add(this.type);
            this.add(this.useVariantsPricing);
            this.add(this.priceVariantTable);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.name.getFocusComponents();
            a.addAll(this.code.getFocusComponents());
            a.addAll(this.defaultPrint.getFocusComponents());
            a.addAll(this.defaultValue.getFocusComponents());
            a.addAll(this.fixPrice.getFocusComponents());
            a.addAll(this.type.getFocusComponents());
            a.addAll(this.useVariantsPricing.getFocusComponents());
            a.addAll(this.priceVariantTable.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.name.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.name.setVisibleContainer(pane);
            this.code.setVisibleContainer(pane);
            this.defaultPrint.setVisibleContainer(pane);
            this.defaultValue.setVisibleContainer(pane);
            this.fixPrice.setVisibleContainer(pane);
            this.type.setVisibleContainer(pane);
            this.useVariantsPricing.setVisibleContainer(pane);
            this.priceVariantTable.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.name.kill();
            this.defaultPrint.kill();
            this.defaultValue.kill();
            this.type.kill();
            this.fixPrice.kill();
            this.useVariantsPricing.kill();
            this.priceVariantTable.kill();
            this.code = null;
            this.name = null;
            this.defaultPrint = null;
            this.defaultValue = null;
            this.type = null;
            this.fixPrice = null;
            this.useVariantsPricing = null;
            this.priceVariantTable = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.name.setEnabled(b);
            this.code.setEnabled(b);
            this.defaultPrint.setEnabled(b);
            this.defaultValue.setEnabled(b);
            this.type.setEnabled(b);
            this.fixPrice.setEnabled(b);
            this.useVariantsPricing.setEnabled(b);
            this.priceVariantTable.setEnabled(b && this.useVariantsPricing.getElement().isChecked());
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.name.getElement().setNode(node.getChildNamed(SalesPriceFactorComplete_.name));
            this.code.getElement().setNode(node.getChildNamed(SalesPriceFactorComplete_.code));
            this.defaultPrint.getElement().setNode(node.getChildNamed(SalesPriceFactorComplete_.defaultPrint));
            this.defaultValue.getElement().setNode(node.getChildNamed(SalesPriceFactorComplete_.defaultValue));
            this.type.getElement().refreshPossibleValues(NodeToolkit.getAffixList(SalesPriceFactorTypeE.class));
            this.type.getElement().setNode(node.getChildNamed(SalesPriceFactorComplete_.type));
            this.fixPrice.getElement().setNode(node.getChildNamed(SalesPriceFactorComplete_.defaultFixPrice));
            this.useVariantsPricing.getElement().setNode(node.getChildNamed(SalesPriceFactorComplete_.useVariantsPricing));
            this.priceVariantTable.getModel().setNode(node.getChildNamed(SalesPriceFactorComplete_.priceVariants));
            this.setEnabled(true);
            ProductSalesPriceFactorsConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return SalesPriceFactorComplete_.name;
        }

        private class TableRowImpl
        extends Table2RowPanel {
            private TitledPeriodEditor periodEditor;
            private TextField price;
            private CheckBox fixPrice;
            private TextLabel unit;
            private DeleteButton deleteButton;

            public TableRowImpl(Table2RowModel m) {
                super(m);
                this.periodEditor = new TitledPeriodEditor((Node<PeriodComplete>)m.getNode().getChildNamed(SalesPriceFactorPriceVariantComplete_.validity), null);
                this.price = new TextField(m.getNode().getChildNamed(SalesPriceFactorPriceVariantComplete_.value), TextFieldType.DOUBLE);
                this.fixPrice = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(SalesPriceFactorPriceVariantComplete_.usePrice));
                this.unit = new TextLabel("");
                this.deleteButton = new DeleteButton();
                this.deleteButton.addButtonListener((source, x, y) -> SalesPriceFactorConfigPanel.this.priceVariantTable.getModel().getNode().removeChild(this.model.getNode(), 0L));
                this.fixPrice.addButtonListener((source, x, y) -> {
                    if (this.fixPrice.isChecked()) {
                        SystemSettingsComplete value = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                        this.unit.setText(value.getCurrency().getCode());
                    } else {
                        this.unit.setText("%");
                    }
                });
                this.setLayout(new RowLayout());
                this.add(this.periodEditor);
                this.add(this.price);
                this.add(this.fixPrice);
                this.add(this.unit);
                this.add(this.deleteButton);
            }

            @Override
            public Object getObject4Column(int column) {
                return this.model.getNode().getChildNamed(new DtoField[]{SalesPriceFactorPriceVariantComplete_.validity, PeriodComplete_.startDate});
            }

            private class RowLayout
            extends DefaultLayout {
                private RowLayout() {
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
                }

                @Override
                public void layoutContainer(Container parent) {
                    int currentX = 0;
                    int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                    TableRowImpl.this.periodEditor.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.periodEditor.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.periodEditor.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.periodEditor.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                    TableRowImpl.this.fixPrice.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.fixPrice.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.fixPrice.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                    TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                    TableRowImpl.this.unit.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.unit.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.unit.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.unit.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                    TableRowImpl.this.setControlsX(currentX);
                    TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
                }
            }
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                SalesPriceFactorConfigPanel.this.name.setLocation(ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding(), ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding());
                SalesPriceFactorConfigPanel.this.name.setSize(200, (int)SalesPriceFactorConfigPanel.this.name.getPreferredSize().getHeight());
                SalesPriceFactorConfigPanel.this.code.setLocation(ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding(), SalesPriceFactorConfigPanel.this.name.getY() + SalesPriceFactorConfigPanel.this.name.getHeight() + ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding());
                SalesPriceFactorConfigPanel.this.code.setSize(200, (int)SalesPriceFactorConfigPanel.this.code.getPreferredSize().getHeight());
                SalesPriceFactorConfigPanel.this.defaultPrint.setLocation(ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding(), SalesPriceFactorConfigPanel.this.code.getY() + SalesPriceFactorConfigPanel.this.code.getHeight() + ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding());
                SalesPriceFactorConfigPanel.this.defaultPrint.setSize(SalesPriceFactorConfigPanel.this.defaultPrint.getPreferredSize());
                SalesPriceFactorConfigPanel.this.defaultValue.setLocation(ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding(), SalesPriceFactorConfigPanel.this.defaultPrint.getY() + SalesPriceFactorConfigPanel.this.defaultPrint.getHeight() + ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding());
                SalesPriceFactorConfigPanel.this.defaultValue.setSize(200, (int)SalesPriceFactorConfigPanel.this.defaultValue.getPreferredSize().getHeight());
                SalesPriceFactorConfigPanel.this.fixPrice.setLocation(ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding(), SalesPriceFactorConfigPanel.this.defaultValue.getY() + SalesPriceFactorConfigPanel.this.defaultValue.getHeight() + ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding());
                SalesPriceFactorConfigPanel.this.fixPrice.setSize(200, (int)SalesPriceFactorConfigPanel.this.fixPrice.getPreferredSize().getHeight());
                SalesPriceFactorConfigPanel.this.type.setLocation(ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding(), SalesPriceFactorConfigPanel.this.fixPrice.getY() + SalesPriceFactorConfigPanel.this.fixPrice.getHeight() + ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding());
                SalesPriceFactorConfigPanel.this.type.setSize(200, (int)SalesPriceFactorConfigPanel.this.type.getPreferredSize().getHeight());
                SalesPriceFactorConfigPanel.this.useVariantsPricing.setLocation(ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding(), SalesPriceFactorConfigPanel.this.type.getY() + SalesPriceFactorConfigPanel.this.type.getHeight() + ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding());
                SalesPriceFactorConfigPanel.this.useVariantsPricing.setSize(SalesPriceFactorConfigPanel.this.useVariantsPricing.getPreferredSize());
                SalesPriceFactorConfigPanel.this.priceVariantTable.setLocation(ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding(), SalesPriceFactorConfigPanel.this.useVariantsPricing.getY() + SalesPriceFactorConfigPanel.this.useVariantsPricing.getHeight() + ProductSalesPriceFactorsConfig.this.masterDataTable.getCellPadding());
                SalesPriceFactorConfigPanel.this.priceVariantTable.setSize(800, 400);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

