/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.CustomSequenceEditor;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollableTextArea;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.textfield.InvoiceNoFormatEditor;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.system.CustomSequenceComplete;
import ch.icit.pegasus.server.core.dtos.system.SequenceIdentifierE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SettingsInvoiceConfig
extends DefaultDataInsert {
    private static final long serialVersionUID = 1L;
    private Node<SystemSettingsComplete> node;
    private ScrollableBackground scrollPane;
    private TitledItem<ScrollableTextArea> invoiceTaxTermsText;
    private TitledItem<ScrollableTextArea> invoicePaymentTermsText;
    private TitledItem<ScrollableTextArea> creditNoteTermsText;
    private CustomSequenceEditor invoiceSequenceEditor;
    private TitledItem<TextField> twmApproveTreshold;
    private TitledItem<InvoiceNoFormatEditor> defaultInvoiceFormat;
    private TitledItem<TextField> commercialRegister;
    private TitledItem<TextField> districtCourt;
    private TitledItem<TextField> management;
    private TitledItem<CheckBox> includeNullValues;
    private TitledItem<CheckBox> useProductsInsteadOfFixMeals;
    private TitledItem<CheckBox> totalTaxGroups;
    private TitledItem<CheckBox> showLegInExport;
    private TitledItem<CheckBox> mergeFillUpProducts;
    private TitledItem<CheckBox> sortByMealPlan;
    private TitledItem<CheckBox> sortByNumber;
    private TitledItem<CheckBox> sortByName;
    private TitledItem<CheckBox> showProductsInsteadOfFixPrices;
    private TitledItem<CheckBox> showAdditionalOrderName;
    private TitledItem<CheckBox> useTodayForDefaultInvoiceDate;

    public SettingsInvoiceConfig(AbstractDataInsertModule parent) {
        super(parent);
        this.setLayout(new Layout2());
    }

    @Override
    public void insertElements() {
        this.scrollPane = new ScrollableBackground(false);
        this.invoiceTaxTermsText = new TitledItem<ScrollableTextArea>(new ScrollableTextArea(), "Invoice Tax Terms Text (Footer 1) - max 10000 letters", TitledItem.TitledItemOrientation.NORTH);
        this.invoiceTaxTermsText.setIgnorePrefHeight(true);
        this.invoiceTaxTermsText.getElement().setMaxStringLength(10000);
        this.invoicePaymentTermsText = new TitledItem<ScrollableTextArea>(new ScrollableTextArea(), "Invoice Payment Terms Text (Footer 2) - max 10000 letters", TitledItem.TitledItemOrientation.NORTH);
        this.invoicePaymentTermsText.setIgnorePrefHeight(true);
        this.invoicePaymentTermsText.getElement().setMaxStringLength(10000);
        this.creditNoteTermsText = new TitledItem<ScrollableTextArea>(new ScrollableTextArea(), "Credit Note Terms Text - max 10000 letters", TitledItem.TitledItemOrientation.NORTH);
        this.creditNoteTermsText.setIgnorePrefHeight(true);
        this.creditNoteTermsText.getElement().setMaxStringLength(10000);
        this.invoiceSequenceEditor = new CustomSequenceEditor();
        this.twmApproveTreshold = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), "TWM approve threshold [%]", TitledItem.TitledItemOrientation.NORTH);
        this.defaultInvoiceFormat = new TitledItem<InvoiceNoFormatEditor>(new InvoiceNoFormatEditor(), Words.INVOICE_NUMBER_FORMAT, TitledItem.TitledItemOrientation.NORTH);
        this.commercialRegister = new TitledItem<TextField>(new TextField(), Words.COMMERCIAL_REGISTER, TitledItem.TitledItemOrientation.NORTH);
        this.districtCourt = new TitledItem<TextField>(new TextField(), Words.COURT, TitledItem.TitledItemOrientation.NORTH);
        this.management = new TitledItem<TextField>(new TextField(), Words.MANAGEMENT, TitledItem.TitledItemOrientation.NORTH);
        this.includeNullValues = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_NULL_VALUES, TitledItem.TitledItemOrientation.EAST);
        this.useProductsInsteadOfFixMeals = new TitledItem<CheckBox>(new CheckBox(), "Use Products instead of fix Meals", TitledItem.TitledItemOrientation.EAST);
        this.totalTaxGroups = new TitledItem<CheckBox>(new CheckBox(), "Total Tax Groups", TitledItem.TitledItemOrientation.EAST);
        this.showProductsInsteadOfFixPrices = new TitledItem<CheckBox>(new CheckBox(), "Show Products instead of fix Prices", TitledItem.TitledItemOrientation.EAST);
        this.showAdditionalOrderName = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_ADDITIONAL_ORDER_NAME, TitledItem.TitledItemOrientation.EAST);
        this.showLegInExport = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_LEG_IN_EXPORT, TitledItem.TitledItemOrientation.EAST);
        this.mergeFillUpProducts = new TitledItem<CheckBox>(new CheckBox(), Words.MERGE_FILLUP_PRODUCTS_IN_INVOICE_EXPORT, TitledItem.TitledItemOrientation.EAST);
        this.sortByMealPlan = new TitledItem<CheckBox>(new CheckBox(), Words.SORT_BY_MEALPLAN, TitledItem.TitledItemOrientation.EAST);
        this.sortByNumber = new TitledItem<CheckBox>(new CheckBox(), Words.SORT_BY_NUMBER, TitledItem.TitledItemOrientation.EAST);
        this.sortByName = new TitledItem<CheckBox>(new CheckBox(), "Sort by Name", TitledItem.TitledItemOrientation.EAST);
        this.useTodayForDefaultInvoiceDate = new TitledItem<CheckBox>(new CheckBox(), Words.USE_TODAY_FOR_DEFAULT_INVOICE_DATE, TitledItem.TitledItemOrientation.EAST);
        this.scrollPane.getViewPort().setLayout(new Layout());
        this.scrollPane.getViewPort().add(this.invoiceTaxTermsText);
        this.scrollPane.getViewPort().add(this.invoicePaymentTermsText);
        this.scrollPane.getViewPort().add(this.creditNoteTermsText);
        this.scrollPane.getViewPort().add(this.invoiceSequenceEditor);
        this.scrollPane.getViewPort().add(this.twmApproveTreshold);
        this.scrollPane.getViewPort().add(this.defaultInvoiceFormat);
        this.scrollPane.getViewPort().add(this.commercialRegister);
        this.scrollPane.getViewPort().add(this.districtCourt);
        this.scrollPane.getViewPort().add(this.management);
        this.scrollPane.getViewPort().add(this.includeNullValues);
        this.scrollPane.getViewPort().add(this.useProductsInsteadOfFixMeals);
        this.scrollPane.getViewPort().add(this.totalTaxGroups);
        this.scrollPane.getViewPort().add(this.showProductsInsteadOfFixPrices);
        this.scrollPane.getViewPort().add(this.sortByMealPlan);
        this.scrollPane.getViewPort().add(this.sortByNumber);
        this.scrollPane.getViewPort().add(this.sortByName);
        this.scrollPane.getViewPort().add(this.showAdditionalOrderName);
        this.scrollPane.getViewPort().add(this.showLegInExport);
        this.scrollPane.getViewPort().add(this.mergeFillUpProducts);
        this.scrollPane.getViewPort().add(this.useTodayForDefaultInvoiceDate);
        this.add(this.scrollPane);
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return "Settings";
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.invoiceTaxTermsText.kill();
            this.invoicePaymentTermsText.kill();
            this.creditNoteTermsText.kill();
            this.invoiceSequenceEditor.kill();
            this.twmApproveTreshold.kill();
            this.defaultInvoiceFormat.kill();
            this.commercialRegister.kill();
            this.districtCourt.kill();
            this.management.kill();
            this.includeNullValues.kill();
            this.useProductsInsteadOfFixMeals.kill();
            this.totalTaxGroups.kill();
            this.showProductsInsteadOfFixPrices.kill();
            this.sortByMealPlan.kill();
            this.sortByNumber.kill();
            this.sortByName.kill();
            this.showAdditionalOrderName.kill();
            this.showLegInExport.kill();
            this.mergeFillUpProducts.kill();
            this.useTodayForDefaultInvoiceDate.kill();
        }
        this.invoiceTaxTermsText = null;
        this.invoicePaymentTermsText = null;
        this.creditNoteTermsText = null;
        this.invoiceSequenceEditor = null;
        this.twmApproveTreshold = null;
        this.defaultInvoiceFormat = null;
        this.commercialRegister = null;
        this.districtCourt = null;
        this.management = null;
        this.includeNullValues = null;
        this.useProductsInsteadOfFixMeals = null;
        this.totalTaxGroups = null;
        this.showProductsInsteadOfFixPrices = null;
        this.sortByMealPlan = null;
        this.sortByNumber = null;
        this.sortByName = null;
        this.showAdditionalOrderName = null;
        this.showLegInExport = null;
        this.mergeFillUpProducts = null;
        this.useTodayForDefaultInvoiceDate = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.invoiceTaxTermsText.setEnabled(isEnabled);
            this.invoicePaymentTermsText.setEnabled(isEnabled);
            this.creditNoteTermsText.setEnabled(isEnabled);
            this.invoiceSequenceEditor.setEnabled(isEnabled);
            this.twmApproveTreshold.setEnabled(isEnabled);
            this.defaultInvoiceFormat.setEnabled(isEnabled);
            this.commercialRegister.setEnabled(isEnabled);
            this.districtCourt.setEnabled(isEnabled);
            this.management.setEnabled(isEnabled);
            this.includeNullValues.setEnabled(isEnabled);
            this.useProductsInsteadOfFixMeals.setEnabled(isEnabled);
            this.totalTaxGroups.setEnabled(isEnabled);
            this.showProductsInsteadOfFixPrices.setEnabled(isEnabled);
            this.sortByMealPlan.setEnabled(isEnabled);
            this.sortByNumber.setEnabled(isEnabled);
            this.sortByName.setEnabled(isEnabled);
            this.showAdditionalOrderName.setEnabled(isEnabled);
            this.showLegInExport.setEnabled(isEnabled);
            this.mergeFillUpProducts.setEnabled(isEnabled);
            this.useTodayForDefaultInvoiceDate.setEnabled(isEnabled);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.invoiceTaxTermsText.getFocusComponents());
            a.addAll(this.invoicePaymentTermsText.getFocusComponents());
            a.addAll(this.creditNoteTermsText.getFocusComponents());
            a.addAll(this.invoiceSequenceEditor.getFocusComponents());
            a.addAll(this.twmApproveTreshold.getFocusComponents());
            a.addAll(this.defaultInvoiceFormat.getFocusComponents());
            CheckedListAdder.addToList(a, this.commercialRegister);
            CheckedListAdder.addToList(a, this.districtCourt);
            CheckedListAdder.addToList(a, this.management);
            CheckedListAdder.addToList(a, this.includeNullValues);
            CheckedListAdder.addToList(a, this.useProductsInsteadOfFixMeals);
            CheckedListAdder.addToList(a, this.showAdditionalOrderName);
            CheckedListAdder.addToList(a, this.totalTaxGroups);
            CheckedListAdder.addToList(a, this.showProductsInsteadOfFixPrices);
            CheckedListAdder.addToList(a, this.sortByMealPlan);
            CheckedListAdder.addToList(a, this.sortByNumber);
            CheckedListAdder.addToList(a, this.sortByName);
            CheckedListAdder.addToList(a, this.showLegInExport);
            CheckedListAdder.addToList(a, this.mergeFillUpProducts);
            CheckedListAdder.addToList(a, this.useTodayForDefaultInvoiceDate);
            return a;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.invoiceSequenceEditor.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsInvoiceConfig.this.node.commitThis(SystemSettingsComplete.class);
                SystemSettingsComplete s = (SystemSettingsComplete)SettingsInvoiceConfig.this.node.getValue(SystemSettingsComplete.class);
                s = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSystemSettings(s).getValue();
                Node<CustomSequenceComplete> seq = SettingsInvoiceConfig.this.invoiceSequenceEditor.getNode();
                seq.commit(CustomSequenceComplete.class);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateCustomSequence((CustomSequenceComplete)seq.getValue());
                SettingsInvoiceConfig.this.node.removeExistingValues();
                SettingsInvoiceConfig.this.node.setValue((Object)s, 0L);
                SettingsInvoiceConfig.this.node.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsInvoiceConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsInvoiceConfig.this.changeLoadingState("Load 1/1 Modules");
                CustomSequenceComplete invoiceSequence = (CustomSequenceComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getCurrentCustomSequence(SequenceIdentifierE.INVOICE).getValue();
                Node sqNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)invoiceSequence, false, false);
                sqNode.setName("invoiceSequence");
                NodeToolkit.addAffix((Node)sqNode);
                return ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsInvoiceConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (this.currentState == DefaultDataInsert.LoadingState.LOAD) {
            this.setNode(node);
        }
    }

    private void setNode(Node<?> node) {
        this.node = node;
        if (!this.isInserted) {
            return;
        }
        this.invoiceTaxTermsText.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.invoiceTaxTermsText));
        this.invoicePaymentTermsText.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.invoicePaymentTermsText));
        this.creditNoteTermsText.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.creditnoteTermsText));
        this.invoiceSequenceEditor.setNode(NodeToolkit.getAffixNamed((String)"invoiceSequence"));
        this.defaultInvoiceFormat.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.defaultInvoiceNoFormat));
        this.defaultInvoiceFormat.getElement().setValid();
        if (node.getChildNamed(SystemSettingsComplete_.orderReviewSumTreshold).getValue() == null) {
            node.getChildNamed(SystemSettingsComplete_.orderReviewSumTreshold).setValue((Object)0.0, 0L);
        }
        this.twmApproveTreshold.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.orderReviewSumTreshold));
        this.commercialRegister.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.commercialRegister));
        this.districtCourt.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.districtCourt));
        this.management.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.management));
        this.includeNullValues.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.includeNullValues));
        this.showAdditionalOrderName.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.showAdditionalOrderName));
        this.useProductsInsteadOfFixMeals.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.useProductsInsteadOfFixMeals));
        this.totalTaxGroups.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.totalTaxGroups));
        this.showProductsInsteadOfFixPrices.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.showProductsInsteadOfFixPrices));
        this.sortByMealPlan.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.sortByMealpan));
        this.sortByNumber.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.sortByNumber));
        this.sortByName.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.sortByName));
        this.showLegInExport.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.includeLegInInvoiceExport));
        this.mergeFillUpProducts.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.mergeFillUpProducts));
        this.useTodayForDefaultInvoiceDate.getElement().setNode(node.getChildNamed(SystemSettingsComplete_.useToadyForDefaultInvoiceDate));
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        return a;
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsInvoiceConfig.this.layoutAnimation(parent);
            if (SettingsInvoiceConfig.this.isInserted) {
                SettingsInvoiceConfig.this.scrollPane.setLocation(1, 1);
                SettingsInvoiceConfig.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (SettingsInvoiceConfig.this.isInserted) {
                h = (int)((double)h + SettingsInvoiceConfig.this.invoiceSequenceEditor.getPreferredSize().getHeight());
                h += border;
                h += 120;
                h += border;
                h += 120;
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.defaultInvoiceFormat.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.commercialRegister.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.districtCourt.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.management.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.includeNullValues.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.showAdditionalOrderName.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.useProductsInsteadOfFixMeals.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.showProductsInsteadOfFixPrices.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.totalTaxGroups.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.sortByMealPlan.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.sortByNumber.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.sortByName.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.showLegInExport.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.mergeFillUpProducts.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SettingsInvoiceConfig.this.useTodayForDefaultInvoiceDate.getPreferredSize().getHeight());
                h += border;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 40;
            int border = 10;
            w /= 2;
            if (SettingsInvoiceConfig.this.isInserted) {
                SettingsInvoiceConfig.this.invoiceSequenceEditor.setLocation(border, border);
                SettingsInvoiceConfig.this.invoiceSequenceEditor.setSize(w, (int)SettingsInvoiceConfig.this.invoiceSequenceEditor.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.twmApproveTreshold.setLocation(border, SettingsInvoiceConfig.this.invoiceSequenceEditor.getY() + SettingsInvoiceConfig.this.invoiceSequenceEditor.getHeight() + border);
                SettingsInvoiceConfig.this.twmApproveTreshold.setSize(120, (int)SettingsInvoiceConfig.this.twmApproveTreshold.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.invoiceTaxTermsText.setLocation(border, SettingsInvoiceConfig.this.twmApproveTreshold.getY() + SettingsInvoiceConfig.this.twmApproveTreshold.getHeight() + border);
                SettingsInvoiceConfig.this.invoiceTaxTermsText.setSize(w, 100);
                SettingsInvoiceConfig.this.invoicePaymentTermsText.setLocation(SettingsInvoiceConfig.this.invoiceTaxTermsText.getX() + SettingsInvoiceConfig.this.invoiceTaxTermsText.getWidth() + border, SettingsInvoiceConfig.this.invoiceTaxTermsText.getY());
                SettingsInvoiceConfig.this.invoicePaymentTermsText.setSize(w, 100);
                SettingsInvoiceConfig.this.creditNoteTermsText.setLocation(SettingsInvoiceConfig.this.invoiceTaxTermsText.getX(), SettingsInvoiceConfig.this.invoicePaymentTermsText.getY() + SettingsInvoiceConfig.this.invoicePaymentTermsText.getHeight() + border);
                SettingsInvoiceConfig.this.creditNoteTermsText.setSize(w, 100);
                SettingsInvoiceConfig.this.defaultInvoiceFormat.setLocation(SettingsInvoiceConfig.this.creditNoteTermsText.getX(), SettingsInvoiceConfig.this.creditNoteTermsText.getY() + SettingsInvoiceConfig.this.creditNoteTermsText.getHeight() + border);
                SettingsInvoiceConfig.this.defaultInvoiceFormat.setSize(180, (int)SettingsInvoiceConfig.this.defaultInvoiceFormat.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.commercialRegister.setLocation(SettingsInvoiceConfig.this.invoiceTaxTermsText.getX(), SettingsInvoiceConfig.this.defaultInvoiceFormat.getY() + SettingsInvoiceConfig.this.defaultInvoiceFormat.getHeight() + border);
                SettingsInvoiceConfig.this.commercialRegister.setSize(480, (int)SettingsInvoiceConfig.this.commercialRegister.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.districtCourt.setLocation(SettingsInvoiceConfig.this.commercialRegister.getX(), SettingsInvoiceConfig.this.commercialRegister.getY() + SettingsInvoiceConfig.this.commercialRegister.getHeight() + border);
                SettingsInvoiceConfig.this.districtCourt.setSize(480, (int)SettingsInvoiceConfig.this.districtCourt.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.management.setLocation(SettingsInvoiceConfig.this.districtCourt.getX(), SettingsInvoiceConfig.this.districtCourt.getY() + SettingsInvoiceConfig.this.districtCourt.getHeight() + border);
                SettingsInvoiceConfig.this.management.setSize(480, (int)SettingsInvoiceConfig.this.management.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.includeNullValues.setLocation(SettingsInvoiceConfig.this.management.getX(), SettingsInvoiceConfig.this.management.getY() + SettingsInvoiceConfig.this.management.getHeight() + border);
                SettingsInvoiceConfig.this.includeNullValues.setSize(480, (int)SettingsInvoiceConfig.this.includeNullValues.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.showAdditionalOrderName.setLocation(SettingsInvoiceConfig.this.management.getX(), SettingsInvoiceConfig.this.includeNullValues.getY() + SettingsInvoiceConfig.this.includeNullValues.getHeight() + border);
                SettingsInvoiceConfig.this.showAdditionalOrderName.setSize(480, (int)SettingsInvoiceConfig.this.showAdditionalOrderName.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.useProductsInsteadOfFixMeals.setLocation(SettingsInvoiceConfig.this.includeNullValues.getX(), SettingsInvoiceConfig.this.showAdditionalOrderName.getY() + SettingsInvoiceConfig.this.showAdditionalOrderName.getHeight() + border);
                SettingsInvoiceConfig.this.useProductsInsteadOfFixMeals.setSize(480, (int)SettingsInvoiceConfig.this.useProductsInsteadOfFixMeals.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.totalTaxGroups.setLocation(SettingsInvoiceConfig.this.useProductsInsteadOfFixMeals.getX(), SettingsInvoiceConfig.this.useProductsInsteadOfFixMeals.getY() + SettingsInvoiceConfig.this.useProductsInsteadOfFixMeals.getHeight() + border);
                SettingsInvoiceConfig.this.totalTaxGroups.setSize(480, (int)SettingsInvoiceConfig.this.totalTaxGroups.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.showProductsInsteadOfFixPrices.setLocation(SettingsInvoiceConfig.this.totalTaxGroups.getX(), SettingsInvoiceConfig.this.totalTaxGroups.getY() + SettingsInvoiceConfig.this.totalTaxGroups.getHeight() + border);
                SettingsInvoiceConfig.this.showProductsInsteadOfFixPrices.setSize(480, (int)SettingsInvoiceConfig.this.showProductsInsteadOfFixPrices.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.sortByMealPlan.setLocation(SettingsInvoiceConfig.this.showProductsInsteadOfFixPrices.getX(), SettingsInvoiceConfig.this.showProductsInsteadOfFixPrices.getY() + SettingsInvoiceConfig.this.showProductsInsteadOfFixPrices.getHeight() + border);
                SettingsInvoiceConfig.this.sortByMealPlan.setSize(480, (int)SettingsInvoiceConfig.this.sortByMealPlan.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.sortByNumber.setLocation(SettingsInvoiceConfig.this.sortByMealPlan.getX(), SettingsInvoiceConfig.this.sortByMealPlan.getY() + SettingsInvoiceConfig.this.sortByMealPlan.getHeight() + border);
                SettingsInvoiceConfig.this.sortByNumber.setSize(480, (int)SettingsInvoiceConfig.this.sortByNumber.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.sortByName.setLocation(SettingsInvoiceConfig.this.sortByNumber.getX(), SettingsInvoiceConfig.this.sortByNumber.getY() + SettingsInvoiceConfig.this.sortByNumber.getHeight() + border);
                SettingsInvoiceConfig.this.sortByName.setSize(480, (int)SettingsInvoiceConfig.this.sortByName.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.showLegInExport.setLocation(SettingsInvoiceConfig.this.sortByNumber.getX(), SettingsInvoiceConfig.this.sortByName.getY() + SettingsInvoiceConfig.this.sortByName.getHeight() + border);
                SettingsInvoiceConfig.this.showLegInExport.setSize(480, (int)SettingsInvoiceConfig.this.showLegInExport.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.mergeFillUpProducts.setLocation(SettingsInvoiceConfig.this.sortByNumber.getX(), SettingsInvoiceConfig.this.showLegInExport.getY() + SettingsInvoiceConfig.this.showLegInExport.getHeight() + border);
                SettingsInvoiceConfig.this.mergeFillUpProducts.setSize(480, (int)SettingsInvoiceConfig.this.mergeFillUpProducts.getPreferredSize().getHeight());
                SettingsInvoiceConfig.this.useTodayForDefaultInvoiceDate.setLocation(SettingsInvoiceConfig.this.mergeFillUpProducts.getX(), SettingsInvoiceConfig.this.mergeFillUpProducts.getY() + SettingsInvoiceConfig.this.mergeFillUpProducts.getHeight() + border);
                SettingsInvoiceConfig.this.useTodayForDefaultInvoiceDate.setSize(SettingsInvoiceConfig.this.useTodayForDefaultInvoiceDate.getPreferredSize());
            }
        }
    }
}

