/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.solar.SolarCompanySettingsComplete;
import ch.icit.pegasus.server.core.dtos.solar.SolarCompanySettingsComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SettingsSolarCompanyConfig
extends DefaultDataInsert
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private ScrollableBackground scrollPane;
    private Node<SolarCompanySettingsComplete> node;
    private TitledItem<SearchTextField2<CustomerLight>> solarCustomer;

    public SettingsSolarCompanyConfig(AbstractDataInsertModule parent) {
        super(parent);
        this.setLayout(new Layout2());
    }

    @Override
    public void insertElements() {
        this.scrollPane = new ScrollableBackground(false);
        this.solarCustomer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, null), Words.SOLAR_COMPANY_CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.scrollPane.getViewPort().setLayout(new Layout());
        this.scrollPane.getViewPort().add(this.solarCustomer);
        this.add(this.scrollPane);
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return "Solar Company Settings";
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.solarCustomer.kill();
        }
        this.solarCustomer = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.solarCustomer.setEnabled(isEnabled);
        this.solarCustomer.setEnabled(isEnabled);
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.solarCustomer);
            CheckedListAdder.addToList(focusList, this.solarCustomer);
            return focusList;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.solarCustomer.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsSolarCompanyConfig.this.node.commitThis(SolarCompanySettingsComplete.class);
                SolarCompanySettingsComplete s = (SolarCompanySettingsComplete)SettingsSolarCompanyConfig.this.node.getValue(SolarCompanySettingsComplete.class);
                s = (SolarCompanySettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)s).getValue();
                SettingsSolarCompanyConfig.this.node.removeExistingValues();
                SettingsSolarCompanyConfig.this.node.setValue((Object)s, 0L);
                SettingsSolarCompanyConfig.this.node.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsSolarCompanyConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsSolarCompanyConfig.this.changeLoadingState("Load 1/1 Modules");
                SolarCompanySettingsComplete dutyFreeSettings = (SolarCompanySettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSolarCompanySettings().getValue();
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)dutyFreeSettings, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsSolarCompanyConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (this.currentState == DefaultDataInsert.LoadingState.LOAD) {
            this.setNode(node);
        }
    }

    private void setNode(Node<SolarCompanySettingsComplete> node) {
        this.node = node;
        if (!this.isInserted) {
            return;
        }
        this.solarCustomer.getElement().setNode(node.getChildNamed(SolarCompanySettingsComplete_.solarCustomer));
        this.setEnabled(true);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsSolarCompanyConfig.this.layoutAnimation(parent);
            if (SettingsSolarCompanyConfig.this.isInserted) {
                SettingsSolarCompanyConfig.this.scrollPane.setLocation(1, 1);
                SettingsSolarCompanyConfig.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (SettingsSolarCompanyConfig.this.isInserted) {
                h = (int)((double)h + (SettingsSolarCompanyConfig.this.solarCustomer.getPreferredSize().getHeight() + (double)border));
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (SettingsSolarCompanyConfig.this.isInserted) {
                SettingsSolarCompanyConfig.this.solarCustomer.setLocation(border, border * 2);
                SettingsSolarCompanyConfig.this.solarCustomer.setSize(400, (int)SettingsSolarCompanyConfig.this.solarCustomer.getPreferredSize().getHeight());
            }
        }
    }
}

