/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.matdispo.details;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.CurrencyConverter;
import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.ProductVariantConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.matdispo.MatDispoOldModule;
import ch.icit.pegasus.client.gui.modules.matdispo.details.FlightDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.splitscreen.SplitView;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ArticleProductInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.ProductInfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserListener;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.client.util.variantaccessor.RecipeVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.CustomerSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ProductVariantSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.dtos.utils.ProductPriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.Tuple;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductDetailsPanel
extends SplitView
implements ButtonListener,
SearchTextField2Listener,
DateChooserListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SpecificationDetailsPanel.class);
    private TitledItem<SearchTextField2> productSearch;
    private TitledItem<SearchComboBox> customerSearch;
    private TitledPeriodEditor period;
    private TitledItem<DateChooser> dueDate;
    private TextButton add;
    private TextButton addAll;
    private TextButton clearAll;
    private TextButton importProducts;
    private MatDispoOldModule matDispo;
    private CurrencyVariantAccessor currencyAccessor = new CurrencyVariantAccessorImpl();
    private Map<FlightLight, List<String>> warnings = new HashMap<FlightLight, List<String>>();
    private Table2 results;

    public ProductDetailsPanel(MatDispoOldModule md) {
        this.matDispo = md;
        this.productSearch = new TitledItem<SearchTextField2<ProductVariantLight>>(SearchTextField2Factory.getProductVariantSearchField(true, new DTOProxyNode()), "Product Variant", TitledItem.TitledItemOrientation.NORTH);
        this.productSearch.getElement().addSearchTextFieldListener(this);
        this.customerSearch = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getCustomerSearchField(true), "Customer", TitledItem.TitledItemOrientation.NORTH);
        this.customerSearch.getElement().addSearchTextFieldListener(this);
        long now = 2592000000L;
        PeriodComplete p = new PeriodComplete(new java.sql.Date(System.currentTimeMillis()), new java.sql.Date(System.currentTimeMillis() + now));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, false, false);
        this.period = new TitledPeriodEditor((Node<PeriodComplete>)n, null);
        this.period.getStartDateChooser().addDateChooserListener(this);
        this.period.getEndDateChooser().addDateChooserListener(this);
        Node dd = INodeCreator.getDefaultImpl().getNode4DTO((Object)new Timestamp(System.currentTimeMillis()), false, false);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(dd), Words.DUE_DATE, TitledItem.TitledItemOrientation.WEST);
        this.dueDate.setIgnorePrefWidth(true);
        this.dueDate.getElement().setIsTimestamp(true);
        this.add = new TextButton("Add");
        this.add.addButtonListener(this);
        this.clearAll = new TextButton("Clear All");
        this.clearAll.addButtonListener(this);
        this.importProducts = new TextButton("Import");
        this.importProducts.addButtonListener(this);
        this.addAll = new TextButton("Add all");
        this.addAll.addButtonListener(this);
        this.results = new Table2(false, "");
        this.results.setScrollDownOnAdd(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("NO", null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo("NAME", null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo("CUSTOMER", null, null, null, "", 30, 30, 30));
        int tw = this.results.getCellPadding() * 2 + InputComboBox2.getPreferredWidth(this, 5);
        columns.add(new TableColumnInfo("AMOUNT", null, null, null, "", tw, tw, tw));
        tw = 2 * this.results.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.results.setModel(new Table2Model(columns, model -> new TableRowImpl(model, Table2RowPanel.TableControlsType.ONE)));
        this.results.setProgress(1.0f);
        this.results.getModel().setNode((Node)new ViewNode(""));
        this.ensureAdditionalSearchParas();
        this.setLayout(new Layout());
        this.add(this.productSearch);
        this.add(this.customerSearch);
        this.add(this.add);
        this.add(this.addAll);
        this.add(this.clearAll);
        this.add(this.importProducts);
        this.add(this.results);
        this.add(this.period);
        this.add(this.dueDate);
    }

    @Override
    public void resetData() {
    }

    private void removeNodeFromList(Node n) {
        this.results.getModel().getNode().removeChild(n, 0L);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.productSearch.setEnabled(isEnabled);
        this.customerSearch.setEnabled(isEnabled);
        this.results.setEnabled(isEnabled);
        this.add.setEnabled(isEnabled);
        this.addAll.setEnabled(isEnabled);
        this.period.setEnabled(isEnabled);
        this.clearAll.setEnabled(isEnabled);
        this.importProducts.setEnabled(isEnabled);
        this.dueDate.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.productSearch.kill();
        this.productSearch = null;
        this.customerSearch.kill();
        this.customerSearch = null;
        this.clearAll.kill();
        this.clearAll = null;
        this.importProducts.kill();
        this.importProducts = null;
        this.add.kill();
        this.add = null;
        this.results.kill();
        this.results = null;
        this.period.kill();
        this.period = null;
        this.dueDate.kill();
        this.dueDate = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.productSearch.getFocusComponents();
        a.addAll(this.customerSearch.getFocusComponents());
        a.addAll(this.period.getFocusComponents());
        a.addAll(this.dueDate.getFocusComponents());
        a.addAll(this.importProducts.getFocusComponents());
        a.addAll(this.add.getFocusComponents());
        a.addAll(this.clearAll.getFocusComponents());
        a.addAll(this.results.getFocusComponents());
        return a;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.add) {
            if (this.productSearch.getElement().isItemSelected()) {
                ProductVariantLight pl = (ProductVariantLight)this.productSearch.getElement().getNode().getValue();
                this.addProduct(pl, 1);
            } else {
                InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Please select a Product first")}), "Unable to add Product", (Component)source);
            }
        } else if (source == this.addAll) {
            if (this.customerSearch.getElement().isItemSelected()) {
                this.matDispo.showAnimation(true);
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        CustomerLight l = (CustomerLight)((SearchComboBox)ProductDetailsPanel.this.customerSearch.getElement()).getNode().getValue();
                        ProductVariantSearchConfiguration c = new ProductVariantSearchConfiguration();
                        c.setNumResults(Integer.MAX_VALUE);
                        c.setCustomer(l);
                        PeriodComplete p = new PeriodComplete(ProductDetailsPanel.this.period.getStartDate(), ProductDetailsPanel.this.period.getEndDate());
                        c.setPeriod(p);
                        c.setUsePeriod(Boolean.valueOf(true));
                        SearchResult r = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)c);
                        ViewNode n = new ViewNode("");
                        n.setValue((Object)r, 0L);
                        return n;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                SearchResult r = (SearchResult)node.getValue();
                                for (ProductVariantLight pl : r.getResults()) {
                                    ProductDetailsPanel.this.addProduct(pl, 1);
                                }
                                ProductDetailsPanel.this.matDispo.showAnimation(false);
                                ProductDetailsPanel.this.matDispo.revalidate();
                            }

                            public void errorOccurred(ClientException exception) {
                                ProductDetailsPanel.this.errorOccurred(exception);
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            } else {
                InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Please select a Customer first")}), "Unable to get all Products for Customer", (Component)source);
            }
        } else if (source == this.clearAll) {
            Iterator it = this.results.getModel().getNode().getFailSafeChildIterator();
            while (it.hasNext()) {
                this.results.getModel().getNode().removeChild((Node)it.next(), 0L);
            }
            this.warnings = new HashMap<FlightLight, List<String>>();
        } else if (source == this.importProducts) {
            this.matDispo.showAnimation(true);
            this.matDispo.setEnabled(false);
            final File templateFile = FileChooserUtil.loadFile();
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    ArrayList<Tuple> products = new ArrayList<Tuple>();
                    List rows = ExcelToolkit.readRows((File)templateFile);
                    for (ExcelRow row : rows) {
                        Integer productNo = ExcelToolkit.readAsInteger((ExcelRow)row, (int)0);
                        Integer quantity = ExcelToolkit.readAsInteger((ExcelRow)row, (int)2);
                        ProductVariantSearchConfiguration configuration = new ProductVariantSearchConfiguration();
                        configuration.setNumber(productNo);
                        configuration.setValidityDate(new Timestamp(System.currentTimeMillis()));
                        SearchResultIterator sr = new SearchResultIterator((ASearchConfiguration)configuration);
                        while (sr.hasNext()) {
                            ProductVariantLight product = (ProductVariantLight)sr.next();
                            SwingUtilities.invokeLater(() -> ProductDetailsPanel.this.addProduct(product, quantity));
                            products.add(new Tuple((Object)product, (Object)quantity));
                        }
                    }
                    Node n = new Node();
                    n.setValue(products, 0L);
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            ProductDetailsPanel.this.matDispo.showAnimation(false);
                            ProductDetailsPanel.this.matDispo.setEnabled(true);
                        }

                        public void errorOccurred(ClientException exception) {
                            ProductDetailsPanel.this.matDispo.showAnimation(false);
                            ProductDetailsPanel.this.matDispo.setEnabled(true);
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ProductDetailsPanel.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    private void addProduct(ProductVariantLight pl, Integer amount) {
        DTONode n = new DTONode();
        n.setValue((Object)pl, 0L);
        if (amount == null) {
            amount = 0;
        }
        EmbeddedDTONode a = new EmbeddedDTONode();
        a.setName("cquantity");
        StoreQuantityComplete q = new StoreQuantityComplete();
        q.setClientOId(Long.valueOf(q.getNextId()));
        q.setAmount(Long.valueOf(amount.longValue()));
        a.setValue((Object)q, 0L);
        n.addChild((Node)a, 0L);
        a = new EmbeddedDTONode();
        a.setName("oquantity");
        q = new StoreQuantityComplete();
        q.setClientOId(Long.valueOf(q.getNextId()));
        q.setAmount(Long.valueOf(amount.longValue()));
        a.setValue((Object)q, 0L);
        n.addChild((Node)a, 0L);
        if (n.getValue() == null) {
            return;
        }
        this.results.getModel().getNode().addChild((Node)n, 0L);
    }

    private Node<ProductVariantLight> getProductNode(ProductVariantLight p) {
        for (Table2RowPanel pp : this.results.getRows()) {
            if (!pp.getModel().getNode().getValue().equals(p)) continue;
            return pp.getModel().getNode();
        }
        return null;
    }

    public void addProducts(Map<ProductVariantLight, Integer> p) {
        for (ProductVariantLight pc : p.keySet()) {
            Integer i = p.get(pc);
            this.addProduct(pc, i);
        }
    }

    public Map<CustomerLight, Map<ProductVariantReference, Integer>> getProductMap(boolean groupByCustomer) {
        HashMap<CustomerLight, Map<ProductVariantReference, Integer>> mapIndex = new HashMap<CustomerLight, Map<ProductVariantReference, Integer>>();
        HashMap<Long, CustomerLight> customerIndex = new HashMap<Long, CustomerLight>();
        if (groupByCustomer) {
            CustomerSearchConfiguration cc = new CustomerSearchConfiguration();
            try {
                SearchResultIterator it = new SearchResultIterator((ASearchConfiguration)cc);
                while (it.hasNext()) {
                    CustomerLight next = (CustomerLight)it.next();
                    customerIndex.put(next.getId(), next);
                }
            }
            catch (ServiceException e) {
                log.error("", (Throwable)e);
            }
        }
        for (Table2RowPanel p : this.results.getRows()) {
            Integer i;
            CustomerLight customerLight;
            ProductVariantLight pl = (ProductVariantLight)p.getModel().getNode().getValue(ProductVariantLight.class);
            ProductVariantReference pc = (ProductVariantReference)p.getModel().getNode().getValue(ProductVariantReference.class);
            pc = new ProductVariantReference(pc.getId());
            HashMap<ProductVariantReference, Integer> map = null;
            if (groupByCustomer) {
                if (pl.getProduct() == null) {
                    customerLight = (CustomerLight)customerIndex.get(pl.getProductCustomerId());
                    mapIndex.get(customerLight);
                } else {
                    map = (Map)mapIndex.get(pl.getProduct().getCustomer());
                }
            } else {
                map = (HashMap<ProductVariantReference, Integer>)mapIndex.get(null);
            }
            if (map == null) {
                map = new HashMap<ProductVariantReference, Integer>();
                if (groupByCustomer) {
                    if (pl.getProduct() == null) {
                        customerLight = (CustomerLight)customerIndex.get(pl.getProductCustomerId());
                        mapIndex.put(customerLight, map);
                    } else {
                        mapIndex.put(pl.getProduct().getCustomer(), map);
                    }
                } else {
                    mapIndex.put(null, map);
                }
            }
            if ((i = (Integer)map.get(pc)) != null) {
                map.remove(pc);
            } else {
                i = 0;
            }
            Long ni = TransactionToolkit.getLongValue(p.getModel().getNode().getChildNamed(new String[]{"cquantity-amount"}));
            int putter = (int)(ni + (long)i.intValue());
            map.put(pc, putter);
        }
        return mapIndex;
    }

    public Timestamp getSearchPeriod() {
        java.sql.Date s = this.period.getStartDate();
        return new Timestamp(s.getTime());
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        if (source == this.customerSearch.getElement()) {
            this.ensureAdditionalSearchParas();
        }
        this.add.requestFocusInWindowNow();
    }

    @Override
    public void dateChanged(DateChooser source, Date selectedDate) {
        this.ensureAdditionalSearchParas();
    }

    private void ensureAdditionalSearchParas() {
        Object[] o = new Object[]{this.period.getStartDate(), this.period.getEndDate(), this.customerSearch.getElement().getNode().getValue()};
        this.productSearch.getElement().setAdditionalSearchField(o);
    }

    public List<ExcelRow> getRecipeExcelRows(BondedStateE bondedState, FlightDetailsPanel fdp, LoadingAnimation animation) {
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        ExcelRow h = new ExcelRow();
        h.setHeader(true);
        switch (bondedState) {
            case ALL: {
                h.addCell((Object)"Material Disposition", new String[0]);
                break;
            }
            case NOT_BONDED: {
                h.addCell((Object)"Material Disposition - Non Bonded", new String[0]);
                break;
            }
            case ONLY_BONDED: {
                h.addCell((Object)"Material Disposition - Bonded Only", new String[0]);
                break;
            }
            default: {
                h.addCell((Object)"Material Disposition", new String[0]);
            }
        }
        rows.add(h);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        ExcelRow h2 = new ExcelRow();
        h2.setHeader(true);
        h2.addCell((Object)Words.NO_NUMBER, new String[0]);
        h2.addCell((Object)Words.NAME, new String[0]);
        h2.addCell((Object)Words.CATEGORY, new String[0]);
        h2.addCell((Object)Words.YIELD_AMOUNT, new String[0]);
        h2.addCell((Object)Words.YIELD_UNIT, new String[0]);
        h2.addCell((Object)Words.TARGET_AMOUNT, new String[0]);
        h2.addCell((Object)Words.TARGET_UNIT, new String[0]);
        rows.add(h2);
        int count = 1;
        int maxCount = this.results.getRowCount();
        block14: for (Table2RowPanel p : this.results.getRows()) {
            animation.stateChanged("Process Product for Recipe " + count + "/" + maxCount);
            ProductVariantLight pL = (ProductVariantLight)p.getModel().getNode().getValue(ProductVariantLight.class);
            boolean bonded = Boolean.TRUE.equals(pL.getProduct().getBonded());
            switch (bondedState) {
                case ALL: {
                    break;
                }
                case NOT_BONDED: {
                    if (!bonded) break;
                    continue block14;
                }
                case ONLY_BONDED: {
                    if (bonded) break;
                    continue block14;
                }
            }
            ProductVariantComplete productVariant = (ProductVariantComplete)p.getModel().getNode().getValue(ProductVariantComplete.class);
            if (productVariant == null) {
                try {
                    productVariant = (ProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantByReference(new ProductVariantReference(pL.getId())).getValue();
                    p.getModel().getNode().setValue((Object)productVariant, 0L);
                }
                catch (ClientServerCallException e) {
                    InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)fdp);
                }
            }
            if (productVariant instanceof ComplexProductVariantComplete) {
                ComplexProductVariantComplete px = (ComplexProductVariantComplete)productVariant;
                long q = (Long)p.getObject4Column(3);
                Integer i = (int)q;
                try {
                    Map ret = ((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).getSubRecipesQuantity(new ProductVariantReference(pL.getId()), i.intValue(), new TimestampWrapper((Timestamp)this.dueDate.getElement().getNode().getValue())).getMap();
                    for (Map.Entry e : ret.entrySet()) {
                        ExcelRow r = new ExcelRow();
                        r.addCell((Object)((RecipeVariantComplete)e.getKey()).getNumber(), new String[0]);
                        r.addCell((Object)((RecipeVariantComplete)e.getKey()).getName(), new String[0]);
                        r.addCell((Object)((RecipeVariantComplete)e.getKey()).getCategory().getName(), new String[0]);
                        r.addCell((Object)((RecipeVariantComplete)e.getKey()).getYield().getQuantity(), new String[0]);
                        r.addCell((Object)((RecipeVariantComplete)e.getKey()).getYield().getUnit().getShortName(), new String[0]);
                        r.addCell((Object)((QuantityComplete)e.getValue()).getQuantity(), new String[0]);
                        r.addCell((Object)((QuantityComplete)e.getValue()).getUnit().getShortName(), new String[0]);
                        rows.add(r);
                    }
                }
                catch (ClientServerCallException e) {
                    InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)fdp);
                }
            }
            ++count;
        }
        rows.addAll(this.getSummary(bondedState));
        return rows;
    }

    public List<ExcelRow> getWarnings() {
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        ExcelRow h = new ExcelRow(true);
        h.addCell((Object)"Calculate Product Warnings", new String[0]);
        rows.add(h);
        h = new ExcelRow(true);
        h.addCell((Object)"Std", new String[0]);
        h.addCell((Object)"Outbound Code", new String[0]);
        h.addCell((Object)"Customer Code", new String[0]);
        h.addCell((Object)"Warnings", new String[0]);
        rows.add(h);
        for (Map.Entry<FlightLight, List<String>> w : this.warnings.entrySet()) {
            for (String t : w.getValue()) {
                ExcelRow r = new ExcelRow();
                r.addCell(w.getKey() != null ? w.getKey().getStd() : "", new String[0]);
                r.addCell((Object)(w.getKey() != null ? w.getKey().getOutboundCode() : ""), new String[0]);
                r.addCell((Object)(w.getKey() != null ? w.getKey().getCustomer().getCode() : ""), new String[0]);
                r.addCell((Object)t, new String[0]);
                rows.add(r);
            }
        }
        return rows;
    }

    public List<ExcelRow> getProductExcelRows(BondedStateE bondedState, FlightDetailsPanel fdp, LoadingAnimation animation, boolean includeMatCosts) {
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        RecipeVariantAccessorImpl accessor = new RecipeVariantAccessorImpl();
        ExcelRow h = new ExcelRow();
        h.setHeader(true);
        switch (bondedState) {
            case ALL: {
                h.addCell((Object)"Material Disposition", new String[0]);
                break;
            }
            case NOT_BONDED: {
                h.addCell((Object)"Material Disposition - Non Bonded", new String[0]);
                break;
            }
            case ONLY_BONDED: {
                h.addCell((Object)"Material Disposition - Bonded Only", new String[0]);
                break;
            }
            default: {
                h.addCell((Object)"Material Disposition", new String[0]);
            }
        }
        rows.add(h);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        ExcelRow h2 = new ExcelRow();
        h2.setHeader(true);
        h2.addCell((Object)Words.CUSTOMER, new String[0]);
        h2.addCell((Object)Words.NO_NUMBER, new String[0]);
        h2.addCell((Object)Words.CUSTOMER_PRODUCT_NUMBER, new String[0]);
        h2.addCell((Object)Words.NAME, new String[0]);
        h2.addCell((Object)Words.PRODUCT_AIS_NAME, new String[0]);
        h2.addCell((Object)Words.CUSTOMER, new String[0]);
        h2.addCell((Object)Words.VALIDITY, new String[0]);
        h2.addCell((Object)Words.CURRENCY, new String[0]);
        h2.addCell((Object)Words.UNITPRICE, new String[0]);
        h2.addCell((Object)Words.AMOUNT, new String[0]);
        h2.addCell((Object)Words.VALUE, new String[0]);
        if (includeMatCosts) {
            h2.addCell((Object)Words.MATERIAL_COST_UP, new String[0]);
        }
        rows.add(h2);
        int count = 1;
        int maxCount = this.results.getRowCount();
        block14: for (Table2RowPanel p : this.results.getRows()) {
            animation.stateChanged("Process Product " + count + "/" + maxCount);
            ProductVariantLight productVariant = (ProductVariantLight)p.getModel().getNode().getValue(ProductVariantLight.class);
            boolean bonded = Boolean.TRUE.equals(productVariant.getProduct().getBonded());
            switch (bondedState) {
                case ALL: {
                    break;
                }
                case NOT_BONDED: {
                    if (!bonded) break;
                    continue block14;
                }
                case ONLY_BONDED: {
                    if (bonded) break;
                    continue block14;
                }
            }
            ExcelRow r = new ExcelRow();
            r.addCell((Object)productVariant.getProduct().getCustomer().getCode(), new String[0]);
            r.addCell(p.getObject4Column(0), new String[0]);
            r.addCell((Object)productVariant.getCustomerProductNumber(), new String[0]);
            if (bonded && bondedState == BondedStateE.ALL) {
                r.addCell((Object)(p.getObject4Column(1) + " *"), new String[0]);
            } else {
                r.addCell(p.getObject4Column(1), new String[0]);
            }
            r.addCell((Object)productVariant.getPaxName(), new String[0]);
            CustomerLight cus = (CustomerLight)p.getObject4Column(2);
            r.addCell((Object)((CustomerConverter)ConverterRegistry.getConverter(CustomerConverter.class)).convert(cus, null, new Object[0]), new String[0]);
            r.addCell((Object)((PeriodConverter)ConverterRegistry.getConverter(PeriodConverter.class)).convert((Object)productVariant.getValidityPeriod(), null, new Object[0]), new String[0]);
            r.addCell((Object)((CurrencyConverter)ConverterRegistry.getConverter(CurrencyConverter.class)).convert(settings.getCurrency(), null, new Object[0]), new String[0]);
            if (productVariant.getSalesPrice() != null) {
                r.addCell((Object)productVariant.getSalesPrice().getPrice(), new String[0]);
            } else {
                r.addCell(null, new String[0]);
            }
            long q = (Long)p.getObject4Column(3);
            Integer i = (int)q;
            if ((long)i.intValue() != q) {
                r.addCell((Object)Long.valueOf(q).toString(), new String[0]);
                if (productVariant.getSalesPrice() != null) {
                    r.addCell((Object)((double)q * productVariant.getSalesPrice().getPrice()), new String[0]);
                } else {
                    r.addCell(null, new String[0]);
                }
            } else {
                r.addCell((Object)i, new String[0]);
                if (productVariant.getSalesPrice() != null) {
                    r.addCell((Object)((double)i.intValue() * productVariant.getSalesPrice().getPrice()), new String[0]);
                } else {
                    r.addCell(null, new String[0]);
                }
            }
            if (includeMatCosts) {
                Timestamp selectedDate = (Timestamp)this.dueDate.getElement().getNode().getValue();
                ProductVariantComplete pvc = (ProductVariantComplete)p.getModel().getNode().getValue(ProductVariantComplete.class);
                if (pvc == null) {
                    try {
                        pvc = (ProductVariantComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantByReference(new ProductVariantReference(productVariant.getId())).getValue();
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                }
                try {
                    PriceComplete mat = ProductPriceCalculationToolkit.getProductMaterialPrice((ProductVariantComplete)pvc, (int)1, (ModificationStateE)pvc.getState(), (SystemSettingsComplete)settings, (Timestamp)selectedDate, (RecipeVariantAccessor)accessor, (CurrencyVariantAccessor)this.currencyAccessor);
                    r.addCell((Object)mat.getPrice(), new String[0]);
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
            rows.add(r);
            ++count;
        }
        rows.addAll(this.getSummary(bondedState));
        return rows;
    }

    private List<ExcelRow> getSummary(BondedStateE bondedState) {
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        rows.add(new ExcelRow());
        ExcelRow bonded = new ExcelRow();
        bonded.addCell((Object)"Bonded", new String[0]);
        bonded.addCell((Object)((BondedStateEConverter)ConverterRegistry.getConverter(BondedStateEConverter.class)).convert(bondedState, null, new Object[0]), new String[0]);
        rows.add(bonded);
        ExcelRow hint = new ExcelRow();
        hint.addCell((Object)"", new String[0]);
        hint.addCell((Object)"* = bonded Article", new String[0]);
        rows.add(hint);
        ExcelRow time2 = new ExcelRow();
        time2.addCell((Object)"Due Date", new String[0]);
        time2.addCell(this.dueDate.getElement().getNode().getValue(), new String[0]);
        rows.add(time2);
        return rows;
    }

    public Node<Timestamp> getDueDate() {
        return this.dueDate.getElement().getNode();
    }

    public List<ExcelRow> getProductsRow() {
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        ExcelRow h = new ExcelRow();
        h.setHeader(true);
        h.addCell((Object)"Product Parameters", new String[0]);
        rows.add(h);
        if (this.customerSearch.getElement().isItemSelected()) {
            ExcelRow custeomer = new ExcelRow();
            custeomer.addCell((Object)"Customer", new String[0]);
            custeomer.addCell((Object)((CustomerLight)this.customerSearch.getElement().getNode().getValue()).getName(), new String[0]);
            rows.add(custeomer);
        }
        DateTimeConverter c = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
        ExcelRow time = new ExcelRow();
        time.addCell((Object)"Period from", new String[0]);
        time.addCell((Object)this.period.getStartDate(), new String[0]);
        rows.add(time);
        ExcelRow time2 = new ExcelRow();
        time2.addCell((Object)"Period to", new String[0]);
        time2.addCell((Object)this.period.getEndDate(), new String[0]);
        rows.add(time2);
        ExcelRow header = new ExcelRow();
        header.setHeader(true);
        header.addCell((Object)"Customer", new String[0]);
        header.addCell((Object)"Product No", new String[0]);
        header.addCell((Object)"Product Name", new String[0]);
        header.addCell((Object)"Qty", new String[0]);
        header.addCell((Object)"Calculated Qty", new String[0]);
        rows.add(header);
        for (Table2RowPanel p : this.results.getRows()) {
            TableRowImpl pi = (TableRowImpl)p;
            rows.add(pi.getProductRow());
        }
        return rows;
    }

    public Integer getProductAmount(ProductComplete product) {
        Long amount = 0L;
        for (Table2RowPanel p : this.results.getRows()) {
            TableRowImpl pi = (TableRowImpl)p;
            if (pi.getModel().getNode().getChildNamed(new String[]{"product"}) == null || !pi.getModel().getNode().getChildNamed(new String[]{"product"}).getValue().equals(product)) continue;
            StoreQuantityComplete q = (StoreQuantityComplete)pi.getModel().getNode().getChildNamed(new String[]{"cquantity"}).getValue();
            amount = amount + q.getAmount();
        }
        return amount.intValue();
    }

    public void addWarnings(Map<FlightLight, List<String>> warnings) {
        this.warnings.putAll(warnings);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel no;
        private TextLabel name;
        private TextLabel customer;
        private InputComboBox amount;
        private ArticleProductInfoButton infoButton;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m, Table2RowPanel.TableControlsType controlSkin) {
            super(m);
            this.setUseControlSkin(controlSkin);
            this.name = new TextLabel(m.getNode(), ConverterRegistry.getConverter(ProductVariantConverter.class));
            if (((ProductVariantLight)m.getNode().getValue()).getProduct() == null) {
                this.no = new TextLabel("" + ((ProductVariantLight)m.getNode().getValue()).getProductNumber());
                this.customer = new TextLabel(((ProductVariantLight)m.getNode().getValue()).getProductCustomer());
            } else {
                this.no = new TextLabel(m.getNode().getChildNamed(new String[]{"product-number"}), ConverterRegistry.getConverter(IntegerConverter.class));
                this.customer = new TextLabel(m.getNode().getChildNamed(new String[]{"product-customer"}), ConverterRegistry.getConverter(CustomerConverter.class));
            }
            SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            Node qn = this.model.getNode().getChildNamed(new String[]{"cquantity"});
            if (qn == null) {
                StoreQuantityComplete q = new StoreQuantityComplete();
                q.setClientOId(Long.valueOf(q.getNextId()));
                q.setAmount(Long.valueOf(1L));
                q.setUnit(s.getPieceUnit());
                qn = INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false);
                qn.setName("cquantity");
                this.model.getNode().addChild(qn, 0L);
            } else {
                if (qn.getChildNamed(new String[]{"amount"}).getValue() == null) {
                    qn.getChildNamed(new String[]{"amount"}).setValue((Object)1, 0L);
                }
                if (qn.getChildNamed(new String[]{"unit"}).getValue() == null) {
                    qn.getChildNamed(new String[]{"unit"}).setValue((Object)s.getPieceUnit(), 0L);
                }
            }
            this.infoButton = new ProductInfoButton(m.getNode(), (Node<java.sql.Date>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new java.sql.Date(System.currentTimeMillis()), false, false), ProductToolkit.getAllTypes());
            this.amount = new InputComboBox(qn.getChildNamed(new String[]{"amount"}), qn.getChildNamed(new String[]{"unit"}), InputComboBox.InputComboBoxType.PRICE_LONG);
            this.amount.setNextFocusComponent((Focusable)ProductDetailsPanel.this.productSearch.getElement());
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.no);
            this.add(this.name);
            this.add(this.customer);
            this.add(this.amount);
            this.add(this.infoButton);
            this.add(this.delete);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.no.kill();
            this.name.kill();
            this.customer.kill();
            this.amount.kill();
            this.delete.kill();
            this.infoButton.kill();
            this.no = null;
            this.name = null;
            this.customer = null;
            this.amount = null;
            this.delete = null;
            this.infoButton = null;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.amount.requestFocusInWindowNow();
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.amount.getFocusComponents();
            a.addAll(this.delete.getFocusComponents());
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new String[]{"product-number"}).getValue();
                }
                case 1: {
                    Node n = this.model.getNode().getChildNamed(new String[]{"product"});
                    if (n != null && (n = n.getChildNamed(new String[]{"currentVariant"})) != null) {
                        n = n.getChildNamed(new String[]{"name"});
                        return n.getValue();
                    }
                    return null;
                }
                case 2: {
                    return this.model.getNode().getChildNamed(new String[]{"product-customer"}).getValue();
                }
                case 3: {
                    return this.amount.getValueNode().getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.no.setEnabled(isEnabled);
            this.name.setEnabled(isEnabled);
            this.customer.setEnabled(isEnabled);
            this.amount.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
            this.infoButton.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                ProductDetailsPanel.this.removeNodeFromList(this.model.getNode());
            }
        }

        public ExcelRow getProductRow() {
            ExcelRow sproduct = new ExcelRow();
            sproduct.addCell(this.model.getNode().getChildNamed(new String[]{"product-customer-code"}).getValue(), new String[0]);
            sproduct.addCell(this.model.getNode().getChildNamed(new String[]{"product-number"}).getValue(), new String[0]);
            sproduct.addCell(this.model.getNode().getChildNamed(new String[]{"name"}).getValue(), new String[0]);
            sproduct.addCell(this.model.getNode().getChildNamed(new String[]{"cquantity-amount"}).getValue(), new String[0]);
            sproduct.addCell(this.model.getNode().getChildNamed(new String[]{"oquantity-amount"}).getValue(), new String[0]);
            return sproduct;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.no.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.no.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.no.setSize(TableRowImpl.this.no.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + 5) + TableRowImpl.this.infoButton.getPreferredSize().getWidth())), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                TableRowImpl.this.infoButton.setLocation(TableRowImpl.this.name.getX() + TableRowImpl.this.name.getWidth() + 5, (int)(((double)parent.getHeight() - TableRowImpl.this.infoButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.infoButton.setSize(TableRowImpl.this.infoButton.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.customer.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customer.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customer.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customer.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.amount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.amount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.amount.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.amount.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            ProductDetailsPanel.this.productSearch.setLocation(10, 10);
            ProductDetailsPanel.this.productSearch.setSize(150, (int)ProductDetailsPanel.this.productSearch.getPreferredSize().getHeight());
            ProductDetailsPanel.this.customerSearch.setLocation(ProductDetailsPanel.this.productSearch.getX() + ProductDetailsPanel.this.productSearch.getWidth() + 10, 10);
            int w = 250;
            int pw = (int)((double)parent.getWidth() - (20.0 + ProductDetailsPanel.this.add.getPreferredSize().getWidth() + 10.0 + ProductDetailsPanel.this.addAll.getPreferredSize().getWidth()));
            if (w + ProductDetailsPanel.this.customerSearch.getX() > pw) {
                w = pw - (ProductDetailsPanel.this.customerSearch.getX() + 10);
            }
            ProductDetailsPanel.this.customerSearch.setSize(w, (int)ProductDetailsPanel.this.customerSearch.getPreferredSize().getHeight());
            ProductDetailsPanel.this.period.setLocation(ProductDetailsPanel.this.productSearch.getX(), ProductDetailsPanel.this.productSearch.getY() + ProductDetailsPanel.this.productSearch.getHeight() + 10);
            ProductDetailsPanel.this.period.setSize(ProductDetailsPanel.this.period.getPreferredSize());
            ProductDetailsPanel.this.dueDate.setLocation(ProductDetailsPanel.this.period.getX() + ProductDetailsPanel.this.period.getWidth() + 10, ProductDetailsPanel.this.period.getY());
            ProductDetailsPanel.this.dueDate.setSize(ProductDetailsPanel.this.dueDate.getPreferredSize());
            ProductDetailsPanel.this.importProducts.setLocation(ProductDetailsPanel.this.dueDate.getX() + ProductDetailsPanel.this.dueDate.getWidth() + 10, (int)((double)(ProductDetailsPanel.this.customerSearch.getY() + ProductDetailsPanel.this.customerSearch.getHeight()) - ProductDetailsPanel.this.importProducts.getPreferredSize().getHeight()));
            ProductDetailsPanel.this.importProducts.setSize(ProductDetailsPanel.this.add.getPreferredSize());
            ProductDetailsPanel.this.add.setLocation(ProductDetailsPanel.this.dueDate.getX() + ProductDetailsPanel.this.dueDate.getWidth() + 10, (int)((double)(ProductDetailsPanel.this.period.getY() + ProductDetailsPanel.this.period.getHeight()) - ProductDetailsPanel.this.add.getPreferredSize().getHeight()) - 3);
            ProductDetailsPanel.this.add.setSize(ProductDetailsPanel.this.add.getPreferredSize());
            ProductDetailsPanel.this.addAll.setLocation(ProductDetailsPanel.this.add.getX() + ProductDetailsPanel.this.add.getWidth() + 10, ProductDetailsPanel.this.add.getY());
            ProductDetailsPanel.this.addAll.setSize(ProductDetailsPanel.this.addAll.getPreferredSize());
            ProductDetailsPanel.this.clearAll.setLocation(ProductDetailsPanel.this.addAll.getX(), (int)((double)(ProductDetailsPanel.this.customerSearch.getY() + ProductDetailsPanel.this.customerSearch.getHeight()) - ProductDetailsPanel.this.clearAll.getPreferredSize().getHeight()));
            ProductDetailsPanel.this.clearAll.setSize(ProductDetailsPanel.this.clearAll.getPreferredSize());
            ProductDetailsPanel.this.results.setLocation(1, ProductDetailsPanel.this.period.getY() + ProductDetailsPanel.this.period.getHeight() + 10);
            ProductDetailsPanel.this.results.setSize(parent.getWidth() - 2, parent.getHeight() - (ProductDetailsPanel.this.results.getY() + 3));
        }
    }
}

