/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.migros.details;

import ch.icit.pegasus.client.gui.modules.importer.utils.ImporterItemView;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.file.FileChooserPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosArticleImportComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosArticleImportLight_;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosDataComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosDataTypeE;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosStoreImportComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosStoreImportComplete_;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class AddImportDetailsPanel
extends DefaultDetailsPanel<MigrosDataComplete> {
    private TitledItem<RDTextField> name;
    private TitledItem<RDDateChooser> validFrom;
    private TitledItem<FileChooserPanel> fileChooser;
    private TitledItem<ComboBox> typeChooser;
    private ViewButton downloadTemplateFile;

    public AddImportDetailsPanel(RowEditor<MigrosDataComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText("Product Price Import");
        this.typeChooser = new TitledItem<ComboBox>(new ComboBox(), "Import Type", TitledItem.TitledItemOrientation.NORTH);
        this.typeChooser.getElement().addItem(MigrosDataTypeE.ArticleData);
        this.typeChooser.getElement().addItem(MigrosDataTypeE.Store);
        this.typeChooser.getElement().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AddImportDetailsPanel.this.initDTO();
            }
        });
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), "Name", TitledItem.TitledItemOrientation.NORTH);
        this.validFrom = new TitledItem<RDDateChooser>(new RDDateChooser(provider), "Valid from", TitledItem.TitledItemOrientation.NORTH);
        this.fileChooser = new TitledItem<FileChooserPanel>(new FileChooserPanel(null), "Upload File", TitledItem.TitledItemOrientation.NORTH);
        this.fileChooser.getElement().setFileType("xlsx");
        this.downloadTemplateFile = new ViewButton();
        this.downloadTemplateFile.addButtonListener((source, x, y) -> this.openTemplateFile());
        this.setCustomLayouter(new Layout());
        this.addToView(this.name);
        this.addToView(this.validFrom);
        this.addToView(this.fileChooser);
        this.addToView(this.downloadTemplateFile);
        this.addToView(this.typeChooser);
    }

    private void initDTO() {
        if (this.isArticleImport()) {
            MigrosArticleImportComplete articleImportComplete = new MigrosArticleImportComplete();
            articleImportComplete.setClientOId(Long.valueOf(ADTO.getNextId()));
            articleImportComplete.setValidityDate(new Date(System.currentTimeMillis()));
            articleImportComplete.setValidity(Boolean.valueOf(false));
            articleImportComplete.setProcessed(Boolean.valueOf(false));
            this.setTitleText("Import Product Data");
            this.editor.getModel().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)articleImportComplete, false, false));
            this.setNode(this.editor.getModel().getNode());
        } else {
            MigrosStoreImportComplete storeImport = new MigrosStoreImportComplete();
            storeImport.setClientOId(Long.valueOf(ADTO.getNextId()));
            storeImport.setValidity(Boolean.valueOf(false));
            storeImport.setProcessed(Boolean.valueOf(false));
            this.setTitleText("Import Filialen Data");
            this.editor.getModel().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)storeImport, false, false));
            this.setNode(this.editor.getModel().getNode());
        }
    }

    private void openTemplateFile() {
        File f = null;
        try {
            f = this.downloadFile();
        }
        catch (IOException e) {
            f = null;
        }
        if (f == null) {
            InnerPopupFactory.showErrorDialog("No template ready. Please contact support.", (Component)this);
        }
        try {
            Desktop.getDesktop().open(f);
        }
        catch (IOException e) {
            InnerPopupFactory.showErrorDialog("Unable to open template", (Component)this);
        }
    }

    private File downloadFile() throws IOException {
        File tempFile = File.createTempFile("ImporterFile_", ".xlsx");
        URL url = this.createURL();
        if (url == null) {
            return null;
        }
        FileUtils.copyURLToFile((URL)url, (File)tempFile);
        return tempFile;
    }

    private URL createURL() throws MalformedURLException {
        return ImporterItemView.class.getResource("/importtemplates/MigrosArticleImport.xlsx");
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        return this.fileChooser.getElement().commitFile();
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.isArticleImport()) {
            if (StringUtil.isBlank((String)((String)this.editor.getModel().getNode().getChildNamed(MigrosArticleImportLight_.name).getValue()))) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure name is set"));
            }
            if (this.editor.getModel().getNode().getChildNamed(MigrosArticleImportLight_.associatedFile).getValue() == null) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure file is selected"));
            }
        } else {
            if (StringUtil.isBlank((String)((String)this.editor.getModel().getNode().getChildNamed(MigrosStoreImportComplete_.name).getValue()))) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure name is set"));
            }
            if (this.editor.getModel().getNode().getChildNamed(MigrosStoreImportComplete_.associatedFile).getValue() == null) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure file is selected"));
            }
        }
        return super.validateParagraph();
    }

    private boolean isArticleImport() {
        return this.typeChooser.getElement().getSelectedItem() == MigrosDataTypeE.ArticleData;
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.isArticleImport()) {
            this.name.getElement().setNode(node.getChildNamed(MigrosArticleImportLight_.name));
            this.validFrom.getElement().setNode(node.getChildNamed(MigrosArticleImportLight_.validityDate));
            this.fileChooser.getElement().setNode(node.getChildNamed(MigrosArticleImportLight_.associatedFile));
        } else {
            this.name.getElement().setNode(node.getChildNamed(MigrosStoreImportComplete_.name));
            this.fileChooser.getElement().setNode(node.getChildNamed(MigrosStoreImportComplete_.associatedFile));
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enabled = isEnabled && this.editor.getModel().isAddRow();
        super.setEnabled(enabled);
        this.name.setEnabled(enabled);
        this.validFrom.setEnabled(enabled);
        this.fileChooser.setEnabled(enabled);
        this.downloadTemplateFile.setEnabled(enabled);
        this.typeChooser.setEnabled(enabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.typeChooser);
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.validFrom);
        CheckedListAdder.addToList(focusList, this.fileChooser);
        CheckedListAdder.addToList(focusList, this.downloadTemplateFile);
        return focusList;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = AddImportDetailsPanel.this.verticalBorder;
            h = (int)((double)h + AddImportDetailsPanel.this.typeChooser.getPreferredSize().getHeight());
            h += AddImportDetailsPanel.this.verticalBorder;
            h = (int)((double)h + AddImportDetailsPanel.this.name.getPreferredSize().getHeight());
            h += AddImportDetailsPanel.this.verticalBorder;
            h = (int)((double)h + AddImportDetailsPanel.this.validFrom.getPreferredSize().getHeight());
            h += AddImportDetailsPanel.this.verticalBorder;
            h = (int)((double)h + AddImportDetailsPanel.this.fileChooser.getPreferredSize().getHeight());
            return new Dimension(0, h += AddImportDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = AddImportDetailsPanel.this.verticalBorder;
            AddImportDetailsPanel.this.typeChooser.setLocation(AddImportDetailsPanel.this.horizontalBorder, y);
            AddImportDetailsPanel.this.typeChooser.setSize(400, (int)AddImportDetailsPanel.this.typeChooser.getPreferredSize().getHeight());
            AddImportDetailsPanel.this.name.setLocation(AddImportDetailsPanel.this.horizontalBorder, AddImportDetailsPanel.this.typeChooser.getY() + AddImportDetailsPanel.this.typeChooser.getHeight() + AddImportDetailsPanel.this.verticalBorder);
            AddImportDetailsPanel.this.name.setSize(400, (int)AddImportDetailsPanel.this.name.getPreferredSize().getHeight());
            AddImportDetailsPanel.this.validFrom.setLocation(AddImportDetailsPanel.this.horizontalBorder, AddImportDetailsPanel.this.name.getY() + AddImportDetailsPanel.this.name.getHeight() + AddImportDetailsPanel.this.verticalBorder);
            AddImportDetailsPanel.this.validFrom.setSize(AddImportDetailsPanel.this.validFrom.getPreferredSize());
            AddImportDetailsPanel.this.fileChooser.setLocation(AddImportDetailsPanel.this.horizontalBorder, AddImportDetailsPanel.this.validFrom.getY() + AddImportDetailsPanel.this.validFrom.getHeight() + AddImportDetailsPanel.this.verticalBorder);
            AddImportDetailsPanel.this.fileChooser.setSize(AddImportDetailsPanel.this.fileChooser.getPreferredSize());
            AddImportDetailsPanel.this.downloadTemplateFile.setLocation(AddImportDetailsPanel.this.fileChooser.getX() + AddImportDetailsPanel.this.fileChooser.getWidth() + AddImportDetailsPanel.this.horizontalBorder, (int)((double)(AddImportDetailsPanel.this.fileChooser.getY() + AddImportDetailsPanel.this.fileChooser.getHeight()) - AddImportDetailsPanel.this.downloadTemplateFile.getPreferredSize().getHeight() - 2.0));
            AddImportDetailsPanel.this.downloadTemplateFile.setSize(AddImportDetailsPanel.this.downloadTemplateFile.getPreferredSize());
        }
    }
}

