/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.movement.article.chargebased;

import ch.icit.pegasus.client.gui.modules.movement.article.chargebased.GroupCBStockMovementModule;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.DocumentScanToolkit;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.report.ManualMovementLabelConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupComplete_;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupLight;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupReference;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete_;
import ch.icit.pegasus.server.core.dtos.store.transaction.remark.ManualStockCheckoutRemarkComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.sql.Date;
import java.util.Iterator;
import java.util.List;

public class GroupCBStockMovementModuleDataHandler
extends DefaultDataHandler<StockMovementGroupComplete, StockMovementGroupComplete> {
    public GroupCBStockMovementModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = node;
                StockMovementGroupLight group = (StockMovementGroupLight)n.getValue(StockMovementGroupLight.class);
                StockMovementGroupComplete ngroup = (StockMovementGroupComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStockMovementGroup(new StockMovementGroupReference(group.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)ngroup, 0L);
                node.updateNode();
                Iterator it = n.getChildNamed(StockMovementGroupComplete_.stockMovements).getChilds();
                while (it.hasNext()) {
                    Node no = (Node)it.next();
                    ArticleChargeLight al = (ArticleChargeLight)no.getChildNamed(ManualStockMovementComplete_.charge).getValue();
                    ArticleChargeComplete ac = (ArticleChargeComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getCharge((ArticleChargeReference)al).getValue();
                    no.getChildNamed(ManualStockMovementComplete_.charge).removeExistingValues();
                    no.getChildNamed(ManualStockMovementComplete_.charge).setValue((Object)ac, 0L);
                    BasicArticleComplete artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(al.getBasicArticle().getId())).getValue();
                    no.getChildNamed(new DtoField[]{ManualStockMovementComplete_.charge, ArticleChargeLight_.basicArticle}).setValue((Object)artC, 0L);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    public void reloadArticle(Node<BasicArticleReference> article, RemoteLoader listener) {
        new BasicArticleLoader((BasicArticleReference)article.getValue(BasicArticleLight.class), listener, article, this);
    }

    @Override
    public void updateData(final Node<StockMovementGroupComplete> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                GroupCBStockMovementModule v = (GroupCBStockMovementModule)GroupCBStockMovementModuleDataHandler.this.model.getTable().getOutSideConnection();
                Iterator it = node.getChildNamed(StockMovementGroupComplete_.documents).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node next = (Node)it.next();
                    if (!(next instanceof DTOProxyNode)) continue;
                    next = ((DTOProxyNode)next).getRefNode();
                    next.commitThis(CustomsDocumentComplete.class);
                }
                node.commitThis(StockMovementGroupComplete.class);
                StockMovementGroupComplete d = (StockMovementGroupComplete)node.getValue(StockMovementGroupComplete.class);
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                DocumentScanComplete doc = d.getDocumentScan();
                if (doc != null && doc.getFileData() != null && doc.getFileData().getId() == null) {
                    try {
                        doc.setDescription("Movement " + d.getNumber());
                        File localFile = doc.getFileData().getLocalFile();
                        PegasusFileComplete uploadedFile = FileTransferUtil.upload((PegasusFileComplete)doc.getFileData(), (FileTransferListener[])new FileTransferListener[0]);
                        doc.setFileData(uploadedFile);
                        doc.setCreationUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                        String rawTextFromPDF = DocumentScanToolkit.readRawTextFromPDF(localFile);
                        doc.setContentAsText(rawTextFromPDF);
                        d.setDocumentScan(doc);
                        String fileName = "Movement-" + d.getNumber();
                        DocumentScanToolkit.moveScannedFile(settings, localFile, d.getMovementDate(), fileName);
                    }
                    catch (Exception e1) {
                        InnerPopupFactory.showErrorDialog("Something went wrong with the PDF file (order should be saved correctly): " + e1.getMessage(), (Component)GroupCBStockMovementModuleDataHandler.this.tableView);
                        d.setDocumentScan(null);
                    }
                }
                StockMovementGroupComplete dto = (StockMovementGroupComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateStockMovementGroup(d, v.isChargeBased()).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<StockMovementGroupComplete> createEmptyNode() {
        StockMovementGroupComplete d = new StockMovementGroupComplete();
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        d.setMovementDate(new Date(System.currentTimeMillis()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<StockMovementGroupComplete> node, final RemoteLoader model, boolean sameNode, final ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                GroupCBStockMovementModule v = (GroupCBStockMovementModule)GroupCBStockMovementModuleDataHandler.this.model.getTable().getOutSideConnection();
                StockMovementGroupComplete d = (StockMovementGroupComplete)node.getValue(StockMovementGroupComplete.class);
                d.setUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                Iterator it = d.getStockMovements().iterator();
                DocumentScanComplete doc = d.getDocumentScan();
                d.setDocumentScan(null);
                while (it.hasNext()) {
                    ManualStockMovementComplete c = (ManualStockMovementComplete)it.next();
                    if (Boolean.TRUE.equals(c.getMoveAll()) && v.isChargeBased()) {
                        ArticleChargeLight charge = c.getCharge();
                        StorePositionLight position = c.getOriginPosition();
                        ArticleChargeBatchComplete selectedBatch = null;
                        ArticleChargeComplete chargeComplete = (ArticleChargeComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getCharge(new ArticleChargeReference(charge.getId())).getValue();
                        for (ArticleChargeBatchComplete batch : chargeComplete.getBatches()) {
                            if (!batch.getPosition().equals((Object)position)) continue;
                            selectedBatch = batch;
                        }
                        if (selectedBatch != null) {
                            StoreQuantityComplete q = new StoreQuantityComplete(selectedBatch.getQuantity());
                            c.setAmount(q);
                        } else {
                            c.setAmount(null);
                        }
                    }
                    if (c.getAmount() != null && c.getAmount().getAmount() == 0L && (v.isChargeBased() || !v.isChargeBased() && Boolean.FALSE.equals(c.getMoveAll()))) {
                        it.remove();
                        continue;
                    }
                    c.setUser(d.getUser());
                    c.setContainingMovement((StockMovementGroupReference)d);
                }
                d.getStockMovements().removeIf(manualStockMovementComplete -> manualStockMovementComplete.getAmount() == null);
                if (d.getEligibleLocations().isEmpty()) {
                    d.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                StockMovementGroupComplete dto = (StockMovementGroupComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).createStockMovementGroup(d, v.isChargeBased()).getValue();
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                if (doc != null && doc.getFileData() != null && doc.getFileData().getId() == null) {
                    try {
                        doc.setDescription("Movement " + dto.getNumber());
                        File localFile = doc.getFileData().getLocalFile();
                        PegasusFileComplete uploadedFile = FileTransferUtil.upload((PegasusFileComplete)doc.getFileData(), (FileTransferListener[])new FileTransferListener[0]);
                        doc.setFileData(uploadedFile);
                        doc.setCreationUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                        String rawTextFromPDF = DocumentScanToolkit.readRawTextFromPDF(localFile);
                        doc.setContentAsText(rawTextFromPDF);
                        dto.setDocumentScan(doc);
                        String fileName = "Movement-" + dto.getNumber();
                        DocumentScanToolkit.moveScannedFile(settings, localFile, dto.getMovementDate(), fileName);
                        dto = (StockMovementGroupComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateStockMovementGroup(dto, v.isChargeBased()).getValue();
                    }
                    catch (Exception e1) {
                        InnerPopupFactory.showErrorDialog("Something went wrong with the PDF file (order should be saved correctly): " + e1.getMessage(), (Component)GroupCBStockMovementModuleDataHandler.this.tableView);
                        d.setDocumentScan(null);
                    }
                }
                if (Boolean.TRUE.equals(settings.getAutoPrintMovementLabels())) {
                    try {
                        l.stateChanged("Create Labels");
                        List styleSheets = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getReportStylesheets(ReportTypeE.ARTICLE_STORE_INFO_SHEET).getList();
                        ReportFileComplete selectedReport = null;
                        for (ReportFileComplete styleSheet : styleSheets) {
                            if (!styleSheet.getDescription().contains("Label")) continue;
                            selectedReport = styleSheet;
                        }
                        if (selectedReport == null && !styleSheets.isEmpty()) {
                            selectedReport = (ReportFileComplete)styleSheets.get(0);
                        }
                        if (selectedReport != null) {
                            ManualMovementLabelConfiguration conf = new ManualMovementLabelConfiguration();
                            conf.setGroupReference(new StockMovementGroupReference(dto.getId()));
                            conf.setStyleSheet(selectedReport);
                            conf.setIncludeBarCode(Boolean.valueOf(true));
                            conf.setStartPosition(Integer.valueOf(1));
                            PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createArticleLabelsForMovement(conf).getValue();
                            File labelFile = FileTransferUtil.download((PegasusFileComplete)t, (FileTransferListener[])new FileTransferListener[0]);
                            Desktop.getDesktop().open(labelFile);
                        }
                    }
                    catch (Exception e) {
                        InnerPopupFactory.showErrorDialog("Unable to auto print movement labels. Movement data is correctly saved. Message: " + e.getMessage(), (Component)GroupCBStockMovementModuleDataHandler.this.tableView);
                    }
                }
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                GroupCBStockMovementModuleDataHandler.this.setCurrentLoadMaximum(7);
                GroupCBStockMovementModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                GroupCBStockMovementModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                GroupCBStockMovementModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                GroupCBStockMovementModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CustomsDocumentTypeComplete.class);
                GroupCBStockMovementModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ManualStockCheckoutRemarkComplete.class);
                GroupCBStockMovementModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                GroupCBStockMovementModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return GroupCBStockMovementModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<StockMovementGroupComplete> resetData(Node<StockMovementGroupComplete> node) {
        StockMovementGroupComplete n = new StockMovementGroupComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<StockMovementGroupComplete> getCommittingClass() {
        return StockMovementGroupComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<StockMovementGroupComplete> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

